<?php
define("EW_PAGE_ID", "preview", TRUE);
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "mefsectioninfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "mefcominfo_admin.php" ?>
<?php include "mefdepinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php

// Init table objects
$mefsection = new cmefsection();
$usermis = new cusermis();
$mefcom = new cmefcom();
$mefdep = new cmefdep();

// Open connection to the database
$conn = ew_Connect();
$Security = new cAdvancedSecurity();
if (!$Security->IsLoggedIn()) $Security->AutoLogin();
if (!$Security->IsLoggedIn()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->TablePermission_Loading();
$Security->LoadCurrentUserLevel('mefsection');
$Security->TablePermission_Loaded();
if (!$Security->IsLoggedIn()) {
	$Security->SaveLastUrl();
	$this->Page_Terminate("login_admin.php");
}
if (!$Security->CanList()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->UserID_Loading();
if ($Security->IsLoggedIn()) $Security->LoadUserID();
$Security->UserID_Loaded();

// Load filter
$qs = new cQueryString();
$filter = $qs->GetValue("f");
$filter = TEAdecrypt($filter, EW_RANDOM_KEY);
if ($filter == "") $filter = "0=1";

// Load recordset
$rs = $mefsection->LoadRs($filter);
$nTotalRecs = ($rs) ? $rs->RecordCount() : 0;
?>
<link href="prima_dev_v2.css" rel="stylesheet" type="text/css">
<p><span class="phpmaker" style="white-space: nowrap;">Table: Ville/Quartier/Section
<?php if ($nTotalRecs > 0) { ?>
(<?php echo $nTotalRecs ?> Records)
<?php } else { ?>
(No records found)
<?php } ?>
</span></p>
<?php if ($nTotalRecs > 0) { ?>
<table cellspacing="0" class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table id="ewDetailsPreviewTable" name="ewDetailsPreviewTable" cellspacing="0" class="ewTable ewTableSeparate">
	<thead><!-- Table header -->
		<tr class="ewTableHeader">
			<td valign="top">Dpartement</td>
			<td valign="top">Commune</td>
			<td valign="top">Ville/Quartier/Section</td>
			<td valign="top">Position gographique</td>
			<td valign="top">Relief</td>
			<td valign="top">Population</td>
			<td valign="top">Superficie (km&sup2)</td>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$nRecCount = 0;
while ($rs && !$rs->EOF) {

	// Init row class and style
	$nRecCount++;
	$mefsection->CssClass = "ewTableRow";
	$mefsection->CssStyle = "";

	// Display alternate color for rows
	if ($nRecCount % 2 <> 1)
		$mefsection->CssClass = "ewTableAltRow";
	$mefsection->LoadListRowValues($rs);

	// Render row
	$mefsection->RowType = EW_ROWTYPE_PREVIEW; // Preview record
	$mefsection->RenderListRow();
?>
	<tr<?php echo $mefsection->RowAttributes() ?>>
		<!-- id_dep -->
		<td<?php echo $mefsection->id_dep->CellAttributes() ?>>
<div<?php echo $mefsection->id_dep->ViewAttributes() ?>><?php echo $mefsection->id_dep->ViewValue ?></div></td>
		<!-- id_com -->
		<td<?php echo $mefsection->id_com->CellAttributes() ?>>
<div<?php echo $mefsection->id_com->ViewAttributes() ?>><?php echo $mefsection->id_com->ViewValue ?></div></td>
		<!-- vqs -->
		<td<?php echo $mefsection->vqs->CellAttributes() ?>>
<div<?php echo $mefsection->vqs->ViewAttributes() ?>><?php echo $mefsection->vqs->ViewValue ?></div></td>
		<!-- pgeo -->
		<td<?php echo $mefsection->pgeo->CellAttributes() ?>>
<div<?php echo $mefsection->pgeo->ViewAttributes() ?>><?php echo $mefsection->pgeo->ViewValue ?></div></td>
		<!-- relief -->
		<td<?php echo $mefsection->relief->CellAttributes() ?>>
<div<?php echo $mefsection->relief->ViewAttributes() ?>><?php echo $mefsection->relief->ViewValue ?></div></td>
		<!-- population -->
		<td<?php echo $mefsection->population->CellAttributes() ?>>
<div<?php echo $mefsection->population->ViewAttributes() ?>><?php echo $mefsection->population->ViewValue ?></div></td>
		<!-- superfici -->
		<td<?php echo $mefsection->superfici->CellAttributes() ?>>
<div<?php echo $mefsection->superfici->ViewAttributes() ?>><?php echo $mefsection->superfici->ViewValue ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
?>
	</tbody>
</table>
</div>
</td></tr></table>
<?php
if ($rs)
	$rs->Close();
}
$content = ob_get_contents();
ob_end_clean();
echo ew_ConvertToUtf8($content);
?>
