<?php
session_start();
ob_start();
?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php include "phprptinc/ewrcfg3report.php"; ?>
<?php include "phprptinc/ewmysqlreport.php"; ?>
<?php include "phprptinc/ewrfn3report.php"; ?>
<?php

// Get page start time
$starttime = ewrpt_microtime();

// Open connection to the database
$conn = ewrpt_Connect();

// Table level constants
define("EW_REPORT_TABLE_VAR", "Crosstab1", TRUE);
define("EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE", "Crosstab1_grpperpage", TRUE);
define("EW_REPORT_TABLE_SESSION_START_GROUP", "Crosstab1_start", TRUE);
define("EW_REPORT_TABLE_SESSION_SEARCH", "Crosstab1_search", TRUE);
define("EW_REPORT_TABLE_SESSION_CHILD_USER_ID", "Crosstab1_childuserid", TRUE);
define("EW_REPORT_TABLE_SESSION_ORDER_BY", "Crosstab1_orderby", TRUE);

// Table level SQL
define("EW_REPORT_TABLE_REPORT_COLUMN_FLD", "projets.datedebut", TRUE); // Column field
define("EW_REPORT_TABLE_REPORT_COLUMN_DATE_TYPE", "y", TRUE); // Column date type
define("EW_REPORT_TABLE_REPORT_SUMMARY_FLD", "projets.montantproj", TRUE); // Summary field
define("EW_REPORT_TABLE_REPORT_SUMMARY_TYPE", "SUM", TRUE);
define("EW_REPORT_TABLE_REPORT_COLUMN_CAPTIONS", "", TRUE);
define("EW_REPORT_TABLE_REPORT_COLUMN_NAMES", "", TRUE);
define("EW_REPORT_TABLE_REPORT_COLUMN_VALUES", "", TRUE); // Column values
$EW_REPORT_TABLE_SQL_TRANSFORM = "";
$EW_REPORT_TABLE_SQL_FROM = "departement Inner Join projets On (departement.ID_Dep = projets.departement) Inner Join entites On (projets.entite = entites.identite) Inner Join secteurs On projets.secteur = secteurs.idsecteur";
$EW_REPORT_TABLE_SQL_SELECT = "SELECT entites.nomentite AS `nomentite`, departement.departemen AS `departemen`, `nomsecteur`, <DistinctColumnFields> FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_TABLE_SQL_WHERE = "";
$EW_REPORT_TABLE_SQL_GROUPBY = "entites.nomentite, departement.departemen, `nomsecteur`";
$EW_REPORT_TABLE_SQL_HAVING = "";
$EW_REPORT_TABLE_SQL_ORDERBY = "entites.nomentite ASC, departement.departemen ASC, `nomsecteur` ASC";
$EW_REPORT_TABLE_SQL_PIVOT = "";
$EW_REPORT_TABLE_DISTINCT_SQL_SELECT = "SELECT DISTINCT Year(projets.datedebut) FROM departement Inner Join projets On (departement.ID_Dep = projets.departement) Inner Join entites On (projets.entite = entites.identite) Inner Join secteurs On projets.secteur = secteurs.idsecteur";
$EW_REPORT_TABLE_DISTINCT_SQL_WHERE = "";
$EW_REPORT_TABLE_DISTINCT_SQL_ORDERBY = "Year(projets.datedebut)";
$EW_REPORT_TABLE_SQL_USERID_FILTER = "";

// Table Level Group SQL
define("EW_REPORT_TABLE_FIRST_GROUP_FIELD", "entites.nomentite", TRUE);
$EW_REPORT_TABLE_SQL_SELECT_GROUP = "SELECT DISTINCT " . EW_REPORT_TABLE_FIRST_GROUP_FIELD . " AS `nomentite` FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_TABLE_SQL_SELECT_AGG = "SELECT <DistinctColumnFields> FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_TABLE_SQL_GROUPBY_AGG = "";
$af_departemen = NULL; // Popup filter for departemen
$af_FIELD_1 = NULL; // Popup filter for FIELD_1
$af_nomentite = NULL; // Popup filter for nomentite
$af_montantproj = NULL; // Popup filter for montantproj
$af_identite = NULL; // Popup filter for identite
$af_ID_Dep = NULL; // Popup filter for ID_Dep
$af_idsecteur = NULL; // Popup filter for idsecteur
$af_nomsecteur = NULL; // Popup filter for nomsecteur
?>
<?php
if (!IsLoggedIn()) AutoLogin(); // Auto login
LoadUserLevel();
$ewCurSec = CurrentUserLevelPriv('Crosstab1');
if (($ewCurSec & EW_ALLOW_REPORT) <> EW_ALLOW_REPORT) {
	SaveLastUrl();
	ob_end_clean();
	header("Location: login_admin.php");
	exit();
}
?>
<?php
$sExport = @$_GET["export"]; // Load export request
if ($sExport == "html") {

	// Printer friendly
}
if ($sExport == "excel") {
	header('Content-Type: application/vnd.ms-excel');
	header('Content-Disposition: attachment; filename=' . EW_REPORT_TABLE_VAR .'.xls');
}
if ($sExport == "word") {
	header('Content-Type: application/vnd.ms-word');
	header('Content-Disposition: attachment; filename=' . EW_REPORT_TABLE_VAR .'.doc');
}
?>
<?php

// Initialize common variables
// Paging variables

$nRecCount = 0; // Record count
$nStartGrp = 0; // Start group
$nStopGrp = 0; // Stop group
$nTotalGrps = 0; // Total groups
$nGrpCount = 0; // Group count
$nDisplayGrps = 10; // Groups per page
$nGrpRange = 10;

// Clear field for ext filter
$sClearExtFilter = "";

// Non-Text Extended Filters
// Text Extended Filters
// Custom filters

$ewrpt_CustomFilters = array();
?>
<?php
$EW_REPORT_FIELD_NOMENTITE_SQL_SELECT = "SELECT DISTINCT entites.nomentite FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_FIELD_NOMENTITE_SQL_ORDERBY = "entites.nomentite";
$EW_REPORT_FIELD_DEPARTEMEN_SQL_SELECT = "SELECT DISTINCT departement.departemen FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_FIELD_DEPARTEMEN_SQL_ORDERBY = "departement.departemen";
$EW_REPORT_FIELD_NOMSECTEUR_SQL_SELECT = "SELECT DISTINCT `nomsecteur` FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_FIELD_NOMSECTEUR_SQL_ORDERBY = "`nomsecteur`";
?>
<?php

// Static group variables
$x_nomentite = NULL;
$o_nomentite = NULL;
$t_nomentite = NULL;
$g_nomentite = NULL;
$ft_nomentite = 200;
$rf_nomentite = NULL;
$rt_nomentite = NULL;
$x_departemen = NULL;
$o_departemen = NULL;
$t_departemen = NULL;
$g_departemen = NULL;
$ft_departemen = 200;
$rf_departemen = NULL;
$rt_departemen = NULL;
$x_nomsecteur = NULL;
$o_nomsecteur = NULL;
$t_nomsecteur = NULL;
$g_nomsecteur = NULL;
$ft_nomsecteur = 200;
$rf_nomsecteur = NULL;
$rt_nomsecteur = NULL;

// Column variables
$x_datedebut = NULL;
$ft_datedebut = 133;
$rf_datedebut = NULL;
$rt_datedebut = NULL;

// Summary variables
$x_montantproj = NULL;
$rowsmry = NULL; // row summary
?>
<?php

// Chart level SQL
$EW_REPORT_CHART_CHART1_SQL_SELECT = "SELECT departement.departemen, YEAR(projets.datedebut), SUM(projets.montantproj) FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_CHART_CHART1_SQL_GROUPBY = "departement.departemen, YEAR(projets.datedebut)";
$EW_REPORT_CHART_CHART1_SQL_ORDERBY = "departement.departemen ASC, YEAR(projets.datedebut) ASC";
$EW_REPORT_CHART_CHART1_DATE_TYPE = "";
$EW_REPORT_CHART_CHART1_SQL_SELECT_SERIES = "SELECT DISTINCT YEAR(projets.datedebut) FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_CHART_CHART1_SQL_GROUPBY_SERIES = "YEAR(projets.datedebut)";
$EW_REPORT_CHART_CHART1_SQL_ORDERBY_SERIES = "YEAR(projets.datedebut) ASC";

// Chart configuration parameters
$Chart1_cht_parms = array(); // Store all chart parameters

// Chart data
$Chart1_cht_index = NULL;
$Chart1_cht_id = NULL;
$Chart1_cht_smry = NULL;
$Chart1_cht_series = NULL; // Series field
$Chart1_cht_XFld = NULL;
$Chart1_cht_YFld = NULL;
$Chart1_cht_YFldBase = NULL;
$Chart1_cht_XFld = 'departemen';
$Chart1_cht_YFld = 'montantproj';
$Chart1_cht_YFldBase = 3;
$Chart1_cht_XDateFld = '';
$Chart1_cht_SFld = 'datedebut';
$Chart1_cht_SFldAr = NULL;
?>
<?php
$Chart1_cht_trends = array(); // Store all chart trendlines
?>
<?php

// Chart level SQL
$EW_REPORT_CHART_CHART2_SQL_SELECT = "SELECT `nomsecteur`, YEAR(projets.datedebut), SUM(projets.montantproj) FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_CHART_CHART2_SQL_GROUPBY = "`nomsecteur`, YEAR(projets.datedebut)";
$EW_REPORT_CHART_CHART2_SQL_ORDERBY = "`nomsecteur` ASC, YEAR(projets.datedebut) ASC";
$EW_REPORT_CHART_CHART2_DATE_TYPE = "";
$EW_REPORT_CHART_CHART2_SQL_SELECT_SERIES = "SELECT DISTINCT YEAR(projets.datedebut) FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_CHART_CHART2_SQL_GROUPBY_SERIES = "YEAR(projets.datedebut)";
$EW_REPORT_CHART_CHART2_SQL_ORDERBY_SERIES = "YEAR(projets.datedebut) ASC";

// Chart configuration parameters
$Chart2_cht_parms = array(); // Store all chart parameters

// Chart data
$Chart2_cht_index = NULL;
$Chart2_cht_id = NULL;
$Chart2_cht_smry = NULL;
$Chart2_cht_series = NULL; // Series field
$Chart2_cht_XFld = NULL;
$Chart2_cht_YFld = NULL;
$Chart2_cht_YFldBase = NULL;
$Chart2_cht_XFld = 'nomsecteur';
$Chart2_cht_YFld = 'montantproj';
$Chart2_cht_YFldBase = 3;
$Chart2_cht_XDateFld = '';
$Chart2_cht_SFld = 'datedebut';
$Chart2_cht_SFldAr = NULL;
?>
<?php
$Chart2_cht_trends = array(); // Store all chart trendlines
?>
<?php

// Chart level SQL
$EW_REPORT_CHART_CHART3_SQL_SELECT = "SELECT entites.nomentite, YEAR(projets.datedebut), SUM(projets.montantproj) FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_CHART_CHART3_SQL_GROUPBY = "entites.nomentite, YEAR(projets.datedebut)";
$EW_REPORT_CHART_CHART3_SQL_ORDERBY = "entites.nomentite ASC, YEAR(projets.datedebut) ASC";
$EW_REPORT_CHART_CHART3_DATE_TYPE = "";
$EW_REPORT_CHART_CHART3_SQL_SELECT_SERIES = "SELECT DISTINCT YEAR(projets.datedebut) FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_CHART_CHART3_SQL_GROUPBY_SERIES = "YEAR(projets.datedebut)";
$EW_REPORT_CHART_CHART3_SQL_ORDERBY_SERIES = "YEAR(projets.datedebut) ASC";

// Chart configuration parameters
$Chart3_cht_parms = array(); // Store all chart parameters

// Chart data
$Chart3_cht_index = NULL;
$Chart3_cht_id = NULL;
$Chart3_cht_smry = NULL;
$Chart3_cht_series = NULL; // Series field
$Chart3_cht_XFld = NULL;
$Chart3_cht_YFld = NULL;
$Chart3_cht_YFldBase = NULL;
$Chart3_cht_XFld = 'nomentite';
$Chart3_cht_YFld = 'montantproj';
$Chart3_cht_YFldBase = 3;
$Chart3_cht_XDateFld = '';
$Chart3_cht_SFld = 'datedebut';
$Chart3_cht_SFldAr = NULL;
?>
<?php
$Chart3_cht_trends = array(); // Store all chart trendlines
?>
<?php

// Filter
$sFilter = "";
$sButtonImage = "";
$sDivDisplay = FALSE;

// Get sort
$sSort = getSort();

// Popup values and selections
$sel_nomentite = "";
$seld_nomentite = "";
$val_nomentite = "";
$sel_departemen = "";
$seld_departemen = "";
$val_departemen = "";
$sel_nomsecteur = "";
$seld_nomsecteur = "";
$val_nomsecteur = "";
$sel_datedebut = NULL;
$seld_datedebut = NULL;
$val_datedebut = NULL;

// Load default filter values
LoadDefaultFilters();

// Set up popup filter
SetupPopup();

// Load columns to array
GetColumns();

// Extended filter
$sExtendedFilter = "";

// Build popup filter
$sPopupFilter = GetPopupFilter();

//echo "popup filter: " . $sPopupFilter . "<br>";
if ($sPopupFilter <> "") {
	if ($sFilter <> "")
  		$sFilter = "($sFilter) AND ($sPopupFilter)";
	else
		$sFilter = $sPopupFilter;
}

// Check if filter applied
$bFilterApplied = CheckFilter();

// Get total group count
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_TABLE_SQL_SELECT_GROUP, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_TABLE_SQL_GROUPBY, "", $EW_REPORT_TABLE_SQL_ORDERBY, "", $sFilter, @$sSort);
$nTotalGrps = GetGrpCnt($sSql);
if ($nDisplayGrps <= 0) // Display all groups
	$nDisplayGrps = $nTotalGrps;
$nStartGrp = 1;

// Show header
$bShowFirstHeader = ($nTotalGrps > 0);

//$bShowFirstHeader = TRUE; // Uncomment to always show header
// Set up start position if not export all

if (EW_REPORT_EXPORT_ALL && @$sExport <> "")
    $nDisplayGrps = $nTotalGrps;
else
    SetUpStartGroup(); 

// Get total groups
$rsgrp = GetGrpRs($sSql, $nStartGrp, $nDisplayGrps);

// Init detail recordset
$rs = NULL;
?>
<?php if (@$sExport == "") { ?>
<?php //include "header_admin.php"; ?>
<?php } ?>
<?php include "phprptinc/headerreport.php"; ?>
<?php if (@$sExport == "") { ?>
<script type="text/javascript">
var EW_REPORT_DATE_SEPARATOR = "/";
if (EW_REPORT_DATE_SEPARATOR == "") EW_REPORT_DATE_SEPARATOR = "/"; // Default date separator
</script>
<script type="text/javascript" src="phprptjs/ewrpt.js"></script>
<?php } ?>
<?php if (@$sExport == "") { ?>
<script src="phprptjs/popup.js" type="text/javascript"></script>
<script src="phprptjs/ewrptpop.js" type="text/javascript"></script>
<script src="FusionChartsFree/JSClass/FusionCharts.js" type="text/javascript"></script>
<script type="text/javascript">
var EW_REPORT_POPUP_ALL = "(All)";
var EW_REPORT_POPUP_OK = "  OK  ";
var EW_REPORT_POPUP_CANCEL = "Cancel";
var EW_REPORT_POPUP_FROM = "From";
var EW_REPORT_POPUP_TO = "To";
var EW_REPORT_POPUP_PLEASE_SELECT = "Please Select";
var EW_REPORT_POPUP_NO_VALUE = "No value selected!";

// popup fields
<?php $jsdata = ewrpt_GetJsData($val_nomentite, $sel_nomentite, $ft_nomentite) ?>
ewrpt_CreatePopup("Crosstab1_nomentite", [<?php echo $jsdata ?>]);
<?php $jsdata = ewrpt_GetJsData($val_departemen, $sel_departemen, $ft_departemen) ?>
ewrpt_CreatePopup("Crosstab1_departemen", [<?php echo $jsdata ?>]);
<?php $jsdata = ewrpt_GetJsData($val_nomsecteur, $sel_nomsecteur, $ft_nomsecteur) ?>
ewrpt_CreatePopup("Crosstab1_nomsecteur", [<?php echo $jsdata ?>]);
<?php $jsdata = ewrpt_GetJsData($val_datedebut, $sel_datedebut, $ft_datedebut) ?>
ewrpt_CreatePopup("Crosstab1_datedebut", [<?php echo $jsdata ?>]);
</script>
<div id="Crosstab1_nomentite_Popup" class="ewPopup">
<span class="phpreportmaker"></span>
</div>
<div id="Crosstab1_departemen_Popup" class="ewPopup">
<span class="phpreportmaker"></span>
</div>
<div id="Crosstab1_nomsecteur_Popup" class="ewPopup">
<span class="phpreportmaker"></span>
</div>
<div id="Crosstab1_datedebut_Popup" class="ewPopup">
<span class="phpreportmaker"></span>
</div>
<!-- Table container (begin) -->
<table id="ewContainer" cellspacing="0" cellpadding="0" border="0">
<!-- Top container (begin) -->
<tr><td colspan="3"><div id="ewTop" class="phpreportmaker">
<!-- top slot -->
<a name="top"></a>
<?php } ?>
Engagement par anne
<?php if (@$sExport == "") { ?>
<!-- &nbsp;&nbsp;<a href="Crosstab1ctbreport.php?export=html">Printer Friendly</a> -->
&nbsp;&nbsp;<a href="Crosstab1ctbreport.php?export=excel">Export to Excel</a>
&nbsp;&nbsp;<a href="Crosstab1ctbreport.php?export=word">Export to Word</a>
<?php if ($bFilterApplied) { ?>
&nbsp;&nbsp;<a href="Crosstab1ctbreport.php?cmd=reset">Reset All Filters</a>
<?php } ?>
<?php } ?>
<br /><br />
<?php if (@$sExport == "") { ?>
</div></td></tr>
<!-- Top container (end) -->
<tr>
	<!-- Left container (begin) -->
	<td valign="top"><div id="ewLeft" class="phpreportmaker">
	<!-- left slot -->
	</div></td>
	<!-- Left container (end) -->
	<!-- Center container (report) (begin) -->
	<td valign="top" class="ewPadding"><div id="ewCenter" class="phpreportmaker">
	<!-- center slot -->
<?php } ?>
<!-- crosstab report starts -->
<div id="report_crosstab">
<?php if (defined("EW_REPORT_SHOW_CURRENT_FILTER")) { ?>
<div id="ewrptFilterList">
<?php ShowFilterList() ?>
</div>
<br />
<?php } ?>
<table class="ewGrid" cellspacing="0"><tr>
	<td class="ewGridContent">
<!-- Report grid (begin) -->
<div class="ewGridMiddlePanel">
<table class="ewTable ewTableSeparate" cellspacing="0">
<?php if ($bShowFirstHeader) { // Show header ?>
	<thead>
	<!-- Table header -->
	<tr class="ewTableRow">
		<td colspan="3" nowrap><div class="phpreportmaker">Montant engag&eacute; <!-- (SUM) -->&nbsp;</div></td>
		<td class="ewRptColHeader" colspan="<?php echo @$ncolspan; ?>" nowrap>
			Anne de dmarrage des projets 
<?php if (@$sExport == "") { ?>
			<a href="#" onClick="ewrpt_ShowPopup(this.name, 'Crosstab1_datedebut', false, '<?php echo $rf_datedebut; ?>', '<?php echo $rt_datedebut; ?>');return false;" name="x_datedebut" id="x_datedebut"><img src="phprptimages/popup.gif" width="15" height="14" align="texttop" border="0" alt=""></a>
<?php } ?>
		</td>
	</tr>
	<tr>
<?php if (@$sExport <> "") { ?>
		<td class="ewRptGrpHeader1">
		Organisme <br>Responsable
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td class="ewPointer" onmousedown="ewrpt_Sort(event, 'Crosstab1ctbreport.php?<?php echo EW_REPORT_TABLE_ORDER_BY . "=" . urlencode("nomentite") . "&" . EW_REPORT_TABLE_ORDER_BY_TYPE . "=" . ewrpt_ReverseSort(@$_SESSION["sort_Crosstab1_nomentite"]); ?>');">Organisme <br>Responsable</td><td style="width: 10px;">
			<?php if (@$_SESSION["sort_Crosstab1_nomentite"] == "ASC") { ?><img src="phprptimages/sortup.gif" width="10" height="9" border="0"><?php } elseif (@$_SESSION["sort_Crosstab1_nomentite"] == "DESC") { ?><img src="phprptimages/sortdown.gif" width="10" height="9" border="0"><?php } ?></td>
			<td style="width: 20px;" align="right"><a href="#" onClick="ewrpt_ShowPopup(this.name, 'Crosstab1_nomentite', false, '<?php echo $rf_nomentite; ?>', '<?php echo $rt_nomentite; ?>');return false;" name="x_nomentite" id="x_nomentite"><img src="phprptimages/popup.gif" width="15" height="14" align="texttop" border="0" alt=""></a></td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td class="ewRptGrpHeader2" style="width: 40px;">
		Dpartement
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn" style="width: 40px;"><tr>
			<td class="ewPointer" onmousedown="ewrpt_Sort(event, 'Crosstab1ctbreport.php?<?php echo EW_REPORT_TABLE_ORDER_BY . "=" . urlencode("departemen") . "&" . EW_REPORT_TABLE_ORDER_BY_TYPE . "=" . ewrpt_ReverseSort(@$_SESSION["sort_Crosstab1_departemen"]); ?>');">Dpartement</td><td style="width: 10px;">
			<?php if (@$_SESSION["sort_Crosstab1_departemen"] == "ASC") { ?><img src="phprptimages/sortup.gif" width="10" height="9" border="0"><?php } elseif (@$_SESSION["sort_Crosstab1_departemen"] == "DESC") { ?><img src="phprptimages/sortdown.gif" width="10" height="9" border="0"><?php } ?></td>
			<td style="width: 20px;" align="right"><a href="#" onClick="ewrpt_ShowPopup(this.name, 'Crosstab1_departemen', false, '<?php echo $rf_departemen; ?>', '<?php echo $rt_departemen; ?>');return false;" name="x_departemen" id="x_departemen"><img src="phprptimages/popup.gif" width="15" height="14" align="texttop" border="0" alt=""></a></td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td class="ewRptGrpHeader3" style="width: 40px;">
		Secteur
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn" style="width: 40px;"><tr>
			<td class="ewPointer" onmousedown="ewrpt_Sort(event, 'Crosstab1ctbreport.php?<?php echo EW_REPORT_TABLE_ORDER_BY . "=" . urlencode("nomsecteur") . "&" . EW_REPORT_TABLE_ORDER_BY_TYPE . "=" . ewrpt_ReverseSort(@$_SESSION["sort_Crosstab1_nomsecteur"]); ?>');">Secteur</td><td style="width: 10px;">
			<?php if (@$_SESSION["sort_Crosstab1_nomsecteur"] == "ASC") { ?><img src="phprptimages/sortup.gif" width="10" height="9" border="0"><?php } elseif (@$_SESSION["sort_Crosstab1_nomsecteur"] == "DESC") { ?><img src="phprptimages/sortdown.gif" width="10" height="9" border="0"><?php } ?></td>
			<td style="width: 20px;" align="right"><a href="#" onClick="ewrpt_ShowPopup(this.name, 'Crosstab1_nomsecteur', false, '<?php echo $rf_nomsecteur; ?>', '<?php echo $rt_nomsecteur; ?>');return false;" name="x_nomsecteur" id="x_nomsecteur"><img src="phprptimages/popup.gif" width="15" height="14" align="texttop" border="0" alt=""></a></td>
			</tr></table>
		</td>
<?php } ?>
<!-- Dynamic columns begin -->
	<?php
	$cntval = count($val);
	for ($iy = 1; $iy < $cntval; $iy++) {
		if ($col[$iy][2]) {
			$x_datedebut = $col[$iy][1];
	?>
		<td class="ewTableHeader" valign="top">
<?php echo ewrpt_ViewValue($x_datedebut) ?>
</td>
	<?php
		}
	}
	?>
<!-- Dynamic columns end -->
		<?php $x_datedebut = "Total"; ?>
		<td class="ewTableHeader" valign="top">
<?php echo ewrpt_ViewValue($x_datedebut) ?>
</td>
	</tr>
	</thead>
<?php } // End show header ?>
	<tbody>
<?php
if ($nTotalGrps > 0) {

// Set the last group to display if not export all
if (EW_REPORT_EXPORT_ALL && @$sExport <> "") {
	$nStopGrp = $nTotalGrps;
} else {
	$nStopGrp = $nStartGrp + $nDisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($nStopGrp) > intval($nTotalGrps)) {
	$nStopGrp = $nTotalGrps;
}

// Navigate
$grpvalue = "";
$nRecCount = 0;

// Get first row
if ($nTotalGrps > 0) {
	GetGrpRow(1);
	$nGrpCount = 1;
}
while ($rsgrp && !$rsgrp->EOF) {

	// Build detail SQL
	//$sWhere = EW_REPORT_TABLE_FIRST_GROUP_FIELD . " = " . ewrpt_QuotedValue($x_nomentite, EW_REPORT_DATATYPE_STRING);

	$sWhere = ewrpt_DetailFilterSQL(EW_REPORT_TABLE_FIRST_GROUP_FIELD, $x_nomentite, EW_REPORT_DATATYPE_STRING);
	if ($sFilter != "")
		$sWhere = "($sFilter) AND ($sWhere)";
	$sSql = ewrpt_BuildReportSql($EW_REPORT_TABLE_SQL_TRANSFORM, $EW_REPORT_TABLE_SQL_SELECT, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_TABLE_SQL_GROUPBY, "", $EW_REPORT_TABLE_SQL_ORDERBY, $EW_REPORT_TABLE_SQL_PIVOT, $sWhere, @$sSort);

//	echo "sql: " . $sSql . "<br>";
	$rs = $conn->Execute($sSql);
	$rsdtlcnt = ($rs) ? $rs->RecordCount() : 0;
	if ($rsdtlcnt > 0)
		GetRow(1);
	while ($rs && !$rs->EOF) {
		$nRecCount++;

		// Set row color
		$sItemRowClass = " class=\"ewTableRow\"";

		// Display alternate color for rows
		if ($nRecCount % 2 <> 1)
			$sItemRowClass = " class=\"ewTableAltRow\"";

		// Show group values
		$g_nomentite = $x_nomentite;
		if ($x_nomentite <> "" && $o_nomentite == $x_nomentite && !ChkLvlBreak(1)) {
			$g_nomentite = "&nbsp;";
		} elseif (is_null($x_nomentite)) {
			$g_nomentite = EW_REPORT_NULL_LABEL;
		} elseif ($x_nomentite == "") {
			$g_nomentite = EW_REPORT_EMPTY_LABEL;
		}
		$g_departemen = $x_departemen;
		if ($x_departemen <> "" && $o_departemen == $x_departemen && !ChkLvlBreak(2)) {
			$g_departemen = "&nbsp;";
		} elseif (is_null($x_departemen)) {
			$g_departemen = EW_REPORT_NULL_LABEL;
		} elseif ($x_departemen == "") {
			$g_departemen = EW_REPORT_EMPTY_LABEL;
		}
		$g_nomsecteur = $x_nomsecteur;
		if ($x_nomsecteur <> "" && $o_nomsecteur == $x_nomsecteur && !ChkLvlBreak(3)) {
			$g_nomsecteur = "&nbsp;";
		} elseif (is_null($x_nomsecteur)) {
			$g_nomsecteur = EW_REPORT_NULL_LABEL;
		} elseif ($x_nomsecteur == "") {
			$g_nomsecteur = EW_REPORT_EMPTY_LABEL;
		}
?>
	<!-- Data -->
	<tr>
		<!-- Organisme <br>Responsable -->
		<td class="ewRptGrpField1"><?php $t_nomentite = $x_nomentite; $x_nomentite = $g_nomentite; ?>
<?php echo ewrpt_ViewValue($x_nomentite) ?>
<?php $x_nomentite = $t_nomentite; ?></td>
		<!-- Dpartement -->
		<td class="ewRptGrpField2" style="width: 40px;"><?php $t_departemen = $x_departemen; $x_departemen = $g_departemen; ?>
<?php echo ewrpt_ViewValue($x_departemen) ?>
<?php $x_departemen = $t_departemen; ?></td>
		<!-- Secteur -->
		<td class="ewRptGrpField3" style="width: 40px;"><?php $t_nomsecteur = $x_nomsecteur; $x_nomsecteur = $g_nomsecteur; ?>
<?php echo ewrpt_ViewValue($x_nomsecteur) ?>
<?php $x_nomsecteur = $t_nomsecteur; ?></td>
<!-- Dynamic columns begin -->
	<?php
		$rowsmry = 0;
		$cntval = count($val);
		for ($iy = 1; $iy < $cntval; $iy++) {
			if ($col[$iy][2]) {
				$rowval = $val[$iy];
				$rowsmry = ewrpt_SummaryValue($rowsmry, $rowval, EW_REPORT_TABLE_REPORT_SUMMARY_TYPE);
				$x_montantproj = $val[$iy];
	?>
		<!-- <?php echo $col[$iy][1]; ?> -->
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue(ewrpt_FormatCurrency($x_montantproj,2,-2,-2,-2)) ?>
</td>
	<?php
			}
		}
	?>
<!-- Dynamic columns end -->
	<?php $x_montantproj = $rowsmry; ?>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue(ewrpt_FormatCurrency($x_montantproj,2,-2,-2,-2)) ?>
</td>
	</tr>
<?php

		// Accumulate page summary
		AccumulateSummary();

		// Save old group values
		$o_nomentite = $x_nomentite;
		$o_departemen = $x_departemen;
		$o_nomsecteur = $x_nomsecteur;

		// Get next record
		GetRow(2);
?>
<?php
	} // End detail records loop

	// Save old group values
	$o_nomsecteur = $x_nomentite; // Save old group value
	GetGrpRow(2);
	$nGrpCount++;
?>
<?php
}
?>
	</tbody>
	<tfoot>
	<!-- Grand Total -->
	<tr class="ewRptGrandSummary">
	<td colspan="3">Grand Total</td>
<!-- Dynamic columns begin -->
	<?php 

	// aggregate sql
	$sSql = ewrpt_BuildReportSql($EW_REPORT_TABLE_SQL_TRANSFORM, $EW_REPORT_TABLE_SQL_SELECT_AGG, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_TABLE_SQL_GROUPBY_AGG, "", "", $EW_REPORT_TABLE_SQL_PIVOT, $sFilter, @$sSort);

//	echo "sql: " . $sSql . "<br>";
	$rsagg = $conn->Execute($sSql);
	if ($rsagg && !$rsagg->EOF) $rsagg->MoveFirst();

//	echo "record count: " . $rsagg->RecordCount() . "<br>";
	$rowsmry = 0;

	// Use data from recordset directly
	for ($iy = 1; $iy <= $ncol; $iy++) {
		if ($col[$iy][2]) {
			$rowval = ($rsagg && !$rsagg->EOF) ? $rsagg->fields[$iy+0-1] : 0;

//echo "rowval: $rowval<br>";
			$rowsmry = ewrpt_SummaryValue($rowsmry, $rowval, EW_REPORT_TABLE_REPORT_SUMMARY_TYPE);
			$x_montantproj = $rowval;
	?>
		<!-- <?php echo $col[$iy][1]; ?> -->
		<td>
<?php echo ewrpt_ViewValue(ewrpt_FormatCurrency($x_montantproj,2,-2,-2,-2)) ?>
</td>
	<?php
		}
	}
	?>
<!-- Dynamic columns end -->
	<?php $x_montantproj = $rowsmry; ?>
		<td>
<?php echo ewrpt_ViewValue(ewrpt_FormatCurrency($x_montantproj,2,-2,-2,-2)) ?>
</td>
	</tr>
<?php } ?>
	</tfoot>
</table>
</div>
<?php if (@$sExport == "") { ?>
<div class="ewGridLowerPanel">
<form action="Crosstab1ctbreport.php" name="ewpagerform" id="ewpagerform" class="ewForm">
<table border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td nowrap>
<?php if (!isset($Pager)) $Pager = new cPrevNextPager($nStartGrp, $nDisplayGrps, $nTotalGrps) ?>
<?php if ($Pager->RecordCount > 0) { ?>
	<table border="0" cellspacing="0" cellpadding="0"><tr><td><span class="phpreportmaker"><!-- Page&nbsp; --></span></td>
<!--first page button-->
	<?php if ($Pager->FirstButton->Enabled) { ?>
	<td><!-- <a href="Crosstab1ctbreport.php?start=<?php echo $Pager->FirstButton->Start ?>"><img src="phprptimages/first.gif" alt="First" width="16" height="16" border="0"> --></a></td>
	<?php } else { ?>
	<td><!-- <img src="phprptimages/firstdisab.gif" alt="First" width="16" height="16" border="0"> --></td>
	<?php } ?>
<!--previous page button-->
	<?php if ($Pager->PrevButton->Enabled) { ?>
	<td><!-- <a href="Crosstab1ctbreport.php?start=<?php echo $Pager->PrevButton->Start ?>"><img src="phprptimages/prev.gif" alt="Previous" width="16" height="16" border="0"></a> --></td>
	<?php } else { ?>
	<td><!-- <img src="phprptimages/prevdisab.gif" alt="Previous" width="16" height="16" border="0"> --></td>
	<?php } ?>
<!--current page number-->
	<td ><!--<input type="text" name="pageno" id="pageno" value="<?php echo $Pager->CurrentPage ?>" size="4"> --></td>
<!--next page button-->
	<?php if ($Pager->NextButton->Enabled) { ?>
	<td><!-- <a href="Crosstab1ctbreport.php?start=<?php echo $Pager->NextButton->Start ?>"><img src="phprptimages/next.gif" alt="Next" width="16" height="16" border="0"></a> --></td>	
	<?php } else { ?>
	<td><!-- <img src="phprptimages/nextdisab.gif" alt="Next" width="16" height="16" border="0"> --></td>
	<?php } ?>
<!--last page button-->
	<?php if ($Pager->LastButton->Enabled) { ?>
	<td><!-- <a href="Crosstab1ctbreport.php?start=<?php echo $Pager->LastButton->Start ?>"><img src="phprptimages/last.gif" alt="Last" width="16" height="16" border="0"></a> --></td>	
	<?php } else { ?>
	<td><!-- <img src="phprptimages/lastdisab.gif" alt="Last" width="16" height="16" border="0"> --></td>
	<?php } ?>
	<td><!-- <span class="phpreportmaker"><!-- &nbsp;of <?php echo $Pager->PageCount ?> --> </span></td>
	</tr></table>
	</td>	
	<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
	<td>
	<!-- <span class="phpreportmaker"> <?php echo $Pager->FromIndex ?> to <?php echo $Pager->ToIndex ?> of <?php echo $Pager->RecordCount ?></span> -->
<?php } else { ?>
	<?php if (($ewCurSec & EW_ALLOW_LIST) == EW_ALLOW_LIST) { ?>
	<?php if ($sFilter == "0=101") { ?>
	<span class="phpreportmaker">Please enter search criteria</span>
	<?php } else { ?>
	<span class="phpreportmaker">No records found</span>
	<?php } ?>
	<?php } else { ?>
	<span class="phpreportmaker">You do not have the right permission to view the page</span>
	<?php } ?>
<?php } ?>
		</td>
	</tr>
</table>
</form>
</div>
<?php } ?>
</td></tr></table>
</div>
<!-- Crosstab report ends -->
<?php if (@$sExport == "") { ?>
	</div><br /></td>
	<!-- Center container (report) (end) -->
	<!-- Right container (begin) -->
	<td valign="top"><div id="ewRight" class="phpreportmaker">
	<!-- right slot -->
	</div></td>
	<!-- Right container (end) -->
</tr>
<!-- Bottom container (begin) -->
<tr><td colspan="3" class="ewPadding"><div id="ewBottom" class="phpreportmaker">
	<!-- bottom slot -->
<CENTER><a name="cht_Chart1"></a>
<div id="div_Crosstab1_Chart1"></div></CENTER>
<?php

// Initialize chart data
$Chart1_cht_id = "Crosstab1_Chart1"; // Chart ID
ewrpt_AddChartParam($Chart1_cht_parms, "type", "15", FALSE); // Chart type
ewrpt_AddChartParam($Chart1_cht_parms, "bgcolor", "#FCFCFC", TRUE); // Background color
ewrpt_AddChartParam($Chart1_cht_parms, "caption", "Montant engag par dpartement par anne", TRUE); // Chart caption
ewrpt_AddChartParam($Chart1_cht_parms, "xaxisname", "Dpartement", TRUE); // X axis name
ewrpt_AddChartParam($Chart1_cht_parms, "yaxisname", "Montant engage", TRUE); // Y axis name
ewrpt_AddChartParam($Chart1_cht_parms, "shownames", "1", TRUE); // Show names
ewrpt_AddChartParam($Chart1_cht_parms, "showvalues", "0", TRUE); // Show values
ewrpt_AddChartParam($Chart1_cht_parms, "showhovercap", "1", TRUE); // Show hover
ewrpt_AddChartParam($Chart1_cht_parms, "alpha", "90", FALSE); // Chart alpha
ewrpt_AddChartParam($Chart1_cht_parms, "colorpalette", "#FF8C00|#BDB76B|#9ACD32|#0000FF|#FF8000|#FF3D3D|#7AFFFF|#339900|#FFFF00|#FF7A7A|#3DFFFF|#FFA500|#80FF00|#00FF00|#00FF80|#00FFFF", FALSE); // Chart color palette
?>
<?php
ewrpt_SetChartParam($Chart1_cht_parms, "canvasBgColor", "#EEEEEE", TRUE); // canvasBgColor
ewrpt_SetChartParam($Chart1_cht_parms, "canvasBorderColor", "#A9A9A9", TRUE); // canvasBorderColor
ewrpt_SetChartParam($Chart1_cht_parms, "showCanvasBg", "1", TRUE); // showCanvasBg
ewrpt_SetChartParam($Chart1_cht_parms, "showCanvasBase", "1", TRUE); // showCanvasBase
ewrpt_SetChartParam($Chart1_cht_parms, "showLimits", "1", TRUE); // showLimits
ewrpt_SetChartParam($Chart1_cht_parms, "animation", "1", TRUE); // animation
ewrpt_SetChartParam($Chart1_cht_parms, "rotateNames", "1", TRUE); // rotateNames
ewrpt_SetChartParam($Chart1_cht_parms, "yAxisMinValue", "0", TRUE); // yAxisMinValue
ewrpt_SetChartParam($Chart1_cht_parms, "yAxisMaxValue", "0", TRUE); // yAxisMaxValue
ewrpt_SetChartParam($Chart1_cht_parms, "showColumnShadow", "0", TRUE); // showColumnShadow
ewrpt_SetChartParam($Chart1_cht_parms, "showPercentageValues", "1", TRUE); // showPercentageValues
ewrpt_SetChartParam($Chart1_cht_parms, "showPercentageInLabel", "1", TRUE); // showPercentageInLabel
ewrpt_SetChartParam($Chart1_cht_parms, "showBarShadow", "0", TRUE); // showBarShadow
ewrpt_SetChartParam($Chart1_cht_parms, "showAnchors", "1", TRUE); // showAnchors
ewrpt_SetChartParam($Chart1_cht_parms, "showAreaBorder", "1", TRUE); // showAreaBorder
ewrpt_SetChartParam($Chart1_cht_parms, "showShadow", "1", TRUE); // showShadow
ewrpt_SetChartParam($Chart1_cht_parms, "formatNumber", "1", TRUE); // formatNumber
ewrpt_SetChartParam($Chart1_cht_parms, "formatNumberScale", "1", TRUE); // formatNumberScale
ewrpt_SetChartParam($Chart1_cht_parms, "decimalSeparator", ".", TRUE); // decimalSeparator
ewrpt_SetChartParam($Chart1_cht_parms, "thousandSeparator", ",", TRUE); // thousandSeparator
ewrpt_SetChartParam($Chart1_cht_parms, "decimalPrecision", "2", TRUE); // decimalPrecision
ewrpt_SetChartParam($Chart1_cht_parms, "divLineDecimalPrecision", "2", TRUE); // divLineDecimalPrecision
ewrpt_SetChartParam($Chart1_cht_parms, "limitsDecimalPrecision", "2", TRUE); // limitsDecimalPrecision
ewrpt_SetChartParam($Chart1_cht_parms, "zeroPlaneShowBorder", "1", TRUE); // zeroPlaneShowBorder
ewrpt_SetChartParam($Chart1_cht_parms, "divLineColor", "#DCDCDC", TRUE); // divLineColor
ewrpt_SetChartParam($Chart1_cht_parms, "showDivLineValue", "1", TRUE); // showDivLineValue
ewrpt_SetChartParam($Chart1_cht_parms, "showAlternateHGridColor", "0", TRUE); // showAlternateHGridColor
ewrpt_SetChartParam($Chart1_cht_parms, "showAlternateVGridColor", "0", TRUE); // showAlternateVGridColor
ewrpt_SetChartParam($Chart1_cht_parms, "hoverCapSepChar", ":", TRUE); // hoverCapSepChar

// Define trend lines
?>
<?php

// Load chart series from sql directly
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_CHART_CHART1_SQL_SELECT_SERIES, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_CHART_CHART1_SQL_GROUPBY_SERIES, "", "", "", $sFilter, "");

//echo "sql: " . $sSql . "<br>";
ewrpt_LoadChartSeries($sSql, $Chart1_cht_series, $EW_REPORT_CHART_CHART1_DATE_TYPE);

// Load chart data from sql directly
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_CHART_CHART1_SQL_SELECT, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_CHART_CHART1_SQL_GROUPBY, "", "", "", $sFilter, "");

//echo "sql: " . $sSql . "<br>";
ewrpt_LoadChartData($sSql, $Chart1_cht_smry, $EW_REPORT_CHART_CHART1_DATE_TYPE);
if (is_array($col)) {
	ewrpt_SortMultiChartData($Chart1_cht_smry, 0, count($col) - 1);
} else {
	ewrpt_SortChartData($Chart1_cht_smry, 0);
}
echo ewrpt_ShowChartFCF(15, $Chart1_cht_id, $Chart1_cht_parms, $Chart1_cht_trends, $Chart1_cht_smry, $Chart1_cht_series, 650, 440, "");
?>
<a href="#top">Top</a>
<br /><br />
<CENTER><a name="cht_Chart2"></a>
<div id="div_Crosstab1_Chart2"></div></CENTER>
<?php

// Initialize chart data
$Chart2_cht_id = "Crosstab1_Chart2"; // Chart ID
ewrpt_AddChartParam($Chart2_cht_parms, "type", "15", FALSE); // Chart type
ewrpt_AddChartParam($Chart2_cht_parms, "bgcolor", "#FCFCFC", TRUE); // Background color
ewrpt_AddChartParam($Chart2_cht_parms, "caption", "Montant engag par secteur par anne", TRUE); // Chart caption
ewrpt_AddChartParam($Chart2_cht_parms, "xaxisname", "Secteur", TRUE); // X axis name
ewrpt_AddChartParam($Chart2_cht_parms, "yaxisname", "Montant engage", TRUE); // Y axis name
ewrpt_AddChartParam($Chart2_cht_parms, "shownames", "1", TRUE); // Show names
ewrpt_AddChartParam($Chart2_cht_parms, "showvalues", "0", TRUE); // Show values
ewrpt_AddChartParam($Chart2_cht_parms, "showhovercap", "1", TRUE); // Show hover
ewrpt_AddChartParam($Chart2_cht_parms, "alpha", "70", FALSE); // Chart alpha
ewrpt_AddChartParam($Chart2_cht_parms, "colorpalette", "#FF8C00|#BDB76B|#9ACD32|#0000FF|#FF8000|#FF3D3D|#7AFFFF|#339900|#FFFF00|#FF7A7A|#3DFFFF|#FFA500|#80FF00|#00FF00|#00FF80|#00FFFF", FALSE); // Chart color palette
?>
<?php
ewrpt_SetChartParam($Chart2_cht_parms, "showCanvasBg", "1", TRUE); // showCanvasBg
ewrpt_SetChartParam($Chart2_cht_parms, "showCanvasBase", "1", TRUE); // showCanvasBase
ewrpt_SetChartParam($Chart2_cht_parms, "showLimits", "1", TRUE); // showLimits
ewrpt_SetChartParam($Chart2_cht_parms, "animation", "1", TRUE); // animation
ewrpt_SetChartParam($Chart2_cht_parms, "rotateNames", "1", TRUE); // rotateNames
ewrpt_SetChartParam($Chart2_cht_parms, "yAxisMinValue", "0", TRUE); // yAxisMinValue
ewrpt_SetChartParam($Chart2_cht_parms, "yAxisMaxValue", "0", TRUE); // yAxisMaxValue
ewrpt_SetChartParam($Chart2_cht_parms, "showColumnShadow", "0", TRUE); // showColumnShadow
ewrpt_SetChartParam($Chart2_cht_parms, "showPercentageValues", "1", TRUE); // showPercentageValues
ewrpt_SetChartParam($Chart2_cht_parms, "showPercentageInLabel", "1", TRUE); // showPercentageInLabel
ewrpt_SetChartParam($Chart2_cht_parms, "showBarShadow", "0", TRUE); // showBarShadow
ewrpt_SetChartParam($Chart2_cht_parms, "showAnchors", "1", TRUE); // showAnchors
ewrpt_SetChartParam($Chart2_cht_parms, "showAreaBorder", "1", TRUE); // showAreaBorder
ewrpt_SetChartParam($Chart2_cht_parms, "showShadow", "1", TRUE); // showShadow
ewrpt_SetChartParam($Chart2_cht_parms, "formatNumber", "1", TRUE); // formatNumber
ewrpt_SetChartParam($Chart2_cht_parms, "formatNumberScale", "1", TRUE); // formatNumberScale
ewrpt_SetChartParam($Chart2_cht_parms, "decimalSeparator", ".", TRUE); // decimalSeparator
ewrpt_SetChartParam($Chart2_cht_parms, "thousandSeparator", ",", TRUE); // thousandSeparator
ewrpt_SetChartParam($Chart2_cht_parms, "decimalPrecision", "2", TRUE); // decimalPrecision
ewrpt_SetChartParam($Chart2_cht_parms, "divLineDecimalPrecision", "2", TRUE); // divLineDecimalPrecision
ewrpt_SetChartParam($Chart2_cht_parms, "limitsDecimalPrecision", "2", TRUE); // limitsDecimalPrecision
ewrpt_SetChartParam($Chart2_cht_parms, "zeroPlaneShowBorder", "1", TRUE); // zeroPlaneShowBorder
ewrpt_SetChartParam($Chart2_cht_parms, "showDivLineValue", "1", TRUE); // showDivLineValue
ewrpt_SetChartParam($Chart2_cht_parms, "showAlternateHGridColor", "0", TRUE); // showAlternateHGridColor
ewrpt_SetChartParam($Chart2_cht_parms, "showAlternateVGridColor", "0", TRUE); // showAlternateVGridColor
ewrpt_SetChartParam($Chart2_cht_parms, "hoverCapSepChar", ":", TRUE); // hoverCapSepChar

// Define trend lines
?>
<?php

// Load chart series from sql directly
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_CHART_CHART2_SQL_SELECT_SERIES, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_CHART_CHART2_SQL_GROUPBY_SERIES, "", "", "", $sFilter, "");

//echo "sql: " . $sSql . "<br>";
ewrpt_LoadChartSeries($sSql, $Chart2_cht_series, $EW_REPORT_CHART_CHART2_DATE_TYPE);

// Load chart data from sql directly
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_CHART_CHART2_SQL_SELECT, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_CHART_CHART2_SQL_GROUPBY, "", "", "", $sFilter, "");

//echo "sql: " . $sSql . "<br>";
ewrpt_LoadChartData($sSql, $Chart2_cht_smry, $EW_REPORT_CHART_CHART2_DATE_TYPE);
if (is_array($col)) {
	ewrpt_SortMultiChartData($Chart2_cht_smry, 0, count($col) - 1);
} else {
	ewrpt_SortChartData($Chart2_cht_smry, 0);
}
echo ewrpt_ShowChartFCF(15, $Chart2_cht_id, $Chart2_cht_parms, $Chart2_cht_trends, $Chart2_cht_smry, $Chart2_cht_series, 850, 840, "");
?>
<a href="#top">Top</a>
<br /><br />
<CENTER><a name="cht_Chart3"></a>
<div id="div_Crosstab1_Chart3"></div></CENTER>
<?php

// Initialize chart data
$Chart3_cht_id = "Crosstab1_Chart3"; // Chart ID
ewrpt_AddChartParam($Chart3_cht_parms, "type", "15", FALSE); // Chart type
ewrpt_AddChartParam($Chart3_cht_parms, "bgcolor", "#FCFCFC", TRUE); // Background color
ewrpt_AddChartParam($Chart3_cht_parms, "caption", "Montant engag par organisme responsable par anne", TRUE); // Chart caption
ewrpt_AddChartParam($Chart3_cht_parms, "xaxisname", "Organisme Responsable", TRUE); // X axis name
ewrpt_AddChartParam($Chart3_cht_parms, "yaxisname", "Montant engage", TRUE); // Y axis name
ewrpt_AddChartParam($Chart3_cht_parms, "shownames", "1", TRUE); // Show names
ewrpt_AddChartParam($Chart3_cht_parms, "showvalues", "0", TRUE); // Show values
ewrpt_AddChartParam($Chart3_cht_parms, "showhovercap", "1", TRUE); // Show hover
ewrpt_AddChartParam($Chart3_cht_parms, "alpha", "60", FALSE); // Chart alpha
ewrpt_AddChartParam($Chart3_cht_parms, "colorpalette", "#FF8C00|#BDB76B|#9ACD32|#0000FF|#FF8000|#FF3D3D|#7AFFFF|#339900|#FFFF00|#FF7A7A|#3DFFFF|#FFA500|#80FF00|#00FF00|#00FF80|#00FFFF", FALSE); // Chart color palette
?>
<?php
ewrpt_SetChartParam($Chart3_cht_parms, "showCanvasBg", "1", TRUE); // showCanvasBg
ewrpt_SetChartParam($Chart3_cht_parms, "showCanvasBase", "1", TRUE); // showCanvasBase
ewrpt_SetChartParam($Chart3_cht_parms, "showLimits", "1", TRUE); // showLimits
ewrpt_SetChartParam($Chart3_cht_parms, "animation", "1", TRUE); // animation
ewrpt_SetChartParam($Chart3_cht_parms, "rotateNames", "1", TRUE); // rotateNames
ewrpt_SetChartParam($Chart3_cht_parms, "yAxisMinValue", "0", TRUE); // yAxisMinValue
ewrpt_SetChartParam($Chart3_cht_parms, "yAxisMaxValue", "0", TRUE); // yAxisMaxValue
ewrpt_SetChartParam($Chart3_cht_parms, "showColumnShadow", "0", TRUE); // showColumnShadow
ewrpt_SetChartParam($Chart3_cht_parms, "showPercentageValues", "1", TRUE); // showPercentageValues
ewrpt_SetChartParam($Chart3_cht_parms, "showPercentageInLabel", "1", TRUE); // showPercentageInLabel
ewrpt_SetChartParam($Chart3_cht_parms, "showBarShadow", "0", TRUE); // showBarShadow
ewrpt_SetChartParam($Chart3_cht_parms, "showAnchors", "1", TRUE); // showAnchors
ewrpt_SetChartParam($Chart3_cht_parms, "showAreaBorder", "1", TRUE); // showAreaBorder
ewrpt_SetChartParam($Chart3_cht_parms, "showShadow", "1", TRUE); // showShadow
ewrpt_SetChartParam($Chart3_cht_parms, "formatNumber", "1", TRUE); // formatNumber
ewrpt_SetChartParam($Chart3_cht_parms, "formatNumberScale", "1", TRUE); // formatNumberScale
ewrpt_SetChartParam($Chart3_cht_parms, "decimalSeparator", ".", TRUE); // decimalSeparator
ewrpt_SetChartParam($Chart3_cht_parms, "thousandSeparator", ",", TRUE); // thousandSeparator
ewrpt_SetChartParam($Chart3_cht_parms, "decimalPrecision", "2", TRUE); // decimalPrecision
ewrpt_SetChartParam($Chart3_cht_parms, "divLineDecimalPrecision", "2", TRUE); // divLineDecimalPrecision
ewrpt_SetChartParam($Chart3_cht_parms, "limitsDecimalPrecision", "2", TRUE); // limitsDecimalPrecision
ewrpt_SetChartParam($Chart3_cht_parms, "zeroPlaneShowBorder", "1", TRUE); // zeroPlaneShowBorder
ewrpt_SetChartParam($Chart3_cht_parms, "showDivLineValue", "1", TRUE); // showDivLineValue
ewrpt_SetChartParam($Chart3_cht_parms, "showAlternateHGridColor", "0", TRUE); // showAlternateHGridColor
ewrpt_SetChartParam($Chart3_cht_parms, "showAlternateVGridColor", "0", TRUE); // showAlternateVGridColor
ewrpt_SetChartParam($Chart3_cht_parms, "hoverCapSepChar", ":", TRUE); // hoverCapSepChar

// Define trend lines
?>
<?php

// Load chart series from sql directly
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_CHART_CHART3_SQL_SELECT_SERIES, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_CHART_CHART3_SQL_GROUPBY_SERIES, "", "", "", $sFilter, "");

//echo "sql: " . $sSql . "<br>";
ewrpt_LoadChartSeries($sSql, $Chart3_cht_series, $EW_REPORT_CHART_CHART3_DATE_TYPE);

// Load chart data from sql directly
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_CHART_CHART3_SQL_SELECT, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_CHART_CHART3_SQL_GROUPBY, "", "", "", $sFilter, "");

//echo "sql: " . $sSql . "<br>";
ewrpt_LoadChartData($sSql, $Chart3_cht_smry, $EW_REPORT_CHART_CHART3_DATE_TYPE);
if (is_array($col)) {
	ewrpt_SortMultiChartData($Chart3_cht_smry, 0, count($col) - 1);
} else {
	ewrpt_SortChartData($Chart3_cht_smry, 0);
}
echo ewrpt_ShowChartFCF(15, $Chart3_cht_id, $Chart3_cht_parms, $Chart3_cht_trends, $Chart3_cht_smry, $Chart3_cht_series, 650, 440, "");
?>
<a href="#top">Top</a>
<br /><br />
	</div><br /></td></tr>
<!-- Bottom container (end) -->
</table>
<!-- Table container (end) -->
<?php } ?>
<?php

// Close recordset and connection
if ($rs)
	$rs->Close();
$conn->Close();

// Display elapsed time
if (defined("EW_REPORT_DEBUG_ENABLED"))
	echo ewrpt_calcElapsedTime($starttime);
?>
<?php// include "phprptinc/footerreport.php"; ?>
<?php if (@$sExport == "") { ?>
<?php //include "footer_admin.php"; ?>
<?php } ?>
<?php

// Get column values
function GetColumns() {
	global $conn;
	global $EW_REPORT_TABLE_SQL_SELECT;
	global $EW_REPORT_TABLE_SQL_SELECT_AGG;
	global $EW_REPORT_TABLE_DISTINCT_SQL_SELECT;
	global $EW_REPORT_TABLE_DISTINCT_SQL_WHERE;
	global $EW_REPORT_TABLE_DISTINCT_SQL_ORDERBY;
	global $sFilter, $sSort;
	global $ncol, $col, $val, $valcnt, $cnt, $smry, $smrycnt, $ncolspan;
	global $sel_datedebut;
	global $val_datedebut;

	// Build SQL
	$sSql = ewrpt_BuildReportSql("", $EW_REPORT_TABLE_DISTINCT_SQL_SELECT, $EW_REPORT_TABLE_DISTINCT_SQL_WHERE, "", "", $EW_REPORT_TABLE_DISTINCT_SQL_ORDERBY, "", $sFilter, @$sSort);

	// Load recordset
	$rscol = $conn->Execute($sSql);

	// Get distinct column count
	$ncol = ($rscol) ? $rscol->RecordCount() : 0;
	if ($ncol == 0) {
		$rscol->Close();
		echo "No distinct column values for sql: " . $sSql . "<br />";
		exit();
	}

	// 1st dimension = no of groups (level 0 used for grand total)
	// 2nd dimension = no of distinct values

	$nGrps = 3;
	$col = ewrpt_Init2DArray($ncol+1, 2, NULL);
	$val = ewrpt_InitArray($ncol+1, NULL);
	$valcnt = ewrpt_InitArray($ncol+1, NULL);
	$cnt = ewrpt_Init2DArray($ncol+1, $nGrps+1, NULL);
	$smry = ewrpt_Init2DArray($ncol+1, $nGrps+1, NULL);
	$smrycnt = ewrpt_Init2DArray($ncol+1, $nGrps+1, NULL);

	// Reset summary values
	ResetLevelSummary(0);
	$colcnt = 0;
	while (!$rscol->EOF) {
		if (is_null($rscol->fields[0])) {
			$wrkValue = "";
			$wrkCaption = EW_REPORT_NULL_LABEL;
		} elseif ($rscol->fields[0] == "") {
			$wrkValue = "";
			$wrkCaption = EW_REPORT_EMPTY_LABEL;
		} else {
			$wrkValue = $rscol->fields[0];
			$wrkCaption = $rscol->fields[0];
		}
		$colcnt++;
		$col[$colcnt][0] = $wrkValue; // value
		$col[$colcnt][1] = $wrkCaption; // caption
		$col[$colcnt][2] = TRUE; // column visible
		$val_datedebut[$wrkValue] = $wrkCaption;
		$rscol->MoveNext();
	}
	$rscol->Close();

	// Get active columns
	if (!is_array($sel_datedebut)) {
		$ncolspan = $ncol;
	} else {
		$ncolspan = 0;
		$cntcol = count($col);
		for ($i = 0; $i < $cntcol; $i++) {
			$bSelected = FALSE;
			$cntsel = count($sel_datedebut);
			for ($j = 0; $j < $cntsel; $j++) {
				if (trim($sel_datedebut[$j]) == trim($col[$i][0])) {
					$ncolspan++;
					$bSelected = TRUE;
					break;
				}
			}
			$col[$i][2] = $bSelected;
		}
	}
	$ncolspan++; // Add summary column

	// Update crosstab sql
	$sSqlFlds = "";
	for ($colcnt = 1; $colcnt <= $ncol; $colcnt++) {
		$sFld = ewrpt_CrossTabField(EW_REPORT_TABLE_REPORT_SUMMARY_TYPE, EW_REPORT_TABLE_REPORT_SUMMARY_FLD, EW_REPORT_TABLE_REPORT_COLUMN_FLD, EW_REPORT_TABLE_REPORT_COLUMN_DATE_TYPE, $col[$colcnt][0], "'", "C" . $colcnt);
		if ($sSqlFlds <> "")
			$sSqlFlds .= ", ";
		$sSqlFlds .= $sFld;
	}
	$EW_REPORT_TABLE_SQL_SELECT = str_replace("<DistinctColumnFields>", $sSqlFlds, $EW_REPORT_TABLE_SQL_SELECT);
	$EW_REPORT_TABLE_SQL_SELECT_AGG = str_replace("<DistinctColumnFields>", $sSqlFlds, $EW_REPORT_TABLE_SQL_SELECT_AGG);

	// Update chart sql if Y Axis = Column Field
	$sSqlChtFld = "";
	for ($i = 0; $i < $ncol; $i++) {
		if ($col[$i+1][2]) {
			$sChtFld = ewrpt_CrossTabField("SUM", EW_REPORT_TABLE_REPORT_SUMMARY_FLD, EW_REPORT_TABLE_REPORT_COLUMN_FLD, EW_REPORT_TABLE_REPORT_COLUMN_DATE_TYPE, $col[$i+1][0], "'");
			if ($sSqlChtFld != "") $sSqlChtFld .= "+";
			$sSqlChtFld .= $sChtFld;
		}
	}
}

// Get group count
function GetGrpCnt($sql) {
	global $conn;

	//echo "sql (GetGrpCnt): " . $sql . "<br>";
	$rsgrpcnt = $conn->Execute($sql);
	$grpcnt = ($rsgrpcnt) ? $rsgrpcnt->RecordCount() : 0;
	return $grpcnt;
}

// Get group rs
function GetGrpRs($sql, $start, $grps) {
	global $conn;
	$wrksql = $sql . " LIMIT " . ($start-1) . ", " . ($grps);

	//echo "wrksql: (rsgrp)" . $sSql . "<br>";
	$rswrk = $conn->Execute($wrksql);
	return $rswrk;
}

// Get group row values
function GetGrpRow($opt) {
	global $rsgrp;
	if (!$rsgrp)
		return;
	if ($opt == 1) { // Get first group
		$rsgrp->MoveFirst();
	} else { // Get next group
		$rsgrp->MoveNext();
	}
	if ($rsgrp->EOF) {
		$GLOBALS['x_nomentite'] = "";
	} else {
		$GLOBALS['x_nomentite'] = $rsgrp->fields('nomentite');
	}
}

// Get row values
function GetRow($opt) {
	global $rs, $val;
	if (!$rs)
		return;
	if ($opt == 1) { // Get first row
		$rs->MoveFirst();
	} else { // Get next row
		$rs->MoveNext();
	}
	if (!$rs->EOF) {
		$GLOBALS['x_departemen'] = $rs->fields('departemen');
		$GLOBALS['x_nomsecteur'] = $rs->fields('nomsecteur');
		$cntval = count($val);
		for ($ix = 1; $ix < $cntval; $ix++)
			$val[$ix] = $rs->fields[$ix+3-1];
	} else {
		$GLOBALS['x_departemen'] = "";
		$GLOBALS['x_nomsecteur'] = "";
	}
}

// Check level break
function ChkLvlBreak($lvl) {
	switch ($lvl) {
		case 1:
			return (is_null($GLOBALS["x_nomentite"]) && !is_null($GLOBALS["o_nomentite"])) ||
			(!is_null($GLOBALS["x_nomentite"]) && is_null($GLOBALS["o_nomentite"])) ||
			($GLOBALS["x_nomentite"] <> $GLOBALS["o_nomentite"]);
		case 2:
			return (is_null($GLOBALS["x_departemen"]) && !is_null($GLOBALS["o_departemen"])) ||
			(!is_null($GLOBALS["x_departemen"]) && is_null($GLOBALS["o_departemen"])) ||
			($GLOBALS["x_departemen"] <> $GLOBALS["o_departemen"]) || ChkLvlBreak(1); // Recurse upper level
		case 3:
			return (is_null($GLOBALS["x_nomsecteur"]) && !is_null($GLOBALS["o_nomsecteur"])) ||
			(!is_null($GLOBALS["x_nomsecteur"]) && is_null($GLOBALS["o_nomsecteur"])) ||
			($GLOBALS["x_nomsecteur"] <> $GLOBALS["o_nomsecteur"]) || ChkLvlBreak(2); // Recurse upper level
	}
}

// Accummulate summary
function AccumulateSummary() {
	global $val, $cnt, $smry;
	$cntx = count($smry);
	for ($ix = 1; $ix < $cntx; $ix++) {
		$cnty = count($smry[$ix]);
		for ($iy = 0; $iy < $cnty; $iy++) {
			$valwrk = $val[$ix];
			$cnt[$ix][$iy]++;
			$smry[$ix][$iy] = ewrpt_SummaryValue($smry[$ix][$iy], $valwrk, EW_REPORT_TABLE_REPORT_SUMMARY_TYPE);
		}
	}
}

// Reset level summary
function ResetLevelSummary($lvl) {

	// Clear summary values
	global $nRecCount, $cnt, $smry, $smrycnt;
	$cntx = count($smry);
	for ($ix = 1; $ix < $cntx; $ix++) {
		$cnty = count($smry[$ix]);
		for ($iy = $lvl; $iy < $cnty; $iy++) {
			$cnt[$ix][$iy] = 0;
			$smry[$ix][$iy] = 0;
		}
	}

	// Reset record count
	$nRecCount = 0;
}

// Set up starting group
function SetUpStartGroup() {
	global $nStartGrp, $nTotalGrps, $nDisplayGrps;

	// Exit if no groups
	if ($nDisplayGrps == 0)
		return;

	// Check for a 'start' parameter
	if (@$_GET[EW_REPORT_TABLE_START_GROUP] != "") {
		$nStartGrp = $_GET[EW_REPORT_TABLE_START_GROUP];
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (@$_GET["pageno"] != "") {
		$nPageNo = $_GET["pageno"];
		if (is_numeric($nPageNo)) {
			$nStartGrp = ($nPageNo-1)*$nDisplayGrps+1;
			if ($nStartGrp <= 0) {
				$nStartGrp = 1;
			} elseif ($nStartGrp >= intval(($nTotalGrps-1)/$nDisplayGrps)*$nDisplayGrps+1) {
				$nStartGrp = intval(($nTotalGrps-1)/$nDisplayGrps)*$nDisplayGrps+1;
			}
			$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
		} else {
			$nStartGrp = @$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP];	
		}
	} else {
		$nStartGrp = @$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP];
	}

	// Check if correct start group counter
	if (!is_numeric($nStartGrp) || $nStartGrp == "") { // Avoid invalid start group counter
		$nStartGrp = 1; // Reset start group counter
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (intval($nStartGrp) > intval($nTotalGrps)) { // Avoid starting group > total groups
		$nStartGrp = intval(($nTotalGrps-1)/$nDisplayGrps) * $nDisplayGrps + 1; // Point to last page first group
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (($nStartGrp-1) % $nDisplayGrps <> 0) {
		$nStartGrp = intval(($nStartGrp-1)/$nDisplayGrps) * $nDisplayGrps + 1; // Point to page boundary
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	}
}

// Set up popup
function SetupPopup() {
	global $conn, $sFilter;

	// Build distinct values for Organisme <br>Responsable
	$bNullValue = FALSE;
	$bEmptyValue = FALSE;
	$sSql = ewrpt_BuildReportSql("", $GLOBALS["EW_REPORT_FIELD_NOMENTITE_SQL_SELECT"], $GLOBALS["EW_REPORT_TABLE_SQL_WHERE"], $GLOBALS["EW_REPORT_TABLE_SQL_GROUPBY"], $GLOBALS["EW_REPORT_TABLE_SQL_HAVING"], $GLOBALS["EW_REPORT_FIELD_NOMENTITE_SQL_ORDERBY"], "", $sFilter, "");
	$rswrk = $conn->Execute($sSql);
	while ($rswrk && !$rswrk->EOF) {
		$x_nomentite = $rswrk->fields[0];
		if (is_null($x_nomentite)) {
			$bNullValue = TRUE;
		} elseif ($x_nomentite == "") {
			$bEmptyValue = TRUE;
		} else {
			$g_nomentite = $x_nomentite;
			ewrpt_SetupDistinctValues($GLOBALS["val_nomentite"], $x_nomentite, $g_nomentite, FALSE);
		}
		$rswrk->MoveNext();
	}
	if ($rswrk)
		$rswrk->Close();
	if ($bEmptyValue)
		ewrpt_SetupDistinctValues($GLOBALS["val_nomentite"], EW_REPORT_EMPTY_VALUE, EW_REPORT_EMPTY_LABEL, FALSE);
	if ($bNullValue)
		ewrpt_SetupDistinctValues($GLOBALS["val_nomentite"], EW_REPORT_NULL_VALUE, EW_REPORT_NULL_LABEL, FALSE);

	// Build distinct values for Dpartement
	$bNullValue = FALSE;
	$bEmptyValue = FALSE;
	$sSql = ewrpt_BuildReportSql("", $GLOBALS["EW_REPORT_FIELD_DEPARTEMEN_SQL_SELECT"], $GLOBALS["EW_REPORT_TABLE_SQL_WHERE"], $GLOBALS["EW_REPORT_TABLE_SQL_GROUPBY"], $GLOBALS["EW_REPORT_TABLE_SQL_HAVING"], $GLOBALS["EW_REPORT_FIELD_DEPARTEMEN_SQL_ORDERBY"], "", $sFilter, "");
	$rswrk = $conn->Execute($sSql);
	while ($rswrk && !$rswrk->EOF) {
		$x_departemen = $rswrk->fields[0];
		if (is_null($x_departemen)) {
			$bNullValue = TRUE;
		} elseif ($x_departemen == "") {
			$bEmptyValue = TRUE;
		} else {
			$g_departemen = $x_departemen;
			ewrpt_SetupDistinctValues($GLOBALS["val_departemen"], $x_departemen, $g_departemen, FALSE);
		}
		$rswrk->MoveNext();
	}
	if ($rswrk)
		$rswrk->Close();
	if ($bEmptyValue)
		ewrpt_SetupDistinctValues($GLOBALS["val_departemen"], EW_REPORT_EMPTY_VALUE, EW_REPORT_EMPTY_LABEL, FALSE);
	if ($bNullValue)
		ewrpt_SetupDistinctValues($GLOBALS["val_departemen"], EW_REPORT_NULL_VALUE, EW_REPORT_NULL_LABEL, FALSE);

	// Build distinct values for Secteur
	$bNullValue = FALSE;
	$bEmptyValue = FALSE;
	$sSql = ewrpt_BuildReportSql("", $GLOBALS["EW_REPORT_FIELD_NOMSECTEUR_SQL_SELECT"], $GLOBALS["EW_REPORT_TABLE_SQL_WHERE"], $GLOBALS["EW_REPORT_TABLE_SQL_GROUPBY"], $GLOBALS["EW_REPORT_TABLE_SQL_HAVING"], $GLOBALS["EW_REPORT_FIELD_NOMSECTEUR_SQL_ORDERBY"], "", $sFilter, "");
	$rswrk = $conn->Execute($sSql);
	while ($rswrk && !$rswrk->EOF) {
		$x_nomsecteur = $rswrk->fields[0];
		if (is_null($x_nomsecteur)) {
			$bNullValue = TRUE;
		} elseif ($x_nomsecteur == "") {
			$bEmptyValue = TRUE;
		} else {
			$g_nomsecteur = $x_nomsecteur;
			ewrpt_SetupDistinctValues($GLOBALS["val_nomsecteur"], $x_nomsecteur, $g_nomsecteur, FALSE);
		}
		$rswrk->MoveNext();
	}
	if ($rswrk)
		$rswrk->Close();
	if ($bEmptyValue)
		ewrpt_SetupDistinctValues($GLOBALS["val_nomsecteur"], EW_REPORT_EMPTY_VALUE, EW_REPORT_EMPTY_LABEL, FALSE);
	if ($bNullValue)
		ewrpt_SetupDistinctValues($GLOBALS["val_nomsecteur"], EW_REPORT_NULL_VALUE, EW_REPORT_NULL_LABEL, FALSE);

	// Process post back form
	if (count($_POST) > 0) {
		$sName = @$_POST["popup"]; // Get popup form name
		if ($sName <> "") {
			$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
			if ($cntValues > 0) {
				$arValues = ewrpt_StripSlashes($_POST["sel_$sName"]);
				if (trim($arValues[0]) == "") // Select all
					$arValues = EW_REPORT_INIT_VALUE;
				$_SESSION["sel_$sName"] = $arValues;
				$_SESSION["rf_$sName"] = ewrpt_StripSlashes(@$_POST["rf_$sName"]);
				$_SESSION["rt_$sName"] = ewrpt_StripSlashes(@$_POST["rt_$sName"]);
				ResetPager();
			}
		}

	// Get 'reset' command
	} elseif (@$_GET["cmd"] <> "") {
		$sCmd = $_GET["cmd"];
		if (strtolower($sCmd) == "reset") {
			ClearSessionSelection('nomentite');
			ClearSessionSelection('departemen');
			ClearSessionSelection('nomsecteur');
			$_SESSION["sel_Crosstab1_datedebut"] = "";
			$_SESSION["rf_Crosstab1_datedebut"] = "";
			$_SESSION["rt_Crosstab1_datedebut"] = "";
			ResetPager();
		}
	}

	// Load selection criteria to array
	// Get Organisme <br>Responsable selected values

	if (is_array(@$_SESSION["sel_Crosstab1_nomentite"])) {
		LoadSelectionFromSession('nomentite');
	} elseif (@$_SESSION["sel_Crosstab1_nomentite"] == EW_REPORT_INIT_VALUE) { // Select all
		$GLOBALS["sel_nomentite"] = "";
	}

	// Get Dpartement selected values
	if (is_array(@$_SESSION["sel_Crosstab1_departemen"])) {
		LoadSelectionFromSession('departemen');
	} elseif (@$_SESSION["sel_Crosstab1_departemen"] == EW_REPORT_INIT_VALUE) { // Select all
		$GLOBALS["sel_departemen"] = "";
	}

	// Get Secteur selected values
	if (is_array(@$_SESSION["sel_Crosstab1_nomsecteur"])) {
		LoadSelectionFromSession('nomsecteur');
	} elseif (@$_SESSION["sel_Crosstab1_nomsecteur"] == EW_REPORT_INIT_VALUE) { // Select all
		$GLOBALS["sel_nomsecteur"] = "";
	}
	if (is_array(@$_SESSION["sel_Crosstab1_datedebut"])) {
		$GLOBALS["sel_datedebut"] = @$_SESSION["sel_Crosstab1_datedebut"];
		$GLOBALS["rf_datedebut"] = @$_SESSION["rf_Crosstab1_datedebut"];
		$GLOBALS["rt_datedebut"] = @$_SESSION["rt_Crosstab1_datedebut"];
	} elseif (@$_SESSION["sel_Crosstab1_datedebut"] == EW_REPORT_INIT_VALUE) { // Select all
		$GLOBALS["sel_datedebut"] = "";
	}
}

// Reset pager
function ResetPager() {
	global $nStartGrp;

	// Reset start position (reset command)
	$nStartGrp = 1;
	$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
}

// Check if any column values is present
function HasColumnValues(&$rs) {
	global $col;
	$cntcol = count($col);
	for ($i = 1; $i < $cntcol; $i++) {
		if ($col[$i][2]) {
			if ($rs->fields[3+$i-1] <> 0) return TRUE;
		}
	}
	return FALSE;
}
?>
<?php

// Clear selection stored in session
function ClearSessionSelection($parm) {
	$_SESSION["sel_Crosstab1_$parm"] = "";
	$_SESSION["rf_Crosstab1_$parm"] = "";
	$_SESSION["rt_Crosstab1_$parm"] = "";
}

// Load selection from session
function LoadSelectionFromSession($parm) {
	$GLOBALS["sel_$parm"] = @$_SESSION["sel_Crosstab1_$parm"];
	$GLOBALS["rf_$parm"] = @$_SESSION["rf_Crosstab1_$parm"];
	$GLOBALS["rt_$parm"] = @$_SESSION["rt_Crosstab1_$parm"];
}

// Load default value for filters
function LoadDefaultFilters() {

	/**
	* Set up default values for non Text filters
	*/

	/**
	* Set up default values for extended filters
	* function SetDefaultExtFilter($parm, $so1, $sv1, $sc, $so2, $sv2)
	* Parameters:
	* $parm - Field name
	* $so1 - Default search operator 1
	* $sv1 - Default ext filter value 1
	* $sc - Default search condition (if operator 2 is enabled)
	* $so2 - Default search operator 2 (if operator 2 is enabled)
	* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
	*/

	/**
	* Set up default values for popup filters
	* NOTE: if extended filter is enabled, use default values in extended filter instead
	*/

	// Field departemen
	// Setup your default values for the popup filter below, e.g.
	// $seld_departemen = array("val1", "val2");

	$GLOBALS["seld_departemen"] = "";
	$GLOBALS["sel_departemen"] =  $GLOBALS["seld_departemen"];

	// Field nomentite
	// Setup your default values for the popup filter below, e.g.
	// $seld_nomentite = array("val1", "val2");

	$GLOBALS["seld_nomentite"] = "";
	$GLOBALS["sel_nomentite"] =  $GLOBALS["seld_nomentite"];

	// Field datedebut
	// Setup your default values for the popup filter below, e.g.
	// $seld_datedebut = array("val1", "val2");

	$GLOBALS["seld_datedebut"] = "";
	$GLOBALS["sel_datedebut"] =  $GLOBALS["seld_datedebut"];

	// Field nomsecteur
	// Setup your default values for the popup filter below, e.g.
	// $seld_nomsecteur = array("val1", "val2");

	$GLOBALS["seld_nomsecteur"] = "";
	$GLOBALS["sel_nomsecteur"] =  $GLOBALS["seld_nomsecteur"];
}

// Check if filter applied
function CheckFilter() {

	// Check departemen popup filter
	if (!ewrpt_MatchedArray($GLOBALS["seld_departemen"], $GLOBALS["sel_departemen"]))
		return TRUE;

	// Check nomentite popup filter
	if (!ewrpt_MatchedArray($GLOBALS["seld_nomentite"], $GLOBALS["sel_nomentite"]))
		return TRUE;

	// Check datedebut popup filter
	if (!ewrpt_MatchedArray($GLOBALS["seld_datedebut"], $GLOBALS["sel_datedebut"]))
		return TRUE;

	// Check nomsecteur popup filter
	if (!ewrpt_MatchedArray($GLOBALS["seld_nomsecteur"], $GLOBALS["sel_nomsecteur"]))
		return TRUE;
	return FALSE;
}

// Show list of filters
function ShowFilterList() {

	// Initialize
	$sFilterList = "";

	// Field departemen
	$sExtWrk = "";
	$sWrk = "";
	if (is_array($GLOBALS["sel_departemen"]))
		$sWrk = ewrpt_JoinArray($GLOBALS["sel_departemen"], ", ", EW_REPORT_DATATYPE_STRING);
	if ($sExtWrk <> "" || $sWrk <> "")
		$sFilterList .= "Dpartement<br />";
	if ($sExtWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sExtWrk<br />";
	if ($sWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sWrk<br />";

	// Field nomentite
	$sExtWrk = "";
	$sWrk = "";
	if (is_array($GLOBALS["sel_nomentite"]))
		$sWrk = ewrpt_JoinArray($GLOBALS["sel_nomentite"], ", ", EW_REPORT_DATATYPE_STRING);
	if ($sExtWrk <> "" || $sWrk <> "")
		$sFilterList .= "Organisme <br>Responsable<br />";
	if ($sExtWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sExtWrk<br />";
	if ($sWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sWrk<br />";

	// Field datedebut
	$sExtWrk = "";
	$sWrk = "";
	if (is_array($GLOBALS["sel_datedebut"]))
		$sWrk = ewrpt_JoinArray($GLOBALS["sel_datedebut"], ", ", EW_REPORT_DATATYPE_DATE);
	if ($sExtWrk <> "" || $sWrk <> "")
		$sFilterList .= "Anne de dmarrage des projets <br />";
	if ($sExtWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sExtWrk<br />";
	if ($sWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sWrk<br />";

	// Field nomsecteur
	$sExtWrk = "";
	$sWrk = "";
	if (is_array($GLOBALS["sel_nomsecteur"]))
		$sWrk = ewrpt_JoinArray($GLOBALS["sel_nomsecteur"], ", ", EW_REPORT_DATATYPE_STRING);
	if ($sExtWrk <> "" || $sWrk <> "")
		$sFilterList .= "Secteur<br />";
	if ($sExtWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sExtWrk<br />";
	if ($sWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sWrk<br />";

	// Show Filters
	if ($sFilterList <> "")
		echo "CURRENT FILTERS:<br />$sFilterList";
}

/**
 * Regsiter your Custom filters here
 */

// Setup custom filters
function SetupCustomFilters() {

	// 1. Register your custom filter below (see example)
	// 2. Write your custom filter function (see example fucntions: GetLastMonthFilter, GetStartsWithAFilter)

}

/**
 * Write your Custom filters here
 */

// Filter for 'Last Month' (example)
function GetLastMonthFilter($FldExpression) {
	$today = getdate();
	$lastmonth = mktime(0, 0, 0, $today['mon']-1, 1, $today['year']);
	$sVal = date("Y|m", $lastmonth);
	$sWrk = $FldExpression . " BETWEEN " .
		ewrpt_QuotedValue(DateVal("month", $sVal, 1), EW_REPORT_DATATYPE_DATE) .
		" AND " .
		ewrpt_QuotedValue(DateVal("month", $sVal, 2), EW_REPORT_DATATYPE_DATE);
	return $sWrk;
}

// Filter for 'Starts With A' (example)
function GetStartsWithAFilter($FldExpression) {
	return $FldExpression . " LIKE 'A%'";
}
?>
<?php

// Return poup filter
function GetPopupFilter() {
	$sWrk = "";
	if (is_array($GLOBALS["sel_departemen"])) {
		if ($sWrk <> "") $sWrk .= " AND ";
		$sWrk .= ewrpt_FilterSQL($GLOBALS["sel_departemen"], "departement.departemen", EW_REPORT_DATATYPE_STRING, $GLOBALS["af_departemen"]);
	}
	if (is_array($GLOBALS["sel_nomentite"])) {
		if ($sWrk <> "") $sWrk .= " AND ";
		$sWrk .= ewrpt_FilterSQL($GLOBALS["sel_nomentite"], "entites.nomentite", EW_REPORT_DATATYPE_STRING, $GLOBALS["af_nomentite"]);
	}
	if (is_array($GLOBALS["sel_datedebut"])) {
		if ($sWrk <> "") $sWrk .= " AND ";
		$sWrk .= ewrpt_FilterSQL($GLOBALS["sel_datedebut"], "Year(projets.datedebut)", EW_REPORT_DATATYPE_DATE, $GLOBALS["af_datedebut"]);
	}
	if (is_array($GLOBALS["sel_nomsecteur"])) {
		if ($sWrk <> "") $sWrk .= " AND ";
		$sWrk .= ewrpt_FilterSQL($GLOBALS["sel_nomsecteur"], "`nomsecteur`", EW_REPORT_DATATYPE_STRING, $GLOBALS["af_nomsecteur"]);
	}
	return $sWrk;
}
?>
<?php

//-------------------------------------------------------------------------------
// Function getSort
// - Return Sort parameters based on Sort Links clicked
// - Variables setup: Session[EW_REPORT_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
function getSort()
{

	// Check for a resetsort command
	if (strlen(@$_GET["cmd"]) > 0) {
		$sCmd = @$_GET["cmd"];
		if ($sCmd == "resetsort") {
			$_SESSION[EW_REPORT_TABLE_SESSION_ORDER_BY] = "";
			$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = 1;
			$_SESSION["sort_Crosstab1_nomentite"] = "";
			$_SESSION["sort_Crosstab1_departemen"] = "";
			$_SESSION["sort_Crosstab1_nomsecteur"] = "";
		}

	// Check for an Order parameter
	} elseif (strlen(@$_GET[EW_REPORT_TABLE_ORDER_BY]) > 0) {
		$sSortSql = "";
		$sSortField = "";
		$sOrder = @$_GET[EW_REPORT_TABLE_ORDER_BY];
		if (strlen(@$_GET[EW_REPORT_TABLE_ORDER_BY_TYPE]) > 0) {
			$sOrderType = @$_GET[EW_REPORT_TABLE_ORDER_BY_TYPE];
		} else {
			$sOrderType = "";
		}

		// Field nomentite
		if ($sOrder == "nomentite") {
			$sSortField = "entites.nomentite";
			$sLastSort = @$_SESSION["sort_Crosstab1_nomentite"];
			if ($sOrderType == "ASC" || $sOrderType == "DESC") {
				$sThisSort = $sOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$_SESSION["sort_Crosstab1_nomentite"] = $sThisSort;
		} else {
			if (@$_SESSION["sort_Crosstab1_nomentite"] <> "") {
				if ($sSortSql <> "") $sSortSql .= ", ";
				$sSortSql .= "entites.nomentite" . " " . @$_SESSION["sort_Crosstab1_nomentite"];
			}
		}

		// Field departemen
		if ($sOrder == "departemen") {
			$sSortField = "departement.departemen";
			$sLastSort = @$_SESSION["sort_Crosstab1_departemen"];
			if ($sOrderType == "ASC" || $sOrderType == "DESC") {
				$sThisSort = $sOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$_SESSION["sort_Crosstab1_departemen"] = $sThisSort;
		} else {
			if (@$_SESSION["sort_Crosstab1_departemen"] <> "") {
				if ($sSortSql <> "") $sSortSql .= ", ";
				$sSortSql .= "departement.departemen" . " " . @$_SESSION["sort_Crosstab1_departemen"];
			}
		}

		// Field nomsecteur
		if ($sOrder == "nomsecteur") {
			$sSortField = "`nomsecteur`";
			$sLastSort = @$_SESSION["sort_Crosstab1_nomsecteur"];
			if ($sOrderType == "ASC" || $sOrderType == "DESC") {
				$sThisSort = $sOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$_SESSION["sort_Crosstab1_nomsecteur"] = $sThisSort;
		} else {
			if (@$_SESSION["sort_Crosstab1_nomsecteur"] <> "") {
				if ($sSortSql <> "") $sSortSql .= ", ";
				$sSortSql .= "`nomsecteur`" . " " . @$_SESSION["sort_Crosstab1_nomsecteur"];
			}
		}
		if ($sSortField <> "") {
			if ($sSortSql <> "") $sSortSql .= ", ";
			$sSortSql .= $sSortField . " " . $sThisSort;
		}
		$_SESSION[EW_REPORT_TABLE_SESSION_ORDER_BY] = $sSortSql;
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = 1;
	}
	return @$_SESSION[EW_REPORT_TABLE_SESSION_ORDER_BY];
}
?>
