<?php
define("EW_PAGE_ID", "preview", TRUE);
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "communeinfo_admin.php" ?>
<?php include "departementinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php

// Init table objects
$commune = new ccommune();
$departement = new cdepartement();
$usermis = new cusermis();

// Open connection to the database
$conn = ew_Connect();
$Security = new cAdvancedSecurity();
if (!$Security->IsLoggedIn()) $Security->AutoLogin();
if (!$Security->IsLoggedIn()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->TablePermission_Loading();
$Security->LoadCurrentUserLevel('commune');
$Security->TablePermission_Loaded();
if (!$Security->IsLoggedIn()) {
	$Security->SaveLastUrl();
	$this->Page_Terminate("login_admin.php");
}
if (!$Security->CanList()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->UserID_Loading();
if ($Security->IsLoggedIn()) $Security->LoadUserID();
$Security->UserID_Loaded();

// Load filter
$qs = new cQueryString();
$filter = $qs->GetValue("f");
$filter = TEAdecrypt($filter, EW_RANDOM_KEY);
if ($filter == "") $filter = "0=1";

// Load recordset
$rs = $commune->LoadRs($filter);
$nTotalRecs = ($rs) ? $rs->RecordCount() : 0;
?>
<link href="prima_dev_v2.css" rel="stylesheet" type="text/css">
<p><span class="phpmaker" style="white-space: nowrap;">TABLE: Commune
<?php if ($nTotalRecs > 0) { ?>
(<?php echo $nTotalRecs ?> Records)
<?php } else { ?>
(No records found)
<?php } ?>
</span></p>
<?php if ($nTotalRecs > 0) { ?>
<table cellspacing="0" class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table id="ewDetailsPreviewTable" name="ewDetailsPreviewTable" cellspacing="0" class="ewTable ewTableSeparate">
	<thead><!-- Table header -->
		<tr class="ewTableHeader">
			<td valign="top">Dpartement</td>
			<td valign="top">Commune</td>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$nRecCount = 0;
while ($rs && !$rs->EOF) {

	// Init row class and style
	$nRecCount++;
	$commune->CssClass = "ewTableRow";
	$commune->CssStyle = "";

	// Display alternate color for rows
	if ($nRecCount % 2 <> 1)
		$commune->CssClass = "ewTableAltRow";
	$commune->LoadListRowValues($rs);

	// Render row
	$commune->RowType = EW_ROWTYPE_PREVIEW; // Preview record
	$commune->RenderListRow();
?>
	<tr<?php echo $commune->RowAttributes() ?>>
		<!-- Id_dep -->
		<td<?php echo $commune->Id_dep->CellAttributes() ?>>
<div<?php echo $commune->Id_dep->ViewAttributes() ?>><?php echo $commune->Id_dep->ViewValue ?></div></td>
		<!-- Commune -->
		<td<?php echo $commune->Commune->CellAttributes() ?>>
<div<?php echo $commune->Commune->ViewAttributes() ?>><?php echo $commune->Commune->ViewValue ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
?>
	</tbody>
</table>
</div>
</td></tr></table>
<?php
if ($rs)
	$rs->Close();
}
$content = ob_get_contents();
ob_end_clean();
echo ew_ConvertToUtf8($content);
?>
