<?php
define("EW_PAGE_ID", "preview", TRUE);
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "mefLesProjetsinfo_admin.php" ?>
<?php include "entitesinfo_admin.php" ?>
<?php include "secteursinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "statutinfo_admin.php" ?>
<?php include "mefcominfo_admin.php" ?>
<?php include "mefdepinfo_admin.php" ?>
<?php include "mefsectioninfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php

// Init table objects
$mefLesProjets = new cmefLesProjets();
$entites = new centites();
$secteurs = new csecteurs();
$usermis = new cusermis();
$statut = new cstatut();
$mefcom = new cmefcom();
$mefdep = new cmefdep();
$mefsection = new cmefsection();

// Open connection to the database
$conn = ew_Connect();
$Security = new cAdvancedSecurity();
if (!$Security->IsLoggedIn()) $Security->AutoLogin();
if (!$Security->IsLoggedIn()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->TablePermission_Loading();
$Security->LoadCurrentUserLevel('mefLesProjets');
$Security->TablePermission_Loaded();
if (!$Security->IsLoggedIn()) {
	$Security->SaveLastUrl();
	$this->Page_Terminate("login_admin.php");
}
if (!$Security->CanList()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->UserID_Loading();
if ($Security->IsLoggedIn()) $Security->LoadUserID();
$Security->UserID_Loaded();

// Load filter
$qs = new cQueryString();
$filter = $qs->GetValue("f");
$filter = TEAdecrypt($filter, EW_RANDOM_KEY);
if ($filter == "") $filter = "0=1";

// Load recordset
$rs = $mefLesProjets->LoadRs($filter);
$nTotalRecs = ($rs) ? $rs->RecordCount() : 0;
?>
<link href="prima_dev_v2.css" rel="stylesheet" type="text/css">
<p><span class="phpmaker" style="white-space: nowrap;">Table: Les projets
<?php if ($nTotalRecs > 0) { ?>
(<?php echo $nTotalRecs ?> Records)
<?php } else { ?>
(No records found)
<?php } ?>
</span></p>
<?php if ($nTotalRecs > 0) { ?>
<table cellspacing="0" class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table id="ewDetailsPreviewTable" name="ewDetailsPreviewTable" cellspacing="0" class="ewTable ewTableSeparate">
	<thead><!-- Table header -->
		<tr class="ewTableHeader">
			<td valign="top">Fiche projet</td>
			<td valign="top">D&eacute;partement</td>
			<td valign="top">Commune</td>
			<td valign="top">Ville/Quartier/Section</td>
			<td valign="top">Secteur</td>
			<td valign="top">Balance &agrave; d&eacute;caisser</td>
			<td valign="top">Bailleur</td>
			<td valign="top">Programme</td>
			<td valign="top">Organisme Responsable</td>
			<td valign="top">Date de d&eacute;marrage</td>
			<td valign="top">Statut</td>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$nRecCount = 0;
while ($rs && !$rs->EOF) {

	// Init row class and style
	$nRecCount++;
	$mefLesProjets->CssClass = "ewTableRow";
	$mefLesProjets->CssStyle = "";

	// Display alternate color for rows
	if ($nRecCount % 2 <> 1)
		$mefLesProjets->CssClass = "ewTableAltRow";
	$mefLesProjets->LoadListRowValues($rs);

	// Render row
	$mefLesProjets->RowType = EW_ROWTYPE_PREVIEW; // Preview record
	$mefLesProjets->RenderListRow();
?>
	<tr<?php echo $mefLesProjets->RowAttributes() ?>>
		<!-- proj -->
		<td<?php echo $mefLesProjets->proj->CellAttributes() ?>>
<div<?php echo $mefLesProjets->proj->ViewAttributes() ?>><?php echo $mefLesProjets->proj->ViewValue ?></div></td>
		<!-- departement -->
		<td<?php echo $mefLesProjets->departement->CellAttributes() ?>>
<div<?php echo $mefLesProjets->departement->ViewAttributes() ?>><?php echo $mefLesProjets->departement->ViewValue ?></div></td>
		<!-- commune -->
		<td<?php echo $mefLesProjets->commune->CellAttributes() ?>>
<div<?php echo $mefLesProjets->commune->ViewAttributes() ?>><?php echo $mefLesProjets->commune->ViewValue ?></div></td>
		<!-- section -->
		<td<?php echo $mefLesProjets->section->CellAttributes() ?>>
<div<?php echo $mefLesProjets->section->ViewAttributes() ?>><?php echo $mefLesProjets->section->ViewValue ?></div></td>
		<!-- secteur -->
		<td<?php echo $mefLesProjets->secteur->CellAttributes() ?>>
<div<?php echo $mefLesProjets->secteur->ViewAttributes() ?>><?php echo $mefLesProjets->secteur->ViewValue ?></div></td>
		<!-- Balance -->
		<td<?php echo $mefLesProjets->Balance->CellAttributes() ?>>
<div<?php echo $mefLesProjets->Balance->ViewAttributes() ?>><?php echo $mefLesProjets->Balance->ViewValue ?></div></td>
		<!-- bailleur -->
		<td<?php echo $mefLesProjets->bailleur->CellAttributes() ?>>
<div<?php echo $mefLesProjets->bailleur->ViewAttributes() ?>><?php echo $mefLesProjets->bailleur->ViewValue ?></div></td>
		<!-- program -->
		<td<?php echo $mefLesProjets->program->CellAttributes() ?>>
<div<?php echo $mefLesProjets->program->ViewAttributes() ?>><?php echo $mefLesProjets->program->ViewValue ?></div></td>
		<!-- entite -->
		<td<?php echo $mefLesProjets->entite->CellAttributes() ?>>
<div<?php echo $mefLesProjets->entite->ViewAttributes() ?>><?php echo $mefLesProjets->entite->ViewValue ?></div></td>
		<!-- datedebut -->
		<td<?php echo $mefLesProjets->datedebut->CellAttributes() ?>>
<div<?php echo $mefLesProjets->datedebut->ViewAttributes() ?>><?php echo $mefLesProjets->datedebut->ViewValue ?></div></td>
		<!-- statut -->
		<td<?php echo $mefLesProjets->statut->CellAttributes() ?>>
<div<?php echo $mefLesProjets->statut->ViewAttributes() ?>><?php echo $mefLesProjets->statut->ViewValue ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
?>
	</tbody>
</table>
</div>
</td></tr></table>
<?php
if ($rs)
	$rs->Close();
}
$content = ob_get_contents();
ob_end_clean();
echo ew_ConvertToUtf8($content);
?>
