<?php
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "sectioninfo_admin.php" ?>
<?php include "departementinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "departinfo_admin.php" ?>
<?php include "cominfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Define page object
$section_delete = new csection_delete();
$Page =& $section_delete;

// Page init processing
$section_delete->Page_Init();

// Page main processing
$section_delete->Page_Main();
?>
<?php include "header_admin.php" ?>
<script type="text/javascript">
<!--

// Create page object
var section_delete = new ew_Page("section_delete");

// page properties
section_delete.PageID = "delete"; // page ID
var EW_PAGE_ID = section_delete.PageID; // for backward compatibility

// extend page with Form_CustomValidate function
section_delete.Form_CustomValidate =  
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
<?php if (EW_CLIENT_VALIDATE) { ?>
section_delete.ValidateRequired = true; // uses JavaScript validation
<?php } else { ?>
section_delete.ValidateRequired = false; // no JavaScript validation
<?php } ?>

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your client script here, no need to add script tags.
// To include another .js script, use:
// ew_ClientScriptInclude("my_javascript.js"); 
//-->

</script>
<?php

// Load records for display
$rs = $section_delete->LoadRecordset();
$section_deletelTotalRecs = $rs->RecordCount(); // Get record count
if ($section_deletelTotalRecs <= 0) { // No record found, exit
	$rs->Close();
	$section_delete->Page_Terminate("sectionlist_admin.php"); // Return to list
}
?>
<p><span class="phpmaker">Delete From TABLE: Ville/Quartier/Section<br><br>
<a href="<?php echo $section->getReturnUrl() ?>">Go Back</a></span></p>
<?php $section_delete->ShowMessage() ?>
<form action="<?php echo ew_CurrentPage() ?>" method="post">
<p>
<input type="hidden" name="t" id="t" value="section">
<input type="hidden" name="a_delete" id="a_delete" value="D">
<?php foreach ($section_delete->arRecKeys as $key) { ?>
<input type="hidden" name="key_m[]" id="key_m[]" value="<?php echo ew_HtmlEncode($key) ?>">
<?php } ?>
<table class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable ewTableSeparate">
<?php echo $section->TableCustomInnerHtml ?>
	<thead>
	<tr class="ewTableHeader">
		<td valign="top">Dpartement</td>
		<td valign="top">Commune</td>
		<td valign="top">Ville/Quartier/Section</td>
		<td valign="top">Position gographique</td>
		<td valign="top">Relief</td>
		<td valign="top">Population</td>
		<td valign="top">Superficie (km&sup2)</td>
	</tr>
	</thead>
	<tbody>
<?php
$section_delete->lRecCnt = 0;
$i = 0;
while (!$rs->EOF) {
	$section_delete->lRecCnt++;

	// Set row properties
	$section->CssClass = "";
	$section->CssStyle = "";
	$section->RowType = EW_ROWTYPE_VIEW; // View

	// Get the field contents
	$section_delete->LoadRowValues($rs);

	// Render row
	$section_delete->RenderRow();
?>
	<tr<?php echo $section->RowAttributes() ?>>
		<td<?php echo $section->id_dep->CellAttributes() ?>>
<div<?php echo $section->id_dep->ViewAttributes() ?>><?php echo $section->id_dep->ListViewValue() ?></div></td>
		<td<?php echo $section->id_com->CellAttributes() ?>>
<div<?php echo $section->id_com->ViewAttributes() ?>><?php echo $section->id_com->ListViewValue() ?></div></td>
		<td<?php echo $section->vqs->CellAttributes() ?>>
<div<?php echo $section->vqs->ViewAttributes() ?>><?php echo $section->vqs->ListViewValue() ?></div></td>
		<td<?php echo $section->pgeo->CellAttributes() ?>>
<div<?php echo $section->pgeo->ViewAttributes() ?>><?php echo $section->pgeo->ListViewValue() ?></div></td>
		<td<?php echo $section->relief->CellAttributes() ?>>
<div<?php echo $section->relief->ViewAttributes() ?>><?php echo $section->relief->ListViewValue() ?></div></td>
		<td<?php echo $section->population->CellAttributes() ?>>
<div<?php echo $section->population->ViewAttributes() ?>><?php echo $section->population->ListViewValue() ?></div></td>
		<td<?php echo $section->superfici->CellAttributes() ?>>
<div<?php echo $section->superfici->ViewAttributes() ?>><?php echo $section->superfici->ListViewValue() ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
$rs->Close();
?>
</tbody>
</table>
</div>
</td></tr></table>
<p>
<input type="submit" name="Action" id="Action" value="Confirm Delete">
</form>
<script language="JavaScript" type="text/javascript">
<!--

// Write your table-specific startup script here
// document.write("page loaded");
//-->

</script>
<?php include "footer_admin.php" ?>
<?php
$section_delete->Page_Terminate();
?>
<?php

//
// Page Class
//
class csection_delete {

	// Page ID
	var $PageID = 'delete';

	// Table Name
	var $TableName = 'section';

	// Page Object Name
	var $PageObjName = 'section_delete';

	// Page Name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page Url
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		global $section;
		if ($section->UseTokenInUrl) $PageUrl .= "t=" . $section->TableVar . "&"; // add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show Message
	function ShowMessage() {
		if ($this->getMessage() <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $this->getMessage() . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate Page request
	function IsPageRequest() {
		global $objForm, $section;
		if ($section->UseTokenInUrl) {

			//IsPageRequest = False
			if ($objForm)
				return ($section->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($section->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	//  Class initialize
	//  - init objects
	//  - open connection
	//
	function csection_delete() {
		global $conn;

		// Initialize table object
		$GLOBALS["section"] = new csection();

		// Initialize other table object
		$GLOBALS['departement'] = new cdepartement();

		// Initialize other table object
		$GLOBALS['usermis'] = new cusermis();

		// Initialize other table object
		$GLOBALS['depart'] = new cdepart();

		// Initialize other table object
		$GLOBALS['com'] = new ccom();

		// Intialize page id (for backward compatibility)
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'delete', TRUE);

		// Initialize table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'section', TRUE);

		// Open connection to the database
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $section;
		global $Security;
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		if (!$Security->CanDelete()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("sectionlist_admin.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();

		// Global page loading event (in userfn6.php)
		Page_Loading();

		// Page load event, used in current page
		$this->Page_Load();
	}

	//
	//  Page_Terminate
	//  - called when exit page
	//  - if URL specified, redirect to the URL
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page unload event, used in current page
		$this->Page_Unload();

		// Global page unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close Connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			ob_end_clean();
			header("Location: $url");
		}
		exit();
	}
	var $lTotalRecs;
	var $lRecCnt;
	var $arRecKeys = array();

	// Page main processing
	function Page_Main() {
		global $section;

		// Load Key Parameters
		$sKey = "";
		$bSingleDelete = TRUE; // Initialize as single delete
		$nKeySelected = 0; // Initialize selected key count
		$sFilter = "";
		if (@$_GET["id_section"] <> "") {
			$section->id_section->setQueryStringValue($_GET["id_section"]);
			if (!is_numeric($section->id_section->QueryStringValue))
				$this->Page_Terminate("sectionlist_admin.php"); // Prevent SQL injection, exit
			$sKey .= $section->id_section->QueryStringValue;
		} else {
			$bSingleDelete = FALSE;
		}
		if ($bSingleDelete) {
			$nKeySelected = 1; // Set up key selected count
			$this->arRecKeys[0] = $sKey;
		} else {
			if (isset($_POST["key_m"])) { // Key in form
				$nKeySelected = count($_POST["key_m"]); // Set up key selected count
				$this->arRecKeys = ew_StripSlashes($_POST["key_m"]);
			}
		}
		if ($nKeySelected <= 0)
			$this->Page_Terminate("sectionlist_admin.php"); // No key specified, return to list

		// Build filter
		foreach ($this->arRecKeys as $sKey) {
			$sFilter .= "(";

			// Set up key field
			$sKeyFld = $sKey;
			if (!is_numeric($sKeyFld))
				$this->Page_Terminate("sectionlist_admin.php"); // Prevent SQL injection, return to list
			$sFilter .= "`id_section`=" . ew_AdjustSql($sKeyFld) . " AND ";
			if (substr($sFilter, -5) == " AND ") $sFilter = substr($sFilter, 0, strlen($sFilter)-5) . ") OR ";
		}
		if (substr($sFilter, -4) == " OR ") $sFilter = substr($sFilter, 0, strlen($sFilter)-4);

		// Set up filter (SQL WhHERE clause) and get return SQL
		// SQL constructor in SQL constructor in section class, sectioninfo.php

		$section->CurrentFilter = $sFilter;

		// Get action
		if (@$_POST["a_delete"] <> "") {
			$section->CurrentAction = $_POST["a_delete"];
		} else {
			$section->CurrentAction = "I"; // Display record
		}
		switch ($section->CurrentAction) {
			case "D": // Delete
				$section->SendEmail = TRUE; // Send email on delete success
				if ($this->DeleteRows()) { // delete rows
					$this->setMessage("Delete succeeded"); // Set up success message
					$this->Page_Terminate($section->getReturnUrl()); // Return to caller
				}
		}
	}

	//
	//  Function DeleteRows
	//  - Delete Records based on current filter
	//
	function DeleteRows() {
		global $conn, $Security, $section;
		$DeleteRows = TRUE;
		$sWrkFilter = $section->CurrentFilter;

		// Set up filter (Sql Where Clause) and get Return SQL
		// SQL constructor in section class, sectioninfo.php

		$section->CurrentFilter = $sWrkFilter;
		$sSql = $section->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setMessage("No records found"); // No record found
			$rs->Close();
			return FALSE;
		}
		$conn->BeginTrans();

		// Clone old rows
		$rsold = ($rs) ? $rs->GetRows() : array();
		if ($rs) $rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $section->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= EW_COMPOSITE_KEY_SEPARATOR;
				$sThisKey .= $row['id_section'];
				$conn->raiseErrorFn = 'ew_ErrorFn';
				$DeleteRows = $conn->Execute($section->DeleteSQL($row)); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		} else {

			// Set up error message
			if ($section->CancelMessage <> "") {
				$this->setMessage($section->CancelMessage);
				$section->CancelMessage = "";
			} else {
				$this->setMessage("Delete cancelled");
			}
		}
		if ($DeleteRows) {
			$conn->CommitTrans(); // Commit the changes
		} else {
			$conn->RollbackTrans(); // Rollback changes
		}

		// Call recordset deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$section->Row_Deleted($row);
			}	
		}
		return $DeleteRows;
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn, $section;

		// Call Recordset Selecting event
		$section->Recordset_Selecting($section->CurrentFilter);

		// Load list page SQL
		$sSql = $section->SelectSQL();
		if ($offset > -1 && $rowcnt > -1) $sSql .= " LIMIT $offset, $rowcnt";

		// Load recordset
		$conn->raiseErrorFn = 'ew_ErrorFn';	
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';

		// Call Recordset Selected event
		$section->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $section;
		$sFilter = $section->KeyFilter();

		// Call Row Selecting event
		$section->Row_Selecting($sFilter);

		// Load sql based on filter
		$section->CurrentFilter = $sFilter;
		$sSql = $section->SQL();
		if ($rs = $conn->Execute($sSql)) {
			if ($rs->EOF) {
				$LoadRow = FALSE;
			} else {
				$LoadRow = TRUE;
				$rs->MoveFirst();
				$this->LoadRowValues($rs); // Load row values

				// Call Row Selected event
				$section->Row_Selected($rs);
			}
			$rs->Close();
		} else {
			$LoadRow = FALSE;
		}
		return $LoadRow;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $section;
		$section->id_dep->setDbValue($rs->fields('id_dep'));
		$section->id_com->setDbValue($rs->fields('id_com'));
		$section->id_section->setDbValue($rs->fields('id_section'));
		$section->vqs->setDbValue($rs->fields('vqs'));
		$section->pgeo->setDbValue($rs->fields('pgeo'));
		$section->relief->setDbValue($rs->fields('relief'));
		$section->climat->setDbValue($rs->fields('climat'));
		$section->population->setDbValue($rs->fields('population'));
		$section->superfici->setDbValue($rs->fields('superfici'));
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $section;

		// Call Row_Rendering event
		$section->Row_Rendering();

		// Common render codes for all row types
		// id_dep

		$section->id_dep->CellCssStyle = "";
		$section->id_dep->CellCssClass = "";

		// id_com
		$section->id_com->CellCssStyle = "";
		$section->id_com->CellCssClass = "";

		// vqs
		$section->vqs->CellCssStyle = "";
		$section->vqs->CellCssClass = "";

		// pgeo
		$section->pgeo->CellCssStyle = "";
		$section->pgeo->CellCssClass = "";

		// relief
		$section->relief->CellCssStyle = "";
		$section->relief->CellCssClass = "";

		// population
		$section->population->CellCssStyle = "";
		$section->population->CellCssClass = "";

		// superfici
		$section->superfici->CellCssStyle = "";
		$section->superfici->CellCssClass = "";
		if ($section->RowType == EW_ROWTYPE_VIEW) { // View row

			// id_dep
			if (strval($section->id_dep->CurrentValue) <> "") {
				$sSqlWrk = "SELECT DISTINCT departement.departemen AS `departemen` FROM departement INNER JOIN section ON (departement.ID_Dep = section.id_dep) WHERE departement.ID_Dep = " . ew_AdjustSql($section->id_dep->CurrentValue) . "";
				$sSqlWrk .= " GROUP BY departement.departemen, departement.ID_Dep";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$section->id_dep->ViewValue = $rswrk->fields('departemen');
					$rswrk->Close();
				} else {
					$section->id_dep->ViewValue = $section->id_dep->CurrentValue;
				}
			} else {
				$section->id_dep->ViewValue = NULL;
			}
			$section->id_dep->CssStyle = "";
			$section->id_dep->CssClass = "";
			$section->id_dep->ViewCustomAttributes = "";

			// id_com
			if (strval($section->id_com->CurrentValue) <> "") {
				$sSqlWrk = "SELECT DISTINCT commune.Commune AS `Commune` FROM commune INNER JOIN section ON (commune.Id_com = section.id_com) WHERE commune.Id_com = " . ew_AdjustSql($section->id_com->CurrentValue) . "";
				$sSqlWrk .= " GROUP BY commune.Id_com";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$section->id_com->ViewValue = $rswrk->fields('Commune');
					$rswrk->Close();
				} else {
					$section->id_com->ViewValue = $section->id_com->CurrentValue;
				}
			} else {
				$section->id_com->ViewValue = NULL;
			}
			$section->id_com->CssStyle = "";
			$section->id_com->CssClass = "";
			$section->id_com->ViewCustomAttributes = "";

			// vqs
			$section->vqs->ViewValue = $section->vqs->CurrentValue;
			$section->vqs->CssStyle = "";
			$section->vqs->CssClass = "";
			$section->vqs->ViewCustomAttributes = "";

			// pgeo
			$section->pgeo->ViewValue = $section->pgeo->CurrentValue;
			$section->pgeo->CssStyle = "";
			$section->pgeo->CssClass = "";
			$section->pgeo->ViewCustomAttributes = "";

			// relief
			$section->relief->ViewValue = $section->relief->CurrentValue;
			$section->relief->CssStyle = "";
			$section->relief->CssClass = "";
			$section->relief->ViewCustomAttributes = "";

			// population
			$section->population->ViewValue = $section->population->CurrentValue;
			$section->population->ViewValue = ew_FormatNumber($section->population->ViewValue, 0, -2, -2, -2);
			$section->population->CssStyle = "";
			$section->population->CssClass = "";
			$section->population->ViewCustomAttributes = "";

			// superfici
			$section->superfici->ViewValue = $section->superfici->CurrentValue;
			$section->superfici->ViewValue = ew_FormatNumber($section->superfici->ViewValue, 2, -2, -2, -2);
			$section->superfici->CssStyle = "";
			$section->superfici->CssClass = "";
			$section->superfici->ViewCustomAttributes = "";

			// id_dep
			$section->id_dep->HrefValue = "";

			// id_com
			$section->id_com->HrefValue = "";

			// vqs
			$section->vqs->HrefValue = "";

			// pgeo
			$section->pgeo->HrefValue = "";

			// relief
			$section->relief->HrefValue = "";

			// population
			$section->population->HrefValue = "";

			// superfici
			$section->superfici->HrefValue = "";
		}

		// Call Row Rendered event
		$section->Row_Rendered();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}
}
?>
