<?php
session_start();
ob_start();
?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php include "phprptinc/ewrcfg3report.php"; ?>
<?php include "phprptinc/ewmysqlreport.php"; ?>
<?php include "phprptinc/ewrfn3report.php"; ?>
<?php

// Get page start time
$starttime = ewrpt_microtime();

// Open connection to the database
$conn = ewrpt_Connect();

// Table level constants
define("EW_REPORT_TABLE_VAR", "usermis", TRUE);
define("EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE", "usermis_grpperpage", TRUE);
define("EW_REPORT_TABLE_SESSION_START_GROUP", "usermis_start", TRUE);
define("EW_REPORT_TABLE_SESSION_SEARCH", "usermis_search", TRUE);
define("EW_REPORT_TABLE_SESSION_CHILD_USER_ID", "usermis_childuserid", TRUE);
define("EW_REPORT_TABLE_SESSION_ORDER_BY", "usermis_orderby", TRUE);

// Table level SQL
$EW_REPORT_TABLE_SQL_FROM = "`usermis`";
$EW_REPORT_TABLE_SQL_SELECT = "SELECT * FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_TABLE_SQL_WHERE = "";
$EW_REPORT_TABLE_SQL_GROUPBY = "";
$EW_REPORT_TABLE_SQL_HAVING = "";
$EW_REPORT_TABLE_SQL_ORDERBY = "";
$EW_REPORT_TABLE_SQL_USERID_FILTER = "`entite` = #UserID#";
$af_EmployeeID = NULL; // Popup filter for EmployeeID
$af_LastName = NULL; // Popup filter for LastName
$af_FirstName = NULL; // Popup filter for FirstName
$af_Title = NULL; // Popup filter for Title
$af_Address = NULL; // Popup filter for Address
$af_City = NULL; // Popup filter for City
$af_HomePhone = NULL; // Popup filter for HomePhone
$af_Cellphone = NULL; // Popup filter for Cellphone
$af_Email = NULL; // Popup filter for Email
$af_ReportsTo = NULL; // Popup filter for ReportsTo
$af_Password = NULL; // Popup filter for Password
$af_UserLevel = NULL; // Popup filter for UserLevel
$af_Username = NULL; // Popup filter for Username
$af_Activated = NULL; // Popup filter for Activated
$af_entite = NULL; // Popup filter for entite
?>
<?php
$ewrpt_ParentUserIDQuery = "";

// Function to get the user id query for parent user
function GetParentUserIDQuery($sUserID) {
	if ($sUserID == "-1") {
		$sWrk = "";
	} else {
		$arUser = ChildUserIDList($sUserID);
		$sWrk = UserIDList($arUser);
	}
	if ($sWrk <> "")
		$sWrk = "`entite` IN (" . $sWrk . ")";
	return $sWrk;
}

// Function to get the child user id list for this user
function ChildUserIDList($sUserID) {
	global $conn;

	// Get all values
	if ($sUserID == "-1") {
		$sSql = "SELECT `entite` FROM `usermis`";
	} else {
		$sSql = "SELECT `entite` FROM `usermis` WHERE `ReportsTo` = " . ewrpt_QuotedValue($sUserID, EW_REPORT_DATATYPE_NUMBER) . " OR `entite` = " . ewrpt_QuotedValue($sUserID, EW_REPORT_DATATYPE_NUMBER);
	}
	$rs = $conn->Execute($sSql);
	$arUser = array();
	if ($rs) {
		while (!$rs->EOF) {
			$arUser[] = $rs->fields('entite');
			$rs->MoveNext();
		}
		$rs->Close();
	}
	sort($arUser);

	// Recurse all levels (hierarchical user id)
	if (EW_USER_ID_IS_HIERARCHICAL) {
		$sCurUserIDList = UserIDList($arUser);
		$sUserIDList = "";
		while ($sUserIDList <> $sCurUserIDList) {
			$arUserWrk = array();
			$sSql = "SELECT `entite` FROM `usermis` WHERE `ReportsTo` IN (" . $sCurUserIDList . ") OR `entite` = " . ewrpt_QuotedValue($sUserID, EW_REPORT_DATATYPE_NUMBER);
			if ($rs = $conn->Execute($sSql)) {
				while (!$rs->EOF) {
					$arUserWrk[] = $rs->fields('entite');
					$rs->MoveNext();
				}
				$rs->Close();
			}
			sort($arUserWrk);
			$sUserIDList = $sCurUserIDList;
			$sCurUserIDList = UserIDList($arUserWrk);
		}
		$arUser = $arUserWrk;
	}
	return $arUser;
}

function UserIDList($ar) {
	$sWrk = "";
	if (is_array($ar)) {
		$cntar = count($ar);
		for ($i = 0; $i < $cntar; $i++) {
			if ($sWrk <> "")
				$sWrk .= ", ";
			$sWrk .= ewrpt_QuotedValue($ar[$i], EW_REPORT_DATATYPE_NUMBER);
		}
	}
	return $sWrk;
}
?>
<?php
if (!IsLoggedIn()) AutoLogin(); // Auto login
LoadUserLevel();
$ewCurSec = CurrentUserLevelPriv('usermis');
if (($ewCurSec & EW_ALLOW_LIST) <> EW_ALLOW_LIST) {
	SaveLastUrl();
	ob_end_clean();
	header("Location: login_admin.php");
	exit();
}
if (IsLoggedIn() && CurrentUserID() == "") {
	SaveLastUrl();
	ob_end_clean();
	header("Location: login_admin.php");
	exit();
}
?>
<?php
$sExport = @$_GET["export"]; // Load export request
if ($sExport == "html") {

	// Printer friendly
}
if ($sExport == "excel") {
	header('Content-Type: application/vnd.ms-excel');
	header('Content-Disposition: attachment; filename=' . EW_REPORT_TABLE_VAR .'.xls');
}
if ($sExport == "word") {
	header('Content-Type: application/vnd.ms-word');
	header('Content-Disposition: attachment; filename=' . EW_REPORT_TABLE_VAR .'.doc');
}
?>
<?php

// Initialize common variables
// Paging variables

$nRecCount = 0; // Record count
$nStartGrp = 0; // Start group
$nStopGrp = 0; // Stop group
$nTotalGrps = 0; // Total groups
$nGrpCount = 0; // Group count
$nDisplayGrps = 3; // Groups per page
$nGrpRange = 10;

// Clear field for ext filter
$sClearExtFilter = "";

// Non-Text Extended Filters
// Text Extended Filters
// Custom filters

$ewrpt_CustomFilters = array();
?>
<?php
?>
<?php

// Field variables
$x_EmployeeID = NULL;
$x_LastName = NULL;
$x_FirstName = NULL;
$x_Title = NULL;
$x_Address = NULL;
$x_City = NULL;
$x_HomePhone = NULL;
$x_Cellphone = NULL;
$x_Email = NULL;
$x_Notes = NULL;
$x_ReportsTo = NULL;
$x_Password = NULL;
$x_UserLevel = NULL;
$x_Username = NULL;
$x_Activated = NULL;
$x_entite = NULL;

// Detail variables
$o_EmployeeID = NULL; $t_EmployeeID = NULL; $ft_EmployeeID = 3; $rf_EmployeeID = NULL; $rt_EmployeeID = NULL;
$o_LastName = NULL; $t_LastName = NULL; $ft_LastName = 200; $rf_LastName = NULL; $rt_LastName = NULL;
$o_FirstName = NULL; $t_FirstName = NULL; $ft_FirstName = 200; $rf_FirstName = NULL; $rt_FirstName = NULL;
$o_Title = NULL; $t_Title = NULL; $ft_Title = 200; $rf_Title = NULL; $rt_Title = NULL;
$o_Address = NULL; $t_Address = NULL; $ft_Address = 200; $rf_Address = NULL; $rt_Address = NULL;
$o_City = NULL; $t_City = NULL; $ft_City = 200; $rf_City = NULL; $rt_City = NULL;
$o_HomePhone = NULL; $t_HomePhone = NULL; $ft_HomePhone = 200; $rf_HomePhone = NULL; $rt_HomePhone = NULL;
$o_Cellphone = NULL; $t_Cellphone = NULL; $ft_Cellphone = 200; $rf_Cellphone = NULL; $rt_Cellphone = NULL;
$o_Email = NULL; $t_Email = NULL; $ft_Email = 200; $rf_Email = NULL; $rt_Email = NULL;
$o_ReportsTo = NULL; $t_ReportsTo = NULL; $ft_ReportsTo = 3; $rf_ReportsTo = NULL; $rt_ReportsTo = NULL;
$o_Password = NULL; $t_Password = NULL; $ft_Password = 200; $rf_Password = NULL; $rt_Password = NULL;
$o_UserLevel = NULL; $t_UserLevel = NULL; $ft_UserLevel = 3; $rf_UserLevel = NULL; $rt_UserLevel = NULL;
$o_Username = NULL; $t_Username = NULL; $ft_Username = 200; $rf_Username = NULL; $rt_Username = NULL;
$o_Activated = NULL; $t_Activated = NULL; $ft_Activated = 202; $rf_Activated = NULL; $rt_Activated = NULL;
$o_entite = NULL; $t_entite = NULL; $ft_entite = 3; $rf_entite = NULL; $rt_entite = NULL;
?>
<?php

// Filter
$sFilter = "";

// Set up User ID
if (CurrentUserID() <> "") {
	if (CurrentUserID() == "-1" || CurrentUserLevel() == -1) { // admin
		if (@$_SESSION[EW_REPORT_TABLE_SESSION_CHILD_USER_ID] <> "") {
			if ($sFilter <> "") $sFilter .= " AND ";
			$sFilter .= str_replace("#UserID#", ewrpt_AdjustSql($_SESSION[EW_REPORT_TABLE_SESSION_CHILD_USER_ID]), $EW_REPORT_TABLE_SQL_USERID_FILTER);
		}
	} else {
		if ($sFilter <> "") $sFilter .= " AND ";
		$ewrpt_ParentUserIDQuery = GetParentUserIDQuery(CurrentUserID());
		if ($ewrpt_ParentUserIDQuery <> "") {
			$sFilter .= "((" . str_replace("#UserID#", ewrpt_AdjustSql(CurrentUserID()), $EW_REPORT_TABLE_SQL_USERID_FILTER) . ") OR (" . $ewrpt_ParentUserIDQuery . "))";
			if (@$_SESSION[EW_REPORT_TABLE_SESSION_CHILD_USER_ID] <> "")
				$sFilter .= " AND (" . str_replace("#UserID#", ewrpt_AdjustSql($_SESSION[EW_REPORT_TABLE_SESSION_CHILD_USER_ID]), $EW_REPORT_TABLE_SQL_USERID_FILTER) . ")";
		} else {
			$sFilter .= str_replace("#UserID#", ewrpt_AdjustSql(CurrentUserID()), $EW_REPORT_TABLE_SQL_USERID_FILTER);
		}
	}
}

// Aggregate variables
// 1st dimension = no of groups (level 0 used for grand total)
// 2nd dimension = no of fields

$nDtls = 16;
$nGrps = 1;
$val = ewrpt_InitArray($nDtls, 0);
$cnt = ewrpt_Init2DArray($nGrps, $nDtls, 0);
$smry = ewrpt_Init2DArray($nGrps, $nDtls, 0);
$mn = ewrpt_Init2DArray($nGrps, $nDtls, NULL);
$mx = ewrpt_Init2DArray($nGrps, $nDtls, NULL);
$grandsmry = ewrpt_InitArray($nDtls, 0);
$grandmn = ewrpt_InitArray($nDtls, NULL);
$grandmx = ewrpt_InitArray($nDtls, NULL);

// Set up if accumulation required
$col = array(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE);

// Set up groups per page dynamically
SetUpDisplayGrps();

// Set up popup filter
SetupPopup();

// Extended filter
$sExtendedFilter = "";

// Build popup filter
$sPopupFilter = GetPopupFilter();

//echo "popup filter: " . $sPopupFilter . "<br>";
if ($sPopupFilter <> "") {
	if ($sFilter <> "")
		$sFilter = "($sFilter) AND ($sPopupFilter)";
	else
		$sFilter = $sPopupFilter;
}

// No filter
$bFilterApplied = FALSE;

// Get sort
$sSort = getSort();

// Get total count
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_TABLE_SQL_SELECT, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_TABLE_SQL_GROUPBY, $EW_REPORT_TABLE_SQL_HAVING, $EW_REPORT_TABLE_SQL_ORDERBY, "", $sFilter, @$sSort);
$nTotalGrps = GetCnt($sSql);
if ($nDisplayGrps <= 0) // Display all groups
	$nDisplayGrps = $nTotalGrps;
$nStartGrp = 1;

// Show header
$bShowFirstHeader = ($nTotalGrps > 0);

//$bShowFirstHeader = TRUE; // Uncomment to always show header
// Set up start position if not export all

if (EW_REPORT_EXPORT_ALL && @$sExport <> "")
    $nDisplayGrps = $nTotalGrps;
else
    SetUpStartGroup(); 

// Get current page records
$rs = GetRs($sSql, $nStartGrp, $nDisplayGrps);
?>
<?php if (@$sExport == "") { ?>
<?php include "header_admin.php"; ?>
<?php } ?>
<?php include "phprptinc/headerreport.php"; ?>
<?php if (@$sExport == "") { ?>
<script type="text/javascript">
var EW_REPORT_DATE_SEPARATOR = "/";
if (EW_REPORT_DATE_SEPARATOR == "") EW_REPORT_DATE_SEPARATOR = "/"; // Default date separator
</script>
<script type="text/javascript" src="phprptjs/ewrpt.js"></script>
<?php } ?>
<?php if (@$sExport == "") { ?>
<script src="phprptjs/popup.js" type="text/javascript"></script>
<script src="phprptjs/ewrptpop.js" type="text/javascript"></script>
<script src="FusionChartsFree/JSClass/FusionCharts.js" type="text/javascript"></script>
<script type="text/javascript">
var EW_REPORT_POPUP_ALL = "(All)";
var EW_REPORT_POPUP_OK = "  OK  ";
var EW_REPORT_POPUP_CANCEL = "Cancel";
var EW_REPORT_POPUP_FROM = "From";
var EW_REPORT_POPUP_TO = "To";
var EW_REPORT_POPUP_PLEASE_SELECT = "Please Select";
var EW_REPORT_POPUP_NO_VALUE = "No value selected!";

// popup fields
</script>
<?php } ?>
<?php if (@$sExport == "") { ?>
<!-- Table Container (Begin) -->
<table id="ewContainer" cellspacing="0" cellpadding="0" border="0">
<!-- Top Container (Begin) -->
<tr><td colspan="3"><div id="ewTop" class="phpreportmaker">
<!-- top slot -->
<a name="top"></a>
<?php } ?>
usermis
<?php if (@$sExport == "") { ?>
&nbsp;&nbsp;<a href="usermisrptreport.php?export=html">Printer Friendly</a>
&nbsp;&nbsp;<a href="usermisrptreport.php?export=excel">Export to Excel</a>
&nbsp;&nbsp;<a href="usermisrptreport.php?export=word">Export to Word</a>
<?php } ?>
<br /><br />
<?php if (@$sExport == "") { ?>
</div></td></tr>
<!-- Top Container (End) -->
<tr>
	<!-- Left Container (Begin) -->
	<td valign="top"><div id="ewLeft" class="phpreportmaker">
	<!-- Left slot -->
	</div></td>
	<!-- Left Container (End) -->
	<!-- Center Container - Report (Begin) -->
	<td valign="top" class="ewPadding"><div id="ewCenter" class="phpreportmaker">
	<!-- center slot -->
<?php } ?>
<!-- summary report starts -->
<div id="report_summary">
<table class="ewGrid" cellspacing="0"><tr>
	<td class="ewGridContent">
<?php if (@$sExport == "") { ?>
<div class="ewGridUpperPanel">
<form action="usermisrptreport.php" name="ewpagerform" id="ewpagerform" class="ewForm">
<table border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td nowrap>
<?php if (!isset($Pager)) $Pager = new cPrevNextPager($nStartGrp, $nDisplayGrps, $nTotalGrps) ?>
<?php if ($Pager->RecordCount > 0) { ?>
	<table border="0" cellspacing="0" cellpadding="0"><tr><td><span class="phpreportmaker">Page&nbsp;</span></td>
<!--first page button-->
	<?php if ($Pager->FirstButton->Enabled) { ?>
	<td><a href="usermisrptreport.php?start=<?php echo $Pager->FirstButton->Start ?>"><img src="phprptimages/first.gif" alt="First" width="16" height="16" border="0"></a></td>
	<?php } else { ?>
	<td><img src="phprptimages/firstdisab.gif" alt="First" width="16" height="16" border="0"></td>
	<?php } ?>
<!--previous page button-->
	<?php if ($Pager->PrevButton->Enabled) { ?>
	<td><a href="usermisrptreport.php?start=<?php echo $Pager->PrevButton->Start ?>"><img src="phprptimages/prev.gif" alt="Previous" width="16" height="16" border="0"></a></td>
	<?php } else { ?>
	<td><img src="phprptimages/prevdisab.gif" alt="Previous" width="16" height="16" border="0"></td>
	<?php } ?>
<!--current page number-->
	<td><input type="text" name="pageno" id="pageno" value="<?php echo $Pager->CurrentPage ?>" size="4"></td>
<!--next page button-->
	<?php if ($Pager->NextButton->Enabled) { ?>
	<td><a href="usermisrptreport.php?start=<?php echo $Pager->NextButton->Start ?>"><img src="phprptimages/next.gif" alt="Next" width="16" height="16" border="0"></a></td>	
	<?php } else { ?>
	<td><img src="phprptimages/nextdisab.gif" alt="Next" width="16" height="16" border="0"></td>
	<?php } ?>
<!--last page button-->
	<?php if ($Pager->LastButton->Enabled) { ?>
	<td><a href="usermisrptreport.php?start=<?php echo $Pager->LastButton->Start ?>"><img src="phprptimages/last.gif" alt="Last" width="16" height="16" border="0"></a></td>	
	<?php } else { ?>
	<td><img src="phprptimages/lastdisab.gif" alt="Last" width="16" height="16" border="0"></td>
	<?php } ?>
	<td><span class="phpreportmaker">&nbsp;of <?php echo $Pager->PageCount ?></span></td>
	</tr></table>
	</td>	
	<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
	<td>
	<span class="phpreportmaker"> <?php echo $Pager->FromIndex ?> to <?php echo $Pager->ToIndex ?> of <?php echo $Pager->RecordCount ?></span>
<?php } else { ?>
	<?php if (($ewCurSec & EW_ALLOW_LIST) == EW_ALLOW_LIST) { ?>
	<?php if ($sFilter == "0=101") { ?>
	<span class="phpreportmaker">Please enter search criteria</span>
	<?php } else { ?>
	<span class="phpreportmaker">No records found</span>
	<?php } ?>
	<?php } else { ?>
	<span class="phpreportmaker">You do not have the right permission to view the page</span>
	<?php } ?>
<?php } ?>
		</td>
<?php if ($nTotalGrps > 0) { ?>
		<td nowrap>&nbsp;&nbsp;&nbsp;&nbsp;</td>
		<td align="right" valign="top" nowrap><span class="phpreportmaker">Records Per Page&nbsp;
<select name="<?php echo EW_REPORT_TABLE_GROUP_PER_PAGE; ?>" onChange="this.form.submit();" class="phpreportmaker">
<option value="3"<?php if ($nDisplayGrps == 3) echo " selected" ?>>3</option>
<option value="10"<?php if ($nDisplayGrps == 10) echo " selected" ?>>10</option>
<option value="20"<?php if ($nDisplayGrps == 20) echo " selected" ?>>20</option>
<option value="50"<?php if ($nDisplayGrps == 50) echo " selected" ?>>50</option>
<option value="100"<?php if ($nDisplayGrps == 100) echo " selected" ?>>100</option>
<option value="ALL"<?php if (@$_SESSION[EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE] == -1) echo " selected" ?>>All</option>
</select>
		</span></td>
<?php } ?>
	</tr>
</table>
</form>
</div>
<?php } ?>
<!-- Report Grid (Begin) -->
<div class="ewGridMiddlePanel">
<table class="ewTable ewTableSeparate" cellspacing="0">
<?php

// Set the last group to display if not export all
if (EW_REPORT_EXPORT_ALL && @$sExport <> "") {
	$nStopGrp = $nTotalGrps;
} else {
	$nStopGrp = $nStartGrp + $nDisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($nStopGrp) > intval($nTotalGrps))
	$nStopGrp = $nTotalGrps;
$nRecCount = 0;

// Get first row
if ($nTotalGrps > 0) {
	GetRow(1);
	$nGrpCount = 1;
}
while (($rs && !$rs->EOF) || $bShowFirstHeader) {

	// Show header
	if ($bShowFirstHeader) {
?>
	<thead>
	<tr>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Employee ID
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Employee ID</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Last Name
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Last Name</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		First Name
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>First Name</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Title
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Title</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Address
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Address</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		City
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>City</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Home Phone
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Home Phone</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Cellphone
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Cellphone</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Email
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Email</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Reports To
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Reports To</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Password
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Password</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		User Level
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>User Level</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Username
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Username</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		Activated
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>Activated</td>
			</tr></table>
		</td>
<?php } ?>
<?php if (@$sExport <> "") { ?>
		<td valign="bottom" class="ewTableHeader">
		entite
		</td>
<?php } else { ?>
		<td class="ewTableHeader">
			<table cellspacing="0" class="ewTableHeaderBtn"><tr>
			<td>entite</td>
			</tr></table>
		</td>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
		$bShowFirstHeader = FALSE;
	}
	$nRecCount++;

		// Set row color
		$sItemRowClass = " class=\"ewTableRow\"";

		// Display alternate color for rows
		if ($nRecCount % 2 <> 1)
			$sItemRowClass = " class=\"ewTableAltRow\"";
?>
	<tr>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_EmployeeID) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_LastName) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_FirstName) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_Title) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_Address) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_City) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_HomePhone) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_Cellphone) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_Email) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_ReportsTo) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_Password) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php if (($ewCurSec & EW_ALLOW_ADMIN) == EW_ALLOW_ADMIN) { // System admin ?>
<?php echo ewrpt_ViewValue($x_UserLevel) ?>
<?php } else {?>
********
<?php } ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_Username) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_Activated) ?>
</td>
		<td<?php echo $sItemRowClass; ?>>
<?php echo ewrpt_ViewValue($x_entite) ?>
</td>
	</tr>
<?php

		// Accumulate page summary
		AccumulateSummary();

		// Get next record
		GetRow(2);
	$nGrpCount++;
} // End while
?>
	</tbody>
	<tfoot>
	</tfoot>
</table>
</div>
</td></tr></table>
</div>
<!-- Summary Report Ends -->
<?php if (@$sExport == "") { ?>
	</div><br /></td>
	<!-- Center Container - Report (End) -->
	<!-- Right Container (Begin) -->
	<td valign="top"><div id="ewRight" class="phpreportmaker">
	<!-- Right slot -->
	</div></td>
	<!-- Right Container (End) -->
</tr>
<!-- Bottom Container (Begin) -->
<tr><td colspan="3"><div id="ewBottom" class="phpreportmaker">
	<!-- Bottom slot -->
	</div><br /></td></tr>
<!-- Bottom Container (End) -->
</table>
<!-- Table Container (End) -->
<?php } ?>
<?php
$conn->Close();

// display elapsed time
if (defined("EW_REPORT_DEBUG_ENABLED"))
	echo ewrpt_calcElapsedTime($starttime);
?>
<?php include "phprptinc/footerreport.php"; ?>
<?php if (@$sExport == "") { ?>
<?php include "footer_admin.php"; ?>
<?php } ?>
<?php

// Accummulate summary
function AccumulateSummary() {
	global $smry, $cnt, $col, $val, $mn, $mx;
	$cntx = count($smry);
	for ($ix = 0; $ix < $cntx; $ix++) {
		$cnty = count($smry[$ix]);
		for ($iy = 1; $iy < $cnty; $iy++) {
			$cnt[$ix][$iy]++;
			if ($col[$iy]) {
				$valwrk = $val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {

					// skip
				} else {
					$smry[$ix][$iy] += $valwrk;
					if (is_null($mn[$ix][$iy])) {
						$mn[$ix][$iy] = $valwrk;
						$mx[$ix][$iy] = $valwrk;
					} else {
						if ($mn[$ix][$iy] > $valwrk) $mn[$ix][$iy] = $valwrk;
						if ($mx[$ix][$iy] < $valwrk) $mx[$ix][$iy] = $valwrk;
					}
				}
			}
		}
	}
	$cntx = count($smry);
	for ($ix = 1; $ix < $cntx; $ix++) {
		$cnt[$ix][0]++;
	}
}

// Reset level summary
function ResetLevelSummary($lvl) {
	global $smry, $cnt, $col, $mn, $mx, $nRecCount;

	// Clear summary values
	$cntx = count($smry);
	for ($ix = $lvl; $ix < $cntx; $ix++) {
		$cnty = count($smry[$ix]);
		for ($iy = 1; $iy < $cnty; $iy++) {
			$cnt[$ix][$iy] = 0;
			if ($col[$iy]) {
				$smry[$ix][$iy] = 0;
				$mn[$ix][$iy] = NULL;
				$mx[$ix][$iy] = NULL;
			}
		}
	}
	$cntx = count($smry);
	for ($ix = $lvl; $ix < $cntx; $ix++) {
		$cnt[$ix][0] = 0;
	}

	// Clear old values
	// Reset record count

	$nRecCount = 0;
}

// Accummulate grand summary
function AccumulateGrandSummary() {
	global $cnt, $col, $val, $grandsmry, $grandmn, $grandmx;
	@$cnt[0][0]++;
	for ($iy = 1; $iy < count($grandsmry); $iy++) {
		if ($col[$iy]) {
			$valwrk = $val[$iy];
			if (is_null($valwrk) || !is_numeric($valwrk)) {

				// skip
			} else {
				$grandsmry[$iy] += $valwrk;
				if (is_null($grandmn[$iy])) {
					$grandmn[$iy] = $valwrk;
					$grandmx[$iy] = $valwrk;
				} else {
					if ($grandmn[$iy] > $valwrk) $grandmn[$iy] = $valwrk;
					if ($grandmx[$iy] < $valwrk) $grandmx[$iy] = $valwrk;
				}
			}
		}
	}
}

// Get count
function GetCnt($sql) {
	global $conn;

	//echo "sql (GetCnt): " . $sql . "<br>";
	$rscnt = $conn->Execute($sql);
	$cnt = ($rscnt) ? $rscnt->RecordCount() : 0;
	return $cnt;
}

// Get rs
function GetRs($sql, $start, $grps) {
	global $conn;
	$wrksql = $sql . " LIMIT " . ($start-1) . ", " . ($grps);

	//echo "wrksql: (rsgrp)" . $sSql . "<br>";
	$rswrk = $conn->Execute($wrksql);
	return $rswrk;
}

// Get row values
function GetRow($opt) {
	global $rs, $val;
	if (!$rs)
		return;
	if ($opt == 1) { // Get first row
		$rs->MoveFirst();
	} else { // Get next row
		$rs->MoveNext();
	}
	if (!$rs->EOF) {
		$GLOBALS['x_EmployeeID'] = $rs->fields('EmployeeID');
		$GLOBALS['x_LastName'] = $rs->fields('LastName');
		$GLOBALS['x_FirstName'] = $rs->fields('FirstName');
		$GLOBALS['x_Title'] = $rs->fields('Title');
		$GLOBALS['x_Address'] = $rs->fields('Address');
		$GLOBALS['x_City'] = $rs->fields('City');
		$GLOBALS['x_HomePhone'] = $rs->fields('HomePhone');
		$GLOBALS['x_Cellphone'] = $rs->fields('Cellphone');
		$GLOBALS['x_Email'] = $rs->fields('Email');
		$GLOBALS['x_Notes'] = $rs->fields('Notes');
		$GLOBALS['x_ReportsTo'] = $rs->fields('ReportsTo');
		$GLOBALS['x_Password'] = $rs->fields('Password');
		$GLOBALS['x_UserLevel'] = $rs->fields('UserLevel');
		$GLOBALS['x_Username'] = $rs->fields('Username');
		$GLOBALS['x_Activated'] = $rs->fields('Activated');
		$GLOBALS['x_entite'] = $rs->fields('entite');
		$val[1] = $GLOBALS['x_EmployeeID'];
		$val[2] = $GLOBALS['x_LastName'];
		$val[3] = $GLOBALS['x_FirstName'];
		$val[4] = $GLOBALS['x_Title'];
		$val[5] = $GLOBALS['x_Address'];
		$val[6] = $GLOBALS['x_City'];
		$val[7] = $GLOBALS['x_HomePhone'];
		$val[8] = $GLOBALS['x_Cellphone'];
		$val[9] = $GLOBALS['x_Email'];
		$val[10] = $GLOBALS['x_ReportsTo'];
		$val[11] = $GLOBALS['x_Password'];
		$val[12] = $GLOBALS['x_UserLevel'];
		$val[13] = $GLOBALS['x_Username'];
		$val[14] = $GLOBALS['x_Activated'];
		$val[15] = $GLOBALS['x_entite'];
	} else {
		$GLOBALS['x_EmployeeID'] = "";
		$GLOBALS['x_LastName'] = "";
		$GLOBALS['x_FirstName'] = "";
		$GLOBALS['x_Title'] = "";
		$GLOBALS['x_Address'] = "";
		$GLOBALS['x_City'] = "";
		$GLOBALS['x_HomePhone'] = "";
		$GLOBALS['x_Cellphone'] = "";
		$GLOBALS['x_Email'] = "";
		$GLOBALS['x_Notes'] = "";
		$GLOBALS['x_ReportsTo'] = "";
		$GLOBALS['x_Password'] = "";
		$GLOBALS['x_UserLevel'] = "";
		$GLOBALS['x_Username'] = "";
		$GLOBALS['x_Activated'] = "";
		$GLOBALS['x_entite'] = "";
	}
}

//  Set up starting group
function SetUpStartGroup() {
	global $nStartGrp, $nTotalGrps, $nDisplayGrps;

	// Exit if no groups
	if ($nDisplayGrps == 0)
		return;

	// Check for a 'start' parameter
	if (@$_GET[EW_REPORT_TABLE_START_GROUP] != "") {
		$nStartGrp = $_GET[EW_REPORT_TABLE_START_GROUP];
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (@$_GET["pageno"] != "") {
		$nPageNo = $_GET["pageno"];
		if (is_numeric($nPageNo)) {
			$nStartGrp = ($nPageNo-1)*$nDisplayGrps+1;
			if ($nStartGrp <= 0) {
				$nStartGrp = 1;
			} elseif ($nStartGrp >= intval(($nTotalGrps-1)/$nDisplayGrps)*$nDisplayGrps+1) {
				$nStartGrp = intval(($nTotalGrps-1)/$nDisplayGrps)*$nDisplayGrps+1;
			}
			$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
		} else {
			$nStartGrp = @$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP];
		}
	} else {
		$nStartGrp = @$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP];	
	}

	// Check if correct start group counter
	if (!is_numeric($nStartGrp) || $nStartGrp == "") { // Avoid invalid start group counter
		$nStartGrp = 1; // Reset start group counter
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (intval($nStartGrp) > intval($nTotalGrps)) { // Avoid starting group > total groups
		$nStartGrp = intval(($nTotalGrps-1)/$nDisplayGrps) * $nDisplayGrps + 1; // Point to last page first group
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (($nStartGrp-1) % $nDisplayGrps <> 0) {
		$nStartGrp = intval(($nStartGrp-1)/$nDisplayGrps) * $nDisplayGrps + 1; // Point to page boundary
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	}
}

// Set up popup
function SetupPopup() {
	global $conn, $sFilter;

	// Initialize popup
	// Process post back form

	if (count($_POST) > 0) {
		$sName = @$_POST["popup"]; // Get popup form name
		if ($sName <> "") {
		$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
			if ($cntValues > 0) {
				$arValues = ewrpt_StripSlashes($_POST["sel_$sName"]);
				if (trim($arValues[0]) == "") // Select all
					$arValues = EW_REPORT_INIT_VALUE;
				$_SESSION["sel_$sName"] = $arValues;
				$_SESSION["rf_$sName"] = ewrpt_StripSlashes(@$_POST["rf_$sName"]);
				$_SESSION["rt_$sName"] = ewrpt_StripSlashes(@$_POST["rt_$sName"]);
				ResetPager();
			}
		}

	// Get 'reset' command
	} elseif (@$_GET["cmd"] <> "") {
		$sCmd = $_GET["cmd"];
		if (strtolower($sCmd) == "reset") {
			ResetPager();
		}
	}

	// Load selection criteria to array
}

// Reset pager
function ResetPager() {

	// Reset start position (reset command)
	global $nStartGrp, $nTotalGrps;
	$nStartGrp = 1;
	$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
}
?>
<?php

// Set up number of groups displayed per page
function SetUpDisplayGrps() {
	global $nDisplayGrps, $nStartGrp;
	$sWrk = @$_GET[EW_REPORT_TABLE_GROUP_PER_PAGE];
	if ($sWrk <> "") {
		if (is_numeric($sWrk)) {
			$nDisplayGrps = intval($sWrk);
		} else {
			if (strtoupper($sWrk) == "ALL") { // display all groups
				$nDisplayGrps = -1;
			} else {
				$nDisplayGrps = 3; // Non-numeric, load default
			}
		}
		$_SESSION[EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE] = $nDisplayGrps; // Save to session

		// Reset start position (reset command)
		$nStartGrp = 1;
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} else {
		if (@$_SESSION[EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE] <> "") {
			$nDisplayGrps = $_SESSION[EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE]; // Restore from session
		} else {
			$nDisplayGrps = 3; // Load default
		}
	}
}
?>
<?php

// Return poup filter
function GetPopupFilter() {
	$sWrk = "";
	return $sWrk;
}
?>
<?php

//-------------------------------------------------------------------------------
// Function getSort
// - Return Sort parameters based on Sort Links clicked
// - Variables setup: Session[EW_REPORT_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
function getSort()
{

	// Check for a resetsort command
	if (strlen(@$_GET["cmd"]) > 0) {
		$sCmd = @$_GET["cmd"];
		if ($sCmd == "resetsort") {
			$_SESSION[EW_REPORT_TABLE_SESSION_ORDER_BY] = "";
			$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = 1;
			$_SESSION["sort_usermis_EmployeeID"] = "";
			$_SESSION["sort_usermis_LastName"] = "";
			$_SESSION["sort_usermis_FirstName"] = "";
			$_SESSION["sort_usermis_Title"] = "";
			$_SESSION["sort_usermis_Address"] = "";
			$_SESSION["sort_usermis_City"] = "";
			$_SESSION["sort_usermis_HomePhone"] = "";
			$_SESSION["sort_usermis_Cellphone"] = "";
			$_SESSION["sort_usermis_Email"] = "";
			$_SESSION["sort_usermis_ReportsTo"] = "";
			$_SESSION["sort_usermis_Password"] = "";
			$_SESSION["sort_usermis_UserLevel"] = "";
			$_SESSION["sort_usermis_Username"] = "";
			$_SESSION["sort_usermis_Activated"] = "";
			$_SESSION["sort_usermis_entite"] = "";
		}

	// Check for an Order parameter
	} elseif (strlen(@$_GET[EW_REPORT_TABLE_ORDER_BY]) > 0) {
		$sSortSql = "";
		$sSortField = "";
		$sOrder = @$_GET[EW_REPORT_TABLE_ORDER_BY];
		if (strlen(@$_GET[EW_REPORT_TABLE_ORDER_BY_TYPE]) > 0) {
			$sOrderType = @$_GET[EW_REPORT_TABLE_ORDER_BY_TYPE];
		} else {
			$sOrderType = "";
		}
	}
	return @$_SESSION[EW_REPORT_TABLE_SESSION_ORDER_BY];
}
?>
