<?php
define("EW_PAGE_ID", "preview", TRUE);
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "LesProjetsinfo_admin.php" ?>
<?php include "departementinfo_admin.php" ?>
<?php include "communeinfo_admin.php" ?>
<?php include "sectioninfo_admin.php" ?>
<?php include "entitesinfo_admin.php" ?>
<?php include "secteursinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "statutinfo_admin.php" ?>
<?php include "departinfo_admin.php" ?>
<?php include "cominfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php

// Init table objects
$LesProjets = new cLesProjets();
$departement = new cdepartement();
$commune = new ccommune();
$section = new csection();
$entites = new centites();
$secteurs = new csecteurs();
$usermis = new cusermis();
$statut = new cstatut();
$depart = new cdepart();
$com = new ccom();

// Open connection to the database
$conn = ew_Connect();
$Security = new cAdvancedSecurity();
if (!$Security->IsLoggedIn()) $Security->AutoLogin();
if (!$Security->IsLoggedIn()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->TablePermission_Loading();
$Security->LoadCurrentUserLevel('LesProjets');
$Security->TablePermission_Loaded();
if (!$Security->IsLoggedIn()) {
	$Security->SaveLastUrl();
	$this->Page_Terminate("login_admin.php");
}
if (!$Security->CanList()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->UserID_Loading();
if ($Security->IsLoggedIn()) $Security->LoadUserID();
$Security->UserID_Loaded();
if ($Security->IsLoggedIn() && $Security->CurrentUserID() == "") {
	echo "You do not have the right permission to view the page";
	exit();
}

// Load filter
$qs = new cQueryString();
$filter = $qs->GetValue("f");
$filter = TEAdecrypt($filter, EW_RANDOM_KEY);
if ($filter == "") $filter = "0=1";

// Load recordset
$rs = $LesProjets->LoadRs($filter);
$nTotalRecs = ($rs) ? $rs->RecordCount() : 0;
?>
<link href="prima_dev_v2.css" rel="stylesheet" type="text/css">
<p><span class="phpmaker" style="white-space: nowrap;">Table: Les projets
<?php if ($nTotalRecs > 0) { ?>
(<?php echo $nTotalRecs ?> Records)
<?php } else { ?>
(No records found)
<?php } ?>
</span></p>
<?php if ($nTotalRecs > 0) { ?>
<table cellspacing="0" class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table id="ewDetailsPreviewTable" name="ewDetailsPreviewTable" cellspacing="0" class="ewTable ewTableSeparate">
	<thead><!-- Table header -->
		<tr class="ewTableHeader">
			<td valign="top">Fiche projet</td>
			<td valign="top">D&eacute;partement</td>
			<td valign="top">Commune</td>
			<td valign="top">Ville/Quartier/Section</td>
			<td valign="top">Secteur</td>
			<td valign="top">Balance &agrave; d&eacute;caisser</td>
			<td valign="top">Bailleur</td>
			<td valign="top">Programme</td>
			<td valign="top">Date de d&eacute;marrage</td>
			<td valign="top">Statut</td>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$nRecCount = 0;
while ($rs && !$rs->EOF) {

	// Init row class and style
	$nRecCount++;
	$LesProjets->CssClass = "ewTableRow";
	$LesProjets->CssStyle = "";

	// Display alternate color for rows
	if ($nRecCount % 2 <> 1)
		$LesProjets->CssClass = "ewTableAltRow";
	$LesProjets->LoadListRowValues($rs);

	// Render row
	$LesProjets->RowType = EW_ROWTYPE_PREVIEW; // Preview record
	$LesProjets->RenderListRow();
?>
	<tr<?php echo $LesProjets->RowAttributes() ?>>
		<!-- proj -->
		<td<?php echo $LesProjets->proj->CellAttributes() ?>>
<div<?php echo $LesProjets->proj->ViewAttributes() ?>><?php echo $LesProjets->proj->ViewValue ?></div></td>
		<!-- departement -->
		<td<?php echo $LesProjets->departement->CellAttributes() ?>>
<div<?php echo $LesProjets->departement->ViewAttributes() ?>><?php echo $LesProjets->departement->ViewValue ?></div></td>
		<!-- commune -->
		<td<?php echo $LesProjets->commune->CellAttributes() ?>>
<div<?php echo $LesProjets->commune->ViewAttributes() ?>><?php echo $LesProjets->commune->ViewValue ?></div></td>
		<!-- section -->
		<td<?php echo $LesProjets->section->CellAttributes() ?>>
<div<?php echo $LesProjets->section->ViewAttributes() ?>><?php echo $LesProjets->section->ViewValue ?></div></td>
		<!-- secteur -->
		<td<?php echo $LesProjets->secteur->CellAttributes() ?>>
<div<?php echo $LesProjets->secteur->ViewAttributes() ?>><?php echo $LesProjets->secteur->ViewValue ?></div></td>
		<!-- Balance -->
		<td<?php echo $LesProjets->Balance->CellAttributes() ?>>
<div<?php echo $LesProjets->Balance->ViewAttributes() ?>><?php echo $LesProjets->Balance->ViewValue ?></div></td>
		<!-- bailleur -->
		<td<?php echo $LesProjets->bailleur->CellAttributes() ?>>
<div<?php echo $LesProjets->bailleur->ViewAttributes() ?>><?php echo $LesProjets->bailleur->ViewValue ?></div></td>
		<!-- program -->
		<td<?php echo $LesProjets->program->CellAttributes() ?>>
<div<?php echo $LesProjets->program->ViewAttributes() ?>><?php echo $LesProjets->program->ViewValue ?></div></td>
		<!-- datedebut -->
		<td<?php echo $LesProjets->datedebut->CellAttributes() ?>>
<div<?php echo $LesProjets->datedebut->ViewAttributes() ?>><?php echo $LesProjets->datedebut->ViewValue ?></div></td>
		<!-- statut -->
		<td<?php echo $LesProjets->statut->CellAttributes() ?>>
<div<?php echo $LesProjets->statut->ViewAttributes() ?>><?php echo $LesProjets->statut->ViewValue ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
?>
	</tbody>
</table>
</div>
</td></tr></table>
<?php
if ($rs)
	$rs->Close();
}
$content = ob_get_contents();
ob_end_clean();
echo ew_ConvertToUtf8($content);
?>
