<?php
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php

// PHPMaker 6 configuration for Table Report1
$Report1 = NULL; // Initialize table object

// Define table class
class cReport1 {

	// Define table level constants
	var $TableVar;
	var $TableName;
	var $SelectLimit = FALSE;
	var $idprojet;
	var $departement;
	var $commune;
	var $section;
	var $titre;
	var $objectif;
	var $montantdec;
	var $entite;
	var $secteur;
	var $ast;
	var $bailleur;
	var $program;
	var $statut;
	var $datedebut;
	var $datemaj;
	var $zuserID;
	var $montantproj;
	var $nbrbd;
	var $nbrec;
	var $Realisation;
	var $idfbp;
	var $fields = array();
	var $UseTokenInUrl = EW_USE_TOKEN_IN_URL;
	var $Export; // Export
	var $ExportOriginalValue = EW_EXPORT_ORIGINAL_VALUE;
	var	$ExportAll = EW_EXPORT_ALL;
	var $SendEmail; // Send Email
	var $TableCustomInnerHtml; // Custom Inner Html

	function cReport1() {
		$this->TableVar = "Report1";
		$this->TableName = "Report1";
		$this->idprojet = new cField('Report1', 'x_idprojet', 'idprojet', "`idprojet`", 3, -1, FALSE);
		$this->fields['idprojet'] =& $this->idprojet;
		$this->departement = new cField('Report1', 'x_departement', 'departement', "`departement`", 3, -1, FALSE);
		$this->fields['departement'] =& $this->departement;
		$this->commune = new cField('Report1', 'x_commune', 'commune', "`commune`", 3, -1, FALSE);
		$this->fields['commune'] =& $this->commune;
		$this->section = new cField('Report1', 'x_section', 'section', "`section`", 3, -1, FALSE);
		$this->fields['section'] =& $this->section;
		$this->titre = new cField('Report1', 'x_titre', 'titre', "`titre`", 200, -1, FALSE);
		$this->fields['titre'] =& $this->titre;
		$this->objectif = new cField('Report1', 'x_objectif', 'objectif', "`objectif`", 201, -1, FALSE);
		$this->fields['objectif'] =& $this->objectif;
		$this->montantdec = new cField('Report1', 'x_montantdec', 'montantdec', "`montantdec`", 5, -1, FALSE);
		$this->fields['montantdec'] =& $this->montantdec;
		$this->entite = new cField('Report1', 'x_entite', 'entite', "`entite`", 3, -1, FALSE);
		$this->fields['entite'] =& $this->entite;
		$this->secteur = new cField('Report1', 'x_secteur', 'secteur', "`secteur`", 3, -1, FALSE);
		$this->fields['secteur'] =& $this->secteur;
		$this->ast = new cField('Report1', 'x_ast', 'ast', "`ast`", 200, -1, FALSE);
		$this->fields['ast'] =& $this->ast;
		$this->bailleur = new cField('Report1', 'x_bailleur', 'bailleur', "`bailleur`", 200, -1, FALSE);
		$this->fields['bailleur'] =& $this->bailleur;
		$this->program = new cField('Report1', 'x_program', 'program', "`program`", 200, -1, FALSE);
		$this->fields['program'] =& $this->program;
		$this->statut = new cField('Report1', 'x_statut', 'statut', "`statut`", 3, -1, FALSE);
		$this->fields['statut'] =& $this->statut;
		$this->datedebut = new cField('Report1', 'x_datedebut', 'datedebut', "`datedebut`", 133, 7, FALSE);
		$this->fields['datedebut'] =& $this->datedebut;
		$this->datemaj = new cField('Report1', 'x_datemaj', 'datemaj', "`datemaj`", 133, 7, FALSE);
		$this->fields['datemaj'] =& $this->datemaj;
		$this->zuserID = new cField('Report1', 'x_zuserID', 'userID', "`userID`", 3, -1, FALSE);
		$this->fields['userID'] =& $this->zuserID;
		$this->montantproj = new cField('Report1', 'x_montantproj', 'montantproj', "`montantproj`", 5, -1, FALSE);
		$this->fields['montantproj'] =& $this->montantproj;
		$this->nbrbd = new cField('Report1', 'x_nbrbd', 'nbrbd', "`nbrbd`", 200, -1, FALSE);
		$this->fields['nbrbd'] =& $this->nbrbd;
		$this->nbrec = new cField('Report1', 'x_nbrec', 'nbrec', "`nbrec`", 200, -1, FALSE);
		$this->fields['nbrec'] =& $this->nbrec;
		$this->Realisation = new cField('Report1', 'x_Realisation', 'Realisation', "`Realisation`", 201, -1, FALSE);
		$this->fields['Realisation'] =& $this->Realisation;
		$this->idfbp = new cField('Report1', 'x_idfbp', 'idfbp', "`idfbp`", 3, -1, FALSE);
		$this->fields['idfbp'] =& $this->idfbp;
	}

	// Report Group Level SQL
	function SqlGroupSelect() { // Select
		return "SELECT DISTINCT `bailleur` FROM `projets`";
	}

	function SqlGroupWhere() { // Where
		return "";
	}

	function SqlGroupGroupBy() { // Group By
		return "";
	}

	function SqlGroupHaving() { // Having
		return "";
	}

	function SqlGroupOrderBy() { // Order By
		return "`bailleur` ASC";
	}

	// Report Detail Level SQL
	function SqlDetailSelect() { // Select
		return "SELECT * FROM `projets`";
	}

	function SqlDetailWhere() { // Where
		return "";
	}

	function SqlDetailGroupBy() { // Group By
		return "";
	}

	function SqlDetailHaving() { // Having
		return "";
	}

	function SqlDetailOrderBy() { // Order By
		return "";
	}

	// SQL variables
	var $CurrentFilter; // Current filter
	var $CurrentOrder; // Current order
	var $CurrentOrderType; // Current order type

	// Return report group sql
	function GroupSQL() {
		$sFilter = $this->CurrentFilter;
		$sSort = "";
		return ew_BuildSelectSql($this->SqlGroupSelect(), $this->SqlGroupWhere(),
			 $this->SqlGroupGroupBy(), $this->SqlGroupHaving(),
			 $this->SqlGroupOrderBy(), $sFilter, $sSort);
	}

	// Return report detail SQL
	function DetailSQL() {
		$sFilter = $this->CurrentFilter;
		$sSort = "";
		return ew_BuildSelectSql($this->SqlDetailSelect(), $this->SqlDetailWhere(),
			$this->SqlDetailGroupBy(), $this->SqlDetailHaving(),
			$this->SqlDetailOrderBy(), $sFilter, $sSort);
	}

	// Return url
	function getReturnUrl() {

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login_admin.php") // Referer not same page or login page
			$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] <> "") {
			return $_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL];
		} else {
			return "Report1report_admin.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// View url
	function ViewUrl() {
		return $this->KeyUrl("", $this->UrlParm());
	}

	// Add url
	function AddUrl() {
		$AddUrl = "";
		$sUrlParm = $this->UrlParm();
		if ($sUrlParm <> "")
			$AddUrl .= "?" . $sUrlParm;
		return $AddUrl;
	}

	// Edit url
	function EditUrl() {
		return $this->KeyUrl("", $this->UrlParm());
	}

	// Inline edit url
	function InlineEditUrl() {
		return $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
	}

	// Copy url
	function CopyUrl() {
		return $this->KeyUrl("", $this->UrlParm());
	}

	// Inline copy url
	function InlineCopyUrl() {
		return $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
	}

	// Delete url
	function DeleteUrl() {
		return $this->KeyUrl("", $this->UrlParm());
	}

	// Key url
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->idprojet->CurrentValue)) {
			$sUrl .= "idprojet=" . urlencode($this->idprojet->CurrentValue);
		} else {
			return "javascript:alert('Invalid Record! Key is null');";
		}
		return $sUrl;
	}

	// Sort Url
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			($fld->FldType == 205)) { // Unsortable data type
			return "";
		} else {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&ordertype=" . $fld->ReverseSort());
			return ew_CurrentPage() . "?" . $sUrlParm;
		}
	}

	// URL parm
	function UrlParm($parm = "") {
		$UrlParm = ($this->UseTokenInUrl) ? "t=Report1" : "";
		if ($parm <> "") {
			if ($UrlParm <> "")
				$UrlParm .= "&";
			$UrlParm .= $parm;
		}
		return $UrlParm;
	}

	// Function LoadRs
	// - Load rows based on filter
	function LoadRs($sFilter) {
		global $conn;

		// Set up filter (Sql Where Clause) and get Return Sql
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		return $conn->Execute($sSql);
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->idprojet->setDbValue($rs->fields('idprojet'));
		$this->departement->setDbValue($rs->fields('departement'));
		$this->commune->setDbValue($rs->fields('commune'));
		$this->section->setDbValue($rs->fields('section'));
		$this->titre->setDbValue($rs->fields('titre'));
		$this->objectif->setDbValue($rs->fields('objectif'));
		$this->montantdec->setDbValue($rs->fields('montantdec'));
		$this->entite->setDbValue($rs->fields('entite'));
		$this->secteur->setDbValue($rs->fields('secteur'));
		$this->ast->setDbValue($rs->fields('ast'));
		$this->bailleur->setDbValue($rs->fields('bailleur'));
		$this->program->setDbValue($rs->fields('program'));
		$this->statut->setDbValue($rs->fields('statut'));
		$this->datedebut->setDbValue($rs->fields('datedebut'));
		$this->datemaj->setDbValue($rs->fields('datemaj'));
		$this->zuserID->setDbValue($rs->fields('userID'));
		$this->montantproj->setDbValue($rs->fields('montantproj'));
		$this->nbrbd->setDbValue($rs->fields('nbrbd'));
		$this->nbrec->setDbValue($rs->fields('nbrec'));
		$this->Realisation->setDbValue($rs->fields('Realisation'));
		$this->idfbp->setDbValue($rs->fields('idfbp'));
	}

	// Render list row values
	function RenderListRow() {
		global $conn, $Security;

		// departement
		if (strval($Report1->departement->CurrentValue) <> "") {
			$sSqlWrk = "SELECT `departemen` FROM `departement` WHERE `ID_Dep` = " . ew_AdjustSql($Report1->departement->CurrentValue) . "";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->departement->ViewValue = $rswrk->fields('departemen');
				$rswrk->Close();
			} else {
				$Report1->departement->ViewValue = $Report1->departement->CurrentValue;
			}
		} else {
			$Report1->departement->ViewValue = NULL;
		}
		$Report1->departement->CssStyle = "";
		$Report1->departement->CssClass = "";
		$Report1->departement->ViewCustomAttributes = "";

		// commune
		if (strval($Report1->commune->CurrentValue) <> "") {
			$sSqlWrk = "SELECT `Commune` FROM `commune` WHERE `Id_com` = " . ew_AdjustSql($Report1->commune->CurrentValue) . "";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->commune->ViewValue = $rswrk->fields('Commune');
				$rswrk->Close();
			} else {
				$Report1->commune->ViewValue = $Report1->commune->CurrentValue;
			}
		} else {
			$Report1->commune->ViewValue = NULL;
		}
		$Report1->commune->CssStyle = "";
		$Report1->commune->CssClass = "";
		$Report1->commune->ViewCustomAttributes = "";

		// section
		if (strval($Report1->section->CurrentValue) <> "") {
			$sSqlWrk = "SELECT `vqs` FROM `section` WHERE `id_section` = " . ew_AdjustSql($Report1->section->CurrentValue) . "";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->section->ViewValue = $rswrk->fields('vqs');
				$rswrk->Close();
			} else {
				$Report1->section->ViewValue = $Report1->section->CurrentValue;
			}
		} else {
			$Report1->section->ViewValue = NULL;
		}
		$Report1->section->CssStyle = "";
		$Report1->section->CssClass = "";
		$Report1->section->ViewCustomAttributes = "";

		// titre
		$Report1->titre->ViewValue = $Report1->titre->CurrentValue;
		$Report1->titre->CssStyle = "";
		$Report1->titre->CssClass = "";
		$Report1->titre->ViewCustomAttributes = "";

		// objectif
		$Report1->objectif->ViewValue = $Report1->objectif->CurrentValue;
		$Report1->objectif->CssStyle = "";
		$Report1->objectif->CssClass = "";
		$Report1->objectif->ViewCustomAttributes = "";

		// montantdec
		$Report1->montantdec->ViewValue = $Report1->montantdec->CurrentValue;
		$Report1->montantdec->ViewValue = ew_FormatCurrency($Report1->montantdec->ViewValue, 2, -2, -2, -2);
		$Report1->montantdec->CssStyle = "text-align:left;";
		$Report1->montantdec->CssClass = "";
		$Report1->montantdec->ViewCustomAttributes = "";

		// entite
		if (strval($Report1->entite->CurrentValue) <> "") {
			$sSqlWrk = "SELECT `nomentite` FROM `entites` WHERE `identite` = " . ew_AdjustSql($Report1->entite->CurrentValue) . "";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->entite->ViewValue = $rswrk->fields('nomentite');
				$rswrk->Close();
			} else {
				$Report1->entite->ViewValue = $Report1->entite->CurrentValue;
			}
		} else {
			$Report1->entite->ViewValue = NULL;
		}
		$Report1->entite->CssStyle = "";
		$Report1->entite->CssClass = "";
		$Report1->entite->ViewCustomAttributes = "";

		// secteur
		if (strval($Report1->secteur->CurrentValue) <> "") {
			$sSqlWrk = "SELECT `nomsecteur` FROM `secteurs` WHERE `idsecteur` = " . ew_AdjustSql($Report1->secteur->CurrentValue) . "";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->secteur->ViewValue = $rswrk->fields('nomsecteur');
				$rswrk->Close();
			} else {
				$Report1->secteur->ViewValue = $Report1->secteur->CurrentValue;
			}
		} else {
			$Report1->secteur->ViewValue = NULL;
		}
		$Report1->secteur->CssStyle = "";
		$Report1->secteur->CssClass = "";
		$Report1->secteur->ViewCustomAttributes = "";

		// ast
		if (strval($Report1->ast->CurrentValue) <> "") {
			$arwrk = explode(",", $Report1->ast->CurrentValue);
			$sSqlWrk = "SELECT `nomsecteur` FROM `secteurs` WHERE ";
			$sWhereWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
				$sWhereWrk .= "`idsecteur` = " . ew_AdjustSql(trim($wrk)) . "";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= "(" . $sWhereWrk . ")";
			$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->ast->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$Report1->ast->ViewValue .= $rswrk->fields('nomsecteur');
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $Report1->ast->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$Report1->ast->ViewValue = $Report1->ast->CurrentValue;
			}
		} else {
			$Report1->ast->ViewValue = NULL;
		}
		$Report1->ast->CssStyle = "";
		$Report1->ast->CssClass = "";
		$Report1->ast->ViewCustomAttributes = "";

		// bailleur
		if (strval($Report1->bailleur->CurrentValue) <> "") {
			$arwrk = explode(",", $Report1->bailleur->CurrentValue);
			$sSqlWrk = "SELECT `nombailleur` FROM `bailleurs` WHERE ";
			$sWhereWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
				$sWhereWrk .= "`idbailleur` = " . ew_AdjustSql(trim($wrk)) . "";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= "(" . $sWhereWrk . ")";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->bailleur->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$Report1->bailleur->ViewValue .= $rswrk->fields('nombailleur');
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $Report1->bailleur->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$Report1->bailleur->ViewValue = $Report1->bailleur->CurrentValue;
			}
		} else {
			$Report1->bailleur->ViewValue = NULL;
		}
		$Report1->bailleur->CssStyle = "";
		$Report1->bailleur->CssClass = "";
		$Report1->bailleur->ViewCustomAttributes = "";

		// program
		if (strval($Report1->program->CurrentValue) <> "") {
			$arwrk = explode(",", $Report1->program->CurrentValue);
			$sSqlWrk = "SELECT `sigleprog`, `nomprog` FROM `programme` WHERE ";
			$sWhereWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
				$sWhereWrk .= "`idprog` = " . ew_AdjustSql(trim($wrk)) . "";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= "(" . $sWhereWrk . ")";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->program->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$Report1->program->ViewValue .= $rswrk->fields('sigleprog');
					$Report1->program->ViewValue .= ew_ValueSeparator($ari) . $rswrk->fields('nomprog');
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $Report1->program->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$Report1->program->ViewValue = $Report1->program->CurrentValue;
			}
		} else {
			$Report1->program->ViewValue = NULL;
		}
		$Report1->program->CssStyle = "";
		$Report1->program->CssClass = "";
		$Report1->program->ViewCustomAttributes = "";

		// statut
		if (strval($Report1->statut->CurrentValue) <> "") {
			$sSqlWrk = "SELECT `NomStatut` FROM `statut` WHERE `StatutID` = " . ew_AdjustSql($Report1->statut->CurrentValue) . "";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
				$Report1->statut->ViewValue = $rswrk->fields('NomStatut');
				$rswrk->Close();
			} else {
				$Report1->statut->ViewValue = $Report1->statut->CurrentValue;
			}
		} else {
			$Report1->statut->ViewValue = NULL;
		}
		$Report1->statut->CssStyle = "";
		$Report1->statut->CssClass = "";
		$Report1->statut->ViewCustomAttributes = "";

		// datedebut
		$Report1->datedebut->ViewValue = $Report1->datedebut->CurrentValue;
		$Report1->datedebut->ViewValue = ew_FormatDateTime($Report1->datedebut->ViewValue, 7);
		$Report1->datedebut->CssStyle = "";
		$Report1->datedebut->CssClass = "";
		$Report1->datedebut->ViewCustomAttributes = "";

		// montantproj
		$Report1->montantproj->ViewValue = $Report1->montantproj->CurrentValue;
		$Report1->montantproj->CssStyle = "";
		$Report1->montantproj->CssClass = "";
		$Report1->montantproj->ViewCustomAttributes = "";

		// nbrbd
		$Report1->nbrbd->ViewValue = $Report1->nbrbd->CurrentValue;
		$Report1->nbrbd->CssStyle = "";
		$Report1->nbrbd->CssClass = "";
		$Report1->nbrbd->ViewCustomAttributes = "";

		// nbrec
		$Report1->nbrec->ViewValue = $Report1->nbrec->CurrentValue;
		$Report1->nbrec->CssStyle = "";
		$Report1->nbrec->CssClass = "";
		$Report1->nbrec->ViewCustomAttributes = "";

		// idfbp
		$Report1->idfbp->ViewValue = $Report1->idfbp->CurrentValue;
		$Report1->idfbp->CssStyle = "";
		$Report1->idfbp->CssClass = "";
		$Report1->idfbp->ViewCustomAttributes = "";

		// departement
		$Report1->departement->HrefValue = "";

		// commune
		$Report1->commune->HrefValue = "";

		// section
		$Report1->section->HrefValue = "";

		// titre
		$Report1->titre->HrefValue = "";

		// objectif
		$Report1->objectif->HrefValue = "";

		// montantdec
		$Report1->montantdec->HrefValue = "";

		// entite
		$Report1->entite->HrefValue = "";

		// secteur
		$Report1->secteur->HrefValue = "";

		// ast
		$Report1->ast->HrefValue = "";

		// bailleur
		$Report1->bailleur->HrefValue = "";

		// program
		$Report1->program->HrefValue = "";

		// statut
		$Report1->statut->HrefValue = "";

		// datedebut
		$Report1->datedebut->HrefValue = "";

		// montantproj
		$Report1->montantproj->HrefValue = "";

		// nbrbd
		$Report1->nbrbd->HrefValue = "";

		// nbrec
		$Report1->nbrec->HrefValue = "";

		// idfbp
		$Report1->idfbp->HrefValue = "";
	}
	var $RowType; // Row Type
	var $CssClass; // Css class
	var $CssStyle; // Css style
	var $RowClientEvents; // Row client events

	// Row Attribute
	function RowAttributes() {
		$sAtt = "";
		if (trim($this->CssStyle) <> "") {
			$sAtt .= " style=\"" . trim($this->CssStyle) . "\"";
		}
		if (trim($this->CssClass) <> "") {
			$sAtt .= " class=\"" . trim($this->CssClass) . "\"";
		}
		if ($this->Export == "") {
			if (trim($this->RowClientEvents) <> "") {
				$sAtt .= " " . trim($this->RowClientEvents);
			}
		}
		return $sAtt;
	}

	// Field objects
	function fields($fldname) {
		return $this->fields[$fldname];
	}
}
?>
<?php include "usermisinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Define page object
$Report1_report = new cReport1_report();
$Page =& $Report1_report;

// Page init processing
$Report1_report->Page_Init();

// Page main processing
$Report1_report->Page_Main();
?>
<?php include "header_admin.php" ?>
<?php if ($Report1->Export == "") { ?>
<script language="JavaScript" type="text/javascript">
<!--

// Write your client script here, no need to add script tags.
// To include another .js script, use:
// ew_ClientScriptInclude("my_javascript.js"); 
//-->

</script>
<?php } ?>
<?php if ($Report1->Export == "") { ?>
<?php } ?>
<p><span class="phpmaker">Report: Report 1
<?php if ($Report1->Export == "") { ?>
&nbsp;&nbsp;<a href="<?php echo $Report1_report->PageUrl() ?>export=print"><img src='images/print.gif' alt='Printer Friendly' title='Printer Friendly' width='16' height='16' border='0'></a>
&nbsp;&nbsp;<a href="<?php echo $Report1_report->PageUrl() ?>export=excel"><img src='images/exportxls.gif' alt='Export to Excel' title='Export to Excel' width='16' height='16' border='0'></a>
&nbsp;&nbsp;<a href="<?php echo $Report1_report->PageUrl() ?>export=word"><img src='images/exportdoc.gif' alt='Export to Word' title='Export to Word' width='16' height='16' border='0'></a>
<?php } ?>
</span></p>
<form method="post">
<table class="ewReportTable" cellspacing="-1">
<?php
$Report1_report->sFilter = "";
if (!$Security->CanReport()) {
	if ($Report1_report->sFilter <> "") $Report1_report->sFilter .= " AND ";
	$Report1_report->sFilter .= "(0=1)";
}
if ($Report1_report->sDbDetailFilter <> "") {
	if ($Report1_report->sFilter <> "") $Report1_report->sFilter .= " AND ";
	$Report1_report->sFilter .= "(" . $Report1_report->sDbDetailFilter . ")";
}

// Set up filter and load Group level sql
$Report1->CurrentFilter = $Report1_report->sFilter;
$Report1_report->sSql = $Report1->GroupSQL();

// Load recordset
$rs = $conn->Execute($Report1_report->sSql);

// Get First Row
if (!$rs->EOF) {
	$Report1->bailleur->setDbValue($rs->fields('bailleur'));
	$Report1_report->vGrps[0] = $Report1->bailleur->DbValue;
}
$Report1_report->lRecCnt = 0;
$Report1_report->nCntRecs[0] = 0;
$Report1_report->ChkLvlBreak();
while (!$rs->EOF) {

	// Render for view
	$Report1->RowType = EW_ROWTYPE_VIEW;
	$Report1_report->RenderRow();

	// Show group headers
	if ($Report1_report->bLvlBreak[1]) { // Reset counter and aggregation
?>
	<tr><td class="ewGroupField"><span class="phpmaker">Bailleur</span></td>
	<td colspan=16 class="ewGroupName"><span class="phpmaker">
<div<?php echo $Report1->bailleur->ViewAttributes() ?>><?php echo $Report1->bailleur->ViewValue ?></div></span></td></tr>
<?php
	}

	// Get detail records
	$Report1_report->sFilter = "";
	if ($Report1_report->sFilter <> "") $Report1_report->sFilter .= " AND ";
	if (is_null($Report1->bailleur->CurrentValue)) {
		$Report1_report->sFilter .= "(`bailleur` IS NULL)";
	} else {
		$Report1_report->sFilter .= "(`bailleur` = '" . ew_AdjustSql($Report1->bailleur->CurrentValue) . "')";
	}
	if ($Report1_report->sDbDetailFilter <> "") {
		if ($Report1_report->sFilter <> "")
			$Report1_report->sFilter .= " AND ";
		$Report1_report->sFilter .= "(" . $Report1_report->sDbDetailFilter . ")";
	}
	if (!$Security->CanReport()) {
		if ($sFilter <> "") $sFilter .= " AND ";
		$sFilter .= "(0=1)";
	}

	// Set up detail SQL
	$Report1->CurrentFilter = $Report1_report->sFilter;
	$Report1_report->sSql = $Report1->DetailSQL();

	// Load detail records
	$rsdtl = $conn->Execute($Report1_report->sSql);
	$Report1_report->nDtlRecs = $rsdtl->RecordCount();

	// Initialize Aggregate
	if (!$rsdtl->EOF) {
		$Report1_report->lRecCnt++;
		$Report1->montantdec->setDbValue($rsdtl->fields('montantdec'));
		$Report1->montantproj->setDbValue($rsdtl->fields('montantproj'));
	}
	if ($Report1_report->lRecCnt == 1) {
		$Report1_report->nCntRecs[0] = 0;
		$Report1_report->nTotals[0][5] = 0;
		$Report1_report->nTotals[0][12] = 0;
	}
	for ($i = 1; $i <= 1; $i++) {
		if ($Report1_report->bLvlBreak[$i]) { // Reset counter and aggregation
			$Report1_report->nCntRecs[$i] = 0;
			$Report1_report->nTotals[$i][5] = 0;
			$Report1_report->nTotals[$i][12] = 0;
		}
	}
	$Report1_report->nCntRecs[0] += $Report1_report->nDtlRecs;
	$Report1_report->nCntRecs[1] += $Report1_report->nDtlRecs;
?>
	<tr>
		<td></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Dpartement</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Commune</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Section</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Titre</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">objectif</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Montant dcaiss</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Organisme Responsable</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Secteur</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Autres secteurs touchs</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Programme</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Statut</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Date de dmarrage</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Montant engag</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Nbrbd</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">Nbrec</span></td>
		<td valign="top" class="ewGroupHeader"><span class="phpmaker">idfbp</span></td>
	</tr>
<?php
	while (!$rsdtl->EOF) {
		$Report1->departement->setDbValue($rsdtl->fields('departement'));
		$Report1->commune->setDbValue($rsdtl->fields('commune'));
		$Report1->section->setDbValue($rsdtl->fields('section'));
		$Report1->titre->setDbValue($rsdtl->fields('titre'));
		$Report1->objectif->setDbValue($rsdtl->fields('objectif'));
		$Report1->montantdec->setDbValue($rsdtl->fields('montantdec'));
		$Report1_report->nTotals[0][5] += $Report1->montantdec->CurrentValue;
		$Report1_report->nTotals[1][5] += $Report1->montantdec->CurrentValue;
		$Report1->entite->setDbValue($rsdtl->fields('entite'));
		$Report1->secteur->setDbValue($rsdtl->fields('secteur'));
		$Report1->ast->setDbValue($rsdtl->fields('ast'));
		$Report1->program->setDbValue($rsdtl->fields('program'));
		$Report1->statut->setDbValue($rsdtl->fields('statut'));
		$Report1->datedebut->setDbValue($rsdtl->fields('datedebut'));
		$Report1->montantproj->setDbValue($rsdtl->fields('montantproj'));
		$Report1_report->nTotals[0][12] += $Report1->montantproj->CurrentValue;
		$Report1_report->nTotals[1][12] += $Report1->montantproj->CurrentValue;
		$Report1->nbrbd->setDbValue($rsdtl->fields('nbrbd'));
		$Report1->nbrec->setDbValue($rsdtl->fields('nbrec'));
		$Report1->idfbp->setDbValue($rsdtl->fields('idfbp'));

		// Render for view
		$Report1->RowType = EW_ROWTYPE_VIEW;
		$Report1_report->RenderRow();
?>
	<tr>
		<td></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->departement->ViewAttributes() ?>><?php echo $Report1->departement->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->commune->ViewAttributes() ?>><?php echo $Report1->commune->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->section->ViewAttributes() ?>><?php echo $Report1->section->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->titre->ViewAttributes() ?>><?php echo $Report1->titre->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->objectif->ViewAttributes() ?>><?php echo $Report1->objectif->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->montantdec->ViewAttributes() ?>><?php echo $Report1->montantdec->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->entite->ViewAttributes() ?>><?php echo $Report1->entite->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->secteur->ViewAttributes() ?>><?php echo $Report1->secteur->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->ast->ViewAttributes() ?>><?php echo $Report1->ast->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->program->ViewAttributes() ?>><?php echo $Report1->program->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->statut->ViewAttributes() ?>><?php echo $Report1->statut->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->datedebut->ViewAttributes() ?>><?php echo $Report1->datedebut->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->montantproj->ViewAttributes() ?>><?php echo $Report1->montantproj->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->nbrbd->ViewAttributes() ?>><?php echo $Report1->nbrbd->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->nbrec->ViewAttributes() ?>><?php echo $Report1->nbrec->ViewValue ?></div></span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->idfbp->ViewAttributes() ?>><?php echo $Report1->idfbp->ViewValue ?></div></span></td>
	</tr>
<?php
		$rsdtl->MoveNext();
	}
	$rsdtl->Close();

	// Save old group data
	$Report1_report->vGrps[0] = $Report1->bailleur->CurrentValue;

	// Get next record
	$rs->MoveNext();
	if ($rs->EOF) {
		$Report1_report->lRecCnt = 0; // EOF, force all level breaks
	} else {
		$Report1->bailleur->setDbValue($rs->fields('bailleur'));
	}
	$Report1_report->ChkLvlBreak();

	// Show Footers
	if ($Report1_report->bLvlBreak[1]) {
		$Report1->bailleur->CurrentValue = $Report1_report->vGrps[0];

		// Render row for view
		$Report1->RowType = EW_ROWTYPE_VIEW;
		$Report1_report->RenderRow();
		$Report1->bailleur->CurrentValue = $Report1->bailleur->DbValue;
?>
	<tr><td colspan=17 class="ewGroupSummary"><span class="phpmaker">Summary for Bailleur: <?php echo $Report1->bailleur->ViewValue ?> (<?php echo ew_FormatNumber($Report1_report->nCntRecs[1],0) ?> Detail Records)</span></td></tr>
<?php
	$Report1->montantdec->CurrentValue = $Report1_report->nTotals[1][5];
	$Report1->montantproj->CurrentValue = $Report1_report->nTotals[1][12];

	// Render row for view
	$Report1->RowType = EW_ROWTYPE_VIEW;
	$Report1_report->RenderRow();
?>
	<tr>
		<td class="ewGroupAggregate"><span class="phpmaker">Sum</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->montantdec->ViewAttributes() ?>><?php echo $Report1->montantdec->ViewValue ?></div></span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->montantproj->ViewAttributes() ?>><?php echo $Report1->montantproj->ViewValue ?></div></span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
	</tr>
	<tr><td colspan=17><span class="phpmaker">&nbsp;<br></span></td></tr>
<?php
}
}

// Close recordset
$rs->Close();
?>
	<tr><td colspan=17><span class="phpmaker">&nbsp;<br></span></td></tr>
	<tr><td colspan=17 class="ewGrandSummary"><span class="phpmaker">Grand Total (<?php echo ew_FormatNumber($Report1_report->nCntRecs[0], 0) ?> Detail Records)</span></td></tr>
<?php
	$Report1->montantdec->CurrentValue = $Report1_report->nTotals[0][5];
	$Report1->montantproj->CurrentValue = $Report1_report->nTotals[0][12];

	// Render row for view
	$Report1->RowType = EW_ROWTYPE_VIEW;
	$Report1_report->RenderRow();
?>
	<tr>
		<td class="ewGroupAggregate"><span class="phpmaker">Sum</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->montantdec->ViewAttributes() ?>><?php echo $Report1->montantdec->ViewValue ?></div></span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">
<div<?php echo $Report1->montantproj->ViewAttributes() ?>><?php echo $Report1->montantproj->ViewValue ?></div></span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
		<td><span class="phpmaker">&nbsp;</span></td>
	</tr>
	<tr><td colspan=17><span class="phpmaker">&nbsp;<br></span></td></tr>
</table>
</form>
<?php if ($Report1->Export == "") { ?>
<script language="JavaScript" type="text/javascript">
<!--

// Write your table-specific startup script here
// document.write("page loaded");
//-->

</script>
<?php } ?>
<?php include "footer_admin.php" ?>
<?php
$Report1_report->Page_Terminate();
?>
<?php

//
// Page Class
//
class cReport1_report {

	// Page ID
	var $PageID = 'report';

	// Table Name
	var $TableName = 'Report1';

	// Page Object Name
	var $PageObjName = 'Report1_report';

	// Page Name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page Url
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show Message
	function ShowMessage() {
		if ($this->getMessage() <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $this->getMessage() . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate Page request
	function IsPageRequest() {
		return TRUE;
	}

	//
	//  Class initialize
	//  - init objects
	//  - open connection
	//
	function cReport1_report() {
		global $conn;

		// Initialize table object
		$GLOBALS["Report1"] = new cReport1();

		// Initialize other table object
		$GLOBALS['usermis'] = new cusermis();

		// Intialize page id (for backward compatibility)
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'report', TRUE);

		// Initialize table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'Report1', TRUE);

		// Open connection to the database
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $Report1;
		global $Security;
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		if (!$Security->CanReport()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();
	$Report1->Export = @$_GET["export"]; // Get export parameter
	$gsExport = $Report1->Export; // Get export parameter, used in header
	$gsExportFile = $Report1->TableVar; // Get export file, used in header
	if ($Report1->Export == "print" || $Report1->Export == "html") {

		// Printer friendly or Export to HTML, no action required
	}
	if ($Report1->Export == "excel") {
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment; filename=' . $gsExportFile .'.xls');
	}
	if ($Report1->Export == "word") {
		header('Content-Type: application/vnd.ms-word');
		header('Content-Disposition: attachment; filename=' . $gsExportFile .'.doc');
	}

		// Global page loading event (in userfn6.php)
		Page_Loading();

		// Page load event, used in current page
		$this->Page_Load();
	}

	//
	//  Page_Terminate
	//  - called when exit page
	//  - if URL specified, redirect to the URL
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page unload event, used in current page
		$this->Page_Unload();

		// Global page unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close Connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			ob_end_clean();
			header("Location: $url");
		}
		exit();
	}
	var $lRecCnt = 0;
	var $sSql = "";
	var $sFilter = "";
	var $sDbMasterFilter = "";
	var $sDbDetailFilter = "";
	var $bMasterRecordExists;
	var $sCmd = "";
	var $lDtlRecs;
	var $vGrps;
	var $nCntRecs;
	var $bLvlBreak;
	var $nTotals;
	var $nMaxs;
	var $nMins;

	//
	// Page main processing
	//
	function Page_Main() {
		global $Report1;
		$this->vGrps = ew_InitArray(2, NULL);
		$this->nCntRecs = ew_InitArray(2, 0);
		$this->bLvlBreak = ew_InitArray(2, FALSE);
		$this->nTotals = ew_Init2DArray(2, 17, 0);
		$this->nMaxs = ew_Init2DArray(2, 17, 0);
		$this->nMins = ew_Init2DArray(2, 17, 0);
	}

	// Check level break
	function ChkLvlBreak() {
		global $Report1;
		$this->bLvlBreak[1] = FALSE;
		if ($this->lRecCnt == 0) { // Start Or End of Recordset
			$this->bLvlBreak[1] = TRUE;
		} else {
			if (!ew_CompareValue($Report1->bailleur->CurrentValue, $this->vGrps[0])) {
				$this->bLvlBreak[1] = TRUE;
			}
		}
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Report1;

		// Common render codes for all row types
		// departement

		$Report1->departement->CellCssStyle = "";
		$Report1->departement->CellCssClass = "";

		// commune
		$Report1->commune->CellCssStyle = "";
		$Report1->commune->CellCssClass = "";

		// section
		$Report1->section->CellCssStyle = "";
		$Report1->section->CellCssClass = "";

		// titre
		$Report1->titre->CellCssStyle = "";
		$Report1->titre->CellCssClass = "";

		// objectif
		$Report1->objectif->CellCssStyle = "";
		$Report1->objectif->CellCssClass = "";

		// montantdec
		$Report1->montantdec->CellCssStyle = "";
		$Report1->montantdec->CellCssClass = "";

		// entite
		$Report1->entite->CellCssStyle = "";
		$Report1->entite->CellCssClass = "";

		// secteur
		$Report1->secteur->CellCssStyle = "";
		$Report1->secteur->CellCssClass = "";

		// ast
		$Report1->ast->CellCssStyle = "";
		$Report1->ast->CellCssClass = "";

		// bailleur
		$Report1->bailleur->CellCssStyle = "";
		$Report1->bailleur->CellCssClass = "";

		// program
		$Report1->program->CellCssStyle = "";
		$Report1->program->CellCssClass = "";

		// statut
		$Report1->statut->CellCssStyle = "";
		$Report1->statut->CellCssClass = "";

		// datedebut
		$Report1->datedebut->CellCssStyle = "";
		$Report1->datedebut->CellCssClass = "";

		// montantproj
		$Report1->montantproj->CellCssStyle = "";
		$Report1->montantproj->CellCssClass = "";

		// nbrbd
		$Report1->nbrbd->CellCssStyle = "";
		$Report1->nbrbd->CellCssClass = "";

		// nbrec
		$Report1->nbrec->CellCssStyle = "";
		$Report1->nbrec->CellCssClass = "";

		// idfbp
		$Report1->idfbp->CellCssStyle = "";
		$Report1->idfbp->CellCssClass = "";
		if ($Report1->RowType == EW_ROWTYPE_VIEW) { // View row

			// departement
			if (strval($Report1->departement->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `departemen` FROM `departement` WHERE `ID_Dep` = " . ew_AdjustSql($Report1->departement->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->departement->ViewValue = $rswrk->fields('departemen');
					$rswrk->Close();
				} else {
					$Report1->departement->ViewValue = $Report1->departement->CurrentValue;
				}
			} else {
				$Report1->departement->ViewValue = NULL;
			}
			$Report1->departement->CssStyle = "";
			$Report1->departement->CssClass = "";
			$Report1->departement->ViewCustomAttributes = "";

			// commune
			if (strval($Report1->commune->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `Commune` FROM `commune` WHERE `Id_com` = " . ew_AdjustSql($Report1->commune->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->commune->ViewValue = $rswrk->fields('Commune');
					$rswrk->Close();
				} else {
					$Report1->commune->ViewValue = $Report1->commune->CurrentValue;
				}
			} else {
				$Report1->commune->ViewValue = NULL;
			}
			$Report1->commune->CssStyle = "";
			$Report1->commune->CssClass = "";
			$Report1->commune->ViewCustomAttributes = "";

			// section
			if (strval($Report1->section->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `vqs` FROM `section` WHERE `id_section` = " . ew_AdjustSql($Report1->section->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->section->ViewValue = $rswrk->fields('vqs');
					$rswrk->Close();
				} else {
					$Report1->section->ViewValue = $Report1->section->CurrentValue;
				}
			} else {
				$Report1->section->ViewValue = NULL;
			}
			$Report1->section->CssStyle = "";
			$Report1->section->CssClass = "";
			$Report1->section->ViewCustomAttributes = "";

			// titre
			$Report1->titre->ViewValue = $Report1->titre->CurrentValue;
			$Report1->titre->CssStyle = "";
			$Report1->titre->CssClass = "";
			$Report1->titre->ViewCustomAttributes = "";

			// objectif
			$Report1->objectif->ViewValue = $Report1->objectif->CurrentValue;
			$Report1->objectif->CssStyle = "";
			$Report1->objectif->CssClass = "";
			$Report1->objectif->ViewCustomAttributes = "";

			// montantdec
			$Report1->montantdec->ViewValue = $Report1->montantdec->CurrentValue;
			$Report1->montantdec->ViewValue = ew_FormatCurrency($Report1->montantdec->ViewValue, 2, -2, -2, -2);
			$Report1->montantdec->CssStyle = "text-align:left;";
			$Report1->montantdec->CssClass = "";
			$Report1->montantdec->ViewCustomAttributes = "";

			// entite
			if (strval($Report1->entite->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `nomentite` FROM `entites` WHERE `identite` = " . ew_AdjustSql($Report1->entite->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->entite->ViewValue = $rswrk->fields('nomentite');
					$rswrk->Close();
				} else {
					$Report1->entite->ViewValue = $Report1->entite->CurrentValue;
				}
			} else {
				$Report1->entite->ViewValue = NULL;
			}
			$Report1->entite->CssStyle = "";
			$Report1->entite->CssClass = "";
			$Report1->entite->ViewCustomAttributes = "";

			// secteur
			if (strval($Report1->secteur->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `nomsecteur` FROM `secteurs` WHERE `idsecteur` = " . ew_AdjustSql($Report1->secteur->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->secteur->ViewValue = $rswrk->fields('nomsecteur');
					$rswrk->Close();
				} else {
					$Report1->secteur->ViewValue = $Report1->secteur->CurrentValue;
				}
			} else {
				$Report1->secteur->ViewValue = NULL;
			}
			$Report1->secteur->CssStyle = "";
			$Report1->secteur->CssClass = "";
			$Report1->secteur->ViewCustomAttributes = "";

			// ast
			if (strval($Report1->ast->CurrentValue) <> "") {
				$arwrk = explode(",", $Report1->ast->CurrentValue);
				$sSqlWrk = "SELECT `nomsecteur` FROM `secteurs` WHERE ";
				$sWhereWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
					$sWhereWrk .= "`idsecteur` = " . ew_AdjustSql(trim($wrk)) . "";
				}
				if ($sWhereWrk <> "") $sSqlWrk .= "(" . $sWhereWrk . ")";
				$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->ast->ViewValue = "";
					$ari = 0;
					while (!$rswrk->EOF) {
						$Report1->ast->ViewValue .= $rswrk->fields('nomsecteur');
						$rswrk->MoveNext();
						if (!$rswrk->EOF) $Report1->ast->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
						$ari++;
					}
					$rswrk->Close();
				} else {
					$Report1->ast->ViewValue = $Report1->ast->CurrentValue;
				}
			} else {
				$Report1->ast->ViewValue = NULL;
			}
			$Report1->ast->CssStyle = "";
			$Report1->ast->CssClass = "";
			$Report1->ast->ViewCustomAttributes = "";

			// bailleur
			if (strval($Report1->bailleur->CurrentValue) <> "") {
				$arwrk = explode(",", $Report1->bailleur->CurrentValue);
				$sSqlWrk = "SELECT `nombailleur` FROM `bailleurs` WHERE ";
				$sWhereWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
					$sWhereWrk .= "`idbailleur` = " . ew_AdjustSql(trim($wrk)) . "";
				}
				if ($sWhereWrk <> "") $sSqlWrk .= "(" . $sWhereWrk . ")";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->bailleur->ViewValue = "";
					$ari = 0;
					while (!$rswrk->EOF) {
						$Report1->bailleur->ViewValue .= $rswrk->fields('nombailleur');
						$rswrk->MoveNext();
						if (!$rswrk->EOF) $Report1->bailleur->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
						$ari++;
					}
					$rswrk->Close();
				} else {
					$Report1->bailleur->ViewValue = $Report1->bailleur->CurrentValue;
				}
			} else {
				$Report1->bailleur->ViewValue = NULL;
			}
			$Report1->bailleur->CssStyle = "";
			$Report1->bailleur->CssClass = "";
			$Report1->bailleur->ViewCustomAttributes = "";

			// program
			if (strval($Report1->program->CurrentValue) <> "") {
				$arwrk = explode(",", $Report1->program->CurrentValue);
				$sSqlWrk = "SELECT `sigleprog`, `nomprog` FROM `programme` WHERE ";
				$sWhereWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
					$sWhereWrk .= "`idprog` = " . ew_AdjustSql(trim($wrk)) . "";
				}
				if ($sWhereWrk <> "") $sSqlWrk .= "(" . $sWhereWrk . ")";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->program->ViewValue = "";
					$ari = 0;
					while (!$rswrk->EOF) {
						$Report1->program->ViewValue .= $rswrk->fields('sigleprog');
						$Report1->program->ViewValue .= ew_ValueSeparator($ari) . $rswrk->fields('nomprog');
						$rswrk->MoveNext();
						if (!$rswrk->EOF) $Report1->program->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
						$ari++;
					}
					$rswrk->Close();
				} else {
					$Report1->program->ViewValue = $Report1->program->CurrentValue;
				}
			} else {
				$Report1->program->ViewValue = NULL;
			}
			$Report1->program->CssStyle = "";
			$Report1->program->CssClass = "";
			$Report1->program->ViewCustomAttributes = "";

			// statut
			if (strval($Report1->statut->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `NomStatut` FROM `statut` WHERE `StatutID` = " . ew_AdjustSql($Report1->statut->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$Report1->statut->ViewValue = $rswrk->fields('NomStatut');
					$rswrk->Close();
				} else {
					$Report1->statut->ViewValue = $Report1->statut->CurrentValue;
				}
			} else {
				$Report1->statut->ViewValue = NULL;
			}
			$Report1->statut->CssStyle = "";
			$Report1->statut->CssClass = "";
			$Report1->statut->ViewCustomAttributes = "";

			// datedebut
			$Report1->datedebut->ViewValue = $Report1->datedebut->CurrentValue;
			$Report1->datedebut->ViewValue = ew_FormatDateTime($Report1->datedebut->ViewValue, 7);
			$Report1->datedebut->CssStyle = "";
			$Report1->datedebut->CssClass = "";
			$Report1->datedebut->ViewCustomAttributes = "";

			// montantproj
			$Report1->montantproj->ViewValue = $Report1->montantproj->CurrentValue;
			$Report1->montantproj->CssStyle = "";
			$Report1->montantproj->CssClass = "";
			$Report1->montantproj->ViewCustomAttributes = "";

			// nbrbd
			$Report1->nbrbd->ViewValue = $Report1->nbrbd->CurrentValue;
			$Report1->nbrbd->CssStyle = "";
			$Report1->nbrbd->CssClass = "";
			$Report1->nbrbd->ViewCustomAttributes = "";

			// nbrec
			$Report1->nbrec->ViewValue = $Report1->nbrec->CurrentValue;
			$Report1->nbrec->CssStyle = "";
			$Report1->nbrec->CssClass = "";
			$Report1->nbrec->ViewCustomAttributes = "";

			// idfbp
			$Report1->idfbp->ViewValue = $Report1->idfbp->CurrentValue;
			$Report1->idfbp->CssStyle = "";
			$Report1->idfbp->CssClass = "";
			$Report1->idfbp->ViewCustomAttributes = "";

			// departement
			$Report1->departement->HrefValue = "";

			// commune
			$Report1->commune->HrefValue = "";

			// section
			$Report1->section->HrefValue = "";

			// titre
			$Report1->titre->HrefValue = "";

			// objectif
			$Report1->objectif->HrefValue = "";

			// montantdec
			$Report1->montantdec->HrefValue = "";

			// entite
			$Report1->entite->HrefValue = "";

			// secteur
			$Report1->secteur->HrefValue = "";

			// ast
			$Report1->ast->HrefValue = "";

			// bailleur
			$Report1->bailleur->HrefValue = "";

			// program
			$Report1->program->HrefValue = "";

			// statut
			$Report1->statut->HrefValue = "";

			// datedebut
			$Report1->datedebut->HrefValue = "";

			// montantproj
			$Report1->montantproj->HrefValue = "";

			// nbrbd
			$Report1->nbrbd->HrefValue = "";

			// nbrec
			$Report1->nbrec->HrefValue = "";

			// idfbp
			$Report1->idfbp->HrefValue = "";
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}
}
?>
