<?php
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "departementinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Define page object
$departement_delete = new cdepartement_delete();
$Page =& $departement_delete;

// Page init processing
$departement_delete->Page_Init();

// Page main processing
$departement_delete->Page_Main();
?>
<?php include "header_admin.php" ?>
<script type="text/javascript">
<!--

// Create page object
var departement_delete = new ew_Page("departement_delete");

// page properties
departement_delete.PageID = "delete"; // page ID
var EW_PAGE_ID = departement_delete.PageID; // for backward compatibility

// extend page with Form_CustomValidate function
departement_delete.Form_CustomValidate =  
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
<?php if (EW_CLIENT_VALIDATE) { ?>
departement_delete.ValidateRequired = true; // uses JavaScript validation
<?php } else { ?>
departement_delete.ValidateRequired = false; // no JavaScript validation
<?php } ?>

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your client script here, no need to add script tags.
// To include another .js script, use:
// ew_ClientScriptInclude("my_javascript.js"); 
//-->

</script>
<?php

// Load records for display
$rs = $departement_delete->LoadRecordset();
$departement_deletelTotalRecs = $rs->RecordCount(); // Get record count
if ($departement_deletelTotalRecs <= 0) { // No record found, exit
	$rs->Close();
	$departement_delete->Page_Terminate("departementlist_admin.php"); // Return to list
}
?>
<p><span class="phpmaker">Delete From TABLE: Dpartement<br><br>
<a href="<?php echo $departement->getReturnUrl() ?>">Go Back</a></span></p>
<?php $departement_delete->ShowMessage() ?>
<form action="<?php echo ew_CurrentPage() ?>" method="post">
<p>
<input type="hidden" name="t" id="t" value="departement">
<input type="hidden" name="a_delete" id="a_delete" value="D">
<?php foreach ($departement_delete->arRecKeys as $key) { ?>
<input type="hidden" name="key_m[]" id="key_m[]" value="<?php echo ew_HtmlEncode($key) ?>">
<?php } ?>
<table class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable ewTableSeparate">
<?php echo $departement->TableCustomInnerHtml ?>
	<thead>
	<tr class="ewTableHeader">
		<td valign="top">Dpartement</td>
	</tr>
	</thead>
	<tbody>
<?php
$departement_delete->lRecCnt = 0;
$i = 0;
while (!$rs->EOF) {
	$departement_delete->lRecCnt++;

	// Set row properties
	$departement->CssClass = "";
	$departement->CssStyle = "";
	$departement->RowType = EW_ROWTYPE_VIEW; // View

	// Get the field contents
	$departement_delete->LoadRowValues($rs);

	// Render row
	$departement_delete->RenderRow();
?>
	<tr<?php echo $departement->RowAttributes() ?>>
		<td<?php echo $departement->departemen->CellAttributes() ?>>
<div<?php echo $departement->departemen->ViewAttributes() ?>><?php echo $departement->departemen->ListViewValue() ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
$rs->Close();
?>
</tbody>
</table>
</div>
</td></tr></table>
<p>
<input type="submit" name="Action" id="Action" value="Confirm Delete">
</form>
<script language="JavaScript" type="text/javascript">
<!--

// Write your table-specific startup script here
// document.write("page loaded");
//-->

</script>
<?php include "footer_admin.php" ?>
<?php
$departement_delete->Page_Terminate();
?>
<?php

//
// Page Class
//
class cdepartement_delete {

	// Page ID
	var $PageID = 'delete';

	// Table Name
	var $TableName = 'departement';

	// Page Object Name
	var $PageObjName = 'departement_delete';

	// Page Name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page Url
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		global $departement;
		if ($departement->UseTokenInUrl) $PageUrl .= "t=" . $departement->TableVar . "&"; // add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show Message
	function ShowMessage() {
		if ($this->getMessage() <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $this->getMessage() . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate Page request
	function IsPageRequest() {
		global $objForm, $departement;
		if ($departement->UseTokenInUrl) {

			//IsPageRequest = False
			if ($objForm)
				return ($departement->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($departement->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	//  Class initialize
	//  - init objects
	//  - open connection
	//
	function cdepartement_delete() {
		global $conn;

		// Initialize table object
		$GLOBALS["departement"] = new cdepartement();

		// Initialize other table object
		$GLOBALS['usermis'] = new cusermis();

		// Intialize page id (for backward compatibility)
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'delete', TRUE);

		// Initialize table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'departement', TRUE);

		// Open connection to the database
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $departement;
		global $Security;
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		if (!$Security->CanDelete()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("departementlist_admin.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();

		// Global page loading event (in userfn6.php)
		Page_Loading();

		// Page load event, used in current page
		$this->Page_Load();
	}

	//
	//  Page_Terminate
	//  - called when exit page
	//  - if URL specified, redirect to the URL
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page unload event, used in current page
		$this->Page_Unload();

		// Global page unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close Connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			ob_end_clean();
			header("Location: $url");
		}
		exit();
	}
	var $lTotalRecs;
	var $lRecCnt;
	var $arRecKeys = array();

	// Page main processing
	function Page_Main() {
		global $departement;

		// Load Key Parameters
		$sKey = "";
		$bSingleDelete = TRUE; // Initialize as single delete
		$nKeySelected = 0; // Initialize selected key count
		$sFilter = "";
		if (@$_GET["ID_Dep"] <> "") {
			$departement->ID_Dep->setQueryStringValue($_GET["ID_Dep"]);
			if (!is_numeric($departement->ID_Dep->QueryStringValue))
				$this->Page_Terminate("departementlist_admin.php"); // Prevent SQL injection, exit
			$sKey .= $departement->ID_Dep->QueryStringValue;
		} else {
			$bSingleDelete = FALSE;
		}
		if ($bSingleDelete) {
			$nKeySelected = 1; // Set up key selected count
			$this->arRecKeys[0] = $sKey;
		} else {
			if (isset($_POST["key_m"])) { // Key in form
				$nKeySelected = count($_POST["key_m"]); // Set up key selected count
				$this->arRecKeys = ew_StripSlashes($_POST["key_m"]);
			}
		}
		if ($nKeySelected <= 0)
			$this->Page_Terminate("departementlist_admin.php"); // No key specified, return to list

		// Build filter
		foreach ($this->arRecKeys as $sKey) {
			$sFilter .= "(";

			// Set up key field
			$sKeyFld = $sKey;
			if (!is_numeric($sKeyFld))
				$this->Page_Terminate("departementlist_admin.php"); // Prevent SQL injection, return to list
			$sFilter .= "`ID_Dep`=" . ew_AdjustSql($sKeyFld) . " AND ";
			if (substr($sFilter, -5) == " AND ") $sFilter = substr($sFilter, 0, strlen($sFilter)-5) . ") OR ";
		}
		if (substr($sFilter, -4) == " OR ") $sFilter = substr($sFilter, 0, strlen($sFilter)-4);

		// Set up filter (SQL WhHERE clause) and get return SQL
		// SQL constructor in SQL constructor in departement class, departementinfo.php

		$departement->CurrentFilter = $sFilter;

		// Get action
		if (@$_POST["a_delete"] <> "") {
			$departement->CurrentAction = $_POST["a_delete"];
		} else {
			$departement->CurrentAction = "I"; // Display record
		}
		switch ($departement->CurrentAction) {
			case "D": // Delete
				$departement->SendEmail = TRUE; // Send email on delete success
				if ($this->DeleteRows()) { // delete rows
					$this->setMessage("Delete succeeded"); // Set up success message
					$this->Page_Terminate($departement->getReturnUrl()); // Return to caller
				}
		}
	}

	//
	//  Function DeleteRows
	//  - Delete Records based on current filter
	//
	function DeleteRows() {
		global $conn, $Security, $departement;
		$DeleteRows = TRUE;
		$sWrkFilter = $departement->CurrentFilter;

		// Set up filter (Sql Where Clause) and get Return SQL
		// SQL constructor in departement class, departementinfo.php

		$departement->CurrentFilter = $sWrkFilter;
		$sSql = $departement->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setMessage("No records found"); // No record found
			$rs->Close();
			return FALSE;
		}
		$conn->BeginTrans();

		// Clone old rows
		$rsold = ($rs) ? $rs->GetRows() : array();
		if ($rs) $rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $departement->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= EW_COMPOSITE_KEY_SEPARATOR;
				$sThisKey .= $row['ID_Dep'];
				$conn->raiseErrorFn = 'ew_ErrorFn';
				$DeleteRows = $conn->Execute($departement->DeleteSQL($row)); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		} else {

			// Set up error message
			if ($departement->CancelMessage <> "") {
				$this->setMessage($departement->CancelMessage);
				$departement->CancelMessage = "";
			} else {
				$this->setMessage("Delete cancelled");
			}
		}
		if ($DeleteRows) {
			$conn->CommitTrans(); // Commit the changes
		} else {
			$conn->RollbackTrans(); // Rollback changes
		}

		// Call recordset deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$departement->Row_Deleted($row);
			}	
		}
		return $DeleteRows;
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn, $departement;

		// Call Recordset Selecting event
		$departement->Recordset_Selecting($departement->CurrentFilter);

		// Load list page SQL
		$sSql = $departement->SelectSQL();
		if ($offset > -1 && $rowcnt > -1) $sSql .= " LIMIT $offset, $rowcnt";

		// Load recordset
		$conn->raiseErrorFn = 'ew_ErrorFn';	
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';

		// Call Recordset Selected event
		$departement->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $departement;
		$sFilter = $departement->KeyFilter();

		// Call Row Selecting event
		$departement->Row_Selecting($sFilter);

		// Load sql based on filter
		$departement->CurrentFilter = $sFilter;
		$sSql = $departement->SQL();
		if ($rs = $conn->Execute($sSql)) {
			if ($rs->EOF) {
				$LoadRow = FALSE;
			} else {
				$LoadRow = TRUE;
				$rs->MoveFirst();
				$this->LoadRowValues($rs); // Load row values

				// Call Row Selected event
				$departement->Row_Selected($rs);
			}
			$rs->Close();
		} else {
			$LoadRow = FALSE;
		}
		return $LoadRow;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $departement;
		$departement->ID_Dep->setDbValue($rs->fields('ID_Dep'));
		$departement->departemen->setDbValue($rs->fields('departemen'));
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $departement;

		// Call Row_Rendering event
		$departement->Row_Rendering();

		// Common render codes for all row types
		// departemen

		$departement->departemen->CellCssStyle = "";
		$departement->departemen->CellCssClass = "";
		if ($departement->RowType == EW_ROWTYPE_VIEW) { // View row

			// departemen
			$departement->departemen->ViewValue = $departement->departemen->CurrentValue;
			$departement->departemen->CssStyle = "";
			$departement->departemen->CssClass = "";
			$departement->departemen->ViewCustomAttributes = "";

			// departemen
			$departement->departemen->HrefValue = "";
		}

		// Call Row Rendered event
		$departement->Row_Rendered();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}
}
?>
