<?php
session_start();
ob_start();
?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php include "phprptinc/ewrcfg3report.php"; ?>
<?php include "phprptinc/ewmysqlreport.php"; ?>
<?php include "phprptinc/ewrfn3report.php"; ?>
<?php

// Get page start time
$starttime = ewrpt_microtime();

// Open connection to the database
$conn = ewrpt_Connect();

// Table level constants
define("EW_REPORT_TABLE_VAR", "lesproj3", TRUE);
define("EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE", "lesproj3_grpperpage", TRUE);
define("EW_REPORT_TABLE_SESSION_START_GROUP", "lesproj3_start", TRUE);
define("EW_REPORT_TABLE_SESSION_SEARCH", "lesproj3_search", TRUE);
define("EW_REPORT_TABLE_SESSION_CHILD_USER_ID", "lesproj3_childuserid", TRUE);
define("EW_REPORT_TABLE_SESSION_ORDER_BY", "lesproj3_orderby", TRUE);

// Table level SQL
$EW_REPORT_TABLE_SQL_FROM = "projets Inner Join departement On (projets.departement = departement.ID_Dep) Inner Join secteurs On (projets.secteur = secteurs.idsecteur) Right Outer Join statut On (projets.statut = statut.StatutID)";
$EW_REPORT_TABLE_SQL_SELECT = "SELECT departement.departemen, projets.montantproj, projets.montantdec, projets.titre, Count(projets.idprojet) As nb, projets.objectif, projets.bailleur, projets.entite, projets.secteur, projets.program, projets.departement, projets.commune, projets.section, projets.datedebut, projets.nbrbd, projets.nbrec, projets.datemaj, projets.statut, projets.ast, projets.userID, statut.NomStatut, secteurs.nomsecteur FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_TABLE_SQL_WHERE = "";
$EW_REPORT_TABLE_SQL_GROUPBY = "departement.departemen, projets.montantproj, projets.montantdec, projets.titre, projets.objectif, projets.bailleur, projets.entite, projets.secteur, projets.program, projets.departement, projets.commune, projets.section, projets.datedebut, projets.nbrbd, projets.nbrec, projets.datemaj, projets.statut, projets.ast, projets.userID, statut.NomStatut, secteurs.nomsecteur";
$EW_REPORT_TABLE_SQL_HAVING = "";
$EW_REPORT_TABLE_SQL_ORDERBY = "";
$EW_REPORT_TABLE_SQL_USERID_FILTER = "";
$af_departemen = NULL; // Popup filter for departemen
$af_montantproj = NULL; // Popup filter for montantproj
$af_montantdec = NULL; // Popup filter for montantdec
$af_titre = NULL; // Popup filter for titre
$af_objectif = NULL; // Popup filter for objectif
$af_bailleur = NULL; // Popup filter for bailleur
$af_entite = NULL; // Popup filter for entite
$af_secteur = NULL; // Popup filter for secteur
$af_program = NULL; // Popup filter for program
$af_departement = NULL; // Popup filter for departement
$af_commune = NULL; // Popup filter for commune
$af_section = NULL; // Popup filter for section
$af_datedebut = NULL; // Popup filter for datedebut
$af_nbrbd = NULL; // Popup filter for nbrbd
$af_nbrec = NULL; // Popup filter for nbrec
$af_datemaj = NULL; // Popup filter for datemaj
$af_statut = NULL; // Popup filter for statut
$af_ast = NULL; // Popup filter for ast
$af_userID = NULL; // Popup filter for userID
$af_NomStatut = NULL; // Popup filter for NomStatut
$af_nomsecteur = NULL; // Popup filter for nomsecteur
$af_nb = NULL; // Popup filter for nb
?>
<?php
if (!IsLoggedIn()) AutoLogin(); // Auto login
LoadUserLevel();
$ewCurSec = CurrentUserLevelPriv('lesproj3');
if (($ewCurSec & EW_ALLOW_LIST) <> EW_ALLOW_LIST) {
	SaveLastUrl();
	ob_end_clean();
	header("Location: login_admin.php");
	exit();
}
?>
<?php
$sExport = @$_GET["export"]; // Load export request
if ($sExport == "html") {

	// Printer friendly
}
if ($sExport == "excel") {
	header('Content-Type: application/vnd.ms-excel');
	header('Content-Disposition: attachment; filename=' . EW_REPORT_TABLE_VAR .'.xls');
}
if ($sExport == "word") {
	header('Content-Type: application/vnd.ms-word');
	header('Content-Disposition: attachment; filename=' . EW_REPORT_TABLE_VAR .'.doc');
}
?>
<?php

// Initialize common variables
// Paging variables

$nRecCount = 0; // Record count
$nStartGrp = 0; // Start group
$nStopGrp = 0; // Stop group
$nTotalGrps = 0; // Total groups
$nGrpCount = 0; // Group count
$nDisplayGrps = 3; // Groups per page
$nGrpRange = 10;

// Clear field for ext filter
$sClearExtFilter = "";

// Non-Text Extended Filters
// Text Extended Filters
// Field entite

$sv1_entite = ""; $sv1d_entite = "";
$sv2_entite = ""; $sv2d_entite = "";
$so1_entite = ""; $so1d_entite = "";
$so2_entite = ""; $so2d_entite = "";
$sc_entite = ""; $scd_entite = "";

// Custom filters
$ewrpt_CustomFilters = array();
?>
<?php
?>
<?php

// Field variables
$x_departemen = NULL;
$x_montantproj = NULL;
$x_montantdec = NULL;
$x_titre = NULL;
$x_objectif = NULL;
$x_bailleur = NULL;
$x_entite = NULL;
$x_secteur = NULL;
$x_program = NULL;
$x_departement = NULL;
$x_commune = NULL;
$x_section = NULL;
$x_datedebut = NULL;
$x_nbrbd = NULL;
$x_nbrec = NULL;
$x_datemaj = NULL;
$x_statut = NULL;
$x_ast = NULL;
$x_userID = NULL;
$x_NomStatut = NULL;
$x_nomsecteur = NULL;
$x_nb = NULL;

// Detail variables
$o_departemen = NULL; $t_departemen = NULL; $ft_departemen = 200; $rf_departemen = NULL; $rt_departemen = NULL;
$o_montantproj = NULL; $t_montantproj = NULL; $ft_montantproj = 5; $rf_montantproj = NULL; $rt_montantproj = NULL;
$o_montantdec = NULL; $t_montantdec = NULL; $ft_montantdec = 5; $rf_montantdec = NULL; $rt_montantdec = NULL;
$o_titre = NULL; $t_titre = NULL; $ft_titre = 200; $rf_titre = NULL; $rt_titre = NULL;
$o_objectif = NULL; $t_objectif = NULL; $ft_objectif = 201; $rf_objectif = NULL; $rt_objectif = NULL;
$o_bailleur = NULL; $t_bailleur = NULL; $ft_bailleur = 200; $rf_bailleur = NULL; $rt_bailleur = NULL;
$o_entite = NULL; $t_entite = NULL; $ft_entite = 3; $rf_entite = NULL; $rt_entite = NULL;
$o_secteur = NULL; $t_secteur = NULL; $ft_secteur = 3; $rf_secteur = NULL; $rt_secteur = NULL;
$o_program = NULL; $t_program = NULL; $ft_program = 200; $rf_program = NULL; $rt_program = NULL;
$o_departement = NULL; $t_departement = NULL; $ft_departement = 3; $rf_departement = NULL; $rt_departement = NULL;
$o_commune = NULL; $t_commune = NULL; $ft_commune = 3; $rf_commune = NULL; $rt_commune = NULL;
$o_section = NULL; $t_section = NULL; $ft_section = 3; $rf_section = NULL; $rt_section = NULL;
$o_datedebut = NULL; $t_datedebut = NULL; $ft_datedebut = 133; $rf_datedebut = NULL; $rt_datedebut = NULL;
$o_nbrbd = NULL; $t_nbrbd = NULL; $ft_nbrbd = 200; $rf_nbrbd = NULL; $rt_nbrbd = NULL;
$o_nbrec = NULL; $t_nbrec = NULL; $ft_nbrec = 200; $rf_nbrec = NULL; $rt_nbrec = NULL;
$o_datemaj = NULL; $t_datemaj = NULL; $ft_datemaj = 133; $rf_datemaj = NULL; $rt_datemaj = NULL;
$o_statut = NULL; $t_statut = NULL; $ft_statut = 3; $rf_statut = NULL; $rt_statut = NULL;
$o_ast = NULL; $t_ast = NULL; $ft_ast = 200; $rf_ast = NULL; $rt_ast = NULL;
$o_userID = NULL; $t_userID = NULL; $ft_userID = 3; $rf_userID = NULL; $rt_userID = NULL;
$o_NomStatut = NULL; $t_NomStatut = NULL; $ft_NomStatut = 200; $rf_NomStatut = NULL; $rt_NomStatut = NULL;
$o_nomsecteur = NULL; $t_nomsecteur = NULL; $ft_nomsecteur = 200; $rf_nomsecteur = NULL; $rt_nomsecteur = NULL;
$o_nb = NULL; $t_nb = NULL; $ft_nb = 20; $rf_nb = NULL; $rt_nb = NULL;
?>
<?php

// Chart level SQL
$EW_REPORT_CHART_CHART1_SQL_SELECT = "SELECT statut.NomStatut, '', SUM(projets.montantproj) FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_CHART_CHART1_SQL_GROUPBY = "statut.NomStatut";
$EW_REPORT_CHART_CHART1_SQL_ORDERBY = "statut.NomStatut ASC";
$EW_REPORT_CHART_CHART1_DATE_TYPE = "";

// Chart configuration parameters
$Chart1_cht_parms = array(); // Store all chart parameters

// Chart data
$Chart1_cht_index = NULL;
$Chart1_cht_id = NULL;
$Chart1_cht_smry = NULL;
$Chart1_cht_series = NULL; // Series field
$Chart1_cht_XFld = NULL;
$Chart1_cht_YFld = NULL;
$Chart1_cht_YFldBase = NULL;
$Chart1_cht_XFld = 'NomStatut';
$Chart1_cht_YFld = 'montantproj';
$Chart1_cht_XDateFld = '';
$Chart1_cht_SFld = '';
$Chart1_cht_SFldAr = NULL;
?>
<?php
$Chart1_cht_trends = array(); // Store all chart trendlines
?>
<?php

// Chart level SQL
$EW_REPORT_CHART_CHART2_SQL_SELECT = "SELECT statut.NomStatut, '', Count(projets.idprojet) FROM " . $EW_REPORT_TABLE_SQL_FROM;
$EW_REPORT_CHART_CHART2_SQL_GROUPBY = "statut.NomStatut";
$EW_REPORT_CHART_CHART2_SQL_ORDERBY = "statut.NomStatut ASC";
$EW_REPORT_CHART_CHART2_DATE_TYPE = "";

// Chart configuration parameters
$Chart2_cht_parms = array(); // Store all chart parameters

// Chart data
$Chart2_cht_index = NULL;
$Chart2_cht_id = NULL;
$Chart2_cht_smry = NULL;
$Chart2_cht_series = NULL; // Series field
$Chart2_cht_XFld = NULL;
$Chart2_cht_YFld = NULL;
$Chart2_cht_YFldBase = NULL;
$Chart2_cht_XFld = 'NomStatut';
$Chart2_cht_YFld = 'nb';
$Chart2_cht_XDateFld = '';
$Chart2_cht_SFld = '';
$Chart2_cht_SFldAr = NULL;
?>
<?php
$Chart2_cht_trends = array(); // Store all chart trendlines
?>
<?php

// Filter
$sFilter = "";

// Aggregate variables
// 1st dimension = no of groups (level 0 used for grand total)
// 2nd dimension = no of fields

$nDtls = 23;
$nGrps = 1;
$val = ewrpt_InitArray($nDtls, 0);
$cnt = ewrpt_Init2DArray($nGrps, $nDtls, 0);
$smry = ewrpt_Init2DArray($nGrps, $nDtls, 0);
$mn = ewrpt_Init2DArray($nGrps, $nDtls, NULL);
$mx = ewrpt_Init2DArray($nGrps, $nDtls, NULL);
$grandsmry = ewrpt_InitArray($nDtls, 0);
$grandmn = ewrpt_InitArray($nDtls, NULL);
$grandmx = ewrpt_InitArray($nDtls, NULL);

// Set up if accumulation required
$col = array(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE);

// Set up groups per page dynamically
SetUpDisplayGrps();

// Load default filter values
LoadDefaultFilters();

// Set up popup filter
SetupPopup();

// Extended filter
$sExtendedFilter = "";

// Get dropdown values
GetExtendedFilterValues();

// Set up custom filters
SetupCustomFilters();

// Build extended filter
$sExtendedFilter = GetExtendedFilter();
if ($sExtendedFilter <> "") {
	if ($sFilter <> "")
  		$sFilter = "($sFilter) AND ($sExtendedFilter)";
	else
		$sFilter = $sExtendedFilter;
}

// Build popup filter
$sPopupFilter = GetPopupFilter();

//echo "popup filter: " . $sPopupFilter . "<br>";
if ($sPopupFilter <> "") {
	if ($sFilter <> "")
		$sFilter = "($sFilter) AND ($sPopupFilter)";
	else
		$sFilter = $sPopupFilter;
}

// Check if filter applied
$bFilterApplied = CheckFilter();

// Get sort
$sSort = getSort();

// Get total count
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_TABLE_SQL_SELECT, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_TABLE_SQL_GROUPBY, $EW_REPORT_TABLE_SQL_HAVING, $EW_REPORT_TABLE_SQL_ORDERBY, "", $sFilter, @$sSort);
$nTotalGrps = GetCnt($sSql);
if ($nDisplayGrps <= 0) // Display all groups
	$nDisplayGrps = $nTotalGrps;
$nStartGrp = 1;

// Show header
$bShowFirstHeader = ($nTotalGrps > 0);

//$bShowFirstHeader = TRUE; // Uncomment to always show header
// Set up start position if not export all

if (EW_REPORT_EXPORT_ALL && @$sExport <> "")
    $nDisplayGrps = $nTotalGrps;
else
    SetUpStartGroup(); 

// Get current page records
$rs = GetRs($sSql, $nStartGrp, $nDisplayGrps);
?>
<?php if (@$sExport == "") { ?>
<?php include "header_admin.php"; ?>
<?php } ?>
<?php include "phprptinc/headerreport.php"; ?>
<?php if (@$sExport == "") { ?>
<script type="text/javascript">
var EW_REPORT_DATE_SEPARATOR = "/";
if (EW_REPORT_DATE_SEPARATOR == "") EW_REPORT_DATE_SEPARATOR = "/"; // Default date separator
</script>
<script type="text/javascript" src="phprptjs/ewrpt.js"></script>
<script type="text/javascript">

function ewrpt_ValidateExtFilter(form_obj) {
var elm = form_obj.sv1_entite;
if (elm && !ewrpt_CheckInteger(elm.value)) {
	if (!ewrpt_OnError(elm, "Incorrect integer - entite"))
		return false;
}
	return true;
}
</script>
<?php } ?>
<?php if (@$sExport == "") { ?>
<script src="phprptjs/popup.js" type="text/javascript"></script>
<script src="phprptjs/ewrptpop.js" type="text/javascript"></script>
<script src="FusionChartsFree/JSClass/FusionCharts.js" type="text/javascript"></script>
<script type="text/javascript">
var EW_REPORT_POPUP_ALL = "(All)";
var EW_REPORT_POPUP_OK = "  OK  ";
var EW_REPORT_POPUP_CANCEL = "Cancel";
var EW_REPORT_POPUP_FROM = "From";
var EW_REPORT_POPUP_TO = "To";
var EW_REPORT_POPUP_PLEASE_SELECT = "Please Select";
var EW_REPORT_POPUP_NO_VALUE = "No value selected!";

// popup fields
</script>
<?php } ?>
<?php if (@$sExport == "") { ?>
<!-- Table Container (Begin) -->
<table id="ewContainer" cellspacing="0" cellpadding="0" border="0">
<!-- Top Container (Begin) -->
<tr><td colspan="3"><div id="ewTop" class="phpreportmaker">
<!-- top slot -->
<a name="top"></a>
<?php } ?>
Statut
<?php if (@$sExport == "") { ?>
<?php } ?>
<br /><br />
<?php if (@$sExport == "") { ?>
</div></td></tr>
<!-- Top Container (End) -->
<tr>
	<!-- Left Container (Begin) -->
	<td valign="top"><div id="ewLeft" class="phpreportmaker">
	<!-- Left slot -->
	</div></td>
	<!-- Left Container (End) -->
	<!-- Center Container - Report (Begin) -->
	<td valign="top"><div id="ewCenter" class="phpreportmaker">
	<!-- center slot -->
<?php } ?>
<?php if (@$sExport == "") { ?>
	</div><br /></td>
	<!-- Center Container - Report (End) -->
	<!-- Right Container (Begin) -->
	<td valign="top"><div id="ewRight" class="phpreportmaker">
	<!-- Right slot -->
	</div></td>
	<!-- Right Container (End) -->
</tr>
<!-- Bottom Container (Begin) -->
<tr><td colspan="4" BORDER="3" class="ewPadding"><div id="ewBottom" class="phpreportmaker">
	<!-- Bottom slot -->
<!-- <a name="cht_Chart1"></a>
<div id="div_lesproj3_Chart1"></div> -->
<?php

// Initialize chart data
$Chart1_cht_id = "lesproj3_Chart1"; // Chart ID
ewrpt_AddChartParam($Chart1_cht_parms, "type", "5", FALSE); // Chart type
ewrpt_AddChartParam($Chart1_cht_parms, "bgcolor", "#FCFCFC", TRUE); // Background color
ewrpt_AddChartParam($Chart1_cht_parms, "caption", "Montant engag selon le statut", TRUE); // Chart caption
ewrpt_AddChartParam($Chart1_cht_parms, "xaxisname", "Statut", TRUE); // X axis name
ewrpt_AddChartParam($Chart1_cht_parms, "yaxisname", "Montant", TRUE); // Y axis name
ewrpt_AddChartParam($Chart1_cht_parms, "shownames", "1", TRUE); // Show names
ewrpt_AddChartParam($Chart1_cht_parms, "showvalues", "1", TRUE); // Show values
ewrpt_AddChartParam($Chart1_cht_parms, "showhovercap", "1", TRUE); // Show hover
ewrpt_AddChartParam($Chart1_cht_parms, "alpha", "50", FALSE); // Chart alpha
ewrpt_AddChartParam($Chart1_cht_parms, "colorpalette", "#FF0000|#FF0080|#FF00FF|#8000FF|#FF8000|#FF3D3D|#7AFFFF|#0000FF|#FFFF00|#FF7A7A|#3DFFFF|#0080FF|#80FF00|#00FF00|#00FF80|#00FFFF", FALSE); // Chart color palette
?>
<?php
ewrpt_SetChartParam($Chart1_cht_parms, "canvasBgColor", "#EEEEEE", TRUE); // canvasBgColor
ewrpt_SetChartParam($Chart1_cht_parms, "canvasBorderColor", "#A9A9A9", TRUE); // canvasBorderColor
ewrpt_SetChartParam($Chart1_cht_parms, "showCanvasBg", "1", TRUE); // showCanvasBg
ewrpt_SetChartParam($Chart1_cht_parms, "showCanvasBase", "1", TRUE); // showCanvasBase
ewrpt_SetChartParam($Chart1_cht_parms, "showLimits", "1", TRUE); // showLimits
ewrpt_SetChartParam($Chart1_cht_parms, "animation", "1", TRUE); // animation
ewrpt_SetChartParam($Chart1_cht_parms, "rotateNames", "0", TRUE); // rotateNames
ewrpt_SetChartParam($Chart1_cht_parms, "yAxisMinValue", "0", TRUE); // yAxisMinValue
ewrpt_SetChartParam($Chart1_cht_parms, "yAxisMaxValue", "0", TRUE); // yAxisMaxValue
ewrpt_SetChartParam($Chart1_cht_parms, "showColumnShadow", "0", TRUE); // showColumnShadow
ewrpt_SetChartParam($Chart1_cht_parms, "showPercentageValues", "1", TRUE); // showPercentageValues
ewrpt_SetChartParam($Chart1_cht_parms, "showPercentageInLabel", "1", TRUE); // showPercentageInLabel
ewrpt_SetChartParam($Chart1_cht_parms, "showBarShadow", "0", TRUE); // showBarShadow
ewrpt_SetChartParam($Chart1_cht_parms, "showAnchors", "1", TRUE); // showAnchors
ewrpt_SetChartParam($Chart1_cht_parms, "showAreaBorder", "1", TRUE); // showAreaBorder
ewrpt_SetChartParam($Chart1_cht_parms, "showShadow", "1", TRUE); // showShadow
ewrpt_SetChartParam($Chart1_cht_parms, "numberPrefix", "Gdes ", TRUE); // numberPrefix
ewrpt_SetChartParam($Chart1_cht_parms, "formatNumber", "1", TRUE); // formatNumber
ewrpt_SetChartParam($Chart1_cht_parms, "formatNumberScale", "1", TRUE); // formatNumberScale
ewrpt_SetChartParam($Chart1_cht_parms, "decimalSeparator", ".", TRUE); // decimalSeparator
ewrpt_SetChartParam($Chart1_cht_parms, "thousandSeparator", ",", TRUE); // thousandSeparator
ewrpt_SetChartParam($Chart1_cht_parms, "decimalPrecision", "2", TRUE); // decimalPrecision
ewrpt_SetChartParam($Chart1_cht_parms, "divLineDecimalPrecision", "2", TRUE); // divLineDecimalPrecision
ewrpt_SetChartParam($Chart1_cht_parms, "limitsDecimalPrecision", "2", TRUE); // limitsDecimalPrecision
ewrpt_SetChartParam($Chart1_cht_parms, "zeroPlaneShowBorder", "1", TRUE); // zeroPlaneShowBorder
ewrpt_SetChartParam($Chart1_cht_parms, "divLineColor", "#DCDCDC", TRUE); // divLineColor
ewrpt_SetChartParam($Chart1_cht_parms, "showDivLineValue", "1", TRUE); // showDivLineValue
ewrpt_SetChartParam($Chart1_cht_parms, "showAlternateHGridColor", "0", TRUE); // showAlternateHGridColor
ewrpt_SetChartParam($Chart1_cht_parms, "showAlternateVGridColor", "0", TRUE); // showAlternateVGridColor
ewrpt_SetChartParam($Chart1_cht_parms, "hoverCapSepChar", ":", TRUE); // hoverCapSepChar
ewrpt_SetChartParam($Chart2_cht_parms, "labelDisplay", "Stagger", TRUE); // showCanvasBase
//ewrpt_SetChartParam($Chart2_cht_parms, "slantLabels", "1", TRUE); // showCanvasBase

// Define trend lines
?>
<?php

// Load chart data from sql directly
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_CHART_CHART1_SQL_SELECT, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_CHART_CHART1_SQL_GROUPBY, "", "", "", $sFilter, "");

//echo "sql: " . $sSql . "<br>";
ewrpt_LoadChartData($sSql, $Chart1_cht_smry, $EW_REPORT_CHART_CHART1_DATE_TYPE);
ewrpt_SortChartData($Chart1_cht_smry, 0);
//echo ewrpt_ShowChartFCF(5, $Chart1_cht_id, $Chart1_cht_parms, $Chart1_cht_trends, $Chart1_cht_smry, $Chart1_cht_series, 550, 440, "");
?>
<!-- <a href="#top">Top   MIMIMIMI</a> -->

 <a name="cht_Chart2"></a>
<div id="div_lesproj3_Chart1"></div> </td>

<td>
<a name="cht_Chart1"></a>
<div id="div_lesproj3_Chart2"></div>

<?php

// Initialize chart data
$Chart2_cht_id = "lesproj3_Chart2"; // Chart ID
ewrpt_AddChartParam($Chart2_cht_parms, "type", "6", FALSE); // Chart type
ewrpt_AddChartParam($Chart2_cht_parms, "bgcolor", "#FCFCFC", TRUE); // Background color
ewrpt_AddChartParam($Chart2_cht_parms, "caption", "Rpartition des projets par statut", TRUE); // Chart caption
ewrpt_AddChartParam($Chart2_cht_parms, "xaxisname", "Statut", TRUE); // X axis name
ewrpt_AddChartParam($Chart2_cht_parms, "yaxisname", "Nombre de projets", TRUE); // Y axis name
ewrpt_AddChartParam($Chart2_cht_parms, "shownames", "1", TRUE); // Show names
ewrpt_AddChartParam($Chart2_cht_parms, "showvalues", "1", TRUE); // Show values
ewrpt_AddChartParam($Chart2_cht_parms, "showhovercap", "1", TRUE); // Show hover
ewrpt_AddChartParam($Chart2_cht_parms, "alpha", "50", FALSE); // Chart alpha
ewrpt_AddChartParam($Chart2_cht_parms, "colorpalette", "#FF0000|#FF0080|#FF00FF|#8000FF|#FF8000|#FF3D3D|#7AFFFF|#0000FF|#FFFF00|#FF7A7A|#3DFFFF|#0080FF|#80FF00|#00FF00|#00FF80|#00FFFF", FALSE); // Chart color palette
?>
<?php
ewrpt_SetChartParam($Chart2_cht_parms, "canvasBgColor", "#EEEEEE", TRUE); // canvasBgColor
ewrpt_SetChartParam($Chart2_cht_parms, "canvasBorderColor", "#A9A9A9", TRUE); // canvasBorderColor
ewrpt_SetChartParam($Chart2_cht_parms, "showCanvasBg", "1", TRUE); // showCanvasBg
ewrpt_SetChartParam($Chart2_cht_parms, "showCanvasBase", "1", TRUE); // showCanvasBase
ewrpt_SetChartParam($Chart2_cht_parms, "showLimits", "1", TRUE); // showLimits
ewrpt_SetChartParam($Chart2_cht_parms, "animation", "1", TRUE); // animation
ewrpt_SetChartParam($Chart2_cht_parms, "rotateNames", "1", TRUE); // rotateNames
ewrpt_SetChartParam($Chart2_cht_parms, "yAxisMinValue", "0", TRUE); // yAxisMinValue
ewrpt_SetChartParam($Chart2_cht_parms, "yAxisMaxValue", "0", TRUE); // yAxisMaxValue
ewrpt_SetChartParam($Chart2_cht_parms, "showColumnShadow", "0", TRUE); // showColumnShadow
ewrpt_SetChartParam($Chart2_cht_parms, "showPercentageValues", "1", TRUE); // showPercentageValues
ewrpt_SetChartParam($Chart2_cht_parms, "showPercentageInLabel", "1", TRUE); // showPercentageInLabel
ewrpt_SetChartParam($Chart2_cht_parms, "showBarShadow", "0", TRUE); // showBarShadow
ewrpt_SetChartParam($Chart2_cht_parms, "showAnchors", "1", TRUE); // showAnchors
ewrpt_SetChartParam($Chart2_cht_parms, "showAreaBorder", "1", TRUE); // showAreaBorder
ewrpt_SetChartParam($Chart2_cht_parms, "showShadow", "1", TRUE); // showShadow
ewrpt_SetChartParam($Chart2_cht_parms, "formatNumber", "0", TRUE); // formatNumber
ewrpt_SetChartParam($Chart2_cht_parms, "formatNumberScale", "0", TRUE); // formatNumberScale
ewrpt_SetChartParam($Chart2_cht_parms, "decimalSeparator", ".", TRUE); // decimalSeparator
ewrpt_SetChartParam($Chart2_cht_parms, "thousandSeparator", ",", TRUE); // thousandSeparator
ewrpt_SetChartParam($Chart2_cht_parms, "decimalPrecision", "2", TRUE); // decimalPrecision
ewrpt_SetChartParam($Chart2_cht_parms, "divLineDecimalPrecision", "2", TRUE); // divLineDecimalPrecision
ewrpt_SetChartParam($Chart2_cht_parms, "limitsDecimalPrecision", "2", TRUE); // limitsDecimalPrecision
ewrpt_SetChartParam($Chart2_cht_parms, "zeroPlaneShowBorder", "1", TRUE); // zeroPlaneShowBorder
ewrpt_SetChartParam($Chart2_cht_parms, "divLineColor", "#DCDCDC", TRUE); // divLineColor
ewrpt_SetChartParam($Chart2_cht_parms, "showDivLineValue", "1", TRUE); // showDivLineValue
ewrpt_SetChartParam($Chart2_cht_parms, "showAlternateHGridColor", "0", TRUE); // showAlternateHGridColor
ewrpt_SetChartParam($Chart2_cht_parms, "showAlternateVGridColor", "0", TRUE); // showAlternateVGridColor
ewrpt_SetChartParam($Chart2_cht_parms, "hoverCapSepChar", ":", TRUE); // hoverCapSepChar
ewrpt_SetChartParam($Chart2_cht_parms, "enableRotation", "1", TRUE); // showCanvasBase
ewrpt_SetChartParam($Chart2_cht_parms, "bgAngle", "90", TRUE); // showCanvasBase
//ewrpt_SetChartParam($Chart2_cht_parms, "labelDisplay", "WRAP", TRUE); // showCanvasBase
//ewrpt_SetChartParam($Chart2_cht_parms, "slantLabels", "1", TRUE); // showCanvasBase

// Define trend lines
?>
<?php

// Load chart data from sql directly
$sSql = ewrpt_BuildReportSql("", $EW_REPORT_CHART_CHART2_SQL_SELECT, $EW_REPORT_TABLE_SQL_WHERE, $EW_REPORT_CHART_CHART2_SQL_GROUPBY, "", "", "", $sFilter, "");

//echo "sql: " . $sSql . "<br>";
ewrpt_LoadChartData($sSql, $Chart2_cht_smry, $EW_REPORT_CHART_CHART2_DATE_TYPE);
ewrpt_SortChartData($Chart2_cht_smry, 0);
echo ewrpt_ShowChartFCF(5, $Chart1_cht_id, $Chart1_cht_parms, $Chart1_cht_trends, $Chart1_cht_smry, $Chart1_cht_series, 400, 640, "")."".ewrpt_ShowChartFCF(6, $Chart2_cht_id, $Chart2_cht_parms, $Chart2_cht_trends, $Chart2_cht_smry, $Chart2_cht_series, 400, 640, "");
?>
<!-- <a href="#top">Top222222</a> 
<br /><br />-->
	</div><!-- <br /> --></td></tr>
<!-- Bottom Container (End) -->
</table>
<!-- Table Container (End) -->
<?php } ?>
<?php
$conn->Close();

// display elapsed time
if (defined("EW_REPORT_DEBUG_ENABLED"))
	echo ewrpt_calcElapsedTime($starttime);
?>
<?php include "phprptinc/footerreport.php"; ?>
<?php if (@$sExport == "") { ?>
<?php include "footer_admin.php"; ?>
<?php } ?>
<?php

// Accummulate summary
function AccumulateSummary() {
	global $smry, $cnt, $col, $val, $mn, $mx;
	$cntx = count($smry);
	for ($ix = 0; $ix < $cntx; $ix++) {
		$cnty = count($smry[$ix]);
		for ($iy = 1; $iy < $cnty; $iy++) {
			$cnt[$ix][$iy]++;
			if ($col[$iy]) {
				$valwrk = $val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {

					// skip
				} else {
					$smry[$ix][$iy] += $valwrk;
					if (is_null($mn[$ix][$iy])) {
						$mn[$ix][$iy] = $valwrk;
						$mx[$ix][$iy] = $valwrk;
					} else {
						if ($mn[$ix][$iy] > $valwrk) $mn[$ix][$iy] = $valwrk;
						if ($mx[$ix][$iy] < $valwrk) $mx[$ix][$iy] = $valwrk;
					}
				}
			}
		}
	}
	$cntx = count($smry);
	for ($ix = 1; $ix < $cntx; $ix++) {
		$cnt[$ix][0]++;
	}
}

// Reset level summary
function ResetLevelSummary($lvl) {
	global $smry, $cnt, $col, $mn, $mx, $nRecCount;

	// Clear summary values
	$cntx = count($smry);
	for ($ix = $lvl; $ix < $cntx; $ix++) {
		$cnty = count($smry[$ix]);
		for ($iy = 1; $iy < $cnty; $iy++) {
			$cnt[$ix][$iy] = 0;
			if ($col[$iy]) {
				$smry[$ix][$iy] = 0;
				$mn[$ix][$iy] = NULL;
				$mx[$ix][$iy] = NULL;
			}
		}
	}
	$cntx = count($smry);
	for ($ix = $lvl; $ix < $cntx; $ix++) {
		$cnt[$ix][0] = 0;
	}

	// Clear old values
	// Reset record count

	$nRecCount = 0;
}

// Accummulate grand summary
function AccumulateGrandSummary() {
	global $cnt, $col, $val, $grandsmry, $grandmn, $grandmx;
	@$cnt[0][0]++;
	for ($iy = 1; $iy < count($grandsmry); $iy++) {
		if ($col[$iy]) {
			$valwrk = $val[$iy];
			if (is_null($valwrk) || !is_numeric($valwrk)) {

				// skip
			} else {
				$grandsmry[$iy] += $valwrk;
				if (is_null($grandmn[$iy])) {
					$grandmn[$iy] = $valwrk;
					$grandmx[$iy] = $valwrk;
				} else {
					if ($grandmn[$iy] > $valwrk) $grandmn[$iy] = $valwrk;
					if ($grandmx[$iy] < $valwrk) $grandmx[$iy] = $valwrk;
				}
			}
		}
	}
}

// Get count
function GetCnt($sql) {
	global $conn;

	//echo "sql (GetCnt): " . $sql . "<br>";
	$rscnt = $conn->Execute($sql);
	$cnt = ($rscnt) ? $rscnt->RecordCount() : 0;
	return $cnt;
}

// Get rs
function GetRs($sql, $start, $grps) {
	global $conn;
	$wrksql = $sql . " LIMIT " . ($start-1) . ", " . ($grps);

	//echo "wrksql: (rsgrp)" . $sSql . "<br>";
	$rswrk = $conn->Execute($wrksql);
	return $rswrk;
}

// Get row values
function GetRow($opt) {
	global $rs, $val;
	if (!$rs)
		return;
	if ($opt == 1) { // Get first row
		$rs->MoveFirst();
	} else { // Get next row
		$rs->MoveNext();
	}
	if (!$rs->EOF) {
		$GLOBALS['x_departemen'] = $rs->fields('departemen');
		$GLOBALS['x_montantproj'] = $rs->fields('montantproj');
		$GLOBALS['x_montantdec'] = $rs->fields('montantdec');
		$GLOBALS['x_titre'] = $rs->fields('titre');
		$GLOBALS['x_objectif'] = $rs->fields('objectif');
		$GLOBALS['x_bailleur'] = $rs->fields('bailleur');
		$GLOBALS['x_entite'] = $rs->fields('entite');
		$GLOBALS['x_secteur'] = $rs->fields('secteur');
		$GLOBALS['x_program'] = $rs->fields('program');
		$GLOBALS['x_departement'] = $rs->fields('departement');
		$GLOBALS['x_commune'] = $rs->fields('commune');
		$GLOBALS['x_section'] = $rs->fields('section');
		$GLOBALS['x_datedebut'] = $rs->fields('datedebut');
		$GLOBALS['x_nbrbd'] = $rs->fields('nbrbd');
		$GLOBALS['x_nbrec'] = $rs->fields('nbrec');
		$GLOBALS['x_datemaj'] = $rs->fields('datemaj');
		$GLOBALS['x_statut'] = $rs->fields('statut');
		$GLOBALS['x_ast'] = $rs->fields('ast');
		$GLOBALS['x_userID'] = $rs->fields('userID');
		$GLOBALS['x_NomStatut'] = $rs->fields('NomStatut');
		$GLOBALS['x_nomsecteur'] = $rs->fields('nomsecteur');
		$GLOBALS['x_nb'] = $rs->fields('nb');
		$val[1] = $GLOBALS['x_departemen'];
		$val[2] = $GLOBALS['x_montantproj'];
		$val[3] = $GLOBALS['x_montantdec'];
		$val[4] = $GLOBALS['x_titre'];
		$val[5] = $GLOBALS['x_objectif'];
		$val[6] = $GLOBALS['x_bailleur'];
		$val[7] = $GLOBALS['x_entite'];
		$val[8] = $GLOBALS['x_secteur'];
		$val[9] = $GLOBALS['x_program'];
		$val[10] = $GLOBALS['x_departement'];
		$val[11] = $GLOBALS['x_commune'];
		$val[12] = $GLOBALS['x_section'];
		$val[13] = $GLOBALS['x_datedebut'];
		$val[14] = $GLOBALS['x_nbrbd'];
		$val[15] = $GLOBALS['x_nbrec'];
		$val[16] = $GLOBALS['x_datemaj'];
		$val[17] = $GLOBALS['x_statut'];
		$val[18] = $GLOBALS['x_ast'];
		$val[19] = $GLOBALS['x_userID'];
		$val[20] = $GLOBALS['x_NomStatut'];
		$val[21] = $GLOBALS['x_nomsecteur'];
		$val[22] = $GLOBALS['x_nb'];
	} else {
		$GLOBALS['x_departemen'] = "";
		$GLOBALS['x_montantproj'] = "";
		$GLOBALS['x_montantdec'] = "";
		$GLOBALS['x_titre'] = "";
		$GLOBALS['x_objectif'] = "";
		$GLOBALS['x_bailleur'] = "";
		$GLOBALS['x_entite'] = "";
		$GLOBALS['x_secteur'] = "";
		$GLOBALS['x_program'] = "";
		$GLOBALS['x_departement'] = "";
		$GLOBALS['x_commune'] = "";
		$GLOBALS['x_section'] = "";
		$GLOBALS['x_datedebut'] = "";
		$GLOBALS['x_nbrbd'] = "";
		$GLOBALS['x_nbrec'] = "";
		$GLOBALS['x_datemaj'] = "";
		$GLOBALS['x_statut'] = "";
		$GLOBALS['x_ast'] = "";
		$GLOBALS['x_userID'] = "";
		$GLOBALS['x_NomStatut'] = "";
		$GLOBALS['x_nomsecteur'] = "";
		$GLOBALS['x_nb'] = "";
	}
}

//  Set up starting group
function SetUpStartGroup() {
	global $nStartGrp, $nTotalGrps, $nDisplayGrps;

	// Exit if no groups
	if ($nDisplayGrps == 0)
		return;

	// Check for a 'start' parameter
	if (@$_GET[EW_REPORT_TABLE_START_GROUP] != "") {
		$nStartGrp = $_GET[EW_REPORT_TABLE_START_GROUP];
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (@$_GET["pageno"] != "") {
		$nPageNo = $_GET["pageno"];
		if (is_numeric($nPageNo)) {
			$nStartGrp = ($nPageNo-1)*$nDisplayGrps+1;
			if ($nStartGrp <= 0) {
				$nStartGrp = 1;
			} elseif ($nStartGrp >= intval(($nTotalGrps-1)/$nDisplayGrps)*$nDisplayGrps+1) {
				$nStartGrp = intval(($nTotalGrps-1)/$nDisplayGrps)*$nDisplayGrps+1;
			}
			$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
		} else {
			$nStartGrp = @$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP];
		}
	} else {
		$nStartGrp = @$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP];	
	}

	// Check if correct start group counter
	if (!is_numeric($nStartGrp) || $nStartGrp == "") { // Avoid invalid start group counter
		$nStartGrp = 1; // Reset start group counter
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (intval($nStartGrp) > intval($nTotalGrps)) { // Avoid starting group > total groups
		$nStartGrp = intval(($nTotalGrps-1)/$nDisplayGrps) * $nDisplayGrps + 1; // Point to last page first group
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} elseif (($nStartGrp-1) % $nDisplayGrps <> 0) {
		$nStartGrp = intval(($nStartGrp-1)/$nDisplayGrps) * $nDisplayGrps + 1; // Point to page boundary
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	}
}

// Set up popup
function SetupPopup() {
	global $conn, $sFilter;

	// Initialize popup
	// Process post back form

	if (count($_POST) > 0) {
		$sName = @$_POST["popup"]; // Get popup form name
		if ($sName <> "") {
		$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
			if ($cntValues > 0) {
				$arValues = ewrpt_StripSlashes($_POST["sel_$sName"]);
				if (trim($arValues[0]) == "") // Select all
					$arValues = EW_REPORT_INIT_VALUE;
				if (!ewrpt_MatchedArray($arValues, $_SESSION["sel_$sName"])) {
					if (HasSessionFilterValues($sName))
						$GLOBALS["sClearExtFilter"] = $sName; // Clear extended filter for this field
				}
				$_SESSION["sel_$sName"] = $arValues;
				$_SESSION["rf_$sName"] = ewrpt_StripSlashes(@$_POST["rf_$sName"]);
				$_SESSION["rt_$sName"] = ewrpt_StripSlashes(@$_POST["rt_$sName"]);
				ResetPager();
			}
		}

	// Get 'reset' command
	} elseif (@$_GET["cmd"] <> "") {
		$sCmd = $_GET["cmd"];
		if (strtolower($sCmd) == "reset") {
			ResetPager();
		}
	}

	// Load selection criteria to array
}

// Reset pager
function ResetPager() {

	// Reset start position (reset command)
	global $nStartGrp, $nTotalGrps;
	$nStartGrp = 1;
	$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
}
?>
<?php

// Set up number of groups displayed per page
function SetUpDisplayGrps() {
	global $nDisplayGrps, $nStartGrp;
	$sWrk = @$_GET[EW_REPORT_TABLE_GROUP_PER_PAGE];
	if ($sWrk <> "") {
		if (is_numeric($sWrk)) {
			$nDisplayGrps = intval($sWrk);
		} else {
			if (strtoupper($sWrk) == "ALL") { // display all groups
				$nDisplayGrps = -1;
			} else {
				$nDisplayGrps = 3; // Non-numeric, load default
			}
		}
		$_SESSION[EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE] = $nDisplayGrps; // Save to session

		// Reset start position (reset command)
		$nStartGrp = 1;
		$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = $nStartGrp;
	} else {
		if (@$_SESSION[EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE] <> "") {
			$nDisplayGrps = $_SESSION[EW_REPORT_TABLE_SESSION_GROUP_PER_PAGE]; // Restore from session
		} else {
			$nDisplayGrps = 3; // Load default
		}
	}
}
?>
<?php

// Get extended filter values
function GetExtendedFilterValues() {
}

// Return extended filter
function GetExtendedFilter() {
	$sFilter = "";
	$bPostBack = (count($_POST) > 0);
	$bRestoreSession = TRUE;
	$bSetupFilter = FALSE;

	// Reset extended filter if filter changed
	if ($bPostBack) {

	// Reset search command
	} elseif (@$_GET["cmd"] == "reset") {

		// Load default values
		// Field entite

		SetSessionFilterValues($GLOBALS["sv1_entite"], $GLOBALS["so1_entite"], $GLOBALS["sc_entite"], $GLOBALS["sv2_entite"], $GLOBALS["so2_entite"], 'entite');
		$bSetupFilter = TRUE;
	} else {

		// Field entite
		if (GetFilterValues($GLOBALS["sv1_entite"], $GLOBALS["so1_entite"], $GLOBALS["sc_entite"], $GLOBALS["sv2_entite"], $GLOBALS["so2_entite"], 'entite')) {
			$bSetupFilter = TRUE;
			$bRestoreSession = FALSE;
		}
	}

	// Restore session
	if ($bRestoreSession) {

		// Field entite
		GetSessionFilterValues($GLOBALS["sv1_entite"], $GLOBALS["so1_entite"], $GLOBALS["sc_entite"], $GLOBALS["sv2_entite"], $GLOBALS["so2_entite"], 'entite');
	}

	// Build SQL
	// Field entite

	BuildExtendedFilter($sFilter, 'entite', 'projets.entite', EW_REPORT_DATATYPE_NUMBER, 0, $GLOBALS["sv1_entite"], $GLOBALS["so1_entite"], $GLOBALS["sc_entite"], $GLOBALS["sv2_entite"], $GLOBALS["so2_entite"]);

	// Save parms to session
	// Field entite

	SetSessionFilterValues($GLOBALS["sv1_entite"], $GLOBALS["so1_entite"], $GLOBALS["sc_entite"], $GLOBALS["sv2_entite"], $GLOBALS["so2_entite"], 'entite');

	// Setup filter
	if ($bSetupFilter) {
	}
	return $sFilter;
}

// Get drop down value from querystring
function GetDropDownValue(&$sv, $parm) {
	if (count($_POST) > 0)
		return FALSE; // Skip post back
	if (isset($_GET["sv_$parm"])) {
		$sv = ewrpt_StripSlashes($_GET["sv_$parm"]);
		return TRUE;
	}
	return FALSE;
}

// Get filter values from querystring
function GetFilterValues(&$sv1, &$so1, &$sc, &$sv2, &$so2, $parm) {
	if (count($_POST) > 0)
		return; // Skip post back
	$got = FALSE;
	if (@$_GET["sv1_$parm"] <> "") {
		$sv1 = ewrpt_StripSlashes($_GET["sv1_$parm"]);
		$got = TRUE;
	}
	if (@$_GET["so1_$parm"] <> "") {
		$so1 = ewrpt_StripSlashes($_GET["so1_$parm"]);
		$got = TRUE;
	}
	if (@$_GET["sc_$parm"] <> "") {
		$sc = ewrpt_StripSlashes($_GET["sc_$parm"]);
		$got = TRUE;
	}
	if (@$_GET["sv2_$parm"] <> "") {
		$sv2 = ewrpt_StripSlashes($_GET["sv2_$parm"]);
		$got = TRUE;
	}
	if (@$_GET["so2_$parm"] <> "") {
		$so2 = ewrpt_StripSlashes($_GET["so2_$parm"]);
		$got = TRUE;
	}
	return $got;
}

// Set default ext filter
function SetDefaultExtFilter($parm, $so1, $sv1, $sc, $so2, $sv2) {
	$GLOBALS["sv1d_$parm"] = $sv1; // Default ext filter value 1
	$GLOBALS["sv2d_$parm"] = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
	$GLOBALS["so1d_$parm"] = $so1; // Default search operator 1
	$GLOBALS["so2d_$parm"] = $so2; // Default search operator 2 (if operator 2 is enabled)
	$GLOBALS["scd_$parm"] = $sc; // Default search condition (if operator 2 is enabled)
}

// Apply default ext filter
function ApplyDefaultExtFilter($parm) {
	$GLOBALS["sv1_$parm"] = $GLOBALS["sv1d_$parm"];
	$GLOBALS["sv2_$parm"] = $GLOBALS["sv2d_$parm"];
	$GLOBALS["so1_$parm"] = $GLOBALS["so1d_$parm"];
	$GLOBALS["so2_$parm"] = $GLOBALS["so2d_$parm"];
	$GLOBALS["sc_$parm"] = $GLOBALS["scd_$parm"];
}

// Check if Text Filter applied
function TextFilterApplied($parm) {
	return (strval($GLOBALS["sv1_$parm"]) <> strval($GLOBALS["sv1d_$parm"]) ||
		strval($GLOBALS["sv2_$parm"]) <> strval($GLOBALS["sv2d_$parm"]) ||
		strval($GLOBALS["so1_$parm"]) <> strval($GLOBALS["so1d_$parm"]) ||
		strval($GLOBALS["so2_$parm"]) <> strval($GLOBALS["so2d_$parm"]) ||
		strval($GLOBALS["sc_$parm"]) <> strval($GLOBALS["scd_$parm"]));
}

// Check if Non-Text Filter applied
function NonTextFilterApplied($parm) {
	if (is_array($GLOBALS["svd_$parm"]) && is_array($GLOBALS["sv_$parm"])) {
		if (count($GLOBALS["svd_$parm"]) <> count($GLOBALS["sv_$parm"]))
			return TRUE;
		else
			return (count(array_diff($GLOBALS["svd_$parm"], $GLOBALS["sv_$parm"])) <> 0);
	}
	else
		return (strval($GLOBALS["svd_$parm"]) <> strval($GLOBALS["sv_$parm"]));
}

// Load selection from a filter clause
function LoadSelectionFromFilter($parm, $filter, &$sel) {
	$sel = "";
	if ($filter <> "") {
		$sSql = ewrpt_BuildReportSql("", $GLOBALS["EW_REPORT_FIELD_" . strtoupper($parm) . "_SQL_SELECT"], $GLOBALS["EW_REPORT_TABLE_SQL_WHERE"], $GLOBALS["EW_REPORT_TABLE_SQL_GROUPBY"], $GLOBALS["EW_REPORT_TABLE_SQL_HAVING"], $GLOBALS["EW_REPORT_FIELD_" . strtoupper($parm) . "_SQL_ORDERBY"], "", $filter, "");
		ewrpt_LoadArrayFromSql($sSql, $sel);
	}
}

// Get dropdown value from session
function GetSessionDropDownValue(&$sv, $parm) {
	GetSessionValue($sv, 'sv_lesproj3_' . $parm);
}

// Get filter values from session
function GetSessionFilterValues(&$sv1, &$so1, &$sc, &$sv2, &$so2, $parm) {
	GetSessionValue($sv1, 'sv1_lesproj3_' . $parm);
	GetSessionValue($so1, 'so1_lesproj3_' . $parm);
	GetSessionValue($sc, 'sc_lesproj3_' . $parm);
	GetSessionValue($sv2, 'sv2_lesproj3_' . $parm);
	GetSessionValue($so2, 'so2_lesproj3_' . $parm);
}

// Get value from session
function GetSessionValue(&$sv, $sn) {
	if (isset($_SESSION[$sn]))
		$sv = $_SESSION[$sn];
}

// Set dropdown value to session
function SetSessionDropDownValue($sv, $parm) {
	$_SESSION['sv_lesproj3_' . $parm] = $sv;
}

// Set filter values to session
function SetSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm) {
	$_SESSION['sv1_lesproj3_' . $parm] = $sv1;
	$_SESSION['so1_lesproj3_' . $parm] = $so1;
	$_SESSION['sc_lesproj3_' . $parm] = $sc;
	$_SESSION['sv2_lesproj3_' . $parm] = $sv2;
	$_SESSION['so2_lesproj3_' . $parm] = $so2;
}

// Check if has Session filter values
function HasSessionFilterValues($parm) {
	return ((@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EW_REPORT_INIT_VALUE) ||
		(@$_SESSION['sv1_' . $parm] <> "" && @$_SESSION['sv1_' . $parm] <> EW_REPORT_INIT_VALUE) ||
		(@$_SESSION['sv2_' . $parm] <> "" && @$_SESSION['sv2_' . $parm] <> EW_REPORT_INIT_VALUE));
}

// Build dropdown filter
function BuildDropDownFilter(&$FilterClause, $FldName, $FldExpression, $FldDataType, $FldDateTimeFormat, $FldVal, $FldOpr) {
	$sSql = "";
	if (is_array($FldVal)) {
		foreach ($FldVal as $val) {
			$sWrk = getDropDownfilter($FldName, $FldExpression, $FldDataType, $FldDateTimeFormat, $val, $FldOpr);
			if ($sWrk <> "") {
				if ($sSql <> "")
					$sSql .= " OR " . $sWrk;
				else
					$sSql = $sWrk;
			}
		}
	} else {
		$sSql = getDropDownfilter($FldName, $FldExpression, $FldDataType, $FldDateTimeFormat, $FldVal, $FldOpr);
	}
	if ($sSql <> "") {
		if ($FilterClause <> "") $FilterClause = "(" . $FilterClause . ") AND ";
		$FilterClause .= "(" . $sSql . ")";
	}
}

function getDropDownfilter($FldName, $FldExpression, $FldDataType, $FldDateTimeFormat, $FldVal, $FldOpr) {
	$sWrk = "";
	if ($FldVal == EW_REPORT_NULL_VALUE) {
		$sWrk = $FldExpression . " IS NULL";
	} elseif ($FldVal == EW_REPORT_EMPTY_VALUE) {
		$sWrk = $FldExpression . " = ''";
	} else {
		if (substr($FldVal, 0, 2) == "@@") {
			$sWrk = CustomFilter($FldName, $FldExpression, $FldVal);
		} else {
			if ($FldVal <> "" && $FldVal <> EW_REPORT_INIT_VALUE) {
				if ($FldDataType == EW_REPORT_DATATYPE_DATE && $FldOpr <> "") {
					$sWrk = DateFilterString($FldOpr, $FldVal, $FldDataType);
				} else {
					$sWrk = FilterString("=", $FldVal, $FldDataType);
				}
			}
			if ($sWrk <> "") $sWrk = $FldExpression . $sWrk;
		}
	}
	return $sWrk;
}

// Register custom filter
function RegisterCustomFilter($FldName, $FilterName, $DisplayName, $FldExpression, $FunctionName) {
	global $ewrpt_CustomFilters;
	if (!is_array($ewrpt_CustomFilters))
		$ewrpt_CustomFilters = array();
	$ewrpt_CustomFilters[] = array($FldName, $FilterName, $DisplayName, $FldExpression, $FunctionName);
}

// Custom filter
function CustomFilter($FldName, $FldExpression, $FldVal) {
	global $ewrpt_CustomFilters;
	$sWrk = "";
	$sParm = substr($FldVal, 2);
	if (is_array($ewrpt_CustomFilters)) {
		$cntf = count($ewrpt_CustomFilters);
		for ($i = 0; $i < $cntf; $i++) {
			if ($ewrpt_CustomFilters[$i][0] == $FldName && $ewrpt_CustomFilters[$i][1] == $sParm) {
				$sFld = $ewrpt_CustomFilters[$i][3];
				$sFn = $ewrpt_CustomFilters[$i][4];
				$sWrk = $sFn($sFld);
				break;
			}
		}
	}
	return $sWrk;
}

// Build extended filter
function BuildExtendedFilter(&$FilterClause, $FldName, $FldExpression, $FldDataType, $FldDateTimeFormat, $FldVal1, $FldOpr1, $FldCond, $FldVal2, $FldOpr2) {
	$sWrk = "";
	$FldOpr1 = strtoupper(trim($FldOpr1));
	if ($FldOpr1 == "") $FldOpr1 = "=";
	$FldOpr2 = strtoupper(trim($FldOpr2));
	if ($FldOpr2 == "") $FldOpr2 = "=";
	$wrkFldVal1 = $FldVal1;
	$wrkFldVal2 = $FldVal2;
	if ($FldDataType == EW_REPORT_DATATYPE_BOOLEAN) {
		if ($wrkFldVal1 <> "") $wrkFldVal1 = ($wrkFldVal1 == "1") ? EW_REPORT_TRUE_STRING : EW_REPORT_FALSE_STRING;
		if ($wrkFldVal2 <> "") $wrkFldVal2 = ($wrkFldVal2 == "1") ? EW_REPORT_TRUE_STRING : EW_REPORT_FALSE_STRING;
	} elseif ($FldDataType == EW_REPORT_DATATYPE_DATE) {
		if ($wrkFldVal1 <> "") $wrkFldVal1 = ewrpt_UnFormatDateTime($wrkFldVal1, $FldDateTimeFormat);
		if ($wrkFldVal2 <> "") $wrkFldVal2 = ewrpt_UnFormatDateTime($wrkFldVal2, $FldDateTimeFormat);
	}
	if ($FldOpr1 == "BETWEEN") {
		$IsValidValue = ($FldDataType <> EW_REPORT_DATATYPE_NUMBER ||
			($FldDataType == EW_REPORT_DATATYPE_NUMBER && is_numeric($wrkFldVal1) && is_numeric($wrkFldVal2)));
		if ($wrkFldVal1 <> "" && $wrkFldVal2 <> "" && $IsValidValue)
			$sWrk = $FldExpression . " BETWEEN " . ewrpt_QuotedValue($wrkFldVal1, $FldDataType) .
				" AND " . ewrpt_QuotedValue($wrkFldVal2, $FldDataType);
	} elseif ($FldOpr1 == "IS NULL" || $FldOpr1 == "IS NOT NULL") {
		$sWrk = $FldExpression . " " . $wrkFldVal1;
	} else {
		$IsValidValue = ($FldDataType <> EW_REPORT_DATATYPE_NUMBER ||
			($FldDataType == EW_REPORT_DATATYPE_NUMBER && is_numeric($wrkFldVal1)));
		if ($wrkFldVal1 <> "" && $IsValidValue && ewrpt_IsValidOpr($FldOpr1, $FldDataType))
			$sWrk = $FldExpression . FilterString($FldOpr1, $wrkFldVal1, $FldDataType);
		$IsValidValue = ($FldDataType <> EW_REPORT_DATATYPE_NUMBER ||
			($FldDataType == EW_REPORT_DATATYPE_NUMBER && is_numeric($wrkFldVal2)));
		if ($wrkFldVal2 <> "" && $IsValidValue && ewrpt_IsValidOpr($FldOpr2, $FldDataType)) {
			if ($sWrk <> "")
				$sWrk .= " " . (($FldCond == "OR") ? "OR" : "AND") . " ";
			$sWrk .= $FldExpression . FilterString($FldOpr2, $wrkFldVal2, $FldDataType);
		}
	}
	if ($sWrk <> "") {
		if ($FilterClause <> "") $FilterClause .= " AND ";
		$FilterClause .= "(" . $sWrk . ")";
	}
}

// Return filter string
function FilterString($FldOpr, $FldVal, $FldType) {
	if ($FldOpr == "LIKE" || $FldOpr == "NOT LIKE") {
		return " " . $FldOpr . " " . ewrpt_QuotedValue("%$FldVal%", $FldType);
	} elseif ($FldOpr == "STARTS WITH") {
		return " LIKE " . ewrpt_QuotedValue("$FldVal%", $FldType);
	} else {
		return " $FldOpr " . ewrpt_QuotedValue($FldVal, $FldType);
	}
}

// Return date search string
function DateFilterString($FldOpr, $FldVal, $FldType) {
	$wrkVal1 = DateVal($FldOpr, $FldVal, 1);
	$wrkVal2 = DateVal($FldOpr, $FldVal, 2);
	if ($wrkVal1 <> "" && $wrkVal2 <> "") {
		return " BETWEEN " . ewrpt_QuotedValue($wrkVal1, $FldType) . " AND " . ewrpt_QuotedValue($wrkVal2, $FldType);
	} else {
		return "";
	}
}

// Return date value
function DateVal($FldOpr, $FldVal, $ValType) {

	// Compose date string
	switch (strtolower($FldOpr)) {
	case "year":
		if ($ValType == 1) {
			$wrkVal = "$FldVal-01-01";
		} elseif ($ValType == 2) {
			$wrkVal = "$FldVal-12-31";
		}
		break;
	case "quarter":
		list($y, $q) = explode("|", $FldVal);
		if (intval($y) == 0 || intval($q) == 0) {
			$wrkVal = "0000-00-00";
		} else {
			if ($ValType == 1) {
				$m = ($q - 1) * 3 + 1;
				$m = str_pad($m, 2, "0", STR_PAD_LEFT);
				$wrkVal = "$y-$m-01";
			} elseif ($ValType == 2) {
				$m = ($q - 1) * 3 + 3;
				$m = str_pad($m, 2, "0", STR_PAD_LEFT);
				$wrkVal = "$y-$m-" . ewrpt_DaysInMonth($y, $m);
			}
		}
		break;
	case "month":
		list($y, $m) = explode("|", $FldVal);
		if (intval($y) == 0 || intval($m) == 0) {
			$wrkVal = "0000-00-00";
		} else {
			if ($ValType == 1) {
				$m = str_pad($m, 2, "0", STR_PAD_LEFT);
				$wrkVal = "$y-$m-01";
			} elseif ($ValType == 2) {
				$m = str_pad($m, 2, "0", STR_PAD_LEFT);
				$wrkVal = "$y-$m-" . ewrpt_DaysInMonth($y, $m);
			}
		}
		break;
	case "day":
		$wrkVal = str_replace("|", "-", $FldVal);
	}

	// Add time if necessary
	if (preg_match('/(\d{4}|\d{2})-(\d{1,2})-(\d{1,2})/', $wrkVal)) { // date without time
		if ($ValType == 1) {
			$wrkVal .= " 00:00:00";
		} elseif ($ValType == 2) {
			$wrkVal .= " 23:59:59";
		}
	}

	// Check if datetime
	if (preg_match('/(\d{4}|\d{2})-(\d{1,2})-(\d{1,2}) (\d{1,2}):(\d{1,2}):(\d{1,2})/', $wrkVal)) { // datetime
		$DateVal = $wrkVal;
	} else {
		$DateVal = "";
	}
	return $DateVal;
}
?>
<?php

// Clear selection stored in session
function ClearSessionSelection($parm) {
	$_SESSION["sel_lesproj3_$parm"] = "";
	$_SESSION["rf_lesproj3_$parm"] = "";
	$_SESSION["rt_lesproj3_$parm"] = "";
}

// Load selection from session
function LoadSelectionFromSession($parm) {
	$GLOBALS["sel_$parm"] = @$_SESSION["sel_lesproj3_$parm"];
	$GLOBALS["rf_$parm"] = @$_SESSION["rf_lesproj3_$parm"];
	$GLOBALS["rt_$parm"] = @$_SESSION["rt_lesproj3_$parm"];
}

// Load default value for filters
function LoadDefaultFilters() {

	/**
	* Set up default values for non Text filters
	*/

	/**
	* Set up default values for extended filters
	* function SetDefaultExtFilter($parm, $so1, $sv1, $sc, $so2, $sv2)
	* Parameters:
	* $parm - Field name
	* $so1 - Default search operator 1
	* $sv1 - Default ext filter value 1
	* $sc - Default search condition (if operator 2 is enabled)
	* $so2 - Default search operator 2 (if operator 2 is enabled)
	* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
	*/

	// Field entite
	SetDefaultExtFilter('entite', '=', NULL, 'AND', '=', NULL);
	ApplyDefaultExtFilter('entite');

	/**
	* Set up default values for popup filters
	* NOTE: if extended filter is enabled, use default values in extended filter instead
	*/
}

// Check if filter applied
function CheckFilter() {

	// Check entite text filter
	if (TextFilterApplied("entite"))
		return TRUE;
	return FALSE;
}

// Show list of filters
function ShowFilterList() {

	// Initialize
	$sFilterList = "";

	// Field entite
	$sExtWrk = "";
	$sWrk = "";
	BuildExtendedFilter($sExtWrk, 'entite', 'projets.entite', EW_REPORT_DATATYPE_NUMBER, 0, $GLOBALS["sv1_entite"], $GLOBALS["so1_entite"], $GLOBALS["sc_entite"], $GLOBALS["sv2_entite"], $GLOBALS["so2_entite"]);
	if ($sExtWrk <> "" || $sWrk <> "")
		$sFilterList .= "entite<br />";
	if ($sExtWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sExtWrk<br />";
	if ($sWrk <> "")
		$sFilterList .= "&nbsp;&nbsp;$sWrk<br />";

	// Show Filters
	if ($sFilterList <> "")
		echo "CURRENT FILTERS:<br />$sFilterList";
}

/**
 * Regsiter your Custom filters here
 */

// Setup custom filters
function SetupCustomFilters() {

	// 1. Register your custom filter below (see example)
	// 2. Write your custom filter function (see example fucntions: GetLastMonthFilter, GetStartsWithAFilter)

}

/**
 * Write your Custom filters here
 */

// Filter for 'Last Month' (example)
function GetLastMonthFilter($FldExpression) {
	$today = getdate();
	$lastmonth = mktime(0, 0, 0, $today['mon']-1, 1, $today['year']);
	$sVal = date("Y|m", $lastmonth);
	$sWrk = $FldExpression . " BETWEEN " .
		ewrpt_QuotedValue(DateVal("month", $sVal, 1), EW_REPORT_DATATYPE_DATE) .
		" AND " .
		ewrpt_QuotedValue(DateVal("month", $sVal, 2), EW_REPORT_DATATYPE_DATE);
	return $sWrk;
}

// Filter for 'Starts With A' (example)
function GetStartsWithAFilter($FldExpression) {
	return $FldExpression . " LIKE 'A%'";
}
?>
<?php

// Return poup filter
function GetPopupFilter() {
	$sWrk = "";
	return $sWrk;
}
?>
<?php

//-------------------------------------------------------------------------------
// Function getSort
// - Return Sort parameters based on Sort Links clicked
// - Variables setup: Session[EW_REPORT_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
function getSort()
{

	// Check for a resetsort command
	if (strlen(@$_GET["cmd"]) > 0) {
		$sCmd = @$_GET["cmd"];
		if ($sCmd == "resetsort") {
			$_SESSION[EW_REPORT_TABLE_SESSION_ORDER_BY] = "";
			$_SESSION[EW_REPORT_TABLE_SESSION_START_GROUP] = 1;
			$_SESSION["sort_lesproj3_departemen"] = "";
			$_SESSION["sort_lesproj3_montantproj"] = "";
			$_SESSION["sort_lesproj3_montantdec"] = "";
			$_SESSION["sort_lesproj3_titre"] = "";
			$_SESSION["sort_lesproj3_objectif"] = "";
			$_SESSION["sort_lesproj3_bailleur"] = "";
			$_SESSION["sort_lesproj3_entite"] = "";
			$_SESSION["sort_lesproj3_secteur"] = "";
			$_SESSION["sort_lesproj3_program"] = "";
			$_SESSION["sort_lesproj3_departement"] = "";
			$_SESSION["sort_lesproj3_commune"] = "";
			$_SESSION["sort_lesproj3_section"] = "";
			$_SESSION["sort_lesproj3_datedebut"] = "";
			$_SESSION["sort_lesproj3_nbrbd"] = "";
			$_SESSION["sort_lesproj3_nbrec"] = "";
			$_SESSION["sort_lesproj3_datemaj"] = "";
			$_SESSION["sort_lesproj3_statut"] = "";
			$_SESSION["sort_lesproj3_ast"] = "";
			$_SESSION["sort_lesproj3_userID"] = "";
			$_SESSION["sort_lesproj3_NomStatut"] = "";
			$_SESSION["sort_lesproj3_nomsecteur"] = "";
			$_SESSION["sort_lesproj3_nb"] = "";
		}

	// Check for an Order parameter
	} elseif (strlen(@$_GET[EW_REPORT_TABLE_ORDER_BY]) > 0) {
		$sSortSql = "";
		$sSortField = "";
		$sOrder = @$_GET[EW_REPORT_TABLE_ORDER_BY];
		if (strlen(@$_GET[EW_REPORT_TABLE_ORDER_BY_TYPE]) > 0) {
			$sOrderType = @$_GET[EW_REPORT_TABLE_ORDER_BY_TYPE];
		} else {
			$sOrderType = "";
		}
	}
	return @$_SESSION[EW_REPORT_TABLE_SESSION_ORDER_BY];
}
?>
