<?php

// Menu
define("EW_MENUBAR_VERTICAL_CLASSNAME", "MenuBarVertical", TRUE);
define("EW_MENUBAR_SUBMENU_CLASSNAME", "MenuBarItemSubmenu", TRUE);
define("EW_MENUBAR_RIGHTHOVER_IMAGE", "images/SpryMenuBarRightHover.gif", TRUE);
?>
<?php
define("EW_SESSION_MENU_AR_USER_LEVEL_PRIV", "prima_dev_v2_arUserLevelPriv", TRUE); // User Level Privilege Array
define("EW_SESSION_MENU_USER_LEVEL", "prima_dev_v2_status_UserLevelValue", TRUE); // User level value
define("EW_MENU_ALLOW_ADMIN", 16, TRUE);

// Restore user level privilege
if (is_array(@$_SESSION[EW_SESSION_MENU_AR_USER_LEVEL_PRIV]))
	$arMenuUserLevelPriv = $_SESSION[EW_SESSION_MENU_AR_USER_LEVEL_PRIV];

// Check if menu item is allowed for current user level
function AllowListMenu($TableName) {
	global $arMenuUserLevelPriv;
	$userlevellist = "";
	if (function_exists("CurrentUserLevelList"))
		$userlevellist = CurrentUserLevelList(); // Get user level id list
	if (strval($userlevellist) == "") // Not defined, just get user level
		$userlevellist = CurrentUserLevel();
	if (IsLoggedIn()) {
		if (IsListItem($userlevellist, "-1")) {
			return TRUE;
		} else {
			$priv = 0;
			if (is_array($arMenuUserLevelPriv)) {
				foreach ($arMenuUserLevelPriv as $row) {
					if (strval($row[0]) == strval($TableName) &&
						IsListItem($userlevellist, $row[1])) {
						$thispriv = $row[2];
						if (is_null($thispriv)) $thispriv = 0;
						$thispriv = intval($thispriv);
						$priv = $priv | $thispriv;
					}
				}
			}
			return ($priv & 8);
		}
	} else {
		return FALSE;
	}
}

// Is list item
function IsListItem($list, $item) {
	if ($list == "") {
		return FALSE;
	} else {
		$ar = explode(",", $list);
		foreach ($ar as $level) {
			if (trim(strval($item)) == trim(strval($level)))
				return TRUE;
		}
		return FALSE;
	}
}

/**
 * Menu class
 */

class cMenu {
	var $Id;
	var $IsRoot = FALSE;
	var $NoItem = NULL;
	var $ItemData = array();

	function cMenu($id) {
		$this->Id = $id;
	}

	// Add a menu item
	function AddMenuItem($id, $text, $url, $parentid, $src, $allowed = TRUE) {
		$item = new cMenuItem($id, $text, $url, $parentid, $src, $allowed);
		if (!MenuItem_Adding($item)) return;
		if ($item->ParentId < 0) {
			$this->AddItem($item);
		} else {
			if ($oParentMenu =& $this->FindItem($item->ParentId))
				$oParentMenu->AddItem($item);
		}
	}

	// Add item to internal array
	function AddItem($item) {
		$this->ItemData[] = $item;
	}

	// Find item
	function &FindItem($id) {
		$cnt = count($this->ItemData);
		for ($i = 0; $i < $cnt; $i++) {
			$item =& $this->ItemData[$i];
			if ($item->Id == $id) {
				return $item;
			} elseif (!is_null($item->SubMenu)) {
				if ($subitem =& $item->SubMenu->FindItem($id))
					return $subitem;
			}
		}
		return $this->NoItem;
	}

	// Check if a menu item should be shown
	function RenderItem($item) {
		if (!is_null($item->SubMenu)) {
			foreach ($item->SubMenu->ItemData as $subitem) {
				if ($item->SubMenu->RenderItem($subitem))
					return TRUE;
			}
		}
		return ($item->Allowed && $item->Url <> "");
	}

	// Check if this menu should be rendered
	function RenderMenu() {
		foreach ($this->ItemData as $item) {
			if ($this->RenderItem($item))
				return TRUE;
		}
		return FALSE;
	}

	// Render the menu
	function Render() {
		if (!$this->RenderMenu())
			return;
		echo "<ul";
		if ($this->Id <> "") {
			if (is_numeric($this->Id)) {
				echo " id=\"menu_" . $this->Id . "\"";
			} else {
				echo " id=\"" . $this->Id . "\"";
			}
		}
		if ($this->IsRoot)
			echo " class=\"" . EW_MENUBAR_VERTICAL_CLASSNAME . "\"";
		echo ">\n";
		foreach ($this->ItemData as $item) {
			if ($this->RenderItem($item)) {
				echo "<li><a";
				if (!is_null($item->SubMenu) && $item->SubMenu->RenderMenu())
					echo " class=\"" . EW_MENUBAR_SUBMENU_CLASSNAME . "\"";
				if ($item->Url <> "")
				if ($item->Url == "Crosstab1ctbreport.php") echo " href=\"" . htmlspecialchars(strval($item->Url)) . "\" class=\"iframe\" ";
				else echo " href=\"" . htmlspecialchars(strval($item->Url)) . "\"";
				echo ">" . $item->Text . "</a>\n";
				if (!is_null($item->SubMenu))
					$item->SubMenu->Render();
				echo "</li>\n";
			}
		}
		echo "</ul>\n";
	}
}

// Menu item class
class cMenuItem {
	var $Id;
	var $Text;
	var $Url;
	var $ParentId; 
	var $SubMenu = NULL; // Data type = cMenu
	var $Source;
	var $Allowed = TRUE;

	function cMenuItem($id, $text, $url, $parentid, $src, $allowed) {
		$this->Id = $id;
		$this->Text = $text;
		$this->Url = $url;
		$this->ParentId = $parentid;
		$this->Source = $src;
		$this->Allowed = $allowed;
	}

	function AddItem($item) { // Add submenu item
		if (is_null($this->SubMenu))
			$this->SubMenu = new cMenu($this->Id);
		$this->SubMenu->AddItem($item);
	}
}

// MenuItem Adding event
function MenuItem_Adding(&$Item) {

	//var_dump($Item);
	// Return FALSE if menu item not allowed

	return TRUE;
}
?>
<!-- Begin Main Menu -->
<div class="phpmaker">
<?php

// Generate all menu items
$RootMenu = new cMenu("RootMenu");
$RootMenu->IsRoot = TRUE;
$RootMenu->AddMenuItem(44, "<IMG SRC=\"images/finance.jpg\" WIDTH=\"24\" HEIGHT=\"24\" hspace=\"2\" align=\"middle\">FINANCEMENT", "", -1, "");
$RootMenu->AddMenuItem(1, "Bailleur ", "bailleurslist_admin.php", 44, "", AllowListMenu('bailleurs'));
$RootMenu->AddMenuItem(2, "Programme", "programmelist_admin.php", 44, "", AllowListMenu('programme'));
$RootMenu->AddMenuItem(38, "Mes Programmes", "lesprogslist_admin.php", 44, "", AllowListMenu('lesprogs'));
$RootMenu->AddMenuItem(40, "Programmation", "meffbplist_admin.php", 44, "", AllowListMenu('meffbp'));
$RootMenu->AddMenuItem(3, "Programmation", "fbplist_admin.php?cmd=resetall", 44, "", AllowListMenu('fbp'));
$RootMenu->AddMenuItem(45, "<img src=\"images/haiti3.gif\" WIDTH=\"40\" HEIGHT=\"22\" hspace=\"2\" align=\"middle\"> LOCALISATION", "", -1, "");
$RootMenu->AddMenuItem(4, "Dpartement", "departementlist_admin.php", 45, "", AllowListMenu('departement'));
$RootMenu->AddMenuItem(34, "Dpartement", "mefdeplist_admin.php", 45, "", AllowListMenu('mefdep'));
$RootMenu->AddMenuItem(32, "Dpartement", "departlist_admin.php", 45, "", AllowListMenu('depart'));
$RootMenu->AddMenuItem(5, "Commune", "communelist_admin.php?cmd=resetall", 45, "", AllowListMenu('commune'));
$RootMenu->AddMenuItem(35, "Commune", "mefcomlist_admin.php?cmd=resetall", 45, "", AllowListMenu('mefcom'));
$RootMenu->AddMenuItem(33, "Commune", "comlist_admin.php?cmd=resetall", 45, "", AllowListMenu('com'));
$RootMenu->AddMenuItem(6, "Ville/Quartier/Section", "sectionlist_admin.php?cmd=resetall", 45, "", AllowListMenu('section'));
$RootMenu->AddMenuItem(36, "Ville/Quartier/Section", "mefsectionlist_admin.php?cmd=resetall", 45, "", AllowListMenu('mefsection'));
$RootMenu->AddMenuItem(50, "New Menu Item", "", 45, "");
$RootMenu->AddMenuItem(46, "<IMG SRC=\"images/Investismnt.jpg\" WIDTH=\"24\" HEIGHT=\"24\" hspace=\"2\" align=\"middle\" > INVESTISSEMENT", "", -1, "");
$RootMenu->AddMenuItem(18, "Projets financs", "LesProjetslist_admin.php?cmd=resetall", 46, "", AllowListMenu('LesProjets'));
$RootMenu->AddMenuItem(19, "Projets financs", "mefLesProjetslist_admin.php?cmd=resetall", 46, "", AllowListMenu('mefLesProjets'));
$RootMenu->AddMenuItem(7, "Organisme Responsable", "entiteslist_admin.php", 46, "", AllowListMenu('entites'));
$RootMenu->AddMenuItem(8, "Secteurs touchs", "secteurslist_admin.php", 46, "", AllowListMenu('secteurs'));
$RootMenu->AddMenuItem(15, "Statut", "statutlist_admin.php", 46, "", AllowListMenu('statut'));
$RootMenu->AddMenuItem(47, "<IMG SRC=\"images/us_stat.png\" WIDTH=\"24\" HEIGHT=\"16\" align=\"middle\" > RAPPORTS", "", -1, "");
$RootMenu->AddMenuItem(20, "Projets par secteur", "projbysecteurlist_admin.php", 47, "", AllowListMenu('projbysecteur'));
$RootMenu->AddMenuItem(21, "Projets par secteur", "mefprojbysecteurlist_admin.php", 47, "", AllowListMenu('mefprojbysecteur'));
$RootMenu->AddMenuItem(22, "Projets par dpartement", "projbydeplist_admin.php", 47, "", AllowListMenu('projbydep'));
$RootMenu->AddMenuItem(23, "Projets par dpartement", "mefprojbydeplist_admin.php", 47, "", AllowListMenu('mefprojbydep'));
$RootMenu->AddMenuItem(24, "Projets par commune", "projetbycomlist_admin.php", 47, "", AllowListMenu('projetbycom'));
$RootMenu->AddMenuItem(25, "Projets par commune", "mefprojetbycomlist_admin.php", 47, "", AllowListMenu('mefprojetbycom'));
$RootMenu->AddMenuItem(26, "Montant engag par hab et km2", "repartionbyhbtantlist_admin.php", 47, "", AllowListMenu('repartionbyhbtant'));
$RootMenu->AddMenuItem(27, "Montant dcaiss par hab et km2", "repartbysuperficielist_admin.php", 47, "", AllowListMenu('repartbysuperficie'));
$RootMenu->AddMenuItem(29, "Montant engag par hab et km2", "mefrepartionbyhbtantlist_admin.php", 47, "", AllowListMenu('mefrepartionbyhbtant'));
$RootMenu->AddMenuItem(30, "Montant dcaiss par hab et km2", "mefrepartbysuperficielist_admin.php", 47, "", AllowListMenu('mefrepartbysuperficie'));
$RootMenu->AddMenuItem(28, "Projets par statut", "rstatutlist_admin.php", 47, "", AllowListMenu('rstatut'));
$RootMenu->AddMenuItem(31, "Projets par statut", "mefrstatutlist_admin.php", 47, "", AllowListMenu('mefrstatut'));
$RootMenu->AddMenuItem(39, "finanbp", "finanbplist_admin.php", 47, "", AllowListMenu('finanbp'));
$RootMenu->AddMenuItem(42, "Projets par bailleur", "Report2report_admin.php", 47, "", AllowListMenu('Report2'));
$RootMenu->AddMenuItem(10025, "<img src=\"images/marks22.png\" WIDTH=\"24\" HEIGHT=\"24\" hspace=\"2\" align=\"middle\" >PROJET EN IMAGES", "", -1, "");
$RootMenu->AddMenuItem(10024, "Photo projet", "modulephotolist_admin.php", 10025, "", AllowListMenu('modulephoto'));
$RootMenu->AddMenuItem(49, "<img src=\"images/graph.gif\" WIDTH=\"24\" HEIGHT=\"24\" hspace=\"2\"  align=\"middle\" >GRAPHIQUES", "", -1, "");
$RootMenu->AddMenuItem(10018, "Dpartement ", "lesproj1rptreport.php", 49, "PHPReportMaker", AllowListMenu('||PHPReportMaker||lesproj1'));
$RootMenu->AddMenuItem(10019, "Secteur ", "lesproj2rptreport.php", 49, "PHPReportMaker", AllowListMenu('||PHPReportMaker||lesproj2'));
$RootMenu->AddMenuItem(10020, "Statut ", "lesproj3rptreport.php", 49, "PHPReportMaker", AllowListMenu('||PHPReportMaker||lesproj3'));
$RootMenu->AddMenuItem(10023, "Engagement par anne", "Crosstab1ctbreport.php", 49, "PHPReportMaker", AllowListMenu('||PHPReportMaker||Crosstab1'));
$RootMenu->AddMenuItem(48, "<img src=\"images/graph.gif\" WIDTH=\"24\" HEIGHT=\"24\" hspace=\"2\" align=\"middle\" >ADMIN & CONNEXION", "", -1, "");
$RootMenu->AddMenuItem(10, "Gestion projets", "projetslist_admin.php", 48, "", AllowListMenu('projets'));
$RootMenu->AddMenuItem(12, "userlevelpermissions", "userlevelpermissionslist_admin.php", 48, "", (@$_SESSION[EW_SESSION_MENU_USER_LEVEL] & EW_MENU_ALLOW_ADMIN) == EW_MENU_ALLOW_ADMIN);
$RootMenu->AddMenuItem(13, "userlevels", "userlevelslist_admin.php", 48, "", (@$_SESSION[EW_SESSION_MENU_USER_LEVEL] & EW_MENU_ALLOW_ADMIN) == EW_MENU_ALLOW_ADMIN);
$RootMenu->AddMenuItem(14, "usermis", "usermislist_admin.php", 48, "", AllowListMenu('usermis'));
$RootMenu->AddMenuItem(0xFFFFFFFF, "<img src=\"images/logout.gif\" WIDTH=\"16\" HEIGHT=\"16\" hspace=\"2\">LOGOUT", "logout_admin.php", -1, "", IsLoggedIn());
$RootMenu->AddMenuItem(0xFFFFFFFF, "<img src=\"images/login.png\" WIDTH=\"26\" HEIGHT=\"26\" hspace=\"2\" align=\"middle\" >LOGIN", "login_admin.php", -1, "", !IsLoggedIn() && substr(@$_SERVER["URL"], -1 * strlen("login_admin.php")) <> "login_admin.php");
$RootMenu->Render();
?>
</div>
<!-- End Main Menu -->
<script type="text/javascript">
<!--
var RootMenu = new Spry.Widget.MenuBar("RootMenu", {imgRight: "<?php echo EW_MENUBAR_RIGHTHOVER_IMAGE ?>"}); // Main menu 

//-->
</script>
