<?php
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "fbpinfo_admin.php" ?>
<?php include "bailleursinfo_admin.php" ?>
<?php include "programmeinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Define page object
$fbp_delete = new cfbp_delete();
$Page =& $fbp_delete;

// Page init processing
$fbp_delete->Page_Init();

// Page main processing
$fbp_delete->Page_Main();
?>
<?php include "header_admin.php" ?>
<script type="text/javascript">
<!--

// Create page object
var fbp_delete = new ew_Page("fbp_delete");

// page properties
fbp_delete.PageID = "delete"; // page ID
var EW_PAGE_ID = fbp_delete.PageID; // for backward compatibility

// extend page with Form_CustomValidate function
fbp_delete.Form_CustomValidate =  
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
<?php if (EW_CLIENT_VALIDATE) { ?>
fbp_delete.ValidateRequired = true; // uses JavaScript validation
<?php } else { ?>
fbp_delete.ValidateRequired = false; // no JavaScript validation
<?php } ?>

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your client script here, no need to add script tags.
// To include another .js script, use:
// ew_ClientScriptInclude("my_javascript.js"); 
//-->

</script>
<?php

// Load records for display
$rs = $fbp_delete->LoadRecordset();
$fbp_deletelTotalRecs = $rs->RecordCount(); // Get record count
if ($fbp_deletelTotalRecs <= 0) { // No record found, exit
	$rs->Close();
	$fbp_delete->Page_Terminate("fbplist_admin.php"); // Return to list
}
?>
<p><span class="phpmaker">Delete From TABLE: Financement<br><br>
<a href="<?php echo $fbp->getReturnUrl() ?>">Go Back</a></span></p>
<?php $fbp_delete->ShowMessage() ?>
<form action="<?php echo ew_CurrentPage() ?>" method="post">
<p>
<input type="hidden" name="t" id="t" value="fbp">
<input type="hidden" name="a_delete" id="a_delete" value="D">
<?php foreach ($fbp_delete->arRecKeys as $key) { ?>
<input type="hidden" name="key_m[]" id="key_m[]" value="<?php echo ew_HtmlEncode($key) ?>">
<?php } ?>
<table class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable ewTableSeparate">
<?php echo $fbp->TableCustomInnerHtml ?>
	<thead>
	<tr class="ewTableHeader">
		<td valign="top">Bailleur</td>
		<td valign="top">Programme</td>
		<td valign="top">Montant programm</td>
		<td valign="top">Estimation en Gdes</td>
		<td valign="top">Organisme Responsable</td>
	</tr>
	</thead>
	<tbody>
<?php
$fbp_delete->lRecCnt = 0;
$i = 0;
while (!$rs->EOF) {
	$fbp_delete->lRecCnt++;

	// Set row properties
	$fbp->CssClass = "";
	$fbp->CssStyle = "";
	$fbp->RowType = EW_ROWTYPE_VIEW; // View

	// Get the field contents
	$fbp_delete->LoadRowValues($rs);

	// Render row
	$fbp_delete->RenderRow();
?>
	<tr<?php echo $fbp->RowAttributes() ?>>
		<td<?php echo $fbp->bailleur->CellAttributes() ?>>
<div<?php echo $fbp->bailleur->ViewAttributes() ?>><?php echo $fbp->bailleur->ListViewValue() ?></div></td>
		<td<?php echo $fbp->program->CellAttributes() ?>>
<div<?php echo $fbp->program->ViewAttributes() ?>><?php echo $fbp->program->ListViewValue() ?></div></td>
		<td<?php echo $fbp->montantprograme->CellAttributes() ?>>
<div<?php echo $fbp->montantprograme->ViewAttributes() ?>><?php echo $fbp->montantprograme->ListViewValue() ?></div></td>
		<td<?php echo $fbp->montprogramgdes->CellAttributes() ?>>
<div<?php echo $fbp->montprogramgdes->ViewAttributes() ?>><?php echo $fbp->montprogramgdes->ListViewValue() ?></div></td>
		<td<?php echo $fbp->entite->CellAttributes() ?>>
<div<?php echo $fbp->entite->ViewAttributes() ?>><?php echo $fbp->entite->ListViewValue() ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
$rs->Close();
?>
</tbody>
</table>
</div>
</td></tr></table>
<p>
<input type="submit" name="Action" id="Action" value="Confirm Delete">
</form>
<script language="JavaScript" type="text/javascript">
<!--

// Write your table-specific startup script here
// document.write("page loaded");
//-->

</script>
<?php include "footer_admin.php" ?>
<?php
$fbp_delete->Page_Terminate();
?>
<?php

//
// Page Class
//
class cfbp_delete {

	// Page ID
	var $PageID = 'delete';

	// Table Name
	var $TableName = 'fbp';

	// Page Object Name
	var $PageObjName = 'fbp_delete';

	// Page Name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page Url
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		global $fbp;
		if ($fbp->UseTokenInUrl) $PageUrl .= "t=" . $fbp->TableVar . "&"; // add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show Message
	function ShowMessage() {
		if ($this->getMessage() <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $this->getMessage() . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate Page request
	function IsPageRequest() {
		global $objForm, $fbp;
		if ($fbp->UseTokenInUrl) {

			//IsPageRequest = False
			if ($objForm)
				return ($fbp->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($fbp->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	//  Class initialize
	//  - init objects
	//  - open connection
	//
	function cfbp_delete() {
		global $conn;

		// Initialize table object
		$GLOBALS["fbp"] = new cfbp();

		// Initialize other table object
		$GLOBALS['bailleurs'] = new cbailleurs();

		// Initialize other table object
		$GLOBALS['programme'] = new cprogramme();

		// Initialize other table object
		$GLOBALS['usermis'] = new cusermis();

		// Intialize page id (for backward compatibility)
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'delete', TRUE);

		// Initialize table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'fbp', TRUE);

		// Open connection to the database
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $fbp;
		global $Security;
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		if (!$Security->CanDelete()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("fbplist_admin.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();
		if ($Security->IsLoggedIn() && $Security->CurrentUserID() == "") {
			$_SESSION[EW_SESSION_MESSAGE] = "You do not have the right permission to view the page";
			$this->Page_Terminate("fbplist_admin.php");
		}

		// Global page loading event (in userfn6.php)
		Page_Loading();

		// Page load event, used in current page
		$this->Page_Load();
	}

	//
	//  Page_Terminate
	//  - called when exit page
	//  - if URL specified, redirect to the URL
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page unload event, used in current page
		$this->Page_Unload();

		// Global page unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close Connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			ob_end_clean();
			header("Location: $url");
		}
		exit();
	}
	var $lTotalRecs;
	var $lRecCnt;
	var $arRecKeys = array();

	// Page main processing
	function Page_Main() {
		global $fbp;

		// Load Key Parameters
		$sKey = "";
		$bSingleDelete = TRUE; // Initialize as single delete
		$nKeySelected = 0; // Initialize selected key count
		$sFilter = "";
		if (@$_GET["idfbp"] <> "") {
			$fbp->idfbp->setQueryStringValue($_GET["idfbp"]);
			if (!is_numeric($fbp->idfbp->QueryStringValue))
				$this->Page_Terminate("fbplist_admin.php"); // Prevent SQL injection, exit
			$sKey .= $fbp->idfbp->QueryStringValue;
		} else {
			$bSingleDelete = FALSE;
		}
		if ($bSingleDelete) {
			$nKeySelected = 1; // Set up key selected count
			$this->arRecKeys[0] = $sKey;
		} else {
			if (isset($_POST["key_m"])) { // Key in form
				$nKeySelected = count($_POST["key_m"]); // Set up key selected count
				$this->arRecKeys = ew_StripSlashes($_POST["key_m"]);
			}
		}
		if ($nKeySelected <= 0)
			$this->Page_Terminate("fbplist_admin.php"); // No key specified, return to list

		// Build filter
		foreach ($this->arRecKeys as $sKey) {
			$sFilter .= "(";

			// Set up key field
			$sKeyFld = $sKey;
			if (!is_numeric($sKeyFld))
				$this->Page_Terminate("fbplist_admin.php"); // Prevent SQL injection, return to list
			$sFilter .= "`idfbp`=" . ew_AdjustSql($sKeyFld) . " AND ";
			if (substr($sFilter, -5) == " AND ") $sFilter = substr($sFilter, 0, strlen($sFilter)-5) . ") OR ";
		}
		if (substr($sFilter, -4) == " OR ") $sFilter = substr($sFilter, 0, strlen($sFilter)-4);

		// Set up filter (SQL WhHERE clause) and get return SQL
		// SQL constructor in SQL constructor in fbp class, fbpinfo.php

		$fbp->CurrentFilter = $sFilter;

		// Get action
		if (@$_POST["a_delete"] <> "") {
			$fbp->CurrentAction = $_POST["a_delete"];
		} else {
			$fbp->CurrentAction = "I"; // Display record
		}
		switch ($fbp->CurrentAction) {
			case "D": // Delete
				$fbp->SendEmail = TRUE; // Send email on delete success
				if ($this->DeleteRows()) { // delete rows
					$this->setMessage("Delete succeeded"); // Set up success message
					$this->Page_Terminate($fbp->getReturnUrl()); // Return to caller
				}
		}
	}

	//
	//  Function DeleteRows
	//  - Delete Records based on current filter
	//
	function DeleteRows() {
		global $conn, $Security, $fbp;
		$DeleteRows = TRUE;
		$sWrkFilter = $fbp->CurrentFilter;

		// Set up filter (Sql Where Clause) and get Return SQL
		// SQL constructor in fbp class, fbpinfo.php

		$fbp->CurrentFilter = $sWrkFilter;
		$sSql = $fbp->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setMessage("No records found"); // No record found
			$rs->Close();
			return FALSE;
		}
		$conn->BeginTrans();

		// Clone old rows
		$rsold = ($rs) ? $rs->GetRows() : array();
		if ($rs) $rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $fbp->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= EW_COMPOSITE_KEY_SEPARATOR;
				$sThisKey .= $row['idfbp'];
				$conn->raiseErrorFn = 'ew_ErrorFn';
				$DeleteRows = $conn->Execute($fbp->DeleteSQL($row)); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		} else {

			// Set up error message
			if ($fbp->CancelMessage <> "") {
				$this->setMessage($fbp->CancelMessage);
				$fbp->CancelMessage = "";
			} else {
				$this->setMessage("Delete cancelled");
			}
		}
		if ($DeleteRows) {
			$conn->CommitTrans(); // Commit the changes
		} else {
			$conn->RollbackTrans(); // Rollback changes
		}

		// Call recordset deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$fbp->Row_Deleted($row);
			}	
		}
		return $DeleteRows;
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn, $fbp;

		// Call Recordset Selecting event
		$fbp->Recordset_Selecting($fbp->CurrentFilter);

		// Load list page SQL
		$sSql = $fbp->SelectSQL();
		if ($offset > -1 && $rowcnt > -1) $sSql .= " LIMIT $offset, $rowcnt";

		// Load recordset
		$conn->raiseErrorFn = 'ew_ErrorFn';	
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';

		// Call Recordset Selected event
		$fbp->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $fbp;
		$sFilter = $fbp->KeyFilter();

		// Call Row Selecting event
		$fbp->Row_Selecting($sFilter);

		// Load sql based on filter
		$fbp->CurrentFilter = $sFilter;
		$sSql = $fbp->SQL();
		if ($rs = $conn->Execute($sSql)) {
			if ($rs->EOF) {
				$LoadRow = FALSE;
			} else {
				$LoadRow = TRUE;
				$rs->MoveFirst();
				$this->LoadRowValues($rs); // Load row values

				// Call Row Selected event
				$fbp->Row_Selected($rs);
			}
			$rs->Close();
		} else {
			$LoadRow = FALSE;
		}
		return $LoadRow;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $fbp;
		$fbp->idfbp->setDbValue($rs->fields('idfbp'));
		$fbp->bailleur->setDbValue($rs->fields('bailleur'));
		$fbp->program->setDbValue($rs->fields('program'));
		$fbp->montantprograme->setDbValue($rs->fields('montantprograme'));
		$fbp->montprogramgdes->setDbValue($rs->fields('montprogramgdes'));
		$fbp->entite->setDbValue($rs->fields('entite'));
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $fbp;

		// Call Row_Rendering event
		$fbp->Row_Rendering();

		// Common render codes for all row types
		// bailleur

		$fbp->bailleur->CellCssStyle = "";
		$fbp->bailleur->CellCssClass = "";

		// program
		$fbp->program->CellCssStyle = "width: 50px;";
		$fbp->program->CellCssClass = "";

		// montantprograme
		$fbp->montantprograme->CellCssStyle = "";
		$fbp->montantprograme->CellCssClass = "";

		// montprogramgdes
		$fbp->montprogramgdes->CellCssStyle = "";
		$fbp->montprogramgdes->CellCssClass = "";

		// entite
		$fbp->entite->CellCssStyle = "white-space: nowrap;";
		$fbp->entite->CellCssClass = "";
		if ($fbp->RowType == EW_ROWTYPE_VIEW) { // View row

			// bailleur
			if (strval($fbp->bailleur->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `nombailleur` FROM `bailleurs` WHERE `idbailleur` = " . ew_AdjustSql($fbp->bailleur->CurrentValue) . "";
				$sSqlWrk .= " ORDER BY `nombailleur` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$fbp->bailleur->ViewValue = $rswrk->fields('nombailleur');
					$rswrk->Close();
				} else {
					$fbp->bailleur->ViewValue = $fbp->bailleur->CurrentValue;
				}
			} else {
				$fbp->bailleur->ViewValue = NULL;
			}
			$fbp->bailleur->CssStyle = "";
			$fbp->bailleur->CssClass = "";
			$fbp->bailleur->ViewCustomAttributes = "";

			// program
			if (strval($fbp->program->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `sigleprog`, `nomprog` FROM `programme` WHERE `idprog` = " . ew_AdjustSql($fbp->program->CurrentValue) . "";
				$sSqlWrk .= " ORDER BY `nomprog` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$fbp->program->ViewValue = $rswrk->fields('sigleprog');
					$fbp->program->ViewValue .= ew_ValueSeparator(0) . $rswrk->fields('nomprog');
					$rswrk->Close();
				} else {
					$fbp->program->ViewValue = $fbp->program->CurrentValue;
				}
			} else {
				$fbp->program->ViewValue = NULL;
			}
			$fbp->program->CssStyle = "";
			$fbp->program->CssClass = "";
			$fbp->program->ViewCustomAttributes = "";

			// montantprograme
			$fbp->montantprograme->ViewValue = $fbp->montantprograme->CurrentValue;
			$fbp->montantprograme->CssStyle = "";
			$fbp->montantprograme->CssClass = "";
			$fbp->montantprograme->ViewCustomAttributes = "";

			// montprogramgdes
			$fbp->montprogramgdes->ViewValue = $fbp->montprogramgdes->CurrentValue;
			$fbp->montprogramgdes->ViewValue = ew_FormatNumber($fbp->montprogramgdes->ViewValue, 2, -2, -2, -2);
			$fbp->montprogramgdes->CssStyle = "";
			$fbp->montprogramgdes->CssClass = "";
			$fbp->montprogramgdes->ViewCustomAttributes = "";

			// entite
			if (strval($fbp->entite->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `nomentite` FROM `entites` WHERE `identite` = " . ew_AdjustSql($fbp->entite->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$fbp->entite->ViewValue = $rswrk->fields('nomentite');
					$rswrk->Close();
				} else {
					$fbp->entite->ViewValue = $fbp->entite->CurrentValue;
				}
			} else {
				$fbp->entite->ViewValue = NULL;
			}
			$fbp->entite->CssStyle = "";
			$fbp->entite->CssClass = "";
			$fbp->entite->ViewCustomAttributes = "";

			// bailleur
			$fbp->bailleur->HrefValue = "";

			// program
			$fbp->program->HrefValue = "";

			// montantprograme
			$fbp->montantprograme->HrefValue = "";

			// montprogramgdes
			$fbp->montprogramgdes->HrefValue = "";

			// entite
			$fbp->entite->HrefValue = "";
		}

		// Call Row Rendered event
		$fbp->Row_Rendered();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}
}
?>
