<?php
define("EW_PAGE_ID", "preview", TRUE);
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "fbpinfo_admin.php" ?>
<?php include "bailleursinfo_admin.php" ?>
<?php include "programmeinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php

// Init table objects
$fbp = new cfbp();
$bailleurs = new cbailleurs();
$programme = new cprogramme();
$usermis = new cusermis();

// Open connection to the database
$conn = ew_Connect();
$Security = new cAdvancedSecurity();
if (!$Security->IsLoggedIn()) $Security->AutoLogin();
if (!$Security->IsLoggedIn()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->TablePermission_Loading();
$Security->LoadCurrentUserLevel('fbp');
$Security->TablePermission_Loaded();
if (!$Security->IsLoggedIn()) {
	$Security->SaveLastUrl();
	$this->Page_Terminate("login_admin.php");
}
if (!$Security->CanList()) {
	echo "You do not have the right permission to view the page";
	exit();
}
$Security->UserID_Loading();
if ($Security->IsLoggedIn()) $Security->LoadUserID();
$Security->UserID_Loaded();
if ($Security->IsLoggedIn() && $Security->CurrentUserID() == "") {
	echo "You do not have the right permission to view the page";
	exit();
}

// Load filter
$qs = new cQueryString();
$filter = $qs->GetValue("f");
$filter = TEAdecrypt($filter, EW_RANDOM_KEY);
if ($filter == "") $filter = "0=1";

// Load recordset
$rs = $fbp->LoadRs($filter);
$nTotalRecs = ($rs) ? $rs->RecordCount() : 0;
?>
<link href="prima_dev_v2.css" rel="stylesheet" type="text/css">
<p><span class="phpmaker" style="white-space: nowrap;">TABLE: Financement
<?php if ($nTotalRecs > 0) { ?>
(<?php echo $nTotalRecs ?> Records)
<?php } else { ?>
(No records found)
<?php } ?>
</span></p>
<?php if ($nTotalRecs > 0) { ?>
<table cellspacing="0" class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table id="ewDetailsPreviewTable" name="ewDetailsPreviewTable" cellspacing="0" class="ewTable ewTableSeparate">
	<thead><!-- Table header -->
		<tr class="ewTableHeader">
			<td valign="top">Bailleur</td>
			<td valign="top" style="width: 50px;">Programme</td>
			<td valign="top">Montant programm</td>
			<td valign="top">Estimation en Gdes</td>
			<td valign="top" style="white-space: nowrap;">Organisme Responsable</td>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$nRecCount = 0;
while ($rs && !$rs->EOF) {

	// Init row class and style
	$nRecCount++;
	$fbp->CssClass = "ewTableRow";
	$fbp->CssStyle = "";

	// Display alternate color for rows
	if ($nRecCount % 2 <> 1)
		$fbp->CssClass = "ewTableAltRow";
	$fbp->LoadListRowValues($rs);

	// Render row
	$fbp->RowType = EW_ROWTYPE_PREVIEW; // Preview record
	$fbp->RenderListRow();
?>
	<tr<?php echo $fbp->RowAttributes() ?>>
		<!-- bailleur -->
		<td<?php echo $fbp->bailleur->CellAttributes() ?>>
<div<?php echo $fbp->bailleur->ViewAttributes() ?>><?php echo $fbp->bailleur->ViewValue ?></div></td>
		<!-- program -->
		<td style="width: 50px;"<?php echo $fbp->program->CellAttributes() ?>>
<div<?php echo $fbp->program->ViewAttributes() ?>><?php echo $fbp->program->ViewValue ?></div></td>
		<!-- montantprograme -->
		<td<?php echo $fbp->montantprograme->CellAttributes() ?>>
<div<?php echo $fbp->montantprograme->ViewAttributes() ?>><?php echo $fbp->montantprograme->ViewValue ?></div></td>
		<!-- montprogramgdes -->
		<td<?php echo $fbp->montprogramgdes->CellAttributes() ?>>
<div<?php echo $fbp->montprogramgdes->ViewAttributes() ?>><?php echo $fbp->montprogramgdes->ViewValue ?></div></td>
		<!-- entite -->
		<td style="white-space: nowrap;"<?php echo $fbp->entite->CellAttributes() ?>>
<div<?php echo $fbp->entite->ViewAttributes() ?>><?php echo $fbp->entite->ViewValue ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
?>
	</tbody>
</table>
</div>
</td></tr></table>
<?php
if ($rs)
	$rs->Close();
}
$content = ob_get_contents();
ob_end_clean();
echo ew_ConvertToUtf8($content);
?>
