<?php
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Define page object
$default = new cdefault();
$Page =& $default;

// Page init processing
$default->Page_Init();

// Page main processing
$default->Page_Main();
?>
<?php
$default->Page_Terminate();
?>
<?php

//
// Page Class
//
class cdefault {

	// Page ID
	var $PageID = 'default';

	// Page Object Name
	var $PageObjName = 'default';

	// Page Name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page Url
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show Message
	function ShowMessage() {
		if ($this->getMessage() <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $this->getMessage() . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate Page request
	function IsPageRequest() {
		return TRUE;
	}

	//
	//  Class initialize
	//  - init objects
	//  - open connection
	//
	function cdefault() {
		global $conn;

		// Initialize user table object
		$GLOBALS["usermis"] = new cusermis;

		// Intialize page id (for backward compatibility)
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'default', TRUE);

		// Open connection to the database
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $usermis;
		global $Security;
		$Security = new cAdvancedSecurity();

		// Global page loading event (in userfn6.php)
		Page_Loading();

		// Page load event, used in current page
		$this->Page_Load();
	}

	//
	//  Page_Terminate
	//  - called when exit page
	//  - if URL specified, redirect to the URL
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page unload event, used in current page
		$this->Page_Unload();

		// Global page unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close Connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			ob_end_clean();
			header("Location: $url");
		}
		exit();
	}

	// Page main processing
	function Page_Main() {
		global $Security;
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		$Security->LoadUserLevel(); // load User Level
		if ($Security->AllowList('bailleurs')) {
		$this->Page_Terminate("bailleurslist_admin.php"); // Exit and go to default page
		}
		if ($Security->AllowList('programme')) {
			$this->Page_Terminate("programmelist_admin.php");
		}
		if ($Security->AllowList('fbp')) {
			$this->Page_Terminate("fbplist_admin.php");
		}
		if ($Security->AllowList('departement')) {
			$this->Page_Terminate("departementlist_admin.php");
		}
		if ($Security->AllowList('commune')) {
			$this->Page_Terminate("communelist_admin.php");
		}
		if ($Security->AllowList('section')) {
			$this->Page_Terminate("sectionlist_admin.php");
		}
		if ($Security->AllowList('entites')) {
			$this->Page_Terminate("entiteslist_admin.php");
		}
		if ($Security->AllowList('secteurs')) {
			$this->Page_Terminate("secteurslist_admin.php");
		}
		if ($Security->AllowList('projets')) {
			$this->Page_Terminate("projetslist_admin.php");
		}
		if ($Security->AllowList('userlevelpermissions')) {
			$this->Page_Terminate("userlevelpermissionslist_admin.php");
		}
		if ($Security->AllowList('userlevels')) {
			$this->Page_Terminate("userlevelslist_admin.php");
		}
		if ($Security->AllowList('usermis')) {
			$this->Page_Terminate("usermislist_admin.php");
		}
		if ($Security->AllowList('statut')) {
			$this->Page_Terminate("statutlist_admin.php");
		}
		if ($Security->AllowList('photoprojet')) {
			$this->Page_Terminate("photoprojetlist_admin.php");
		}
		if ($Security->AllowList('mefLesProjets')) {
			$this->Page_Terminate("mefLesProjetslist_admin.php");
		}
		if ($Security->AllowList('mefprojbysecteur')) {
			$this->Page_Terminate("mefprojbysecteurlist_admin.php");
		}
		if ($Security->AllowList('mefprojbydep')) {
			$this->Page_Terminate("mefprojbydeplist_admin.php");
		}
		if ($Security->AllowList('mefprojetbycom')) {
			$this->Page_Terminate("mefprojetbycomlist_admin.php");
		}
		if ($Security->AllowList('mefrepartionbyhbtant')) {
			$this->Page_Terminate("mefrepartionbyhbtantlist_admin.php");
		}
		if ($Security->AllowList('mefrepartbysuperficie')) {
			$this->Page_Terminate("mefrepartbysuperficielist_admin.php");
		}
		if ($Security->AllowList('mefrstatut')) {
			$this->Page_Terminate("mefrstatutlist_admin.php");
		}
		if ($Security->AllowList('mefcom')) {
			$this->Page_Terminate("mefcomlist_admin.php");
		}
		if ($Security->AllowList('mefdep')) {
			$this->Page_Terminate("mefdeplist_admin.php");
		}
		if ($Security->AllowList('mefsection')) {
			$this->Page_Terminate("mefsectionlist_admin.php");
		}
		if ($Security->AllowList('meffbp')) {
			$this->Page_Terminate("meffbplist_admin.php");
		}
		if ($Security->AllowList('modulephoto')) {
			$this->Page_Terminate("modulephotolist_admin.php");
		}
		if ($Security->AllowList('LesProjets')) {
			$this->Page_Terminate("LesProjetslist_admin.php");
		}
		if ($Security->AllowList('projbysecteur')) {
			$this->Page_Terminate("projbysecteurlist_admin.php");
		}
		if ($Security->AllowList('projbydep')) {
			$this->Page_Terminate("projbydeplist_admin.php");
		}
		if ($Security->AllowList('projetbycom')) {
			$this->Page_Terminate("projetbycomlist_admin.php");
		}
		if ($Security->AllowList('repartionbyhbtant')) {
			$this->Page_Terminate("repartionbyhbtantlist_admin.php");
		}
		if ($Security->AllowList('repartbysuperficie')) {
			$this->Page_Terminate("repartbysuperficielist_admin.php");
		}
		if ($Security->AllowList('rstatut')) {
			$this->Page_Terminate("rstatutlist_admin.php");
		}
		if ($Security->AllowList('depart')) {
			$this->Page_Terminate("departlist_admin.php");
		}
		if ($Security->AllowList('com')) {
			$this->Page_Terminate("comlist_admin.php");
		}
		if ($Security->AllowList('lesprogs')) {
			$this->Page_Terminate("lesprogslist_admin.php");
		}
		if ($Security->AllowList('finanbp')) {
			$this->Page_Terminate("finanbplist_admin.php");
		}
		if ($Security->AllowList('Report1')) {
			$this->Page_Terminate("Report1report_admin.php");
		}
		if ($Security->AllowList('Report2')) {
			$this->Page_Terminate("Report2report_admin.php");
		}
		if ($Security->IsLoggedIn()) {
			echo "You do not have the right permission to view the page";
			echo "<br><a href=\"logout_admin.php\">Back to login page</a>";
		} else {
			$this->Page_Terminate("login_admin.php"); // Exit and go to login page
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}
}
?>
