<?php
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "programmeinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Define page object
$programme_addopt = new cprogramme_addopt();
$Page =& $programme_addopt;

// Page init processing
$programme_addopt->Page_Init();

// Page main processing
$programme_addopt->Page_Main();
?>
<?php $programme_addopt->ShowMessage() ?>
<script type="text/javascript">
<!--
var programme_addopt = new ew_Page("programme_addopt");
programme_addopt.ValidateForm = function(fobj) {
	return true; // ignore validation
}

//-->
</script>
<form name="fprogrammeaddopt" id="fprogrammeaddopt" action="programmeaddopt_admin.php" method="post" onsubmit="return programme_addopt.ValidateForm(this);">
<p>
<input type="hidden" name="t" id="t" value="programme">
<input type="hidden" name="a_addopt" id="a_addopt" value="A">
<table class="ewTableAddOpt">
</table>
<p>
<!-- <input type="submit" name="btnAction" id="btnAction" value="    Add    "> -->
</form>
<?php
$programme_addopt->Page_Terminate();
?>
<?php

//
// Page Class
//
class cprogramme_addopt {

	// Page ID
	var $PageID = 'addopt';

	// Table Name
	var $TableName = 'programme';

	// Page Object Name
	var $PageObjName = 'programme_addopt';

	// Page Name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page Url
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		global $programme;
		if ($programme->UseTokenInUrl) $PageUrl .= "t=" . $programme->TableVar . "&"; // add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show Message
	function ShowMessage() {
		if ($this->getMessage() <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $this->getMessage() . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate Page request
	function IsPageRequest() {
		global $objForm, $programme;
		if ($programme->UseTokenInUrl) {

			//IsPageRequest = False
			if ($objForm)
				return ($programme->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($programme->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	//  Class initialize
	//  - init objects
	//  - open connection
	//
	function cprogramme_addopt() {
		global $conn;

		// Initialize table object
		$GLOBALS["programme"] = new cprogramme();

		// Initialize other table object
		$GLOBALS['usermis'] = new cusermis();

		// Intialize page id (for backward compatibility)
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'addopt', TRUE);

		// Initialize table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'programme', TRUE);

		// Open connection to the database
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $programme;
		global $Security;
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("programmelist_admin.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();

		// Global page loading event (in userfn6.php)
		Page_Loading();

		// Page load event, used in current page
		$this->Page_Load();
	}

	//
	//  Page_Terminate
	//  - called when exit page
	//  - if URL specified, redirect to the URL
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page unload event, used in current page
		$this->Page_Unload();

		// Global page unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close Connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			ob_end_clean();
			header("Location: $url");
		}
		exit();
	}

//
// Page main processing
//
	function Page_Main() {
		global $objForm, $gsFormError, $programme;

		// Create form object
		$objForm = new cFormObj();

		// Process form if post back
		if ($objForm->GetValue("a_addopt") <> "") {
			$programme->CurrentAction = $objForm->GetValue("a_addopt"); // Get form action
			$this->LoadFormValues(); // Load form values

			// Validate Form
			if (!$this->ValidateForm()) {
				$programme->CurrentAction = "I"; // Form error, reset action
				$this->setMessage($gsFormError);
			}
		} else { // Not post back
			$programme->CurrentAction = "I"; // Display Blank Record
			$this->LoadDefaultValues(); // Load default values
		}

		// Perform action based on action code
		switch ($programme->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "A": // Add new record
				$programme->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow()) { // Add successful
					$XMLDoc = new cXMLDocument("root");
					$XMLDoc->Encoding = "utf-8";
					$XMLDoc->BeginRow("result");
					$XMLDoc->AddField("x_idprog", strval($programme->idprog->DbValue));
					$XMLDoc->AddField("x_sigleprog", strval($programme->sigleprog->FormValue));
					$XMLDoc->AddField("x_nomprog", strval($programme->nomprog->FormValue));
					$XMLDoc->EndRow();
					ob_end_clean();
					header("Content-Type: text/xml");
					echo $XMLDoc->XML();
					$this->Page_Terminate();
					exit();
				} else {
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Render row
		$programme->RowType = EW_ROWTYPE_ADD; // Render add type
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $programme;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		global $programme;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm, $programme;
		$programme->idprog->setFormValue(ew_ConvertFromUtf8($objForm->GetValue("x_idprog")));
	}

	// Restore form values
	function RestoreFormValues() {
		global $programme;
		$programme->idprog->CurrentValue = ew_ConvertToUtf8($programme->idprog->FormValue);
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $programme;
		$sFilter = $programme->KeyFilter();

		// Call Row Selecting event
		$programme->Row_Selecting($sFilter);

		// Load sql based on filter
		$programme->CurrentFilter = $sFilter;
		$sSql = $programme->SQL();
		if ($rs = $conn->Execute($sSql)) {
			if ($rs->EOF) {
				$LoadRow = FALSE;
			} else {
				$LoadRow = TRUE;
				$rs->MoveFirst();
				$this->LoadRowValues($rs); // Load row values

				// Call Row Selected event
				$programme->Row_Selected($rs);
			}
			$rs->Close();
		} else {
			$LoadRow = FALSE;
		}
		return $LoadRow;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $programme;
		$programme->idprog->setDbValue($rs->fields('idprog'));
		$programme->sigleprog->setDbValue($rs->fields('sigleprog'));
		$programme->nomprog->setDbValue($rs->fields('nomprog'));
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $programme;

		// Call Row_Rendering event
		$programme->Row_Rendering();

		// Common render codes for all row types
		if ($programme->RowType == EW_ROWTYPE_VIEW) { // View row

			// sigleprog
			$programme->sigleprog->ViewValue = $programme->sigleprog->CurrentValue;
			$programme->sigleprog->CssStyle = "";
			$programme->sigleprog->CssClass = "";
			$programme->sigleprog->ViewCustomAttributes = "";

			// nomprog
			$programme->nomprog->ViewValue = $programme->nomprog->CurrentValue;
			$programme->nomprog->CssStyle = "";
			$programme->nomprog->CssClass = "";
			$programme->nomprog->ViewCustomAttributes = "";
		} elseif ($programme->RowType == EW_ROWTYPE_ADD) { // Add row
		}

		// Call Row Rendered event
		$programme->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $gsFormError, $programme;

		// Initialize
		$gsFormError = "";

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $sFormCustomError;
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow() {
		global $conn, $Security, $programme;
		if ($programme->nomprog->CurrentValue <> "") { // Check field with unique index
			$sFilter = "(nomprog = '" . ew_AdjustSql($programme->nomprog->CurrentValue) . "')";
			$rsChk = $programme->LoadRs($sFilter);
			if ($rsChk && !$rsChk->EOF) {
				$sIdxErrMsg = str_replace("%f", "nomprog", "Duplicate value '%v' for unique index '%f'");
				$sIdxErrMsg = str_replace("%v", $programme->nomprog->CurrentValue, $sIdxErrMsg);
				$this->setMessage($sIdxErrMsg);
				$rsChk->Close();
				return FALSE;
			}
		}
		$rsnew = array();

		// Call Row Inserting event
		$bInsertRow = $programme->Row_Inserting($rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$AddRow = $conn->Execute($programme->InsertSQL($rsnew));
			$conn->raiseErrorFn = '';
		} else {
			if ($programme->CancelMessage <> "") {
				$this->setMessage($programme->CancelMessage);
				$programme->CancelMessage = "";
			} else {
				$this->setMessage("Insert cancelled");
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {
			$programme->idprog->setDbValue($conn->Insert_ID());
			$rsnew['idprog'] =& $programme->idprog->DbValue;

			// Call Row Inserted event
			$programme->Row_Inserted($rsnew);
		}
		return $AddRow;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Custom validate event
	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
