<?php
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "projetsinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "finanbpinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Define page object
$projets_view = new cprojets_view();
$Page =& $projets_view;

// Page init processing
$projets_view->Page_Init();

// Page main processing
$projets_view->Page_Main();
?>
<?php include "header_admin.php" ?>
<?php if ($projets->Export == "") { ?>
<script type="text/javascript">
<!--

// Create page object
var projets_view = new ew_Page("projets_view");

// page properties
projets_view.PageID = "view"; // page ID
var EW_PAGE_ID = projets_view.PageID; // for backward compatibility

// extend page with Form_CustomValidate function
projets_view.Form_CustomValidate =  
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
<?php if (EW_CLIENT_VALIDATE) { ?>
projets_view.ValidateRequired = true; // uses JavaScript validation
<?php } else { ?>
projets_view.ValidateRequired = false; // no JavaScript validation
<?php } ?>

// multi page properties
projets_view.MultiPage = new ew_MultiPage();
projets_view.MultiPage.AddElement("x_departement", 1);
projets_view.MultiPage.AddElement("x_commune", 1);
projets_view.MultiPage.AddElement("x_section", 1);
projets_view.MultiPage.AddElement("x_titre", 1);
projets_view.MultiPage.AddElement("x_objectif", 2);
projets_view.MultiPage.AddElement("x_montantproj", 1);
projets_view.MultiPage.AddElement("x_montantdec", 1);
projets_view.MultiPage.AddElement("x_secteur", 1);
projets_view.MultiPage.AddElement("x_idfbp", 1);
projets_view.MultiPage.AddElement("x_bailleur", 1);
projets_view.MultiPage.AddElement("x_program", 1);
projets_view.MultiPage.AddElement("x_statut", 1);
projets_view.MultiPage.AddElement("x_datedebut", 1);
projets_view.MultiPage.AddElement("x_ast", 1);
projets_view.MultiPage.AddElement("x_Realisation", 2);
projets_view.MultiPage.AddElement("x_nbrbd", 1);
projets_view.MultiPage.AddElement("x_nbrec", 1);

//-->
</script>
<style>

	/* styles for details panel */
	.yui-overlay { position:absolute;background:#fff;border:2px solid orange;padding:4px;margin:10px; }
	.yui-overlay .hd { border:1px solid red;padding:5px; }
	.yui-overlay .bd { border:0px solid green;padding:5px; }
	.yui-overlay .ft { border:1px solid blue;padding:5px; }
</style>
<div id="ewDetailsDiv" name="ewDetailsDivDiv" style="visibility:hidden"></div>
<script language="JavaScript" type="text/javascript">
<!--

// YUI container
var ewDetailsDiv;
var ew_AjaxDetailsTimer = null;

// init details div
function ew_InitDetailsDiv() {
	ewDetailsDiv = new YAHOO.widget.Overlay("ewDetailsDiv", { context:null, visible:false} );
	ewDetailsDiv.beforeMoveEvent.subscribe(ew_EnforceConstraints, ewDetailsDiv, true);
	ewDetailsDiv.render();
}

// init details div on window.load
YAHOO.util.Event.addListener(window, "load", ew_InitDetailsDiv);

// show results in details div
var ew_AjaxHandleSuccess = function(o) {
	if (ewDetailsDiv && o.responseText !== undefined) {
		ewDetailsDiv.cfg.applyConfig({context:[o.argument.id,o.argument.elcorner,o.argument.ctxcorner], visible:false}, true);
		ewDetailsDiv.setBody(o.responseText);
		ewDetailsDiv.render();
		ew_SetupTable(document.getElementById("ewDetailsPreviewTable"));
		ewDetailsDiv.show();
	}
}

// show error in details div
var ew_AjaxHandleFailure = function(o) {
	if (ewDetailsDiv && o.responseText != "") {
		ewDetailsDiv.cfg.applyConfig({context:[o.argument.id,o.argument.elcorner,o.argument.ctxcorner], visible:false, constraintoviewport:true}, true);
		ewDetailsDiv.setBody(o.responseText);
		ewDetailsDiv.render();
		ewDetailsDiv.show();
	}
}

// show details div
function ew_AjaxShowDetails(obj, url) {
	if (ew_AjaxDetailsTimer)
		clearTimeout(ew_AjaxDetailsTimer);
	ew_AjaxDetailsTimer = setTimeout(function() { YAHOO.util.Connect.asyncRequest('GET', url, {success: ew_AjaxHandleSuccess , failure: ew_AjaxHandleFailure, argument:{id: obj.id, elcorner: "tl", ctxcorner: "tr"}}) }, 200);
}

// hide details div
function ew_AjaxHideDetails(obj) {
	if (ew_AjaxDetailsTimer)
		clearTimeout(ew_AjaxDetailsTimer);
	if (ewDetailsDiv)
		ewDetailsDiv.hide();
}

// move details div
ew_EnforceConstraints = function(type, args, obj) {
	var pos = args[0];
	var x = pos[0];
	var y = pos[1];
	var offsetHeight = this.element.offsetHeight;
	var offsetWidth = this.element.offsetWidth;
	var viewPortWidth = YAHOO.util.Dom.getViewportWidth();
	var viewPortHeight = YAHOO.util.Dom.getViewportHeight();
	var scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;
	var scrollY = document.documentElement.scrollTop || document.body.scrollTop;
	var topConstraint = scrollY + 10;
	var leftConstraint = scrollX + 10;
	var bottomConstraint = scrollY + viewPortHeight - offsetHeight - 10;
	var rightConstraint = scrollX + viewPortWidth - offsetWidth - 10;

// if (x < leftConstraint) {
// x = leftConstraint;
// } else if (x > rightConstraint) {
// x = rightConstraint;
// }

	if (y < topConstraint) {
		y = topConstraint;
	} else if (y > bottomConstraint) {
		y = (bottomConstraint < topConstraint) ? topConstraint : bottomConstraint;
	}

// this.cfg.setProperty("x", x, true);
	this.cfg.setProperty("y", y, true);
	this.cfg.setProperty("xy", [x,y], true);
};

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your client script here, no need to add script tags.
// To include another .js script, use:
// ew_ClientScriptInclude("my_javascript.js"); 
//-->

</script>
<?php } ?>
<p><span class="phpmaker">View TABLE: gestion projets
<?php if ($projets->Export == "") { ?>
&nbsp;&nbsp;<a href="<?php echo $projets_view->PageUrl() ?>export=print&idprojet=<?php echo ew_HtmlEncode($projets->idprojet->CurrentValue) ?>"><img src='images/print.gif' alt='Printer Friendly' title='Printer Friendly' width='16' height='16' border='0'></a>
&nbsp;&nbsp;<a href="<?php echo $projets_view->PageUrl() ?>export=html&idprojet=<?php echo ew_HtmlEncode($projets->idprojet->CurrentValue) ?>"><img src='images/exporthtml.gif' alt='Export to HTML' title='Export to HTML' width='16' height='16' border='0'></a>
&nbsp;&nbsp;<a href="<?php echo $projets_view->PageUrl() ?>export=excel&idprojet=<?php echo ew_HtmlEncode($projets->idprojet->CurrentValue) ?>"><img src='images/exportxls.gif' alt='Export to Excel' title='Export to Excel' width='16' height='16' border='0'></a>
&nbsp;&nbsp;<a href="<?php echo $projets_view->PageUrl() ?>export=word&idprojet=<?php echo ew_HtmlEncode($projets->idprojet->CurrentValue) ?>"><img src='images/exportdoc.gif' alt='Export to Word' title='Export to Word' width='16' height='16' border='0'></a>
<?php } ?>
<br><br>
<?php if ($projets->Export == "") { ?>
<a href="projetslist_admin.php">Back to List</a>&nbsp;
<?php if ($Security->CanAdd()) { ?>
<?php if ($projets_view->ShowOptionLink()) { ?>
<a href="<?php echo $projets->AddUrl() ?>">Add</a>&nbsp;
<?php } ?>
<?php } ?>
<?php if ($Security->CanEdit()) { ?>
<?php if ($projets_view->ShowOptionLink()) { ?>
<a href="<?php echo $projets->EditUrl() ?>">Edit</a>&nbsp;
<?php } ?>
<?php } ?>
<?php if ($Security->CanAdd()) { ?>
<?php if ($projets_view->ShowOptionLink()) { ?>
<a href="<?php echo $projets->CopyUrl() ?>">Copy</a>&nbsp;
<?php } ?>
<?php } ?>
<?php if ($Security->CanDelete()) { ?>
<?php if ($projets_view->ShowOptionLink()) { ?>
<a href="<?php echo $projets->DeleteUrl() ?>">Delete</a>&nbsp;
<?php } ?>
<?php } ?>
<?php if ($Security->AllowList('photoprojet')) { ?>
<?php if ($projets_view->ShowOptionLink()) { ?>
<?php
$sSqlWrk = "`idproj`=" . ew_AdjustSql($projets->idprojet->CurrentValue) . "";
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
$sSqlWrk = str_replace("'", "\'", $sSqlWrk);
?>
<a name="ew_projets_photoprojet_DetailLink" id="ew_projets_photoprojet_DetailLink" href="photoprojetlist_admin.php?<?php echo EW_TABLE_SHOW_MASTER ?>=projets&idprojet=<?php echo urlencode(strval($projets->idprojet->CurrentValue)) ?>" onmouseover="ew_AjaxShowDetails(this, 'photoprojetpreview_admin.php?f=<?php echo $sSqlWrk ?>')" onmouseout="ew_AjaxHideDetails(this);">Photoprojet...</a>
&nbsp;
<?php } ?>
<?php } ?>
<?php } ?>
</span></p>
<?php $projets_view->ShowMessage() ?>
<p>
<?php if ($projets->Export == "") { ?>
<form name="ewpagerform" id="ewpagerform" class="ewForm" action="<?php echo ew_CurrentPage() ?>">
<table border="0" cellspacing="0" cellpadding="0" class="ewPager">
	<tr>
		<td nowrap>
<?php if (!isset($projets_view->Pager)) $projets_view->Pager = new cPrevNextPager($projets_view->lStartRec, $projets_view->lDisplayRecs, $projets_view->lTotalRecs) ?>
<?php if ($projets_view->Pager->RecordCount > 0) { ?>
	<table border="0" cellspacing="0" cellpadding="0"><tr><td><span class="phpmaker">Page&nbsp;</span></td>
<!--first page button-->
	<?php if ($projets_view->Pager->FirstButton->Enabled) { ?>
	<td><a href="<?php echo $projets_view->PageUrl() ?>start=<?php echo $projets_view->Pager->FirstButton->Start ?>"><img src="images/first.gif" alt="First" width="16" height="16" border="0"></a></td>
	<?php } else { ?>
	<td><img src="images/firstdisab.gif" alt="First" width="16" height="16" border="0"></td>
	<?php } ?>
<!--previous page button-->
	<?php if ($projets_view->Pager->PrevButton->Enabled) { ?>
	<td><a href="<?php echo $projets_view->PageUrl() ?>start=<?php echo $projets_view->Pager->PrevButton->Start ?>"><img src="images/prev.gif" alt="Previous" width="16" height="16" border="0"></a></td>
	<?php } else { ?>
	<td><img src="images/prevdisab.gif" alt="Previous" width="16" height="16" border="0"></td>
	<?php } ?>
<!--current page number-->
	<td><input type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" id="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $projets_view->Pager->CurrentPage ?>" size="4"></td>
<!--next page button-->
	<?php if ($projets_view->Pager->NextButton->Enabled) { ?>
	<td><a href="<?php echo $projets_view->PageUrl() ?>start=<?php echo $projets_view->Pager->NextButton->Start ?>"><img src="images/next.gif" alt="Next" width="16" height="16" border="0"></a></td>	
	<?php } else { ?>
	<td><img src="images/nextdisab.gif" alt="Next" width="16" height="16" border="0"></td>
	<?php } ?>
<!--last page button-->
	<?php if ($projets_view->Pager->LastButton->Enabled) { ?>
	<td><a href="<?php echo $projets_view->PageUrl() ?>start=<?php echo $projets_view->Pager->LastButton->Start ?>"><img src="images/last.gif" alt="Last" width="16" height="16" border="0"></a></td>	
	<?php } else { ?>
	<td><img src="images/lastdisab.gif" alt="Last" width="16" height="16" border="0"></td>
	<?php } ?>
	<td><span class="phpmaker">&nbsp;of <?php echo $projets_view->Pager->PageCount ?></span></td>
	</tr></table>
<?php } else { ?>
	<?php if ($Security->CanList()) { ?>
	<?php if ($projets_view->sSrchWhere == "0=101") { ?>
	<span class="phpmaker">Please enter search criteria</span>
	<?php } else { ?>
	<span class="phpmaker">No records found</span>
	<?php } ?>
	<?php } else { ?>
	<span class="phpmaker">You do not have the right permission to view the page</span>
	<?php } ?>
<?php } ?>
		</td>
	</tr>
</table>
</form>
<br>
<?php } ?>
<?php if ($projets->Export == "") { ?>
<table cellspacing="0" cellpadding="0"><tr><td>
<div id="projets_view" class="yui-navset">
	<ul class="yui-nav">
		<li class="selected"><a href="#tab_projets_1"><em>Page 1</em></a></li>
		<li><a href="#tab_projets_2"><em>Page 2</em></a></li>
	</ul>            
	<div class="yui-content">
<?php } ?>
		<div id="tab_projets_1">
<table cellspacing="0" class="ewGrid" style="width: 100%"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable">
<?php if ($projets->departement->Visible) { // departement ?>
	<tr<?php echo $projets->departement->RowAttributes ?>>
		<td class="ewTableHeader">Dpartement</td>
		<td<?php echo $projets->departement->CellAttributes() ?>>
<div<?php echo $projets->departement->ViewAttributes() ?>><?php echo $projets->departement->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->commune->Visible) { // commune ?>
	<tr<?php echo $projets->commune->RowAttributes ?>>
		<td class="ewTableHeader">Commune</td>
		<td<?php echo $projets->commune->CellAttributes() ?>>
<div<?php echo $projets->commune->ViewAttributes() ?>><?php echo $projets->commune->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->section->Visible) { // section ?>
	<tr<?php echo $projets->section->RowAttributes ?>>
		<td class="ewTableHeader">Ville/Quartier/Section</td>
		<td<?php echo $projets->section->CellAttributes() ?>>
<div<?php echo $projets->section->ViewAttributes() ?>><?php echo $projets->section->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->titre->Visible) { // titre ?>
	<tr<?php echo $projets->titre->RowAttributes ?>>
		<td class="ewTableHeader">Titre</td>
		<td<?php echo $projets->titre->CellAttributes() ?>>
<div<?php echo $projets->titre->ViewAttributes() ?>><?php echo $projets->titre->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->montantproj->Visible) { // montantproj ?>
	<tr<?php echo $projets->montantproj->RowAttributes ?>>
		<td class="ewTableHeader">Montant engag</td>
		<td<?php echo $projets->montantproj->CellAttributes() ?>>
<div<?php echo $projets->montantproj->ViewAttributes() ?>><?php echo $projets->montantproj->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->montantdec->Visible) { // montantdec ?>
	<tr<?php echo $projets->montantdec->RowAttributes ?>>
		<td class="ewTableHeader">Montant dcaiss</td>
		<td<?php echo $projets->montantdec->CellAttributes() ?>>
<div<?php echo $projets->montantdec->ViewAttributes() ?>><?php echo $projets->montantdec->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->entite->Visible) { // entite ?>
	<tr<?php echo $projets->entite->RowAttributes ?>>
		<td class="ewTableHeader">Organisme Responsable</td>
		<td<?php echo $projets->entite->CellAttributes() ?>>
<div<?php echo $projets->entite->ViewAttributes() ?>><?php echo $projets->entite->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->secteur->Visible) { // secteur ?>
	<tr<?php echo $projets->secteur->RowAttributes ?>>
		<td class="ewTableHeader">Secteur</td>
		<td<?php echo $projets->secteur->CellAttributes() ?>>
<div<?php echo $projets->secteur->ViewAttributes() ?>><?php echo $projets->secteur->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->idfbp->Visible) { // idfbp ?>
	<tr<?php echo $projets->idfbp->RowAttributes ?>>
		<td class="ewTableHeader">Programmation</td>
		<td<?php echo $projets->idfbp->CellAttributes() ?>>
<div<?php echo $projets->idfbp->ViewAttributes() ?>><?php echo $projets->idfbp->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->bailleur->Visible) { // bailleur ?>
	<tr<?php echo $projets->bailleur->RowAttributes ?>>
		<td class="ewTableHeader">Bailleur</td>
		<td<?php echo $projets->bailleur->CellAttributes() ?>>
<div<?php echo $projets->bailleur->ViewAttributes() ?>><?php echo $projets->bailleur->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->program->Visible) { // program ?>
	<tr<?php echo $projets->program->RowAttributes ?>>
		<td class="ewTableHeader">Programme</td>
		<td<?php echo $projets->program->CellAttributes() ?>>
<div<?php echo $projets->program->ViewAttributes() ?>><?php echo $projets->program->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->statut->Visible) { // statut ?>
	<tr<?php echo $projets->statut->RowAttributes ?>>
		<td class="ewTableHeader">Statut</td>
		<td<?php echo $projets->statut->CellAttributes() ?>>
<div<?php echo $projets->statut->ViewAttributes() ?>><?php echo $projets->statut->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->datedebut->Visible) { // datedebut ?>
	<tr<?php echo $projets->datedebut->RowAttributes ?>>
		<td class="ewTableHeader">Date de dmarrage</td>
		<td<?php echo $projets->datedebut->CellAttributes() ?>>
<div<?php echo $projets->datedebut->ViewAttributes() ?>><?php echo $projets->datedebut->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->ast->Visible) { // ast ?>
	<tr<?php echo $projets->ast->RowAttributes ?>>
		<td class="ewTableHeader">Autres secteurs touchs</td>
		<td<?php echo $projets->ast->CellAttributes() ?>>
<div<?php echo $projets->ast->ViewAttributes() ?>><?php echo $projets->ast->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->nbrbd->Visible) { // nbrbd ?>
	<tr<?php echo $projets->nbrbd->RowAttributes ?>>
		<td class="ewTableHeader">B&eacute;n&eacute;ficiaires</td>
		<td<?php echo $projets->nbrbd->CellAttributes() ?>>
<div<?php echo $projets->nbrbd->ViewAttributes() ?>><?php echo $projets->nbrbd->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->nbrec->Visible) { // nbrec ?>
	<tr<?php echo $projets->nbrec->RowAttributes ?>>
		<td class="ewTableHeader">Nombre d'emplois cr&eacute;&eacute;s</td>
		<td<?php echo $projets->nbrec->CellAttributes() ?>>
<div<?php echo $projets->nbrec->ViewAttributes() ?>><?php echo $projets->nbrec->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->datemaj->Visible) { // datemaj ?>
	<tr<?php echo $projets->datemaj->RowAttributes ?>>
		<td class="ewTableHeader">Date update</td>
		<td<?php echo $projets->datemaj->CellAttributes() ?>>
<div<?php echo $projets->datemaj->ViewAttributes() ?>><?php echo $projets->datemaj->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->zuserID->Visible) { // userID ?>
	<tr<?php echo $projets->zuserID->RowAttributes ?>>
		<td class="ewTableHeader">Utilisateur</td>
		<td<?php echo $projets->zuserID->CellAttributes() ?>>
<div<?php echo $projets->zuserID->ViewAttributes() ?>><?php echo $projets->zuserID->ViewValue ?></div></td>
	</tr>
<?php } ?>
</table>
</div>
</td></tr></table>
		</div>
		<div id="tab_projets_2">
<table cellspacing="0" class="ewGrid" style="width: 100%"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable">
<?php if ($projets->objectif->Visible) { // objectif ?>
	<tr<?php echo $projets->objectif->RowAttributes ?>>
		<td class="ewTableHeader">Objectif(s)</td>
		<td<?php echo $projets->objectif->CellAttributes() ?>>
<div<?php echo $projets->objectif->ViewAttributes() ?>><?php echo $projets->objectif->ViewValue ?></div></td>
	</tr>
<?php } ?>
<?php if ($projets->Realisation->Visible) { // Realisation ?>
	<tr<?php echo $projets->Realisation->RowAttributes ?>>
		<td class="ewTableHeader">R&eacute;alisations</td>
		<td<?php echo $projets->Realisation->CellAttributes() ?>>
<div<?php echo $projets->Realisation->ViewAttributes() ?>><?php echo $projets->Realisation->ViewValue ?></div></td>
	</tr>
<?php } ?>
</table>
</div>
</td></tr></table>
		</div>
<?php if ($projets->Export == "") { ?>
	</div>
</div>
</td></tr></table>
<?php } ?>
<?php if ($projets->Export == "") { ?>
<script type="text/javascript">
<!--
projets_view.TabView = new ewWidget.TabView("projets_view");			
projets_view.TabView.subscribe("activeTabChange", function(e) {
	if (projets_view.MultiPage) {
		var i = projets_view.TabView.getTabIndex(e.newValue) + 1;
		projets_view.MultiPage.GotoPageByIndex(i);
	}
});
projets_view.TabView.subscribe("contentReady", function(e) {
	if (projets_view.MultiPage) {
		projets_view.MultiPage.Init(); // Multi-page initialization
		projets_view.MultiPage.TabView = projets_view.TabView;
		projets_view.MultiPage.SubmitButton = document.getElementById("btnAction");
		var i = projets_view.TabView.get("activeIndex") + 1;
		projets_view.MultiPage.GotoPageByIndex(i);
	}
});

//-->
</script>
<?php } ?>
<?php if ($projets->Export == "") { ?>
<br>
<form name="ewpagerform" id="ewpagerform" class="ewForm" action="<?php echo ew_CurrentPage() ?>">
<table border="0" cellspacing="0" cellpadding="0" class="ewPager">
	<tr>
		<td nowrap>
<?php if (!isset($projets_view->Pager)) $projets_view->Pager = new cPrevNextPager($projets_view->lStartRec, $projets_view->lDisplayRecs, $projets_view->lTotalRecs) ?>
<?php if ($projets_view->Pager->RecordCount > 0) { ?>
	<table border="0" cellspacing="0" cellpadding="0"><tr><td><span class="phpmaker">Page&nbsp;</span></td>
<!--first page button-->
	<?php if ($projets_view->Pager->FirstButton->Enabled) { ?>
	<td><a href="<?php echo $projets_view->PageUrl() ?>start=<?php echo $projets_view->Pager->FirstButton->Start ?>"><img src="images/first.gif" alt="First" width="16" height="16" border="0"></a></td>
	<?php } else { ?>
	<td><img src="images/firstdisab.gif" alt="First" width="16" height="16" border="0"></td>
	<?php } ?>
<!--previous page button-->
	<?php if ($projets_view->Pager->PrevButton->Enabled) { ?>
	<td><a href="<?php echo $projets_view->PageUrl() ?>start=<?php echo $projets_view->Pager->PrevButton->Start ?>"><img src="images/prev.gif" alt="Previous" width="16" height="16" border="0"></a></td>
	<?php } else { ?>
	<td><img src="images/prevdisab.gif" alt="Previous" width="16" height="16" border="0"></td>
	<?php } ?>
<!--current page number-->
	<td><input type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" id="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $projets_view->Pager->CurrentPage ?>" size="4"></td>
<!--next page button-->
	<?php if ($projets_view->Pager->NextButton->Enabled) { ?>
	<td><a href="<?php echo $projets_view->PageUrl() ?>start=<?php echo $projets_view->Pager->NextButton->Start ?>"><img src="images/next.gif" alt="Next" width="16" height="16" border="0"></a></td>	
	<?php } else { ?>
	<td><img src="images/nextdisab.gif" alt="Next" width="16" height="16" border="0"></td>
	<?php } ?>
<!--last page button-->
	<?php if ($projets_view->Pager->LastButton->Enabled) { ?>
	<td><a href="<?php echo $projets_view->PageUrl() ?>start=<?php echo $projets_view->Pager->LastButton->Start ?>"><img src="images/last.gif" alt="Last" width="16" height="16" border="0"></a></td>	
	<?php } else { ?>
	<td><img src="images/lastdisab.gif" alt="Last" width="16" height="16" border="0"></td>
	<?php } ?>
	<td><span class="phpmaker">&nbsp;of <?php echo $projets_view->Pager->PageCount ?></span></td>
	</tr></table>
<?php } else { ?>
	<?php if ($Security->CanList()) { ?>
	<?php if ($projets_view->sSrchWhere == "0=101") { ?>
	<span class="phpmaker">Please enter search criteria</span>
	<?php } else { ?>
	<span class="phpmaker">No records found</span>
	<?php } ?>
	<?php } else { ?>
	<span class="phpmaker">You do not have the right permission to view the page</span>
	<?php } ?>
<?php } ?>
		</td>
	</tr>
</table>
</form>
<?php } ?>
<p>
<?php if ($projets->Export == "") { ?>
<script language="JavaScript" type="text/javascript">
<!--

// Write your table-specific startup script here
// document.write("page loaded");
//-->

</script>
<?php } ?>
<?php include "footer_admin.php" ?>
<?php
$projets_view->Page_Terminate();
?>
<?php

//
// Page Class
//
class cprojets_view {

	// Page ID
	var $PageID = 'view';

	// Table Name
	var $TableName = 'projets';

	// Page Object Name
	var $PageObjName = 'projets_view';

	// Page Name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page Url
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		global $projets;
		if ($projets->UseTokenInUrl) $PageUrl .= "t=" . $projets->TableVar . "&"; // add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show Message
	function ShowMessage() {
		if ($this->getMessage() <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $this->getMessage() . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate Page request
	function IsPageRequest() {
		global $objForm, $projets;
		if ($projets->UseTokenInUrl) {

			//IsPageRequest = False
			if ($objForm)
				return ($projets->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($projets->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	//  Class initialize
	//  - init objects
	//  - open connection
	//
	function cprojets_view() {
		global $conn;

		// Initialize table object
		$GLOBALS["projets"] = new cprojets();

		// Initialize other table object
		$GLOBALS['usermis'] = new cusermis();

		// Initialize other table object
		$GLOBALS['finanbp'] = new cfinanbp();

		// Intialize page id (for backward compatibility)
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Initialize table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'projets', TRUE);

		// Open connection to the database
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $projets;
		global $Security;
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		if (!$Security->CanView()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("projetslist_admin.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();
		if ($Security->IsLoggedIn() && $Security->CurrentUserID() == "") {
			$_SESSION[EW_SESSION_MESSAGE] = "You do not have the right permission to view the page";
			$this->Page_Terminate("projetslist_admin.php");
		}
	$projets->Export = @$_GET["export"]; // Get export parameter
	$gsExport = $projets->Export; // Get export parameter, used in header
	$gsExportFile = $projets->TableVar; // Get export file, used in header
	if (@$_GET["idprojet"] <> "") {
		if ($gsExportFile <> "") $gsExportFile .= "_";
		$gsExportFile .= ew_StripSlashes($_GET["idprojet"]);
	}
	if ($projets->Export == "print" || $projets->Export == "html") {

		// Printer friendly or Export to HTML, no action required
	}
	if ($projets->Export == "excel") {
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment; filename=' . $gsExportFile .'.xls');
	}
	if ($projets->Export == "word") {
		header('Content-Type: application/vnd.ms-word');
		header('Content-Disposition: attachment; filename=' . $gsExportFile .'.doc');
	}

		// Global page loading event (in userfn6.php)
		Page_Loading();

		// Page load event, used in current page
		$this->Page_Load();
	}

	//
	//  Page_Terminate
	//  - called when exit page
	//  - if URL specified, redirect to the URL
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page unload event, used in current page
		$this->Page_Unload();

		// Global page unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close Connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			ob_end_clean();
			header("Location: $url");
		}
		exit();
	}
	var $lDisplayRecs; // Number of display records
	var $lStartRec;
	var $lStopRec;
	var $lTotalRecs;
	var $lRecRange;
	var $lRecCnt;

	//
	// Page main processing
	//
	function Page_Main() {
		global $projets;

		// Paging variables
		$this->lDisplayRecs = 1;
		$this->lRecRange = 10;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["idprojet"] <> "") {
				$projets->idprojet->setQueryStringValue($_GET["idprojet"]);
			} else {
				$bLoadCurrentRecord = TRUE;
			}

			// Get action
			$projets->CurrentAction = "I"; // Display form
			switch ($projets->CurrentAction) {
				case "I": // Get a record to display
					$this->lStartRec = 1; // Initialize start position
					$rs = $this->LoadRecordset(); // Load records
					$this->lTotalRecs = $rs->RecordCount(); // Get record count
					if ($this->lTotalRecs <= 0) { // No record found
						$this->setMessage("No records found"); // Set no record message
						$this->Page_Terminate("projetslist_admin.php"); // Return to list page
					} elseif ($bLoadCurrentRecord) { // Load current record position
						$this->SetUpStartRec(); // Set up start record position

						// Point to current record
						if (intval($this->lStartRec) <= intval($this->lTotalRecs)) {
							$bMatchRecord = TRUE;
							$rs->Move($this->lStartRec-1);
						}
					} else { // Match key values
						while (!$rs->EOF) {
							if (strval($projets->idprojet->CurrentValue) == strval($rs->fields('idprojet'))) {
								$projets->setStartRecordNumber($this->lStartRec); // Save record position
								$bMatchRecord = TRUE;
								break;
							} else {
								$this->lStartRec++;
								$rs->MoveNext();
							}
						}
					}
					if (!$bMatchRecord) {
						$this->setMessage("No records found"); // Set no record message
						$sReturnUrl = "projetslist_admin.php"; // No matching record, return to list
					} else {
						$this->LoadRowValues($rs); // Load row values
					}
			}

			// Export data only
			if ($projets->Export == "html" || $projets->Export == "csv" ||
				$projets->Export == "word" || $projets->Export == "excel" ||
				$projets->Export == "xml") {
				$this->ExportData();
				$this->Page_Terminate(); // Terminate response
				exit();
			}
		} else {
			$sReturnUrl = "projetslist_admin.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$projets->RowType = EW_ROWTYPE_VIEW;
		$this->RenderRow();
	}

	// Set up Starting Record parameters based on Pager Navigation
	function SetUpStartRec() {
		global $projets;
		if ($this->lDisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request			
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->lStartRec = $_GET[EW_TABLE_START_REC];
				$projets->setStartRecordNumber($this->lStartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$this->nPageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($this->nPageNo)) {
					$this->lStartRec = ($this->nPageNo-1)*$this->lDisplayRecs+1;
					if ($this->lStartRec <= 0) {
						$this->lStartRec = 1;
					} elseif ($this->lStartRec >= intval(($this->lTotalRecs-1)/$this->lDisplayRecs)*$this->lDisplayRecs+1) {
						$this->lStartRec = intval(($this->lTotalRecs-1)/$this->lDisplayRecs)*$this->lDisplayRecs+1;
					}
					$projets->setStartRecordNumber($this->lStartRec);
				}
			}
		}
		$this->lStartRec = $projets->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->lStartRec) || $this->lStartRec == "") { // Avoid invalid start record counter
			$this->lStartRec = 1; // Reset start record counter
			$projets->setStartRecordNumber($this->lStartRec);
		} elseif (intval($this->lStartRec) > intval($this->lTotalRecs)) { // Avoid starting record > total records
			$this->lStartRec = intval(($this->lTotalRecs-1)/$this->lDisplayRecs)*$this->lDisplayRecs+1; // Point to last page first record
			$projets->setStartRecordNumber($this->lStartRec);
		} elseif (($this->lStartRec-1) % $this->lDisplayRecs <> 0) {
			$this->lStartRec = intval(($this->lStartRec-1)/$this->lDisplayRecs)*$this->lDisplayRecs+1; // Point to page boundary
			$projets->setStartRecordNumber($this->lStartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn, $projets;

		// Call Recordset Selecting event
		$projets->Recordset_Selecting($projets->CurrentFilter);

		// Load list page SQL
		$sSql = $projets->SelectSQL();
		if ($offset > -1 && $rowcnt > -1) $sSql .= " LIMIT $offset, $rowcnt";

		// Load recordset
		$conn->raiseErrorFn = 'ew_ErrorFn';	
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';

		// Call Recordset Selected event
		$projets->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $projets;
		$sFilter = $projets->KeyFilter();

		// Call Row Selecting event
		$projets->Row_Selecting($sFilter);

		// Load sql based on filter
		$projets->CurrentFilter = $sFilter;
		$sSql = $projets->SQL();
		if ($rs = $conn->Execute($sSql)) {
			if ($rs->EOF) {
				$LoadRow = FALSE;
			} else {
				$LoadRow = TRUE;
				$rs->MoveFirst();
				$this->LoadRowValues($rs); // Load row values

				// Call Row Selected event
				$projets->Row_Selected($rs);
			}
			$rs->Close();
		} else {
			$LoadRow = FALSE;
		}
		return $LoadRow;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $projets;
		$projets->idprojet->setDbValue($rs->fields('idprojet'));
		$projets->departement->setDbValue($rs->fields('departement'));
		$projets->commune->setDbValue($rs->fields('commune'));
		$projets->section->setDbValue($rs->fields('section'));
		$projets->titre->setDbValue($rs->fields('titre'));
		$projets->objectif->setDbValue($rs->fields('objectif'));
		$projets->montantproj->setDbValue($rs->fields('montantproj'));
		$projets->montantdec->setDbValue($rs->fields('montantdec'));
		$projets->entite->setDbValue($rs->fields('entite'));
		$projets->secteur->setDbValue($rs->fields('secteur'));
		$projets->idfbp->setDbValue($rs->fields('idfbp'));
		$projets->bailleur->setDbValue($rs->fields('bailleur'));
		$projets->program->setDbValue($rs->fields('program'));
		$projets->statut->setDbValue($rs->fields('statut'));
		$projets->datedebut->setDbValue($rs->fields('datedebut'));
		$projets->ast->setDbValue($rs->fields('ast'));
		$projets->Realisation->setDbValue($rs->fields('Realisation'));
		$projets->nbrbd->setDbValue($rs->fields('nbrbd'));
		$projets->nbrec->setDbValue($rs->fields('nbrec'));
		$projets->datemaj->setDbValue($rs->fields('datemaj'));
		$projets->zuserID->setDbValue($rs->fields('userID'));
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $projets;

		// Call Row_Rendering event
		$projets->Row_Rendering();

		// Common render codes for all row types
		// departement

		$projets->departement->CellCssStyle = "";
		$projets->departement->CellCssClass = "";

		// commune
		$projets->commune->CellCssStyle = "";
		$projets->commune->CellCssClass = "";

		// section
		$projets->section->CellCssStyle = "";
		$projets->section->CellCssClass = "";

		// titre
		$projets->titre->CellCssStyle = "";
		$projets->titre->CellCssClass = "";

		// objectif
		$projets->objectif->CellCssStyle = "";
		$projets->objectif->CellCssClass = "";

		// montantproj
		$projets->montantproj->CellCssStyle = "";
		$projets->montantproj->CellCssClass = "";

		// montantdec
		$projets->montantdec->CellCssStyle = "";
		$projets->montantdec->CellCssClass = "";

		// entite
		$projets->entite->CellCssStyle = "";
		$projets->entite->CellCssClass = "";

		// secteur
		$projets->secteur->CellCssStyle = "";
		$projets->secteur->CellCssClass = "";

		// idfbp
		$projets->idfbp->CellCssStyle = "";
		$projets->idfbp->CellCssClass = "";

		// bailleur
		$projets->bailleur->CellCssStyle = "";
		$projets->bailleur->CellCssClass = "";

		// program
		$projets->program->CellCssStyle = "";
		$projets->program->CellCssClass = "";

		// statut
		$projets->statut->CellCssStyle = "";
		$projets->statut->CellCssClass = "";

		// datedebut
		$projets->datedebut->CellCssStyle = "";
		$projets->datedebut->CellCssClass = "";

		// ast
		$projets->ast->CellCssStyle = "";
		$projets->ast->CellCssClass = "";

		// Realisation
		$projets->Realisation->CellCssStyle = "";
		$projets->Realisation->CellCssClass = "";

		// nbrbd
		$projets->nbrbd->CellCssStyle = "";
		$projets->nbrbd->CellCssClass = "";

		// nbrec
		$projets->nbrec->CellCssStyle = "";
		$projets->nbrec->CellCssClass = "";

		// datemaj
		$projets->datemaj->CellCssStyle = "";
		$projets->datemaj->CellCssClass = "";

		// userID
		$projets->zuserID->CellCssStyle = "";
		$projets->zuserID->CellCssClass = "";
		if ($projets->RowType == EW_ROWTYPE_VIEW) { // View row

			// departement
			if (strval($projets->departement->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `departemen` FROM `departement` WHERE `ID_Dep` = " . ew_AdjustSql($projets->departement->CurrentValue) . "";
				$sSqlWrk .= " ORDER BY `departemen` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->departement->ViewValue = $rswrk->fields('departemen');
					$rswrk->Close();
				} else {
					$projets->departement->ViewValue = $projets->departement->CurrentValue;
				}
			} else {
				$projets->departement->ViewValue = NULL;
			}
			$projets->departement->CssStyle = "";
			$projets->departement->CssClass = "";
			$projets->departement->ViewCustomAttributes = "";

			// commune
			if (strval($projets->commune->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `Commune` FROM `commune` WHERE `Id_com` = " . ew_AdjustSql($projets->commune->CurrentValue) . "";
				$sSqlWrk .= " ORDER BY `Commune` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->commune->ViewValue = $rswrk->fields('Commune');
					$rswrk->Close();
				} else {
					$projets->commune->ViewValue = $projets->commune->CurrentValue;
				}
			} else {
				$projets->commune->ViewValue = NULL;
			}
			$projets->commune->CssStyle = "";
			$projets->commune->CssClass = "";
			$projets->commune->ViewCustomAttributes = "";

			// section
			if (strval($projets->section->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `vqs` FROM `section` WHERE `id_section` = " . ew_AdjustSql($projets->section->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->section->ViewValue = $rswrk->fields('vqs');
					$rswrk->Close();
				} else {
					$projets->section->ViewValue = $projets->section->CurrentValue;
				}
			} else {
				$projets->section->ViewValue = NULL;
			}
			$projets->section->CssStyle = "";
			$projets->section->CssClass = "";
			$projets->section->ViewCustomAttributes = "";

			// titre
			$projets->titre->ViewValue = $projets->titre->CurrentValue;
			$projets->titre->CssStyle = "";
			$projets->titre->CssClass = "";
			$projets->titre->ViewCustomAttributes = "";

			// objectif
			$projets->objectif->ViewValue = $projets->objectif->CurrentValue;
			$projets->objectif->CssStyle = "";
			$projets->objectif->CssClass = "";
			$projets->objectif->ViewCustomAttributes = "";

			// montantproj
			$projets->montantproj->ViewValue = $projets->montantproj->CurrentValue;
			$projets->montantproj->ViewValue = ew_FormatCurrency($projets->montantproj->ViewValue, 2, -2, -2, -2);
			$projets->montantproj->CssStyle = "";
			$projets->montantproj->CssClass = "";
			$projets->montantproj->ViewCustomAttributes = "";

			// montantdec
			$projets->montantdec->ViewValue = $projets->montantdec->CurrentValue;
			$projets->montantdec->ViewValue = ew_FormatCurrency($projets->montantdec->ViewValue, 2, -2, -2, -2);
			$projets->montantdec->CssStyle = "text-align:left;";
			$projets->montantdec->CssClass = "";
			$projets->montantdec->ViewCustomAttributes = "";

			// entite
			if (strval($projets->entite->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `nomentite` FROM `entites` WHERE `identite` = " . ew_AdjustSql($projets->entite->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->entite->ViewValue = $rswrk->fields('nomentite');
					$rswrk->Close();
				} else {
					$projets->entite->ViewValue = $projets->entite->CurrentValue;
				}
			} else {
				$projets->entite->ViewValue = NULL;
			}
			$projets->entite->CssStyle = "";
			$projets->entite->CssClass = "";
			$projets->entite->ViewCustomAttributes = "";

			// secteur
			if (strval($projets->secteur->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `nomsecteur` FROM `secteurs` WHERE `idsecteur` = " . ew_AdjustSql($projets->secteur->CurrentValue) . "";
				$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->secteur->ViewValue = $rswrk->fields('nomsecteur');
					$rswrk->Close();
				} else {
					$projets->secteur->ViewValue = $projets->secteur->CurrentValue;
				}
			} else {
				$projets->secteur->ViewValue = NULL;
			}
			$projets->secteur->CssStyle = "";
			$projets->secteur->CssClass = "";
			$projets->secteur->ViewCustomAttributes = "";

			// idfbp
			if (strval($projets->idfbp->CurrentValue) <> "") {
				$sSqlWrk = "SELECT DISTINCT Concat(bailleurs.nombailleur, ' ', programme.sigleprog, ' ', fbp.montantprograme) AS `nomfbp` FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog) WHERE fbp.idfbp = " . ew_AdjustSql($projets->idfbp->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->idfbp->ViewValue = $rswrk->fields('nomfbp');
					$rswrk->Close();
				} else {
					$projets->idfbp->ViewValue = $projets->idfbp->CurrentValue;
				}
			} else {
				$projets->idfbp->ViewValue = NULL;
			}
			$projets->idfbp->CssStyle = "";
			$projets->idfbp->CssClass = "";
			$projets->idfbp->ViewCustomAttributes = "";

			// bailleur
			if (strval($projets->bailleur->CurrentValue) <> "") {
				$sSqlWrk = "SELECT bailleurs.nombailleur AS `nombailleur` FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog) WHERE fbp.bailleur = " . ew_AdjustSql($projets->bailleur->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->bailleur->ViewValue = $rswrk->fields('nombailleur');
					$rswrk->Close();
				} else {
					$projets->bailleur->ViewValue = $projets->bailleur->CurrentValue;
				}
			} else {
				$projets->bailleur->ViewValue = NULL;
			}
			$projets->bailleur->CssStyle = "";
			$projets->bailleur->CssClass = "";
			$projets->bailleur->ViewCustomAttributes = "";

			// program
			if (strval($projets->program->CurrentValue) <> "") {
				$sSqlWrk = "SELECT DISTINCT programme.sigleprog AS `sigleprog` FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog) WHERE fbp.program = " . ew_AdjustSql($projets->program->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->program->ViewValue = $rswrk->fields('sigleprog');
					$rswrk->Close();
				} else {
					$projets->program->ViewValue = $projets->program->CurrentValue;
				}
			} else {
				$projets->program->ViewValue = NULL;
			}
			$projets->program->CssStyle = "";
			$projets->program->CssClass = "";
			$projets->program->ViewCustomAttributes = "";

			// statut
			if (strval($projets->statut->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `NomStatut` FROM `statut` WHERE `StatutID` = " . ew_AdjustSql($projets->statut->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->statut->ViewValue = $rswrk->fields('NomStatut');
					$rswrk->Close();
				} else {
					$projets->statut->ViewValue = $projets->statut->CurrentValue;
				}
			} else {
				$projets->statut->ViewValue = NULL;
			}
			$projets->statut->CssStyle = "";
			$projets->statut->CssClass = "";
			$projets->statut->ViewCustomAttributes = "";

			// datedebut
			$projets->datedebut->ViewValue = $projets->datedebut->CurrentValue;
			$projets->datedebut->ViewValue = ew_FormatDateTime($projets->datedebut->ViewValue, 7);
			$projets->datedebut->CssStyle = "";
			$projets->datedebut->CssClass = "";
			$projets->datedebut->ViewCustomAttributes = "";

			// ast
			if (strval($projets->ast->CurrentValue) <> "") {
				$arwrk = explode(",", $projets->ast->CurrentValue);
				$sSqlWrk = "SELECT `nomsecteur` FROM `secteurs` WHERE ";
				$sWhereWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
					$sWhereWrk .= "`idsecteur` = " . ew_AdjustSql(trim($wrk)) . "";
				}
				if ($sWhereWrk <> "") $sSqlWrk .= "(" . $sWhereWrk . ")";
				$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->ast->ViewValue = "";
					$ari = 0;
					while (!$rswrk->EOF) {
						$projets->ast->ViewValue .= $rswrk->fields('nomsecteur');
						$rswrk->MoveNext();
						if (!$rswrk->EOF) $projets->ast->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
						$ari++;
					}
					$rswrk->Close();
				} else {
					$projets->ast->ViewValue = $projets->ast->CurrentValue;
				}
			} else {
				$projets->ast->ViewValue = NULL;
			}
			$projets->ast->CssStyle = "";
			$projets->ast->CssClass = "";
			$projets->ast->ViewCustomAttributes = "";

			// Realisation
			$projets->Realisation->ViewValue = $projets->Realisation->CurrentValue;
			$projets->Realisation->CssStyle = "";
			$projets->Realisation->CssClass = "";
			$projets->Realisation->ViewCustomAttributes = "";

			// nbrbd
			$projets->nbrbd->ViewValue = $projets->nbrbd->CurrentValue;
			$projets->nbrbd->CssStyle = "";
			$projets->nbrbd->CssClass = "";
			$projets->nbrbd->ViewCustomAttributes = "";

			// nbrec
			$projets->nbrec->ViewValue = $projets->nbrec->CurrentValue;
			$projets->nbrec->CssStyle = "";
			$projets->nbrec->CssClass = "";
			$projets->nbrec->ViewCustomAttributes = "";

			// datemaj
			$projets->datemaj->ViewValue = $projets->datemaj->CurrentValue;
			$projets->datemaj->ViewValue = ew_FormatDateTime($projets->datemaj->ViewValue, 7);
			$projets->datemaj->CssStyle = "";
			$projets->datemaj->CssClass = "";
			$projets->datemaj->ViewCustomAttributes = "";

			// userID
			if (strval($projets->zuserID->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `Email` FROM `usermis` WHERE `EmployeeID` = " . ew_AdjustSql($projets->zuserID->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->zuserID->ViewValue = $rswrk->fields('Email');
					$rswrk->Close();
				} else {
					$projets->zuserID->ViewValue = $projets->zuserID->CurrentValue;
				}
			} else {
				$projets->zuserID->ViewValue = NULL;
			}
			$projets->zuserID->CssStyle = "";
			$projets->zuserID->CssClass = "";
			$projets->zuserID->ViewCustomAttributes = "";

			// departement
			$projets->departement->HrefValue = "";

			// commune
			$projets->commune->HrefValue = "";

			// section
			$projets->section->HrefValue = "";

			// titre
			$projets->titre->HrefValue = "";

			// objectif
			$projets->objectif->HrefValue = "";

			// montantproj
			$projets->montantproj->HrefValue = "";

			// montantdec
			$projets->montantdec->HrefValue = "";

			// entite
			$projets->entite->HrefValue = "";

			// secteur
			$projets->secteur->HrefValue = "";

			// idfbp
			$projets->idfbp->HrefValue = "";

			// bailleur
			$projets->bailleur->HrefValue = "";

			// program
			$projets->program->HrefValue = "";

			// statut
			$projets->statut->HrefValue = "";

			// datedebut
			$projets->datedebut->HrefValue = "";

			// ast
			$projets->ast->HrefValue = "";

			// Realisation
			$projets->Realisation->HrefValue = "";

			// nbrbd
			$projets->nbrbd->HrefValue = "";

			// nbrec
			$projets->nbrec->HrefValue = "";

			// datemaj
			$projets->datemaj->HrefValue = "";

			// userID
			$projets->zuserID->HrefValue = "";
		}

		// Call Row Rendered event
		$projets->Row_Rendered();
	}

	// Export data in XML or CSV format
	function ExportData() {
		global $projets;
		$sCsvStr = "";

		// Default export style
		$sExportStyle = "v";

		// Load recordset
		$rs = $this->LoadRecordset();
		$this->lTotalRecs = $rs->RecordCount();
		$this->lStartRec = 1;
			$this->SetUpStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->lDisplayRecs < 0) {
				$this->lStopRec = $this->lTotalRecs;
			} else {
				$this->lStopRec = $this->lStartRec + $this->lDisplayRecs - 1;
			}
		if ($projets->Export == "xml") {
			$XmlDoc = new cXMLDocument();
		} else {
			echo ew_ExportHeader($projets->Export);

			// Horizontal format, write header
			if ($sExportStyle <> "v" || $projets->Export == "csv") {
				$sExportStr = "";
				ew_ExportAddValue($sExportStr, 'departement', $projets->Export);
				ew_ExportAddValue($sExportStr, 'commune', $projets->Export);
				ew_ExportAddValue($sExportStr, 'section', $projets->Export);
				ew_ExportAddValue($sExportStr, 'titre', $projets->Export);
				ew_ExportAddValue($sExportStr, 'montantproj', $projets->Export);
				ew_ExportAddValue($sExportStr, 'montantdec', $projets->Export);
				ew_ExportAddValue($sExportStr, 'entite', $projets->Export);
				ew_ExportAddValue($sExportStr, 'secteur', $projets->Export);
				ew_ExportAddValue($sExportStr, 'idfbp', $projets->Export);
				ew_ExportAddValue($sExportStr, 'bailleur', $projets->Export);
				ew_ExportAddValue($sExportStr, 'program', $projets->Export);
				ew_ExportAddValue($sExportStr, 'statut', $projets->Export);
				ew_ExportAddValue($sExportStr, 'datedebut', $projets->Export);
				ew_ExportAddValue($sExportStr, 'nbrbd', $projets->Export);
				ew_ExportAddValue($sExportStr, 'nbrec', $projets->Export);
				echo ew_ExportLine($sExportStr, $projets->Export);
			}
		}

		// Move to first record
		$this->lRecCnt = $this->lStartRec - 1;
		if (!$rs->EOF) {
			$rs->MoveFirst();
			$rs->Move($this->lStartRec - 1);
		}
		while (!$rs->EOF && $this->lRecCnt < $this->lStopRec) {
			$this->lRecCnt++;
			if (intval($this->lRecCnt) >= intval($this->lStartRec)) {
				$this->LoadRowValues($rs);

				// Render row for display
				$projets->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->RenderRow();
				if ($projets->Export == "xml") {
					$XmlDoc->BeginRow();
					$XmlDoc->AddField('departement', $projets->departement->CurrentValue);
					$XmlDoc->AddField('commune', $projets->commune->CurrentValue);
					$XmlDoc->AddField('section', $projets->section->CurrentValue);
					$XmlDoc->AddField('titre', $projets->titre->CurrentValue);
					$XmlDoc->AddField('montantproj', $projets->montantproj->CurrentValue);
					$XmlDoc->AddField('montantdec', $projets->montantdec->CurrentValue);
					$XmlDoc->AddField('entite', $projets->entite->CurrentValue);
					$XmlDoc->AddField('secteur', $projets->secteur->CurrentValue);
					$XmlDoc->AddField('idfbp', $projets->idfbp->CurrentValue);
					$XmlDoc->AddField('bailleur', $projets->bailleur->CurrentValue);
					$XmlDoc->AddField('program', $projets->program->CurrentValue);
					$XmlDoc->AddField('statut', $projets->statut->CurrentValue);
					$XmlDoc->AddField('datedebut', $projets->datedebut->CurrentValue);
					$XmlDoc->AddField('nbrbd', $projets->nbrbd->CurrentValue);
					$XmlDoc->AddField('nbrec', $projets->nbrec->CurrentValue);
					$XmlDoc->EndRow();
				} else {
					if ($sExportStyle == "v" && $projets->Export <> "csv") { // Vertical format
						echo ew_ExportField('departement', $projets->departement->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('commune', $projets->commune->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('section', $projets->section->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('titre', $projets->titre->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('montantproj', $projets->montantproj->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('montantdec', $projets->montantdec->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('entite', $projets->entite->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('secteur', $projets->secteur->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('idfbp', $projets->idfbp->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('bailleur', $projets->bailleur->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('program', $projets->program->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('statut', $projets->statut->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('datedebut', $projets->datedebut->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('nbrbd', $projets->nbrbd->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportField('nbrec', $projets->nbrec->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
					}	else { // Horizontal format
						$sExportStr = "";
						ew_ExportAddValue($sExportStr, $projets->departement->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->commune->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->section->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->titre->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->montantproj->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->montantdec->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->entite->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->secteur->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->idfbp->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->bailleur->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->program->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->statut->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->datedebut->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->nbrbd->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						ew_ExportAddValue($sExportStr, $projets->nbrec->ExportValue($projets->Export, $projets->ExportOriginalValue), $projets->Export);
						echo ew_ExportLine($sExportStr, $projets->Export);
					}
				}
			}
			$rs->MoveNext();
		}

		// Close recordset
		$rs->Close();
		if ($projets->Export == "xml") {
			header("Content-Type: text/xml");
			echo $XmlDoc->XML();
		} else {
			echo ew_ExportFooter($projets->Export);
		}
	}

	// Show link optionally based on User ID
	function ShowOptionLink() {
		global $Security, $projets;
		if ($Security->IsLoggedIn()) {
			if (!$Security->IsAdmin()) {
				return $Security->IsValidUserID($projets->entite->CurrentValue);
			}
		}
		return TRUE;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}
}
?>
