<?php
session_start(); // Initialize session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg6_admin.php" ?>
<?php include "ewmysql6_admin.php" ?>
<?php include "phpfn6_admin.php" ?>
<?php include "projetsinfo_admin.php" ?>
<?php include "usermisinfo_admin.php" ?>
<?php include "finanbpinfo_admin.php" ?>
<?php include "userfn6_admin.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Define page object
$projets_add = new cprojets_add();
$Page =& $projets_add;

// Page init processing
$projets_add->Page_Init();

// Page main processing
$projets_add->Page_Main();
?>
<?php include "header_admin.php" ?>
<script type="text/javascript">
<!--

// Create page object
var projets_add = new ew_Page("projets_add");

// page properties
projets_add.PageID = "add"; // page ID
var EW_PAGE_ID = projets_add.PageID; // for backward compatibility

// extend page with ValidateForm function
projets_add.ValidateForm = function(fobj) {
	if (!this.ValidateRequired)
		return true; // ignore validation
	if (fobj.a_confirm && fobj.a_confirm.value == "F")
		return true;
	var i, elm, aelm, infix;
	var rowcnt = (fobj.key_count) ? Number(fobj.key_count.value) : 1;
	for (i=0; i<rowcnt; i++) {
		infix = (fobj.key_count) ? String(i+1) : "";
		elm = fobj.elements["x" + infix + "_departement"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Dpartement");
		elm = fobj.elements["x" + infix + "_commune"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Commune");
		elm = fobj.elements["x" + infix + "_section"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Ville/Quartier/Section");
		elm = fobj.elements["x" + infix + "_titre"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Titre");
		elm = fobj.elements["x" + infix + "_montantproj"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Montant engag");
		elm = fobj.elements["x" + infix + "_montantproj"];
		if (elm && !ew_CheckNumber(elm.value))
			return ew_OnError(this, elm, "Incorrect floating point number - Montant engag");
		elm = fobj.elements["x" + infix + "_montantdec"];
		if (elm && !ew_CheckNumber(elm.value))
			return ew_OnError(this, elm, "Incorrect floating point number - Montant dcaiss");
		elm = fobj.elements["x" + infix + "_secteur"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Secteur");
		elm = fobj.elements["x" + infix + "_idfbp"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Programmation");
		elm = fobj.elements["x" + infix + "_bailleur"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Bailleur");
		elm = fobj.elements["x" + infix + "_program"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Programme");
		elm = fobj.elements["x" + infix + "_statut"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Statut");
		elm = fobj.elements["x" + infix + "_datedebut"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, "Please enter required field - Date de dmarrage");
		elm = fobj.elements["x" + infix + "_datedebut"];
		if (elm && !ew_CheckEuroDate(elm.value))
			return ew_OnError(this, elm, "Incorrect date, format = dd/mm/yyyy - Date de dmarrage");
		elm = fobj.elements["x" + infix + "_nbrbd"];
		if (elm && !ew_CheckInteger(elm.value))
			return ew_OnError(this, elm, "Incorrect integer - B&eacute;n&eacute;ficiaires");
		elm = fobj.elements["x" + infix + "_nbrec"];
		if (elm && !ew_CheckInteger(elm.value))
			return ew_OnError(this, elm, "Incorrect integer - Nombre d'emplois cr&eacute;&eacute;s");

		// Call Form Custom Validate event
		if (!this.Form_CustomValidate(fobj)) return false;
	}
	return true;
}

// extend page with Form_CustomValidate function
projets_add.Form_CustomValidate =  
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
<?php if (EW_CLIENT_VALIDATE) { ?>
projets_add.ValidateRequired = true; // uses JavaScript validation
<?php } else { ?>
projets_add.ValidateRequired = false; // no JavaScript validation
<?php } ?>

// multi page properties
projets_add.MultiPage = new ew_MultiPage();
projets_add.MultiPage.AddElement("x_departement", 1);
projets_add.MultiPage.AddElement("x_commune", 1);
projets_add.MultiPage.AddElement("x_section", 1);
projets_add.MultiPage.AddElement("x_titre", 1);
projets_add.MultiPage.AddElement("x_objectif", 2);
projets_add.MultiPage.AddElement("x_montantproj", 1);
projets_add.MultiPage.AddElement("x_montantdec", 1);
projets_add.MultiPage.AddElement("x_secteur", 1);
projets_add.MultiPage.AddElement("x_idfbp", 1);
projets_add.MultiPage.AddElement("x_bailleur", 1);
projets_add.MultiPage.AddElement("x_program", 1);
projets_add.MultiPage.AddElement("x_statut", 1);
projets_add.MultiPage.AddElement("x_datedebut", 1);
projets_add.MultiPage.AddElement("x_ast", 1);
projets_add.MultiPage.AddElement("x_Realisation", 2);
projets_add.MultiPage.AddElement("x_nbrbd", 1);
projets_add.MultiPage.AddElement("x_nbrec", 1);

//-->
</script>
<link rel="stylesheet" type="text/css" media="all" href="calendar/calendar-green.css" title="win2k-1">
<script type="text/javascript" src="calendar/calendar.js"></script>
<script type="text/javascript" src="calendar/lang/calendar-en.js"></script>
<script type="text/javascript" src="calendar/calendar-setup.js"></script>
<script type="text/javascript" src="tiny_mce/tiny_mce.js"></script>
<script type="text/javascript">
<!--
_width_multiplier = 18;
_height_multiplier = 60;
var ew_DHTMLEditors = [];

// update value from editor to textarea
function ew_UpdateTextArea() {
	if (typeof ew_DHTMLEditors != 'undefined') {		
		tinyMCE.triggerSave(true, true);
		for (var n in tinyMCE.instances) {
			var inst = tinyMCE.instances[n];
			if (inst.formElement)
				inst.formElement.value = ew_RemoveSpaces(inst.formElement.value);
		}
	}
}

// update value from textarea to editor
function ew_UpdateDHTMLEditor(name) {
	if (typeof ew_DHTMLEditors != 'undefined') {
		tinyMCE.updateContent(name);
	}
}

// focus editor
function ew_FocusDHTMLEditor(name) {
	if (typeof ew_DHTMLEditors != 'undefined') {
		var inst = tinyMCE.get(name);
		if (inst) {
			inst.focus(false);
		}
	}
}

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your client script here, no need to add script tags.
// To include another .js script, use:
// ew_ClientScriptInclude("my_javascript.js"); 
//-->

</script>
<p><span class="phpmaker">Add to TABLE: gestion projets<br><br>
<a href="<?php echo $projets->getReturnUrl() ?>">Go Back</a></span></p>
<?php $projets_add->ShowMessage() ?>
<form name="fprojetsadd" id="fprojetsadd" action="<?php echo ew_CurrentPage() ?>" method="post">
<p>
<input type="hidden" name="t" id="t" value="projets">
<input type="hidden" name="a_add" id="a_add" value="A">
<?php if ($projets->CurrentAction == "F") { // Confirm page ?>
<input type="hidden" name="a_confirm" id="a_confirm" value="F">
<?php } ?>
<table cellspacing="0" cellpadding="0"><tr><td>
<div id="projets_add" class="yui-navset">
	<ul class="yui-nav">
		<li class="selected"><a href="#tab_projets_1"><em><span class="phpmaker">Page 1</span></em></a></li>
		<li><a href="#tab_projets_2"><em><span class="phpmaker">Page 2</span></em></a></li>
	</ul>
	<div class="yui-content">
		<div id="tab_projets_1">
<table cellspacing="0" class="ewGrid" style="width: 100%"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable">
<?php if ($projets->departement->Visible) { // departement ?>
	<tr<?php echo $projets->departement->RowAttributes ?>>
		<td class="ewTableHeader">Dpartement<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->departement->CellAttributes() ?>><span id="el_departement">
<?php if ($projets->CurrentAction <> "F") { ?>
<select id="x_departement" name="x_departement" onchange="ew_UpdateOpt('x_commune','x_departement',true);"<?php echo $projets->departement->EditAttributes() ?>>
<?php
if (is_array($projets->departement->EditValue)) {
	$arwrk = $projets->departement->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($projets->departement->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT `ID_Dep`, `departemen`, '' AS Disp2Fld FROM `departement`";
$sWhereWrk = "";
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
$sSqlWrk .= " ORDER BY `departemen` Asc";
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_departement" id="s_x_departement" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_departement" id="lft_x_departement" value="">
<?php } else { ?>
<div<?php echo $projets->departement->ViewAttributes() ?>><?php echo $projets->departement->ViewValue ?></div>
<input type="hidden" name="x_departement" id="x_departement" value="<?php echo ew_HtmlEncode($projets->departement->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->departement->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->commune->Visible) { // commune ?>
	<tr<?php echo $projets->commune->RowAttributes ?>>
		<td class="ewTableHeader">Commune<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->commune->CellAttributes() ?>><span id="el_commune">
<?php if ($projets->CurrentAction <> "F") { ?>
<select id="x_commune" name="x_commune" onchange="ew_UpdateOpt('x_section','x_commune',true);"<?php echo $projets->commune->EditAttributes() ?>>
<?php
if (is_array($projets->commune->EditValue)) {
	$arwrk = $projets->commune->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($projets->commune->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT `Id_com`, `Commune`, '' AS Disp2Fld FROM `commune`";
$sWhereWrk = "`Id_dep` IN ({filter_value})";
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
$sSqlWrk .= " ORDER BY `Commune` Asc";
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_commune" id="s_x_commune" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_commune" id="lft_x_commune" value="1">
<?php } else { ?>
<div<?php echo $projets->commune->ViewAttributes() ?>><?php echo $projets->commune->ViewValue ?></div>
<input type="hidden" name="x_commune" id="x_commune" value="<?php echo ew_HtmlEncode($projets->commune->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->commune->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->section->Visible) { // section ?>
	<tr<?php echo $projets->section->RowAttributes ?>>
		<td class="ewTableHeader">Ville/Quartier/Section<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->section->CellAttributes() ?>><span id="el_section">
<?php if ($projets->CurrentAction <> "F") { ?>
<select id="x_section" name="x_section"<?php echo $projets->section->EditAttributes() ?>>
<?php
if (is_array($projets->section->EditValue)) {
	$arwrk = $projets->section->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($projets->section->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT `id_section`, `vqs`, '' AS Disp2Fld FROM `section`";
$sWhereWrk = "`id_com` IN ({filter_value})";
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_section" id="s_x_section" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_section" id="lft_x_section" value="1">
<?php } else { ?>
<div<?php echo $projets->section->ViewAttributes() ?>><?php echo $projets->section->ViewValue ?></div>
<input type="hidden" name="x_section" id="x_section" value="<?php echo ew_HtmlEncode($projets->section->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->section->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->titre->Visible) { // titre ?>
	<tr<?php echo $projets->titre->RowAttributes ?>>
		<td class="ewTableHeader">Titre<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->titre->CellAttributes() ?>><span id="el_titre">
<?php if ($projets->CurrentAction <> "F") { ?>
<input type="text" name="x_titre" id="x_titre" size="35" maxlength="255" value="<?php echo $projets->titre->EditValue ?>"<?php echo $projets->titre->EditAttributes() ?>>
<?php } else { ?>
<div<?php echo $projets->titre->ViewAttributes() ?>><?php echo $projets->titre->ViewValue ?></div>
<input type="hidden" name="x_titre" id="x_titre" value="<?php echo ew_HtmlEncode($projets->titre->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->titre->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->montantproj->Visible) { // montantproj ?>
	<tr<?php echo $projets->montantproj->RowAttributes ?>>
		<td class="ewTableHeader">Montant engag<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->montantproj->CellAttributes() ?>><span id="el_montantproj">
<?php if ($projets->CurrentAction <> "F") { ?>
<input type="text" name="x_montantproj" id="x_montantproj" size="30" value="<?php echo $projets->montantproj->EditValue ?>"<?php echo $projets->montantproj->EditAttributes() ?>>
<?php } else { ?>
<div<?php echo $projets->montantproj->ViewAttributes() ?>><?php echo $projets->montantproj->ViewValue ?></div>
<input type="hidden" name="x_montantproj" id="x_montantproj" value="<?php echo ew_HtmlEncode($projets->montantproj->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->montantproj->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->montantdec->Visible) { // montantdec ?>
	<tr<?php echo $projets->montantdec->RowAttributes ?>>
		<td class="ewTableHeader">Montant dcaiss<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->montantdec->CellAttributes() ?>><span id="el_montantdec">
<?php if ($projets->CurrentAction <> "F") { ?>
<input type="text" name="x_montantdec" id="x_montantdec" size="30" value="<?php echo $projets->montantdec->EditValue ?>"<?php echo $projets->montantdec->EditAttributes() ?>>
<?php } else { ?>
<div<?php echo $projets->montantdec->ViewAttributes() ?>><?php echo $projets->montantdec->ViewValue ?></div>
<input type="hidden" name="x_montantdec" id="x_montantdec" value="<?php echo ew_HtmlEncode($projets->montantdec->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->montantdec->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->CurrentAction <> "F") { ?>
<?php } else { ?>
<div<?php echo $projets->entite->ViewAttributes() ?>><?php echo $projets->entite->ViewValue ?></div>
<input type="hidden" name="x_entite" id="x_entite" value="<?php echo ew_HtmlEncode($projets->entite->FormValue) ?>">
<?php } ?>
<?php if ($projets->secteur->Visible) { // secteur ?>
	<tr<?php echo $projets->secteur->RowAttributes ?>>
		<td class="ewTableHeader">Secteur<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->secteur->CellAttributes() ?>><span id="el_secteur">
<?php if ($projets->CurrentAction <> "F") { ?>
<select id="x_secteur" name="x_secteur"<?php echo $projets->secteur->EditAttributes() ?>>
<?php
if (is_array($projets->secteur->EditValue)) {
	$arwrk = $projets->secteur->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($projets->secteur->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php } else { ?>
<div<?php echo $projets->secteur->ViewAttributes() ?>><?php echo $projets->secteur->ViewValue ?></div>
<input type="hidden" name="x_secteur" id="x_secteur" value="<?php echo ew_HtmlEncode($projets->secteur->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->secteur->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->idfbp->Visible) { // idfbp ?>
	<tr<?php echo $projets->idfbp->RowAttributes ?>>
		<td class="ewTableHeader">Programmation<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->idfbp->CellAttributes() ?>><span id="el_idfbp">
<?php if ($projets->CurrentAction <> "F") { ?>
<select id="x_idfbp" name="x_idfbp" onchange="ew_UpdateOpt('x_bailleur','x_idfbp',true);ew_UpdateOpt('x_program','x_idfbp',true);"<?php echo $projets->idfbp->EditAttributes() ?>>
<?php
if (is_array($projets->idfbp->EditValue)) {
	$arwrk = $projets->idfbp->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($projets->idfbp->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT DISTINCT fbp.idfbp, Concat(bailleurs.nombailleur, ' ', programme.sigleprog, ' ', fbp.montantprograme), '' AS Disp2Fld FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog)";
$sWhereWrk = "";
$sWhereWrk = $GLOBALS["finanbp"]->AddUserIDFilter($sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_idfbp" id="s_x_idfbp" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_idfbp" id="lft_x_idfbp" value="">
<?php } else { ?>
<div<?php echo $projets->idfbp->ViewAttributes() ?>><?php echo $projets->idfbp->ViewValue ?></div>
<input type="hidden" name="x_idfbp" id="x_idfbp" value="<?php echo ew_HtmlEncode($projets->idfbp->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->idfbp->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->bailleur->Visible) { // bailleur ?>
	<tr<?php echo $projets->bailleur->RowAttributes ?>>
		<td class="ewTableHeader">Bailleur<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->bailleur->CellAttributes() ?>><span id="el_bailleur">
<?php if ($projets->CurrentAction <> "F") { ?>
<div id="tp_x_bailleur" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_bailleur" id="x_bailleur" value="{value}"<?php echo $projets->bailleur->EditAttributes() ?>></div>
<div id="dsl_x_bailleur" repeatcolumn="5">
<?php
$arwrk = $projets->bailleur->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($projets->bailleur->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label><input type="radio" name="x_bailleur" id="x_bailleur" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $projets->bailleur->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
<?php
$sSqlWrk = "SELECT fbp.bailleur, bailleurs.nombailleur, '' AS Disp2Fld FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog)";
$sWhereWrk = "fbp.idfbp IN ({filter_value})";
$sWhereWrk = $GLOBALS["finanbp"]->AddUserIDFilter($sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_bailleur" id="s_x_bailleur" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_bailleur" id="lft_x_bailleur" value="1">
<?php } else { ?>
<div<?php echo $projets->bailleur->ViewAttributes() ?>><?php echo $projets->bailleur->ViewValue ?></div>
<input type="hidden" name="x_bailleur" id="x_bailleur" value="<?php echo ew_HtmlEncode($projets->bailleur->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->bailleur->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->program->Visible) { // program ?>
	<tr<?php echo $projets->program->RowAttributes ?>>
		<td class="ewTableHeader">Programme<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->program->CellAttributes() ?>><span id="el_program">
<?php if ($projets->CurrentAction <> "F") { ?>
<div id="tp_x_program" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_program" id="x_program" value="{value}"<?php echo $projets->program->EditAttributes() ?>></div>
<div id="dsl_x_program" repeatcolumn="5">
<?php
$arwrk = $projets->program->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($projets->program->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label><input type="radio" name="x_program" id="x_program" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $projets->program->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
<?php
$sSqlWrk = "SELECT DISTINCT fbp.program, programme.sigleprog, '' AS Disp2Fld FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog)";
$sWhereWrk = "fbp.idfbp IN ({filter_value})";
$sWhereWrk = $GLOBALS["finanbp"]->AddUserIDFilter($sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_program" id="s_x_program" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_program" id="lft_x_program" value="1">
<?php } else { ?>
<div<?php echo $projets->program->ViewAttributes() ?>><?php echo $projets->program->ViewValue ?></div>
<input type="hidden" name="x_program" id="x_program" value="<?php echo ew_HtmlEncode($projets->program->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->program->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->statut->Visible) { // statut ?>
	<tr<?php echo $projets->statut->RowAttributes ?>>
		<td class="ewTableHeader">Statut<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->statut->CellAttributes() ?>><span id="el_statut">
<?php if ($projets->CurrentAction <> "F") { ?>
<select id="x_statut" name="x_statut"<?php echo $projets->statut->EditAttributes() ?>>
<?php
if (is_array($projets->statut->EditValue)) {
	$arwrk = $projets->statut->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($projets->statut->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php } else { ?>
<div<?php echo $projets->statut->ViewAttributes() ?>><?php echo $projets->statut->ViewValue ?></div>
<input type="hidden" name="x_statut" id="x_statut" value="<?php echo ew_HtmlEncode($projets->statut->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->statut->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->datedebut->Visible) { // datedebut ?>
	<tr<?php echo $projets->datedebut->RowAttributes ?>>
		<td class="ewTableHeader">Date de dmarrage<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->datedebut->CellAttributes() ?>><span id="el_datedebut">
<?php if ($projets->CurrentAction <> "F") { ?>
<input type="text" name="x_datedebut" id="x_datedebut" value="<?php echo $projets->datedebut->EditValue ?>"<?php echo $projets->datedebut->EditAttributes() ?>>
&nbsp;<img src="images/calendar.png" id="cal_x_datedebut" name="cal_x_datedebut" alt="Pick a date" style="cursor:pointer;cursor:hand;">
<script type="text/javascript">
Calendar.setup({
	inputField : "x_datedebut", // ID of the input field
	ifFormat : "%d/%m/%Y", // the date format
	button : "cal_x_datedebut" // ID of the button
});
</script>
<?php } else { ?>
<div<?php echo $projets->datedebut->ViewAttributes() ?>><?php echo $projets->datedebut->ViewValue ?></div>
<input type="hidden" name="x_datedebut" id="x_datedebut" value="<?php echo ew_HtmlEncode($projets->datedebut->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->datedebut->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->ast->Visible) { // ast ?>
	<tr<?php echo $projets->ast->RowAttributes ?>>
		<td class="ewTableHeader">Autres secteurs touchs<span class="ewRequired">&nbsp;*</span></td>
		<td<?php echo $projets->ast->CellAttributes() ?>><span id="el_ast">
<?php if ($projets->CurrentAction <> "F") { ?>
<select id="x_ast[]" name="x_ast[]" size=10 multiple="multiple"<?php echo $projets->ast->EditAttributes() ?>>
<?php
if (is_array($projets->ast->EditValue)) {
	$arwrk = $projets->ast->EditValue;
	$armultiwrk= explode(",", strval($projets->ast->CurrentValue));
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = "";
		for ($ari = 0; $ari < count($armultiwrk); $ari++) {
			if (strval($arwrk[$rowcntwrk][0]) == trim(strval($armultiwrk[$ari]))) {
				$selwrk = " selected=\"selected\"";
				if ($selwrk <> "") $emptywrk = FALSE;
				break;
			}
		}	
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT `idsecteur`, `nomsecteur`, '' AS Disp2Fld FROM `secteurs`";
$sWhereWrk = "";
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_ast" id="s_x_ast" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_ast" id="lft_x_ast" value="">
<?php } else { ?>
<div<?php echo $projets->ast->ViewAttributes() ?>><?php echo $projets->ast->ViewValue ?></div>
<input type="hidden" name="x_ast" id="x_ast" value="<?php echo ew_HtmlEncode($projets->ast->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->ast->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->nbrbd->Visible) { // nbrbd ?>
	<tr<?php echo $projets->nbrbd->RowAttributes ?>>
		<td class="ewTableHeader">B&eacute;n&eacute;ficiaires</td>
		<td<?php echo $projets->nbrbd->CellAttributes() ?>><span id="el_nbrbd">
<?php if ($projets->CurrentAction <> "F") { ?>
<input type="text" name="x_nbrbd" id="x_nbrbd" size="30" maxlength="200" value="<?php echo $projets->nbrbd->EditValue ?>"<?php echo $projets->nbrbd->EditAttributes() ?>>
<?php } else { ?>
<div<?php echo $projets->nbrbd->ViewAttributes() ?>><?php echo $projets->nbrbd->ViewValue ?></div>
<input type="hidden" name="x_nbrbd" id="x_nbrbd" value="<?php echo ew_HtmlEncode($projets->nbrbd->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->nbrbd->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->nbrec->Visible) { // nbrec ?>
	<tr<?php echo $projets->nbrec->RowAttributes ?>>
		<td class="ewTableHeader">Nombre d'emplois cr&eacute;&eacute;s</td>
		<td<?php echo $projets->nbrec->CellAttributes() ?>><span id="el_nbrec">
<?php if ($projets->CurrentAction <> "F") { ?>
<input type="text" name="x_nbrec" id="x_nbrec" size="30" maxlength="200" value="<?php echo $projets->nbrec->EditValue ?>"<?php echo $projets->nbrec->EditAttributes() ?>>
<?php } else { ?>
<div<?php echo $projets->nbrec->ViewAttributes() ?>><?php echo $projets->nbrec->ViewValue ?></div>
<input type="hidden" name="x_nbrec" id="x_nbrec" value="<?php echo ew_HtmlEncode($projets->nbrec->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->nbrec->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->CurrentAction <> "F") { ?>
<?php } else { ?>
<div<?php echo $projets->datemaj->ViewAttributes() ?>><?php echo $projets->datemaj->ViewValue ?></div>
<input type="hidden" name="x_datemaj" id="x_datemaj" value="<?php echo ew_HtmlEncode($projets->datemaj->FormValue) ?>">
<?php } ?>
<?php if ($projets->CurrentAction <> "F") { ?>
<?php } else { ?>
<div<?php echo $projets->zuserID->ViewAttributes() ?>><?php echo $projets->zuserID->ViewValue ?></div>
<input type="hidden" name="x_zuserID" id="x_zuserID" value="<?php echo ew_HtmlEncode($projets->zuserID->FormValue) ?>">
<?php } ?>
</table>
</div>
</td></tr></table>
		</div>
		<div id="tab_projets_2">
<table cellspacing="0" class="ewGrid" style="width: 100%"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable">
<?php if ($projets->objectif->Visible) { // objectif ?>
	<tr<?php echo $projets->objectif->RowAttributes ?>>
		<td class="ewTableHeader">Objectif(s)</td>
		<td<?php echo $projets->objectif->CellAttributes() ?>><span id="el_objectif">
<?php if ($projets->CurrentAction <> "F") { ?>
<textarea name="x_objectif" id="x_objectif" cols="35" rows="5"<?php echo $projets->objectif->EditAttributes() ?>><?php echo $projets->objectif->EditValue ?></textarea>
<script type="text/javascript">
<!--
tinyMCE.init({
	theme : "advanced",
	mode : "exact",
	theme_advanced_buttons1_add : "fontselect,fontsizeselect",
	theme_advanced_buttons2_add : "preview,separator,forecolor,backcolor",
	theme_advanced_buttons2_add_before: "cut,copy,paste,pastetext,pasteword,separator,search,replace",		
	theme_advanced_toolbar_location : "top",
	theme_advanced_toolbar_align : "left",
	theme_advanced_path_location : "bottom",		
	extended_valid_elements : "hr[class|width|size|noshade],font[face|size|color|style],span[class|align|style]",		
	theme_advanced_resize_horizontal : false,
	theme_advanced_resizing : true,
	apply_source_formatting : true,
	width : 35*_width_multiplier,
	height : 5*_height_multiplier,
	elements : 'x_objectif'
});
ew_DHTMLEditors.push(new ew_DHTMLEditor("x_objectif"));
-->
</script>
<?php } else { ?>
<div<?php echo $projets->objectif->ViewAttributes() ?>><?php echo $projets->objectif->ViewValue ?></div>
<input type="hidden" name="x_objectif" id="x_objectif" value="<?php echo ew_HtmlEncode($projets->objectif->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->objectif->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($projets->Realisation->Visible) { // Realisation ?>
	<tr<?php echo $projets->Realisation->RowAttributes ?>>
		<td class="ewTableHeader">R&eacute;alisations</td>
		<td<?php echo $projets->Realisation->CellAttributes() ?>><span id="el_Realisation">
<?php if ($projets->CurrentAction <> "F") { ?>
<textarea name="x_Realisation" id="x_Realisation" cols="35" rows="4"<?php echo $projets->Realisation->EditAttributes() ?>><?php echo $projets->Realisation->EditValue ?></textarea>
<script type="text/javascript">
<!--
tinyMCE.init({
	theme : "advanced",
	mode : "exact",
	theme_advanced_buttons1_add : "fontselect,fontsizeselect",
	theme_advanced_buttons2_add : "preview,separator,forecolor,backcolor",
	theme_advanced_buttons2_add_before: "cut,copy,paste,pastetext,pasteword,separator,search,replace",		
	theme_advanced_toolbar_location : "top",
	theme_advanced_toolbar_align : "left",
	theme_advanced_path_location : "bottom",		
	extended_valid_elements : "hr[class|width|size|noshade],font[face|size|color|style],span[class|align|style]",		
	theme_advanced_resize_horizontal : false,
	theme_advanced_resizing : true,
	apply_source_formatting : true,
	width : 35*_width_multiplier,
	height : 4*_height_multiplier,
	elements : 'x_Realisation'
});
ew_DHTMLEditors.push(new ew_DHTMLEditor("x_Realisation"));
-->
</script>
<?php } else { ?>
<div<?php echo $projets->Realisation->ViewAttributes() ?>><?php echo $projets->Realisation->ViewValue ?></div>
<input type="hidden" name="x_Realisation" id="x_Realisation" value="<?php echo ew_HtmlEncode($projets->Realisation->FormValue) ?>">
<?php } ?>
</span><?php echo $projets->Realisation->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</div>
</td></tr></table>
		</div>
	</div>
</div>
</td></tr></table>
<script type="text/javascript">
<!--
projets_add.TabView = new ewWidget.TabView("projets_add");			
projets_add.TabView.subscribe("activeTabChange", function(e) {
	if (projets_add.MultiPage) {
		var i = projets_add.TabView.getTabIndex(e.newValue) + 1;
		projets_add.MultiPage.GotoPageByIndex(i);
	}
});
projets_add.TabView.subscribe("contentReady", function(e) {
	if (projets_add.MultiPage) {
		projets_add.MultiPage.Init(); // Multi-page initialization
		projets_add.MultiPage.TabView = projets_add.TabView;
		projets_add.MultiPage.SubmitButton = document.getElementById("btnAction");
		var i = projets_add.TabView.get("activeIndex") + 1;
		projets_add.MultiPage.GotoPageByIndex(i);
	}
});

//-->
</script>	
<p>
<?php if ($projets->CurrentAction <> "F") { // Confirm page ?>
<input type="button" name="btnAction" id="btnAction" value="    Add    " onclick="this.form.a_add.value='F';ew_SubmitForm(projets_add, this.form);">
<?php } else { ?>
<input type="button" name="btnCancel" id="btnCancel" value="  Cancel  " onclick="this.form.a_add.value='X';ew_SubmitForm(projets_add, this.form);">
<input type="button" name="btnAction" id="btnAction" value="  Confirm  " onclick="ew_SubmitForm(projets_add, this.form);">
<?php } ?>
</form>
<?php if ($projets->CurrentAction <> "F") { ?>
<script language="JavaScript">
<!--
ew_UpdateOpts([['x_commune','x_departement',false],
['x_section','x_commune',false],
['x_bailleur','x_idfbp',false],
['x_program','x_idfbp',false],
['x_departement','x_departement',false],
['x_entite','x_entite',false],
['x_idfbp','x_idfbp',false],
['x_ast[]','x_ast[]',false],
['x_zuserID','x_zuserID',false]]);

//-->
</script>
<?php } ?>
<script type="text/javascript">
<!--
ew_CreateEditor();  // Create DHTML editor(s)

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your table-specific startup script here
// document.write("page loaded");
//-->

</script>
<?php include "footer_admin.php" ?>
<?php
$projets_add->Page_Terminate();
?>
<?php

//
// Page Class
//
class cprojets_add {

	// Page ID
	var $PageID = 'add';

	// Table Name
	var $TableName = 'projets';

	// Page Object Name
	var $PageObjName = 'projets_add';

	// Page Name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page Url
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		global $projets;
		if ($projets->UseTokenInUrl) $PageUrl .= "t=" . $projets->TableVar . "&"; // add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show Message
	function ShowMessage() {
		if ($this->getMessage() <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $this->getMessage() . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate Page request
	function IsPageRequest() {
		global $objForm, $projets;
		if ($projets->UseTokenInUrl) {

			//IsPageRequest = False
			if ($objForm)
				return ($projets->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($projets->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	//  Class initialize
	//  - init objects
	//  - open connection
	//
	function cprojets_add() {
		global $conn;

		// Initialize table object
		$GLOBALS["projets"] = new cprojets();

		// Initialize other table object
		$GLOBALS['usermis'] = new cusermis();

		// Initialize other table object
		$GLOBALS['finanbp'] = new cfinanbp();

		// Intialize page id (for backward compatibility)
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Initialize table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'projets', TRUE);

		// Open connection to the database
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $projets;
		global $Security;
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login_admin.php");
		}
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("projetslist_admin.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();
		if ($Security->IsLoggedIn() && $Security->CurrentUserID() == "") {
			$_SESSION[EW_SESSION_MESSAGE] = "You do not have the right permission to view the page";
			$this->Page_Terminate("projetslist_admin.php");
		}

		// Global page loading event (in userfn6.php)
		Page_Loading();

		// Page load event, used in current page
		$this->Page_Load();
	}

	//
	//  Page_Terminate
	//  - called when exit page
	//  - if URL specified, redirect to the URL
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page unload event, used in current page
		$this->Page_Unload();

		// Global page unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close Connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			ob_end_clean();
			header("Location: $url");
		}
		exit();
	}
	var $x_ewPriv = 0;

	// 
	// Page main processing
	//
	function Page_Main() {
		global $objForm, $gsFormError, $projets;

		// Load key values from QueryString
		$bCopy = TRUE;
		if (@$_GET["idprojet"] != "") {
		  $projets->idprojet->setQueryStringValue($_GET["idprojet"]);
		} else {
		  $bCopy = FALSE;
		}

		// Create form object
		$objForm = new cFormObj();

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
		   $projets->CurrentAction = $_POST["a_add"]; // Get form action
		  $this->LoadFormValues(); // Load form values

			// Validate Form
			if (!$this->ValidateForm()) {
				$projets->CurrentAction = "I"; // Form error, reset action
				$this->setMessage($gsFormError);
			}
		} else { // Not post back
		  if ($bCopy) {
		    $projets->CurrentAction = "C"; // Copy Record
		  } else {
		    $projets->CurrentAction = "I"; // Display Blank Record
		    $this->LoadDefaultValues(); // Load default values
		  }
		}

		// Perform action based on action code
		switch ($projets->CurrentAction) {
		  case "I": // Blank record, no action required
				break;
		  case "C": // Copy an existing record
		   if (!$this->LoadRow()) { // Load record based on key
		      $this->setMessage("No records found"); // No record found
		      $this->Page_Terminate("projetslist_admin.php"); // No matching record, return to list
		    }
				break;
		  case "A": // ' Add new record
				$projets->SendEmail = TRUE; // Send email on add success
		    if ($this->AddRow()) { // Add successful
		      $this->setMessage("Add succeeded"); // Set up success message
					$sReturnUrl = $projets->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "projetsview_admin.php")
						$sReturnUrl = $projets->ViewUrl(); // View paging, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
		    } else {
		      $this->RestoreFormValues(); // Add failed, restore form values
		    }
		}

		// Render row based on row type
		if ($projets->CurrentAction == "F") { // Confirm page
		  $projets->RowType = EW_ROWTYPE_VIEW; // Render view type
		} else {
		  $projets->RowType = EW_ROWTYPE_ADD; // Render add type
		}

		// Render row
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $projets;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		global $projets;
		$projets->montantproj->CurrentValue = 0;
		$projets->montantdec->CurrentValue = 0;
		$projets->entite->CurrentValue = CurrentUserID();
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm, $projets;
		$projets->departement->setFormValue($objForm->GetValue("x_departement"));
		$projets->commune->setFormValue($objForm->GetValue("x_commune"));
		$projets->section->setFormValue($objForm->GetValue("x_section"));
		$projets->titre->setFormValue($objForm->GetValue("x_titre"));
		$projets->objectif->setFormValue($objForm->GetValue("x_objectif"));
		$projets->montantproj->setFormValue($objForm->GetValue("x_montantproj"));
		$projets->montantdec->setFormValue($objForm->GetValue("x_montantdec"));
		$projets->entite->setFormValue($objForm->GetValue("x_entite"));
		$projets->secteur->setFormValue($objForm->GetValue("x_secteur"));
		$projets->idfbp->setFormValue($objForm->GetValue("x_idfbp"));
		$projets->bailleur->setFormValue($objForm->GetValue("x_bailleur"));
		$projets->program->setFormValue($objForm->GetValue("x_program"));
		$projets->statut->setFormValue($objForm->GetValue("x_statut"));
		$projets->datedebut->setFormValue($objForm->GetValue("x_datedebut"));
		$projets->datedebut->CurrentValue = ew_UnFormatDateTime($projets->datedebut->CurrentValue, 7);
		$projets->ast->setFormValue($objForm->GetValue("x_ast"));
		$projets->Realisation->setFormValue($objForm->GetValue("x_Realisation"));
		$projets->nbrbd->setFormValue($objForm->GetValue("x_nbrbd"));
		$projets->nbrec->setFormValue($objForm->GetValue("x_nbrec"));
		$projets->datemaj->setFormValue($objForm->GetValue("x_datemaj"));
		$projets->datemaj->CurrentValue = ew_UnFormatDateTime($projets->datemaj->CurrentValue, 7);
		$projets->zuserID->setFormValue($objForm->GetValue("x_zuserID"));
		$projets->idprojet->setFormValue($objForm->GetValue("x_idprojet"));
	}

	// Restore form values
	function RestoreFormValues() {
		global $projets;
		$projets->idprojet->CurrentValue = $projets->idprojet->FormValue;
		$projets->departement->CurrentValue = $projets->departement->FormValue;
		$projets->commune->CurrentValue = $projets->commune->FormValue;
		$projets->section->CurrentValue = $projets->section->FormValue;
		$projets->titre->CurrentValue = $projets->titre->FormValue;
		$projets->objectif->CurrentValue = $projets->objectif->FormValue;
		$projets->montantproj->CurrentValue = $projets->montantproj->FormValue;
		$projets->montantdec->CurrentValue = $projets->montantdec->FormValue;
		$projets->entite->CurrentValue = $projets->entite->FormValue;
		$projets->secteur->CurrentValue = $projets->secteur->FormValue;
		$projets->idfbp->CurrentValue = $projets->idfbp->FormValue;
		$projets->bailleur->CurrentValue = $projets->bailleur->FormValue;
		$projets->program->CurrentValue = $projets->program->FormValue;
		$projets->statut->CurrentValue = $projets->statut->FormValue;
		$projets->datedebut->CurrentValue = $projets->datedebut->FormValue;
		$projets->datedebut->CurrentValue = ew_UnFormatDateTime($projets->datedebut->CurrentValue, 7);
		$projets->ast->CurrentValue = $projets->ast->FormValue;
		$projets->Realisation->CurrentValue = $projets->Realisation->FormValue;
		$projets->nbrbd->CurrentValue = $projets->nbrbd->FormValue;
		$projets->nbrec->CurrentValue = $projets->nbrec->FormValue;
		$projets->datemaj->CurrentValue = $projets->datemaj->FormValue;
		$projets->datemaj->CurrentValue = ew_UnFormatDateTime($projets->datemaj->CurrentValue, 7);
		$projets->zuserID->CurrentValue = $projets->zuserID->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $projets;
		$sFilter = $projets->KeyFilter();

		// Call Row Selecting event
		$projets->Row_Selecting($sFilter);

		// Load sql based on filter
		$projets->CurrentFilter = $sFilter;
		$sSql = $projets->SQL();
		if ($rs = $conn->Execute($sSql)) {
			if ($rs->EOF) {
				$LoadRow = FALSE;
			} else {
				$LoadRow = TRUE;
				$rs->MoveFirst();
				$this->LoadRowValues($rs); // Load row values

				// Call Row Selected event
				$projets->Row_Selected($rs);
			}
			$rs->Close();
		} else {
			$LoadRow = FALSE;
		}
		return $LoadRow;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $projets;
		$projets->idprojet->setDbValue($rs->fields('idprojet'));
		$projets->departement->setDbValue($rs->fields('departement'));
		$projets->commune->setDbValue($rs->fields('commune'));
		$projets->section->setDbValue($rs->fields('section'));
		$projets->titre->setDbValue($rs->fields('titre'));
		$projets->objectif->setDbValue($rs->fields('objectif'));
		$projets->montantproj->setDbValue($rs->fields('montantproj'));
		$projets->montantdec->setDbValue($rs->fields('montantdec'));
		$projets->entite->setDbValue($rs->fields('entite'));
		$projets->secteur->setDbValue($rs->fields('secteur'));
		$projets->idfbp->setDbValue($rs->fields('idfbp'));
		$projets->bailleur->setDbValue($rs->fields('bailleur'));
		$projets->program->setDbValue($rs->fields('program'));
		$projets->statut->setDbValue($rs->fields('statut'));
		$projets->datedebut->setDbValue($rs->fields('datedebut'));
		$projets->ast->setDbValue($rs->fields('ast'));
		$projets->Realisation->setDbValue($rs->fields('Realisation'));
		$projets->nbrbd->setDbValue($rs->fields('nbrbd'));
		$projets->nbrec->setDbValue($rs->fields('nbrec'));
		$projets->datemaj->setDbValue($rs->fields('datemaj'));
		$projets->zuserID->setDbValue($rs->fields('userID'));
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $projets;

		// Call Row_Rendering event
		$projets->Row_Rendering();

		// Common render codes for all row types
		// departement

		$projets->departement->CellCssStyle = "";
		$projets->departement->CellCssClass = "";

		// commune
		$projets->commune->CellCssStyle = "";
		$projets->commune->CellCssClass = "";

		// section
		$projets->section->CellCssStyle = "";
		$projets->section->CellCssClass = "";

		// titre
		$projets->titre->CellCssStyle = "";
		$projets->titre->CellCssClass = "";

		// objectif
		$projets->objectif->CellCssStyle = "";
		$projets->objectif->CellCssClass = "";

		// montantproj
		$projets->montantproj->CellCssStyle = "";
		$projets->montantproj->CellCssClass = "";

		// montantdec
		$projets->montantdec->CellCssStyle = "";
		$projets->montantdec->CellCssClass = "";

		// entite
		$projets->entite->CellCssStyle = "";
		$projets->entite->CellCssClass = "";

		// secteur
		$projets->secteur->CellCssStyle = "";
		$projets->secteur->CellCssClass = "";

		// idfbp
		$projets->idfbp->CellCssStyle = "";
		$projets->idfbp->CellCssClass = "";

		// bailleur
		$projets->bailleur->CellCssStyle = "";
		$projets->bailleur->CellCssClass = "";

		// program
		$projets->program->CellCssStyle = "";
		$projets->program->CellCssClass = "";

		// statut
		$projets->statut->CellCssStyle = "";
		$projets->statut->CellCssClass = "";

		// datedebut
		$projets->datedebut->CellCssStyle = "";
		$projets->datedebut->CellCssClass = "";

		// ast
		$projets->ast->CellCssStyle = "";
		$projets->ast->CellCssClass = "";

		// Realisation
		$projets->Realisation->CellCssStyle = "";
		$projets->Realisation->CellCssClass = "";

		// nbrbd
		$projets->nbrbd->CellCssStyle = "";
		$projets->nbrbd->CellCssClass = "";

		// nbrec
		$projets->nbrec->CellCssStyle = "";
		$projets->nbrec->CellCssClass = "";

		// datemaj
		$projets->datemaj->CellCssStyle = "";
		$projets->datemaj->CellCssClass = "";

		// userID
		$projets->zuserID->CellCssStyle = "";
		$projets->zuserID->CellCssClass = "";
		if ($projets->RowType == EW_ROWTYPE_VIEW) { // View row

			// departement
			if (strval($projets->departement->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `departemen` FROM `departement` WHERE `ID_Dep` = " . ew_AdjustSql($projets->departement->CurrentValue) . "";
				$sSqlWrk .= " ORDER BY `departemen` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->departement->ViewValue = $rswrk->fields('departemen');
					$rswrk->Close();
				} else {
					$projets->departement->ViewValue = $projets->departement->CurrentValue;
				}
			} else {
				$projets->departement->ViewValue = NULL;
			}
			$projets->departement->CssStyle = "";
			$projets->departement->CssClass = "";
			$projets->departement->ViewCustomAttributes = "";

			// commune
			if (strval($projets->commune->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `Commune` FROM `commune` WHERE `Id_com` = " . ew_AdjustSql($projets->commune->CurrentValue) . "";
				$sSqlWrk .= " ORDER BY `Commune` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->commune->ViewValue = $rswrk->fields('Commune');
					$rswrk->Close();
				} else {
					$projets->commune->ViewValue = $projets->commune->CurrentValue;
				}
			} else {
				$projets->commune->ViewValue = NULL;
			}
			$projets->commune->CssStyle = "";
			$projets->commune->CssClass = "";
			$projets->commune->ViewCustomAttributes = "";

			// section
			if (strval($projets->section->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `vqs` FROM `section` WHERE `id_section` = " . ew_AdjustSql($projets->section->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->section->ViewValue = $rswrk->fields('vqs');
					$rswrk->Close();
				} else {
					$projets->section->ViewValue = $projets->section->CurrentValue;
				}
			} else {
				$projets->section->ViewValue = NULL;
			}
			$projets->section->CssStyle = "";
			$projets->section->CssClass = "";
			$projets->section->ViewCustomAttributes = "";

			// titre
			$projets->titre->ViewValue = $projets->titre->CurrentValue;
			$projets->titre->CssStyle = "";
			$projets->titre->CssClass = "";
			$projets->titre->ViewCustomAttributes = "";

			// objectif
			$projets->objectif->ViewValue = $projets->objectif->CurrentValue;
			$projets->objectif->CssStyle = "";
			$projets->objectif->CssClass = "";
			$projets->objectif->ViewCustomAttributes = "";

			// montantproj
			$projets->montantproj->ViewValue = $projets->montantproj->CurrentValue;
			$projets->montantproj->ViewValue = ew_FormatCurrency($projets->montantproj->ViewValue, 2, -2, -2, -2);
			$projets->montantproj->CssStyle = "";
			$projets->montantproj->CssClass = "";
			$projets->montantproj->ViewCustomAttributes = "";

			// montantdec
			$projets->montantdec->ViewValue = $projets->montantdec->CurrentValue;
			$projets->montantdec->ViewValue = ew_FormatCurrency($projets->montantdec->ViewValue, 2, -2, -2, -2);
			$projets->montantdec->CssStyle = "text-align:left;";
			$projets->montantdec->CssClass = "";
			$projets->montantdec->ViewCustomAttributes = "";

			// entite
			if (strval($projets->entite->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `nomentite` FROM `entites` WHERE `identite` = " . ew_AdjustSql($projets->entite->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->entite->ViewValue = $rswrk->fields('nomentite');
					$rswrk->Close();
				} else {
					$projets->entite->ViewValue = $projets->entite->CurrentValue;
				}
			} else {
				$projets->entite->ViewValue = NULL;
			}
			$projets->entite->CssStyle = "";
			$projets->entite->CssClass = "";
			$projets->entite->ViewCustomAttributes = "";

			// secteur
			if (strval($projets->secteur->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `nomsecteur` FROM `secteurs` WHERE `idsecteur` = " . ew_AdjustSql($projets->secteur->CurrentValue) . "";
				$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->secteur->ViewValue = $rswrk->fields('nomsecteur');
					$rswrk->Close();
				} else {
					$projets->secteur->ViewValue = $projets->secteur->CurrentValue;
				}
			} else {
				$projets->secteur->ViewValue = NULL;
			}
			$projets->secteur->CssStyle = "";
			$projets->secteur->CssClass = "";
			$projets->secteur->ViewCustomAttributes = "";

			// idfbp
			if (strval($projets->idfbp->CurrentValue) <> "") {
				$sSqlWrk = "SELECT DISTINCT Concat(bailleurs.nombailleur, ' ', programme.sigleprog, ' ', fbp.montantprograme) AS `nomfbp` FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog) WHERE fbp.idfbp = " . ew_AdjustSql($projets->idfbp->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->idfbp->ViewValue = $rswrk->fields('nomfbp');
					$rswrk->Close();
				} else {
					$projets->idfbp->ViewValue = $projets->idfbp->CurrentValue;
				}
			} else {
				$projets->idfbp->ViewValue = NULL;
			}
			$projets->idfbp->CssStyle = "";
			$projets->idfbp->CssClass = "";
			$projets->idfbp->ViewCustomAttributes = "";

			// bailleur
			if (strval($projets->bailleur->CurrentValue) <> "") {
				$sSqlWrk = "SELECT bailleurs.nombailleur AS `nombailleur` FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog) WHERE fbp.bailleur = " . ew_AdjustSql($projets->bailleur->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->bailleur->ViewValue = $rswrk->fields('nombailleur');
					$rswrk->Close();
				} else {
					$projets->bailleur->ViewValue = $projets->bailleur->CurrentValue;
				}
			} else {
				$projets->bailleur->ViewValue = NULL;
			}
			$projets->bailleur->CssStyle = "";
			$projets->bailleur->CssClass = "";
			$projets->bailleur->ViewCustomAttributes = "";

			// program
			if (strval($projets->program->CurrentValue) <> "") {
				$sSqlWrk = "SELECT DISTINCT programme.sigleprog AS `sigleprog` FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog) WHERE fbp.program = " . ew_AdjustSql($projets->program->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->program->ViewValue = $rswrk->fields('sigleprog');
					$rswrk->Close();
				} else {
					$projets->program->ViewValue = $projets->program->CurrentValue;
				}
			} else {
				$projets->program->ViewValue = NULL;
			}
			$projets->program->CssStyle = "";
			$projets->program->CssClass = "";
			$projets->program->ViewCustomAttributes = "";

			// statut
			if (strval($projets->statut->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `NomStatut` FROM `statut` WHERE `StatutID` = " . ew_AdjustSql($projets->statut->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->statut->ViewValue = $rswrk->fields('NomStatut');
					$rswrk->Close();
				} else {
					$projets->statut->ViewValue = $projets->statut->CurrentValue;
				}
			} else {
				$projets->statut->ViewValue = NULL;
			}
			$projets->statut->CssStyle = "";
			$projets->statut->CssClass = "";
			$projets->statut->ViewCustomAttributes = "";

			// datedebut
			$projets->datedebut->ViewValue = $projets->datedebut->CurrentValue;
			$projets->datedebut->ViewValue = ew_FormatDateTime($projets->datedebut->ViewValue, 7);
			$projets->datedebut->CssStyle = "";
			$projets->datedebut->CssClass = "";
			$projets->datedebut->ViewCustomAttributes = "";

			// ast
			if (strval($projets->ast->CurrentValue) <> "") {
				$arwrk = explode(",", $projets->ast->CurrentValue);
				$sSqlWrk = "SELECT `nomsecteur` FROM `secteurs` WHERE ";
				$sWhereWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
					$sWhereWrk .= "`idsecteur` = " . ew_AdjustSql(trim($wrk)) . "";
				}
				if ($sWhereWrk <> "") $sSqlWrk .= "(" . $sWhereWrk . ")";
				$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->ast->ViewValue = "";
					$ari = 0;
					while (!$rswrk->EOF) {
						$projets->ast->ViewValue .= $rswrk->fields('nomsecteur');
						$rswrk->MoveNext();
						if (!$rswrk->EOF) $projets->ast->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
						$ari++;
					}
					$rswrk->Close();
				} else {
					$projets->ast->ViewValue = $projets->ast->CurrentValue;
				}
			} else {
				$projets->ast->ViewValue = NULL;
			}
			$projets->ast->CssStyle = "";
			$projets->ast->CssClass = "";
			$projets->ast->ViewCustomAttributes = "";

			// Realisation
			$projets->Realisation->ViewValue = $projets->Realisation->CurrentValue;
			$projets->Realisation->CssStyle = "";
			$projets->Realisation->CssClass = "";
			$projets->Realisation->ViewCustomAttributes = "";

			// nbrbd
			$projets->nbrbd->ViewValue = $projets->nbrbd->CurrentValue;
			$projets->nbrbd->CssStyle = "";
			$projets->nbrbd->CssClass = "";
			$projets->nbrbd->ViewCustomAttributes = "";

			// nbrec
			$projets->nbrec->ViewValue = $projets->nbrec->CurrentValue;
			$projets->nbrec->CssStyle = "";
			$projets->nbrec->CssClass = "";
			$projets->nbrec->ViewCustomAttributes = "";

			// datemaj
			$projets->datemaj->ViewValue = $projets->datemaj->CurrentValue;
			$projets->datemaj->ViewValue = ew_FormatDateTime($projets->datemaj->ViewValue, 7);
			$projets->datemaj->CssStyle = "";
			$projets->datemaj->CssClass = "";
			$projets->datemaj->ViewCustomAttributes = "";

			// userID
			if (strval($projets->zuserID->CurrentValue) <> "") {
				$sSqlWrk = "SELECT `Email` FROM `usermis` WHERE `EmployeeID` = " . ew_AdjustSql($projets->zuserID->CurrentValue) . "";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup value(s) found
					$projets->zuserID->ViewValue = $rswrk->fields('Email');
					$rswrk->Close();
				} else {
					$projets->zuserID->ViewValue = $projets->zuserID->CurrentValue;
				}
			} else {
				$projets->zuserID->ViewValue = NULL;
			}
			$projets->zuserID->CssStyle = "";
			$projets->zuserID->CssClass = "";
			$projets->zuserID->ViewCustomAttributes = "";

			// departement
			$projets->departement->HrefValue = "";

			// commune
			$projets->commune->HrefValue = "";

			// section
			$projets->section->HrefValue = "";

			// titre
			$projets->titre->HrefValue = "";

			// objectif
			$projets->objectif->HrefValue = "";

			// montantproj
			$projets->montantproj->HrefValue = "";

			// montantdec
			$projets->montantdec->HrefValue = "";

			// entite
			$projets->entite->HrefValue = "";

			// secteur
			$projets->secteur->HrefValue = "";

			// idfbp
			$projets->idfbp->HrefValue = "";

			// bailleur
			$projets->bailleur->HrefValue = "";

			// program
			$projets->program->HrefValue = "";

			// statut
			$projets->statut->HrefValue = "";

			// datedebut
			$projets->datedebut->HrefValue = "";

			// ast
			$projets->ast->HrefValue = "";

			// Realisation
			$projets->Realisation->HrefValue = "";

			// nbrbd
			$projets->nbrbd->HrefValue = "";

			// nbrec
			$projets->nbrec->HrefValue = "";

			// datemaj
			$projets->datemaj->HrefValue = "";

			// userID
			$projets->zuserID->HrefValue = "";
		} elseif ($projets->RowType == EW_ROWTYPE_ADD) { // Add row

			// departement
			$projets->departement->EditCustomAttributes = "";
			$sSqlWrk = "SELECT `ID_Dep`, `departemen`, '' AS Disp2Fld, '' AS SelectFilterFld FROM `departement`";
			if (trim(strval($projets->departement->CurrentValue)) == "") {
				$sWhereWrk = "0=1";
			} else {
				$sWhereWrk = "`ID_Dep` = " . ew_AdjustSql($projets->departement->CurrentValue) . "";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$sSqlWrk .= " ORDER BY `departemen` Asc";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", "Please Select"));
			$projets->departement->EditValue = $arwrk;

			// commune
			$projets->commune->EditCustomAttributes = "";
			$sSqlWrk = "SELECT `Id_com`, `Commune`, '' AS Disp2Fld, `Id_dep` FROM `commune`";
			if (trim(strval($projets->commune->CurrentValue)) == "") {
				$sWhereWrk = "0=1";
			} else {
				$sWhereWrk = "`Id_com` = " . ew_AdjustSql($projets->commune->CurrentValue) . "";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$sSqlWrk .= " ORDER BY `Commune` Asc";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", "Please Select", ""));
			$projets->commune->EditValue = $arwrk;

			// section
			$projets->section->EditCustomAttributes = "";
			$sSqlWrk = "SELECT `id_section`, `vqs`, '' AS Disp2Fld, `id_com` FROM `section`";
			if (trim(strval($projets->section->CurrentValue)) == "") {
				$sWhereWrk = "0=1";
			} else {
				$sWhereWrk = "`id_section` = " . ew_AdjustSql($projets->section->CurrentValue) . "";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", "Please Select", ""));
			$projets->section->EditValue = $arwrk;

			// titre
			$projets->titre->EditCustomAttributes = "";
			$projets->titre->EditValue = ew_HtmlEncode($projets->titre->CurrentValue);

			// objectif
			$projets->objectif->EditCustomAttributes = "";
			$projets->objectif->EditValue = ew_HtmlEncode($projets->objectif->CurrentValue);

			// montantproj
			$projets->montantproj->EditCustomAttributes = "";
			$projets->montantproj->EditValue = ew_HtmlEncode($projets->montantproj->CurrentValue);

			// montantdec
			$projets->montantdec->EditCustomAttributes = "";
			$projets->montantdec->EditValue = ew_HtmlEncode($projets->montantdec->CurrentValue);

			// entite
			// secteur

			$projets->secteur->EditCustomAttributes = "";
			$sSqlWrk = "SELECT `idsecteur`, `nomsecteur`, '' AS Disp2Fld, '' AS SelectFilterFld FROM `secteurs`";
			$sWhereWrk = "";
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", "Please Select"));
			$projets->secteur->EditValue = $arwrk;

			// idfbp
			$projets->idfbp->EditCustomAttributes = "";
			$sSqlWrk = "SELECT DISTINCT fbp.idfbp, Concat(bailleurs.nombailleur, ' ', programme.sigleprog, ' ', fbp.montantprograme), '' AS Disp2Fld, '' AS SelectFilterFld FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog)";
			if (trim(strval($projets->idfbp->CurrentValue)) == "") {
				$sWhereWrk = "0=1";
			} else {
				$sWhereWrk = "fbp.idfbp = " . ew_AdjustSql($projets->idfbp->CurrentValue) . "";
			}
			$sWhereWrk = $GLOBALS["finanbp"]->AddUserIDFilter($sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", "Please Select"));
			$projets->idfbp->EditValue = $arwrk;

			// bailleur
			$projets->bailleur->EditCustomAttributes = "";
			$sSqlWrk = "SELECT fbp.bailleur, bailleurs.nombailleur, '' AS Disp2Fld, fbp.idfbp FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog)";
			$sWhereWrk = "";
			$sWhereWrk = $GLOBALS["finanbp"]->AddUserIDFilter($sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$projets->bailleur->EditValue = $arwrk;

			// program
			$projets->program->EditCustomAttributes = "";
			$sSqlWrk = "SELECT DISTINCT fbp.program, programme.sigleprog, '' AS Disp2Fld, fbp.idfbp FROM fbp Inner Join bailleurs On (fbp.bailleur = bailleurs.idbailleur) Inner Join programme On (fbp.program = programme.idprog)";
			$sWhereWrk = "";
			$sWhereWrk = $GLOBALS["finanbp"]->AddUserIDFilter($sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$projets->program->EditValue = $arwrk;

			// statut
			$projets->statut->EditCustomAttributes = "";
			$sSqlWrk = "SELECT `StatutID`, `NomStatut`, '' AS Disp2Fld, '' AS SelectFilterFld FROM `statut`";
			$sWhereWrk = "";
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", "Please Select"));
			$projets->statut->EditValue = $arwrk;

			// datedebut
			$projets->datedebut->EditCustomAttributes = "";
			$projets->datedebut->EditValue = ew_HtmlEncode(ew_FormatDateTime($projets->datedebut->CurrentValue, 7));

			// ast
			$projets->ast->EditCustomAttributes = "";
			$sSqlWrk = "SELECT `idsecteur`, `nomsecteur`, '' AS Disp2Fld, '' AS SelectFilterFld FROM `secteurs`";
			if (trim(strval($projets->ast->CurrentValue)) == "") {
				$sWhereWrk = "0=1";
			} else {
				$arwrk = explode(",", $projets->ast->CurrentValue);
				$sWhereWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sWhereWrk <> "") $sWhereWrk .= " OR ";
					$sWhereWrk .= "`idsecteur` = " . ew_AdjustSql(trim($wrk)) . "";
				}
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE $sWhereWrk";
			$sSqlWrk .= " ORDER BY `nomsecteur` Asc";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$projets->ast->EditValue = $arwrk;

			// Realisation
			$projets->Realisation->EditCustomAttributes = "";
			$projets->Realisation->EditValue = ew_HtmlEncode($projets->Realisation->CurrentValue);

			// nbrbd
			$projets->nbrbd->EditCustomAttributes = "";
			$projets->nbrbd->EditValue = ew_HtmlEncode($projets->nbrbd->CurrentValue);

			// nbrec
			$projets->nbrec->EditCustomAttributes = "";
			$projets->nbrec->EditValue = ew_HtmlEncode($projets->nbrec->CurrentValue);

			// datemaj
			// userID

		}

		// Call Row Rendered event
		$projets->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $gsFormError, $projets;

		// Initialize
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if ($projets->departement->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Dpartement";
		}
		if ($projets->commune->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Commune";
		}
		if ($projets->section->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Ville/Quartier/Section";
		}
		if ($projets->titre->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Titre";
		}
		if ($projets->montantproj->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Montant engag";
		}
		if (!ew_CheckNumber($projets->montantproj->FormValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= "Incorrect floating point number - Montant engag";
		}
		if (!ew_CheckNumber($projets->montantdec->FormValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= "Incorrect floating point number - Montant dcaiss";
		}
		if ($projets->secteur->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Secteur";
		}
		if ($projets->idfbp->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Programmation";
		}
		if ($projets->bailleur->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Bailleur";
		}
		if ($projets->program->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Programme";
		}
		if ($projets->statut->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Statut";
		}
		if ($projets->datedebut->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= "Please enter required field - Date de dmarrage";
		}
		if (!ew_CheckEuroDate($projets->datedebut->FormValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= "Incorrect date, format = dd/mm/yyyy - Date de dmarrage";
		}
		if (!ew_CheckInteger($projets->nbrbd->FormValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= "Incorrect integer - B&eacute;n&eacute;ficiaires";
		}
		if (!ew_CheckInteger($projets->nbrec->FormValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= "Incorrect integer - Nombre d'emplois cr&eacute;&eacute;s";
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $sFormCustomError;
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow() {
		global $conn, $Security, $projets;
		$rsnew = array();

		// Field departement
		$projets->departement->SetDbValueDef($projets->departement->CurrentValue, NULL);
		$rsnew['departement'] =& $projets->departement->DbValue;

		// Field commune
		$projets->commune->SetDbValueDef($projets->commune->CurrentValue, NULL);
		$rsnew['commune'] =& $projets->commune->DbValue;

		// Field section
		$projets->section->SetDbValueDef($projets->section->CurrentValue, NULL);
		$rsnew['section'] =& $projets->section->DbValue;

		// Field titre
		$projets->titre->SetDbValueDef($projets->titre->CurrentValue, NULL);
		$rsnew['titre'] =& $projets->titre->DbValue;

		// Field objectif
		$projets->objectif->SetDbValueDef($projets->objectif->CurrentValue, NULL);
		$rsnew['objectif'] =& $projets->objectif->DbValue;

		// Field montantproj
		$projets->montantproj->SetDbValueDef($projets->montantproj->CurrentValue, 0);
		$rsnew['montantproj'] =& $projets->montantproj->DbValue;

		// Field montantdec
		$projets->montantdec->SetDbValueDef($projets->montantdec->CurrentValue, 0);
		$rsnew['montantdec'] =& $projets->montantdec->DbValue;

		// Field entite
		$projets->entite->SetDbValueDef(CurrentUserLevel(), NULL);
		$rsnew['entite'] =& $projets->entite->DbValue;

		// Field secteur
		$projets->secteur->SetDbValueDef($projets->secteur->CurrentValue, NULL);
		$rsnew['secteur'] =& $projets->secteur->DbValue;

		// Field idfbp
		$projets->idfbp->SetDbValueDef($projets->idfbp->CurrentValue, 0);
		$rsnew['idfbp'] =& $projets->idfbp->DbValue;

		// Field bailleur
		$projets->bailleur->SetDbValueDef($projets->bailleur->CurrentValue, NULL);
		$rsnew['bailleur'] =& $projets->bailleur->DbValue;

		// Field program
		$projets->program->SetDbValueDef($projets->program->CurrentValue, NULL);
		$rsnew['program'] =& $projets->program->DbValue;

		// Field statut
		$projets->statut->SetDbValueDef($projets->statut->CurrentValue, NULL);
		$rsnew['statut'] =& $projets->statut->DbValue;

		// Field datedebut
		$projets->datedebut->SetDbValueDef(ew_UnFormatDateTime($projets->datedebut->CurrentValue, 7), NULL);
		$rsnew['datedebut'] =& $projets->datedebut->DbValue;

		// Field ast
		$projets->ast->SetDbValueDef($projets->ast->CurrentValue, "");
		$rsnew['ast'] =& $projets->ast->DbValue;

		// Field Realisation
		$projets->Realisation->SetDbValueDef($projets->Realisation->CurrentValue, NULL);
		$rsnew['Realisation'] =& $projets->Realisation->DbValue;

		// Field nbrbd
		$projets->nbrbd->SetDbValueDef($projets->nbrbd->CurrentValue, NULL);
		$rsnew['nbrbd'] =& $projets->nbrbd->DbValue;

		// Field nbrec
		$projets->nbrec->SetDbValueDef($projets->nbrec->CurrentValue, NULL);
		$rsnew['nbrec'] =& $projets->nbrec->DbValue;

		// Field datemaj
		$projets->datemaj->SetDbValueDef(ew_CurrentDate(), NULL);
		$rsnew['datemaj'] =& $projets->datemaj->DbValue;

		// Field userID
		$projets->zuserID->SetDbValueDef(CurrentUserLevel(), NULL);
		$rsnew['userID'] =& $projets->zuserID->DbValue;

		// Call Row Inserting event
		$bInsertRow = $projets->Row_Inserting($rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$AddRow = $conn->Execute($projets->InsertSQL($rsnew));
			$conn->raiseErrorFn = '';
		} else {
			if ($projets->CancelMessage <> "") {
				$this->setMessage($projets->CancelMessage);
				$projets->CancelMessage = "";
			} else {
				$this->setMessage("Insert cancelled");
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {
			$projets->idprojet->setDbValue($conn->Insert_ID());
			$rsnew['idprojet'] =& $projets->idprojet->DbValue;

			// Call Row Inserted event
			$projets->Row_Inserted($rsnew);
		}
		return $AddRow;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
